/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.remote_machine;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.remote_machine.AbstractRemoteMachineActionHandler;
import org.uitnet.testing.smartfwk.remote_machine.RemoteMachineConfig;
import org.uitnet.testing.smartfwk.remote_machine.RemoteMachineConnectionProvider;
import org.uitnet.testing.smartfwk.remote_machine.RemoteMachineManager;
import org.uitnet.testing.smartfwk.remote_machine.RemoteMachinesConfig;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;
import org.uitnet.testing.smartfwk.ui.core.utils.ObjectUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;

public class SmartRemoteMachineManager
implements RemoteMachineManager {
    private static SmartRemoteMachineManager instance;
    private Map<String, AbstractRemoteMachineActionHandler> actionHandlers = new HashMap<String, AbstractRemoteMachineActionHandler>();
    private Map<String, RemoteMachineConnectionProvider> connectionProviders = new HashMap<String, RemoteMachineConnectionProvider>();

    private SmartRemoteMachineManager() {
        this.initActionHandlers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteMachineManager getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<SmartRemoteMachineManager> clazz = SmartRemoteMachineManager.class;
        synchronized (SmartRemoteMachineManager.class) {
            if (instance == null) {
                instance = new SmartRemoteMachineManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initActionHandlers() {
        Collection<AppConfig> appConfigs = TestConfigManager.getInstance().getAppConfigs();
        if (appConfigs != null) {
            List<RemoteMachineConfig> remoteMachines = null;
            for (AppConfig appConfig : appConfigs) {
                RemoteMachinesConfig remoteMachinesConfig = appConfig.getRemoteMachinesConfig();
                if (remoteMachinesConfig == null || (remoteMachines = remoteMachinesConfig.getRemoteMachines()) == null) continue;
                for (RemoteMachineConfig remoteMachine : remoteMachines) {
                    try {
                        if (StringUtil.isEmptyAfterTrim(remoteMachine.getActionHandlerClass()) || StringUtil.isEmptyAfterTrim(remoteMachine.getName())) continue;
                        Class<?> clazz = Class.forName(remoteMachine.getActionHandlerClass());
                        AbstractRemoteMachineActionHandler obj = (AbstractRemoteMachineActionHandler)ObjectUtil.findClassConstructor(clazz, new Class[]{String.class, String.class, Integer.TYPE, RemoteMachineConfig.class}).newInstance(remoteMachine.getName(), remoteMachinesConfig.getAppName(), remoteMachine.getSessionExpiryDurationInSeconds(), remoteMachine);
                        this.registerActionHandler(appConfig.getAppName(), remoteMachine.getName(), obj);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
    }

    private void registerActionHandler(String appName, String remoteMachineName, AbstractRemoteMachineActionHandler actionHandler) {
        this.actionHandlers.put(this.prepareKey(appName, remoteMachineName), actionHandler);
    }

    @Override
    public AbstractRemoteMachineActionHandler getActionHandler(String appName, String remoteMachineName) {
        AbstractRemoteMachineActionHandler handler = this.getRegisteredActionHandler(appName, remoteMachineName);
        return handler;
    }

    private AbstractRemoteMachineActionHandler getRegisteredActionHandler(String appName, String remoteMachineName) {
        AbstractRemoteMachineActionHandler actionHandler = this.actionHandlers.get(this.prepareKey(appName, remoteMachineName));
        Assert.assertNotNull((Object)actionHandler, (String)("No remote machine registered with SmartRemoteMachineManager class for appName = " + appName + " and remoteMachineName = " + remoteMachineName + ". This must be registered in cucumber step definition method that is annotated with @BeforeAll."));
        AbstractRemoteMachineActionHandler newActionHandler = actionHandler.clone();
        newActionHandler.setRemoteMachineManager(this);
        return newActionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteMachineConnectionProvider getConnectionProvider(String appName, String remoteMachineName) {
        String mapKey = this.prepareConnectionProviderMapKey(appName, remoteMachineName);
        RemoteMachineConnectionProvider connectionProvider = this.connectionProviders.get(mapKey);
        if (connectionProvider != null) {
            return connectionProvider;
        }
        Class<SmartRemoteMachineManager> clazz = SmartRemoteMachineManager.class;
        synchronized (SmartRemoteMachineManager.class) {
            connectionProvider = this.connectionProviders.get(mapKey);
            if (connectionProvider != null) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return connectionProvider;
            }
            connectionProvider = this.getRegisteredActionHandler(appName, remoteMachineName);
            this.connectionProviders.put(mapKey, connectionProvider);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return connectionProvider;
        }
    }

    private String prepareConnectionProviderMapKey(String appName, String remoteMachineName) {
        return appName + ":" + remoteMachineName;
    }

    private String prepareKey(String appName, String remoteMachineName) {
        return appName + ":" + remoteMachineName;
    }

    @Override
    public synchronized void deregisterAll() {
        this.actionHandlers.clear();
        for (RemoteMachineConnectionProvider aap : this.connectionProviders.values()) {
            aap.disconnect();
        }
        this.connectionProviders.clear();
    }
}

