/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config;

import java.util.Map;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;

public class DatabaseProfile {
    private String appName;
    private String profileName;
    private String envFileName;
    private String databaseHandlerClass;
    private Integer sessionExpiryDurationInSeconds;
    private Map<String, Object> additionalProps;

    public DatabaseProfile() {
    }

    public DatabaseProfile(String appName, String profileName) {
        this.appName = appName;
        this.profileName = profileName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getEnvFileName() {
        return this.envFileName;
    }

    public void setEnvFileName(String envFileName) {
        this.envFileName = envFileName;
    }

    public Map<String, Object> getAdditionalProps() {
        return this.additionalProps;
    }

    public void setAdditionalProps(Map<String, Object> additionalProps) {
        this.additionalProps = additionalProps;
    }

    public String getDatabaseHandlerClass() {
        return this.databaseHandlerClass;
    }

    public void setDatabaseHandlerClass(String databaseHandlerClass) {
        this.databaseHandlerClass = databaseHandlerClass;
    }

    public Integer getSessionExpiryDurationInSeconds() {
        return this.sessionExpiryDurationInSeconds;
    }

    public void setSessionExpiryDurationInSeconds(Integer sessionExpiryDurationInSeconds) {
        this.sessionExpiryDurationInSeconds = sessionExpiryDurationInSeconds;
    }

    public void validateInfo() {
        if (StringUtil.isEmptyAfterTrim(this.profileName)) {
            Assert.fail((String)("FATAL: 'profileName' property value cannot be empty in database profile file '" + this.envFileName + "'. AppName - '" + this.appName + "'. Exiting ..."));
            System.exit(1);
        }
    }

    public <T> T getAdditionalPropertyValue(String propName, Class<T> clazz) {
        Assert.assertTrue((boolean)this.additionalProps.containsKey(propName), (String)("Please specify the additional property '" + propName + "' in application '" + this.appName + "' database profile '" + this.profileName + ".yaml' file."));
        return clazz.cast(this.additionalProps.get(propName));
    }
}

