/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.objects;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.sikuli.script.Region;
import org.uitnet.testing.smartfwk.ui.core.SmartCucumberUiScenarioContext;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.LocateBy;
import org.uitnet.testing.smartfwk.ui.core.commons.Locator;
import org.uitnet.testing.smartfwk.ui.core.commons.LocatorType;
import org.uitnet.testing.smartfwk.ui.core.commons.UIObjectType;
import org.uitnet.testing.smartfwk.ui.core.config.ApplicationType;
import org.uitnet.testing.smartfwk.ui.core.config.PlatformType;
import org.uitnet.testing.smartfwk.ui.core.config.WebBrowserType;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObject;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.utils.LocatorUtil;

public class DOMObject
extends UIObject {
    protected Map<String, Locator> platFormLocators = new HashMap<String, Locator>();

    public DOMObject(String displayName, String xpath) {
        super(LocatorType.DOM, UIObjectType.locator, displayName);
        this.platFormLocators.put("default-xpath", new Locator(LocateBy.Xpath, xpath));
    }

    public DOMObject(UIObjectType elemType, String displayName, String xpath) {
        super(LocatorType.DOM, elemType, displayName);
        this.platFormLocators.put("default-xpath", new Locator(LocateBy.Xpath, xpath));
    }

    public DOMObject(UIObjectType elemType, String displayName, Map<String, Locator> platFormLocators) {
        super(LocatorType.DOM, elemType, displayName);
        this.platFormLocators = platFormLocators;
    }

    public DOMObject addPlatformLocatorForNativeApp(PlatformType platform, LocateBy locateBy, String locatorValue) {
        LocatorUtil.setPlatformLocatorForNativeApp(this.platFormLocators, platform, locateBy, locatorValue);
        return this;
    }

    public DOMObject addPlatformLocatorForWebApp(PlatformType platform, WebBrowserType browserType, LocateBy locateBy, String locatorValue) {
        LocatorUtil.setPlatformLocatorForWebApp(this.platFormLocators, platform, browserType, locateBy, locatorValue);
        return this;
    }

    public Locator getLocator(PlatformType platform, ApplicationType appType, WebBrowserType browserType) {
        return LocatorUtil.findLocator(this.platFormLocators, platform, appType, browserType);
    }

    public Map<String, Locator> getPlatformLocators() {
        return this.platFormLocators;
    }

    @Override
    public DOMObject updateLocatorParameterWithValue(String paramName, String paramValue) {
        String newDisplayName = this.displayName.replaceAll(":" + paramName, paramValue);
        HashMap<String, Locator> newPlatFormLocators = new HashMap<String, Locator>();
        for (Map.Entry<String, Locator> locator : this.platFormLocators.entrySet()) {
            newPlatFormLocators.put(locator.getKey(), new Locator(locator.getValue().getLocateBy(), locator.getValue().getValue().replaceAll(":" + paramName, paramValue)));
        }
        return new DOMObject(this.uiObjectType, newDisplayName, newPlatFormLocators);
    }

    @Override
    public DOMObjectValidator getValidator(SmartAppDriver appDriver, Region region) {
        return new DOMObjectValidator(appDriver, this, region);
    }

    @Override
    public UIObjectValidator getValidator(SmartCucumberUiScenarioContext scenarioContext, Region region) {
        return this.getValidator(scenarioContext.getActiveAppDriver(), region);
    }

    @Override
    public DOMObject clone() {
        try {
            Class[] paramTypes = new Class[]{String.class, String.class, Map.class};
            Constructor<?> ctor = this.getClass().getConstructor(paramTypes);
            HashMap<String, Locator> newPlatFormLocators = new HashMap<String, Locator>();
            for (Map.Entry<String, Locator> entry : this.platFormLocators.entrySet()) {
                newPlatFormLocators.put(entry.getKey(), new Locator(entry.getValue().getLocateBy(), entry.getValue().getValue()));
            }
            Object[] paramValues = new Object[]{this.uiObjectType, this.displayName, newPlatFormLocators};
            return (DOMObject)ctor.newInstance(paramValues);
        }
        catch (Exception ex) {
            new Throwable(ex);
            return null;
        }
    }
}

