/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;

public class JsonYamlUtil {
    private JsonYamlUtil() {
    }

    public static <T> T readNoException(String path, Class<T> type, DocumentContext yamlDocCtx) {
        try {
            return (T)yamlDocCtx.read(path, type, new Predicate[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T readNoException(String path, TypeRef<T> type, DocumentContext yamlDocCtx) {
        ObjectMapper mapper = new ObjectMapper();
        JavaType type2 = null;
        try {
            type2 = mapper.getTypeFactory().constructType(type.getType());
            Object obj = yamlDocCtx.read(path, type);
            if (obj == null) {
                if (type2.getRawClass().getName().equals(Map.class.getName())) {
                    return (T)Collections.EMPTY_MAP;
                }
                if (type2.getRawClass().getName().equals(List.class.getName())) {
                    return (T)Collections.EMPTY_LIST;
                }
                if (type2.getRawClass().getName().equals(Set.class.getName())) {
                    return (T)Collections.EMPTY_SET;
                }
            }
            return (T)obj;
        }
        catch (Exception ex) {
            try {
                if (type2.getRawClass().getName().equals(Map.class.getName())) {
                    return (T)Collections.EMPTY_MAP;
                }
                if (type2.getRawClass().getName().equals(List.class.getName())) {
                    return (T)Collections.EMPTY_LIST;
                }
                if (type2.getRawClass().getName().equals(Set.class.getName())) {
                    return (T)Collections.EMPTY_SET;
                }
            }
            catch (Exception e1) {
                Assert.fail((String)("Failed to read '" + path + "' path of type '" + type.getType() + "'."), (Throwable)e1);
            }
            return null;
        }
    }

    public static <T> T readNoException(String yamlPath, Class<T> clazz, DocumentContext defaultProperties, DocumentContext overriddenProperties) {
        if (overriddenProperties == null) {
            return JsonYamlUtil.readNoException(yamlPath, clazz, defaultProperties);
        }
        Object value = null;
        try {
            value = overriddenProperties.read(yamlPath, clazz, new Predicate[0]);
        }
        catch (Exception e) {
            value = JsonYamlUtil.readNoException(yamlPath, clazz, defaultProperties);
        }
        return (T)value;
    }

    public static <T> T readNoException(String yamlPath, TypeRef<T> typeRef, DocumentContext defaultProperties, DocumentContext overriddenProperties) {
        if (overriddenProperties == null) {
            return JsonYamlUtil.readNoException(yamlPath, typeRef, defaultProperties);
        }
        Map value = null;
        try {
            T defValue;
            value = (Map)JsonYamlUtil.readNoException(yamlPath, typeRef, overriddenProperties);
            Map map = null;
            if (value instanceof Map) {
                map = value;
            }
            if ((defValue = JsonYamlUtil.readNoException(yamlPath, typeRef, defaultProperties)) instanceof Map) {
                Map map2 = (Map)defValue;
                if (map != null) {
                    map2.putAll(map);
                }
                value = map2;
            } else if (value == null) {
                value = (Map)defValue;
            } else if ((value instanceof List || value instanceof Set) && ((Collection)((Object)value)).isEmpty()) {
                value = defValue;
            }
        }
        catch (Exception e) {
            value = (Map)JsonYamlUtil.readNoException(yamlPath, typeRef, defaultProperties);
        }
        return (T)value;
    }

    public static String convertObjectToJsonString(Object obj) throws JsonProcessingException {
        if (obj == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(obj);
    }
}

