/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.utils;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.tika.Tika;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypes;

public class MimeTypeUtil {
    private static MimeTypes mimeTypes = MimeTypes.getDefaultMimeTypes();
    private static List<String> binaryFileExtensions = new LinkedList<String>();

    private MimeTypeUtil() {
    }

    public static String getFileExtensionFromMediaType(String mediaType) {
        try {
            MimeType mimeType = mimeTypes.getRegisteredMimeType(mediaType);
            if (mimeType == null) {
                return null;
            }
            return mimeType.getExtension();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getBinaryFileExtension(String mediaType) {
        if (mediaType == null) {
            return null;
        }
        if (mediaType.toLowerCase().startsWith("image/") || mediaType.toLowerCase().startsWith("video/") || mediaType.toLowerCase().startsWith("audio/")) {
            return MimeTypeUtil.getFileExtensionFromMediaType(mediaType);
        }
        String extn = MimeTypeUtil.getFileExtensionFromMediaType(mediaType);
        if (extn != null && binaryFileExtensions.contains(extn)) {
            return extn;
        }
        return null;
    }

    public static String findMediaTypeForFile(String absluteFilePath) {
        try {
            String mType = new Tika().detect(new File(absluteFilePath));
            if (mType != null) {
                return mType;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        binaryFileExtensions.add(".bin");
        binaryFileExtensions.add(".pdf");
        binaryFileExtensions.add(".exe");
        binaryFileExtensions.add(".doc");
        binaryFileExtensions.add(".docx");
        binaryFileExtensions.add(".xls");
        binaryFileExtensions.add(".xlsx");
        binaryFileExtensions.add(".ppt");
        binaryFileExtensions.add(".pptx");
        binaryFileExtensions.add(".zip");
        binaryFileExtensions.add(".gzip");
        binaryFileExtensions.add(".rar");
        binaryFileExtensions.add(".gz");
        binaryFileExtensions.add(".tgz");
        binaryFileExtensions.add(".tar");
        binaryFileExtensions.add(".odt");
        binaryFileExtensions.add(".ods");
        binaryFileExtensions.add(".dll");
        binaryFileExtensions.add(".jar");
        binaryFileExtensions.add(".war");
    }
}

