/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.utils;

import java.util.Locale;
import org.openqa.selenium.WebElement;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.config.ApplicationType;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObject;
import org.uitnet.testing.smartfwk.ui.core.utils.LocatorUtil;

public class WebElementUtil {
    private WebElementUtil() {
    }

    public static boolean isElementDisabled(SmartAppDriver appDriver, DOMObject domObject) {
        boolean disabled = false;
        boolean isReadonlyCalled = false;
        try {
            disabled = WebElementUtil.isElementDisabledButNotReadonly(appDriver, domObject);
            if (!disabled) {
                isReadonlyCalled = true;
                disabled = WebElementUtil.isElementReadonly(appDriver, domObject);
            }
        }
        catch (Error | Exception e) {
            if (!isReadonlyCalled) {
                disabled = WebElementUtil.isElementReadonly(appDriver, domObject);
            }
            throw e;
        }
        return disabled;
    }

    public static boolean isElementDisabledButNotReadonly(SmartAppDriver appDriver, DOMObject domObject) {
        boolean disabled;
        block10: {
            disabled = false;
            WebElement webElem = LocatorUtil.findWebElement(appDriver.getWebDriver(), domObject.getLocator(appDriver.getAppConfig().getTestPlatformType(), appDriver.getAppConfig().getAppType(), appDriver.getAppConfig().getAppWebBrowser()));
            if (appDriver.getAppType() == ApplicationType.native_app) {
                try {
                    if (!(webElem == null || webElem.getAttribute("disabled") == null && webElem.isEnabled())) {
                        disabled = true;
                    }
                }
                catch (Error | Exception ex) {
                    String checkElemEnabledAttr = appDriver.getAppConfig().getAppDriverConfig().getWebAttrMap().get("checkElementEnabledAttr");
                    String attrValue = null;
                    if (checkElemEnabledAttr != null && !"".equals(checkElemEnabledAttr)) {
                        attrValue = webElem.getAttribute(checkElemEnabledAttr);
                        if (attrValue != null && !"true".equals(attrValue.toLowerCase(Locale.ENGLISH))) {
                            disabled = true;
                        }
                        break block10;
                    }
                    String checkElemDisabledAttr = appDriver.getAppConfig().getAppDriverConfig().getWebAttrMap().get("checkElementDisabledAttr");
                    if (checkElemDisabledAttr != null && "".equals(checkElemDisabledAttr)) {
                        attrValue = webElem.getAttribute(checkElemDisabledAttr);
                        if (attrValue != null && "true".equals(attrValue.toLowerCase(Locale.ENGLISH))) {
                            disabled = true;
                        }
                        break block10;
                    }
                    Assert.fail((String)("Please specify the value for property 'checkElementDisabledAttr' or property 'checkElementEnabledAttr' in AppDriver.yaml file for Application '" + appDriver.getAppName() + "'."));
                }
            } else if (!(webElem == null || webElem.getAttribute("disabled") == null && webElem.isEnabled())) {
                disabled = true;
            }
        }
        return disabled;
    }

    public static boolean isElementReadonly(SmartAppDriver appDriver, DOMObject domObject) {
        boolean readonly = false;
        WebElement webElem = LocatorUtil.findWebElement(appDriver.getWebDriver(), domObject.getLocator(appDriver.getAppConfig().getTestPlatformType(), appDriver.getAppConfig().getAppType(), appDriver.getAppConfig().getAppWebBrowser()));
        if (appDriver.getAppType() == ApplicationType.native_app) {
            String checkElemReadonlyAttr = appDriver.getAppConfig().getAppDriverConfig().getWebAttrMap().get("checkTextboxStateAsReadonlyAttr");
            String attrValue = null;
            if (checkElemReadonlyAttr != null && !"".equals(checkElemReadonlyAttr)) {
                attrValue = webElem.getAttribute(checkElemReadonlyAttr);
                if (attrValue != null && !"true".equals(attrValue.toLowerCase(Locale.ENGLISH))) {
                    readonly = true;
                }
            } else {
                Assert.fail((String)("Please specify the value for property 'checkTextboxStateAsReadonlyAttr' in AppDriver.yaml file for Application '" + appDriver.getAppName() + "'."));
            }
        } else if (webElem != null && webElem.getAttribute("readonly") != null) {
            readonly = true;
        }
        return readonly;
    }

    public static boolean isElementVisible(SmartAppDriver appDriver, DOMObject domObject) {
        boolean visible = false;
        WebElement webElem = LocatorUtil.findWebElement(appDriver.getWebDriver(), domObject.getLocator(appDriver.getAppConfig().getTestPlatformType(), appDriver.getAppConfig().getAppType(), appDriver.getAppConfig().getAppWebBrowser()));
        if (appDriver.getAppType() == ApplicationType.native_app) {
            if (webElem != null) {
                visible = true;
            }
        } else if (webElem != null && !"hidden".equals(LocatorUtil.getCssValue(webElem, "visibility")) && !"none".equals(LocatorUtil.getCssValue(webElem, "display")) || webElem.getAttribute("hidden") != null) {
            visible = true;
        }
        return visible;
    }

    public static boolean isElementSelected(SmartAppDriver appDriver, DOMObject domObject) {
        boolean selected;
        block8: {
            selected = false;
            WebElement webElem = LocatorUtil.findWebElement(appDriver.getWebDriver(), domObject.getLocator(appDriver.getAppConfig().getTestPlatformType(), appDriver.getAppConfig().getAppType(), appDriver.getAppConfig().getAppWebBrowser()));
            if (appDriver.getAppType() == ApplicationType.native_app) {
                try {
                    if (webElem != null && webElem.isSelected()) {
                        selected = true;
                    }
                }
                catch (Error | Exception ex) {
                    String checkElemOpSelectedAttr = appDriver.getAppConfig().getAppDriverConfig().getWebAttrMap().get("checkOptionSelectedAttr");
                    String attrValue = null;
                    if (checkElemOpSelectedAttr != null && !"".equals(checkElemOpSelectedAttr)) {
                        attrValue = webElem.getAttribute(checkElemOpSelectedAttr);
                        if (attrValue != null && !"true".equals(attrValue.toLowerCase(Locale.ENGLISH))) {
                            selected = true;
                        }
                        break block8;
                    }
                    Assert.fail((String)("Please specify the value for property 'checkOptionSelectedAttr' in AppDriver.yaml file for Application '" + appDriver.getAppName() + "'."));
                }
            } else if (webElem != null && webElem.isSelected()) {
                selected = true;
            }
        }
        return selected;
    }

    public static String getElementText(SmartAppDriver appDriver, DOMObject domObject, int maxIterationsToLocateElements) {
        String text = "";
        WebElement webElem = null;
        for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
            block8: {
                try {
                    webElem = LocatorUtil.findWebElement(appDriver.getWebDriver(), domObject.getLocator(appDriver.getAppConfig().getTestPlatformType(), appDriver.getAppConfig().getAppType(), appDriver.getAppConfig().getAppWebBrowser()));
                    if (appDriver.getAppType() == ApplicationType.native_app) {
                        String getElemTextAttr = appDriver.getAppConfig().getAppDriverConfig().getWebAttrMap().get("getElementTextAttr");
                        if (getElemTextAttr != null && !"".equals(getElemTextAttr)) {
                            text = webElem.getAttribute(getElemTextAttr);
                        } else {
                            Assert.fail((String)("Please specify the value for property 'getElementTextAttr' in AppDriver.yaml file for Application '" + appDriver.getAppName() + "'."));
                        }
                    } else if (webElem != null) {
                        text = webElem.getText();
                    }
                }
                catch (Throwable th) {
                    if (i != maxIterationsToLocateElements) break block8;
                    throw th;
                }
            }
            appDriver.waitForSeconds(2);
        }
        return text;
    }

    public static String getInputTextValue(SmartAppDriver appDriver, DOMObject domObject, int maxIterationsToLocateElements) {
        String text = "";
        WebElement webElem = null;
        for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
            block8: {
                try {
                    webElem = LocatorUtil.findWebElement(appDriver.getWebDriver(), domObject.getLocator(appDriver.getAppConfig().getTestPlatformType(), appDriver.getAppConfig().getAppType(), appDriver.getAppConfig().getAppWebBrowser()));
                    if (appDriver.getAppType() == ApplicationType.native_app) {
                        String getElemTextAttr = appDriver.getAppConfig().getAppDriverConfig().getWebAttrMap().get("getInputValueAttr");
                        if (getElemTextAttr != null && !"".equals(getElemTextAttr)) {
                            text = webElem.getAttribute(getElemTextAttr);
                        } else {
                            Assert.fail((String)("Please specify the value for property 'getInputValueAttr' in AppDriver.yaml file for Application '" + appDriver.getAppName() + "'."));
                        }
                    } else if (webElem != null) {
                        text = webElem.getAttribute("value");
                    }
                }
                catch (Throwable th) {
                    if (i != maxIterationsToLocateElements) break block8;
                    throw th;
                }
            }
            appDriver.waitForSeconds(2);
        }
        return text;
    }
}

