/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.domobj;

import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObject;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.checkbox.CheckBoxValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.standard.domobj.CheckBoxSD;

public class CheckBoxValidatorSD
extends CheckBoxValidator {
    protected DOMObjectValidator domObjValidator;

    public CheckBoxValidatorSD(SmartAppDriver appDriver, CheckBoxSD uiObject, Region region) {
        super(appDriver, uiObject, region);
        this.domObjValidator = new DOMObjectValidator(appDriver, new DOMObject(uiObject.getType(), uiObject.getDisplayName(), uiObject.getPlatformLocators()), region);
    }

    public DOMObjectValidator getDOMObjectValidator() {
        return this.domObjValidator;
    }

    @Override
    public CheckBoxValidatorSD typeText(String textToType, NewTextLocation location, int maxIterationsToLocateElements) {
        this.domObjValidator.typeText(textToType, location, maxIterationsToLocateElements);
        return this;
    }

    @Override
    public boolean isPresent(int maxIterationsToLocateElements) {
        return this.domObjValidator.isPresent(maxIterationsToLocateElements);
    }

    @Override
    public boolean isVisible(int maxIterationsToLocateElements) {
        return this.domObjValidator.isVisible(maxIterationsToLocateElements);
    }

    @Override
    public CheckBoxValidatorSD click(int maxIterationsToLocateElements) {
        this.domObjValidator.click(maxIterationsToLocateElements);
        return this;
    }

    @Override
    public CheckBoxValidatorSD doubleClick(int maxIterationsToLocateElements) {
        this.domObjValidator.doubleClick(maxIterationsToLocateElements);
        return this;
    }

    @Override
    public CheckBoxValidatorSD rightClick(int maxIterationsToLocateElements) {
        this.domObjValidator.rightClick(maxIterationsToLocateElements);
        return this;
    }

    @Override
    public CheckBoxValidatorSD clickAndHold(int maxIterationsToLocateElements) {
        this.domObjValidator.clickAndHold(maxIterationsToLocateElements);
        return this;
    }

    @Override
    public CheckBoxValidatorSD release(int maxIterationsToLocateElements) {
        this.domObjValidator.release(maxIterationsToLocateElements);
        return this;
    }

    @Override
    public CheckBoxValidatorSD performKeyDown(Keys keys, int maxIterationsToLocateElements) {
        this.domObjValidator.performKeyDown(keys, maxIterationsToLocateElements);
        return this;
    }

    @Override
    public CheckBoxValidatorSD performKeyUp(Keys keys, int maxIterationsToLocateElements) {
        this.domObjValidator.performKeyUp(keys, maxIterationsToLocateElements);
        return this;
    }

    @Override
    public CheckBoxValidatorSD performKeyPressed(Keys keys, int maxIterationsToLocateElements) {
        this.domObjValidator.performKeyPressed(keys, maxIterationsToLocateElements);
        return this;
    }

    @Override
    public CheckBoxValidatorSD scrollElementOnViewport(Scrollbar scrollbar) {
        this.domObjValidator.scrollElementOnViewport(scrollbar);
        return this;
    }

    @Override
    public boolean isCheckBoxChecked(int maxIterationsToLocateElements) {
        return this.domObjValidator.isSelected(maxIterationsToLocateElements);
    }

    @Override
    public CheckBoxValidatorSD validateCheckBoxChecked(int maxIterationsToLocateElements) {
        try {
            for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
                try {
                    Assert.assertTrue((boolean)this.isCheckBoxChecked(0), (String)("Checkbox '" + this.uiObject.getDisplayName() + "' is not checked."));
                    return this;
                }
                catch (Throwable th) {
                    if (i == maxIterationsToLocateElements) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate checkbox checked for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public CheckBoxValidatorSD validateCheckBoxUnchecked(int maxIterationsToLocateElements) {
        try {
            for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
                try {
                    Assert.assertFalse((boolean)this.isCheckBoxChecked(0), (String)("Checkbox '" + this.uiObject.getDisplayName() + "' is checked."));
                    return this;
                }
                catch (Throwable th) {
                    if (i == maxIterationsToLocateElements) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate checkbox unchecked for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public CheckBoxValidatorSD checkAndValidateChecked(int maxIterationsToLocateElements) {
        this.domObjValidator.click(maxIterationsToLocateElements);
        try {
            this.validateCheckBoxChecked(maxIterationsToLocateElements);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to check the Checkbox '" + this.uiObject.getDisplayName() + "'."));
        }
        return this;
    }

    @Override
    public CheckBoxValidatorSD uncheckAndValidateUnchecked(int maxIterationsToLocateElements) {
        this.domObjValidator.click(maxIterationsToLocateElements);
        try {
            this.validateCheckBoxUnchecked(maxIterationsToLocateElements);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to uncheck the Checkbox '" + this.uiObject.getDisplayName() + "'."));
        }
        return this;
    }

    public WebElement findElement(int maxIterationsToLocateElements) {
        return this.domObjValidator.findElement(maxIterationsToLocateElements);
    }

    public WebElement findElementNoException(int maxIterationsToLocateElements) {
        return this.domObjValidator.findElementNoException(maxIterationsToLocateElements);
    }

    @Override
    public List<WebElement> findElements(int maxIterationsToLocateElements) {
        return this.domObjValidator.findElements(maxIterationsToLocateElements);
    }

    @Override
    public boolean isDisabled(int maxIterationsToLocateElements) {
        return this.domObjValidator.isDisabled(maxIterationsToLocateElements);
    }

    @Override
    public CheckBoxValidatorSD validateDisabled(int maxIterationsToLocateElements) {
        Assert.assertTrue((boolean)this.domObjValidator.isDisabled(maxIterationsToLocateElements), (String)("'" + this.uiObject.getDisplayName() + "' element is not disabled."));
        return this;
    }

    @Override
    public CheckBoxValidatorSD validateEnabled(int maxIterationsToLocateElements) {
        Assert.assertFalse((boolean)this.domObjValidator.isDisabled(maxIterationsToLocateElements), (String)("'" + this.uiObject.getDisplayName() + "' element is not enabled."));
        return this;
    }

    @Override
    public boolean isDisabledButNotReadonly(int maxIterationsToLocateElements) {
        return this.domObjValidator.isDisabledButNotReadonly(maxIterationsToLocateElements);
    }

    @Override
    public CheckBoxValidatorSD validateDisabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.assertTrue((boolean)this.domObjValidator.isDisabledButNotReadonly(maxIterationsToLocateElements), (String)("'" + this.uiObject.getDisplayName() + "' element is not disabled."));
        return this;
    }

    @Override
    public CheckBoxValidatorSD validateEnabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.assertFalse((boolean)this.domObjValidator.isDisabledButNotReadonly(maxIterationsToLocateElements), (String)("'" + this.uiObject.getDisplayName() + "' element is not enabled."));
        return this;
    }

    @Override
    public Actions getNewSeleniumActions() {
        return this.domObjValidator.getNewSeleniumActions();
    }
}

