/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.domobj;

import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObject;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.core.objects.textbox.TextBoxValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.WebElementUtil;
import org.uitnet.testing.smartfwk.ui.standard.domobj.TextBoxSD;

public class TextBoxValidatorSD
extends TextBoxValidator {
    protected DOMObjectValidator domObjValidator;

    public TextBoxValidatorSD(SmartAppDriver appDriver, TextBoxSD uiObject, Region region) {
        super(appDriver, uiObject, region);
        this.domObjValidator = new DOMObjectValidator(appDriver, new DOMObject(uiObject.getType(), uiObject.getDisplayName(), uiObject.getPlatformLocators()), region);
    }

    public DOMObjectValidator getDOMObjectValidator() {
        return this.domObjValidator;
    }

    @Override
    public boolean isDisabled(int maxIterationsToLocateElements) {
        return this.domObjValidator.isDisabled(maxIterationsToLocateElements);
    }

    @Override
    public TextBoxValidatorSD validateDisabled(int maxIterationsToLocateElements) {
        Assert.assertTrue((boolean)this.domObjValidator.isDisabled(maxIterationsToLocateElements), (String)("'" + this.uiObject.getDisplayName() + "' element is not disabled."));
        return this;
    }

    @Override
    public TextBoxValidatorSD validateEnabled(int maxIterationsToLocateElements) {
        Assert.assertFalse((boolean)this.domObjValidator.isDisabled(maxIterationsToLocateElements), (String)("'" + this.uiObject.getDisplayName() + "' element is not enabled."));
        return this;
    }

    @Override
    public boolean isDisabledButNotReadonly(int maxIterationsToLocateElements) {
        return this.domObjValidator.isDisabledButNotReadonly(maxIterationsToLocateElements);
    }

    @Override
    public TextBoxValidatorSD validateDisabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.assertTrue((boolean)this.domObjValidator.isDisabledButNotReadonly(maxIterationsToLocateElements), (String)("'" + this.uiObject.getDisplayName() + "' element is not disabled."));
        return this;
    }

    @Override
    public TextBoxValidatorSD validateEnabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.assertFalse((boolean)this.domObjValidator.isDisabledButNotReadonly(maxIterationsToLocateElements), (String)("'" + this.uiObject.getDisplayName() + "' element is not enabled."));
        return this;
    }

    @Override
    public boolean isReadonly(int maxIterationsToLocateElements) {
        return this.domObjValidator.isReadonly(maxIterationsToLocateElements);
    }

    @Override
    public TextBoxValidatorSD validateReadonly(int maxIterationsToLocateElements) {
        Assert.assertTrue((boolean)this.domObjValidator.isReadonly(maxIterationsToLocateElements), (String)("'" + this.uiObject.getDisplayName() + "' element is not readonly."));
        return this;
    }

    @Override
    public TextBoxValidatorSD validateNotReadonly(int maxIterationsToLocateElements) {
        Assert.assertFalse((boolean)this.domObjValidator.isReadonly(maxIterationsToLocateElements), (String)("'" + this.uiObject.getDisplayName() + "' element is readonly."));
        return this;
    }

    @Override
    public TextBoxValidatorSD typeText(String textToType, NewTextLocation location, int maxIterationsToLocateElements) {
        this.domObjValidator.typeText(textToType, location, maxIterationsToLocateElements);
        return this;
    }

    @Override
    public TextBoxValidatorSD validateValue(String expectedValue, TextMatchMechanism validationMechanism, int maxIterationsToLocateElements) {
        try {
            for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
                try {
                    String actualValue = WebElementUtil.getInputTextValue(this.appDriver, this.domObjValidator.getUIObject(), 0);
                    this.validateTextValue(actualValue, expectedValue, validationMechanism);
                    return this;
                }
                catch (Throwable th) {
                    if (i == maxIterationsToLocateElements) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate expected value '" + expectedValue + "' for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public boolean isPresent(int maxIterationsToLocateElements) {
        return this.domObjValidator.isPresent(maxIterationsToLocateElements);
    }

    @Override
    public boolean isVisible(int maxIterationsToLocateElements) {
        return this.domObjValidator.isVisible(maxIterationsToLocateElements);
    }

    @Override
    public TextBoxValidatorSD click(int maxIterationsToLocateElements) {
        this.domObjValidator.click(maxIterationsToLocateElements);
        return this;
    }

    @Override
    public TextBoxValidatorSD doubleClick(int maxIterationsToLocateElements) {
        this.domObjValidator.doubleClick(maxIterationsToLocateElements);
        return this;
    }

    @Override
    public TextBoxValidatorSD rightClick(int maxIterationsToLocateElements) {
        this.domObjValidator.rightClick(maxIterationsToLocateElements);
        return this;
    }

    @Override
    public TextBoxValidatorSD clickAndHold(int maxIterationsToLocateElements) {
        this.domObjValidator.clickAndHold(maxIterationsToLocateElements);
        return this;
    }

    @Override
    public TextBoxValidatorSD release(int maxIterationsToLocateElements) {
        this.domObjValidator.release(maxIterationsToLocateElements);
        return this;
    }

    @Override
    public TextBoxValidatorSD performKeyDown(Keys keys, int maxIterationsToLocateElements) {
        this.domObjValidator.performKeyDown(keys, maxIterationsToLocateElements);
        return this;
    }

    @Override
    public TextBoxValidatorSD performKeyUp(Keys keys, int maxIterationsToLocateElements) {
        this.domObjValidator.performKeyUp(keys, maxIterationsToLocateElements);
        return this;
    }

    @Override
    public TextBoxValidatorSD performKeyPressed(Keys keys, int maxIterationsToLocateElements) {
        this.domObjValidator.performKeyPressed(keys, maxIterationsToLocateElements);
        return this;
    }

    @Override
    public TextBoxValidatorSD scrollElementOnViewport(Scrollbar scrollbar) {
        this.domObjValidator.scrollElementOnViewport(scrollbar);
        return this;
    }

    @Override
    public String getValue(int maxIterationsToLocateElements) {
        WebElement webElem = this.domObjValidator.findElement(maxIterationsToLocateElements);
        return webElem.getAttribute("value");
    }

    public WebElement findElement(int maxIterationsToLocateElements) {
        return this.domObjValidator.findElement(maxIterationsToLocateElements);
    }

    public WebElement findElementNoException(int maxIterationsToLocateElements) {
        return this.domObjValidator.findElementNoException(maxIterationsToLocateElements);
    }

    @Override
    public List<WebElement> findElements(int maxIterationsToLocateElements) {
        return this.domObjValidator.findElements(maxIterationsToLocateElements);
    }

    @Override
    public Actions getNewSeleniumActions() {
        return this.domObjValidator.getNewSeleniumActions();
    }
}

