/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.imgobj;

import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.interactions.Actions;
import org.sikuli.script.Button;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.ImageSection;
import org.uitnet.testing.smartfwk.ui.core.commons.UIObjectType;
import org.uitnet.testing.smartfwk.ui.core.objects.ImageObject;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.radio.RadioButtonValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.RadioButtonSI;

public class RadioButtonValidatorSI
extends RadioButtonValidator {
    protected RadioButtonSI rbObject;

    public RadioButtonValidatorSI(SmartAppDriver appDriver, RadioButtonSI uiObject, Region region) {
        super(appDriver, uiObject, region);
        this.rbObject = uiObject;
    }

    @Override
    public boolean isPresent(int maxIterationsToLocateElements) {
        Match m = this.findElementNoException(maxIterationsToLocateElements);
        return m != null;
    }

    @Override
    public boolean isVisible(int maxIterationsToLocateElements) {
        return this.isPresent(maxIterationsToLocateElements);
    }

    @Override
    public RadioButtonValidatorSI click(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    public RadioButtonValidatorSI click(ImageSection imageSection, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            this.getImageSection(match, imageSection).click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public RadioButtonValidatorSI doubleClick(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    public RadioButtonValidatorSI doubleClick(ImageSection imageSection, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            this.getImageSection(match, imageSection).doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public RadioButtonValidatorSI rightClick(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    public RadioButtonValidatorSI rightClick(ImageSection imageSection, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            this.getImageSection(match, imageSection).rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public RadioButtonValidatorSI clickAndHold(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public RadioButtonValidatorSI release(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public RadioButtonValidatorSI performKeyDown(Keys keys, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
            match.keyDown(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyDown on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public RadioButtonValidatorSI performKeyUp(Keys keys, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
            match.keyUp(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyUp ('" + this.seleniumToSikuliKeyConverter(keys) + "') on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public RadioButtonValidatorSI performKeyPressed(Keys keys, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
            match.keyDown(this.seleniumToSikuliKeyConverter(keys));
            match.keyUp(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyPressed ('" + this.seleniumToSikuliKeyConverter(keys) + "') on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    @Deprecated
    public RadioButtonValidatorSI typeText(String text, NewTextLocation location, int maxIterationsToLocateElements) {
        Assert.fail((String)"typeText() API is not supported for RadioButton element.");
        return this;
    }

    @Override
    public RadioButtonValidatorSI scrollElementOnViewport(Scrollbar scrollbar) {
        return this;
    }

    public Match findElement(int maxIterationsToLocateElements) {
        Match match = null;
        for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
            try {
                Region region = this.rbObject.getRadioButtonImageLocation().getRegionOfImageObject(this.appDriver, this.rbObject.getRadioButtonImage(this.appDriver.getAppConfig().getTestPlatformType(), this.appDriver.getAppConfig().getAppType(), this.appDriver.getAppConfig().getAppWebBrowser()));
                Assert.assertNotNull((Object)region, (String)("Failed to find RadioButton '" + this.rbObject.getDisplayName() + "'."));
                match = new Match(region, 1.0);
                break;
            }
            catch (Throwable th) {
                if (i == maxIterationsToLocateElements) {
                    Assert.fail((String)("Unable to find RadioButton '" + this.rbObject.getDisplayName() + "'. Reason timeout(waited for " + maxIterationsToLocateElements * 2 + " seconds)."), (Throwable)th);
                    break;
                }
                this.appDriver.waitForSeconds(2);
                continue;
            }
        }
        return match;
    }

    public Match findElementNoException(int maxIterationsToLocateElements) {
        Match match = null;
        try {
            match = this.findElement(maxIterationsToLocateElements);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return match;
    }

    @Override
    public List<Match> findElements(int maxIterationsToLocateElements) {
        Region r = this.rbObject.getRadioButtonImageLocation().getRegion(this.appDriver);
        return new ImageObject(UIObjectType.radioButton, this.rbObject.getDisplayName(), this.rbObject.getRadioButtonImage(this.appDriver.getAppConfig().getTestPlatformType(), this.appDriver.getAppConfig().getAppType(), this.appDriver.getAppConfig().getAppWebBrowser())).getValidator(this.appDriver, r).findElements(maxIterationsToLocateElements);
    }

    public RadioButtonValidatorSI dragAndDrop(ImageObject target, Region targetRegion, int maxIterationsToLocateElements) {
        try {
            Match sourceElem = this.findElement(maxIterationsToLocateElements);
            Match targetElem = target.getValidator(this.appDriver, targetRegion).findElement(maxIterationsToLocateElements);
            Assert.assertNotNull((Object)sourceElem, (String)("Failed to find RadioButton '" + this.rbObject.getDisplayName() + "'."));
            Assert.assertNotNull((Object)targetElem, (String)("Failed to find element '" + target.getDisplayName() + "'."));
            sourceElem.drag((Object)targetElem);
            sourceElem.dropAt((Object)targetElem);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform dragAndDrop from source '" + this.rbObject.getDisplayName() + "' to target '" + target.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    protected Location getImageSection(Match imageMatch, ImageSection imageSection) {
        switch (imageSection) {
            case topLeft: {
                return imageMatch.getTopLeft();
            }
            case topRight: {
                return imageMatch.getTopRight();
            }
            case bottomLeft: {
                return imageMatch.getBottomLeft();
            }
            case bottomRight: {
                return imageMatch.getBottomRight();
            }
            case center: {
                return imageMatch.getCenter();
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public RadioButtonValidatorSI validateDisabled(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateDisabled() is not supported for RadioButton component.");
        return this;
    }

    @Override
    @Deprecated
    public RadioButtonValidatorSI validateEnabled(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateEnabled() is not supported for RadioButton component.");
        return this;
    }

    @Override
    public RadioButtonValidatorSI select(int maxIterationsToLocateElements) {
        this.click(maxIterationsToLocateElements);
        return this;
    }

    @Override
    @Deprecated
    public RadioButtonValidatorSI validateSelected(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateEnabled() is not supported for RadioButton component.");
        return this;
    }

    @Override
    @Deprecated
    public RadioButtonValidatorSI validateNotSelected(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateEnabled() is not supported for RadioButton component.");
        return this;
    }

    @Override
    public boolean isDisabled(int maxIterationsToLocateElements) {
        Assert.fail((String)"isDisabled() API is not supported by RadioButton component.");
        return false;
    }

    @Override
    @Deprecated
    public Actions getNewSeleniumActions() {
        Assert.fail((String)"getNewSeleniumActions() API is not supported by RadioButton component.");
        return null;
    }

    @Override
    public boolean isDisabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateEnabledButNotReadonly() API is not supported by RadioButton component.");
        return false;
    }

    @Override
    public RadioButtonValidatorSI validateDisabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateEnabledButNotReadonly() API is not supported by RadioButton component.");
        return this;
    }

    @Override
    public RadioButtonValidatorSI validateEnabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateEnabledButNotReadonly() API is not supported by RadioButton component.");
        return this;
    }
}

