/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.imgobj;

import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.interactions.Actions;
import org.sikuli.script.Button;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.ImageSection;
import org.uitnet.testing.smartfwk.ui.core.objects.ImageObject;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.core.objects.textarea.TextAreaValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.ClipboardUtil;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.TextAreaSI;

public class TextAreaValidatorSI
extends TextAreaValidator {
    protected TextAreaSI textAreaObj;

    public TextAreaValidatorSI(SmartAppDriver appDriver, TextAreaSI uiObject, Region region) {
        super(appDriver, uiObject, region);
        this.textAreaObj = uiObject;
    }

    @Override
    @Deprecated
    public TextAreaValidatorSI validateDisabled(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateDisabled() API is not supported by TextAreaSI.");
        return this;
    }

    @Override
    @Deprecated
    public TextAreaValidatorSI validateEnabled(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateEnabled() API is not supported by TextAreaSI.");
        return this;
    }

    @Override
    public boolean isPresent(int maxIterationsToLocateElements) {
        Match m = this.findElementNoException(maxIterationsToLocateElements);
        return m != null;
    }

    @Override
    public boolean isVisible(int maxIterationsToLocateElements) {
        return this.isPresent(maxIterationsToLocateElements);
    }

    @Override
    public TextAreaValidatorSI click(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on TextArea '" + this.textAreaObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    public TextAreaValidatorSI click(ImageSection imageSection, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            this.getImageSection(match, imageSection).click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on TextArea '" + this.textAreaObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public TextAreaValidatorSI doubleClick(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on TextArea '" + this.textAreaObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    public TextAreaValidatorSI doubleClick(ImageSection imageSection, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            this.getImageSection(match, imageSection).doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on TextArea '" + this.textAreaObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public TextAreaValidatorSI rightClick(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on TextArea '" + this.textAreaObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    public TextAreaValidatorSI rightClick(ImageSection imageSection, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            this.getImageSection(match, imageSection).rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on TextArea '" + this.textAreaObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public TextAreaValidatorSI clickAndHold(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on TextArea '" + this.textAreaObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public TextAreaValidatorSI release(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on TextArea '" + this.textAreaObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public TextAreaValidatorSI performKeyDown(Keys keys, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
            match.keyDown(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyDown on TextArea '" + this.textAreaObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public TextAreaValidatorSI performKeyUp(Keys keys, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
            match.keyUp(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyUp ('" + this.seleniumToSikuliKeyConverter(keys) + "') on TextArea '" + this.textAreaObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public TextAreaValidatorSI performKeyPressed(Keys keys, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
            match.type(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyPressed ('" + this.seleniumToSikuliKeyConverter(keys) + "') on TextArea '" + this.textAreaObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public TextAreaValidatorSI typeText(String text, NewTextLocation location, int maxIterationsToLocateElements) {
        Match match = this.findElement(maxIterationsToLocateElements);
        try {
            match.click();
            switch (location) {
                case start: {
                    match.type("\ue008");
                    break;
                }
                case end: {
                    match.type("\ue007");
                    break;
                }
                case replace: {
                    match.type("a", 2);
                }
            }
            match.type(text);
        }
        catch (Throwable th) {
            Assert.fail((String)("Fail to type text '" + text + "' in TextArea '" + this.textAreaObj.getDisplayName() + "'."));
        }
        return this;
    }

    @Override
    public TextAreaValidatorSI scrollElementOnViewport(Scrollbar scrollbar) {
        return this;
    }

    public Match findElement(int maxIterationsToLocateElements) {
        Match match = null;
        for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
            try {
                Region region = this.textAreaObj.getLocation().getRegionOfImageObject(this.appDriver, this.textAreaObj.getLeftSideImage(this.appDriver.getAppConfig().getTestPlatformType(), this.appDriver.getAppConfig().getAppType(), this.appDriver.getAppConfig().getAppWebBrowser()), this.textAreaObj.getRightSideImage(this.appDriver.getAppConfig().getTestPlatformType(), this.appDriver.getAppConfig().getAppType(), this.appDriver.getAppConfig().getAppWebBrowser()));
                Assert.assertNotNull((Object)region, (String)("Failed to find TextArea '" + this.textAreaObj.getDisplayName() + "'."));
                match = new Match(region, 1.0);
                break;
            }
            catch (Throwable th) {
                if (i == maxIterationsToLocateElements) {
                    Assert.fail((String)("Unable to find TextArea '" + this.textAreaObj.getDisplayName() + "'. Reason timeout(waited for " + maxIterationsToLocateElements * 2 + " seconds)."), (Throwable)th);
                    break;
                }
                this.appDriver.waitForSeconds(2);
                continue;
            }
        }
        return match;
    }

    public Match findElementNoException(int maxIterationsToLocateElements) {
        Match match = null;
        try {
            match = this.findElement(maxIterationsToLocateElements);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return match;
    }

    @Override
    public List<Match> findElements(int maxIterationsToLocateElements) {
        Assert.fail((String)"findElements() api for TextAreaSI element is not implemented.");
        return null;
    }

    public TextAreaValidatorSI dragAndDrop(ImageObject target, Region targetRegion, int maxIterationsToLocateElements) {
        try {
            Match sourceElem = this.findElement(maxIterationsToLocateElements);
            Match targetElem = target.getValidator(this.appDriver, targetRegion).findElement(maxIterationsToLocateElements);
            Assert.assertNotNull((Object)sourceElem, (String)("Failed to find TextArea '" + this.textAreaObj.getDisplayName() + "'."));
            Assert.assertNotNull((Object)targetElem, (String)("Failed to find element '" + target.getDisplayName() + "'."));
            sourceElem.drag((Object)targetElem);
            sourceElem.dropAt((Object)targetElem);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform dragAndDrop from source '" + this.textAreaObj.getDisplayName() + "' to target '" + target.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    protected Location getImageSection(Match imageMatch, ImageSection imageSection) {
        switch (imageSection) {
            case topLeft: {
                return imageMatch.getTopLeft();
            }
            case topRight: {
                return imageMatch.getTopRight();
            }
            case bottomLeft: {
                return imageMatch.getBottomLeft();
            }
            case bottomRight: {
                return imageMatch.getBottomRight();
            }
            case center: {
                return imageMatch.getCenter();
            }
        }
        return null;
    }

    @Override
    public TextAreaValidatorSI validateTextValue(String expectedValue, TextMatchMechanism validationMechanism, int maxIterationsToLocateElements) {
        if (this.textAreaObj.isDisabled()) {
            Match match = this.findElement(maxIterationsToLocateElements);
            this.validateTextValue(match.text(), expectedValue, validationMechanism);
        } else {
            this.validateTextValue(this.getTextValue(maxIterationsToLocateElements), expectedValue, validationMechanism);
        }
        return this;
    }

    @Override
    public String getTextValue(int maxIterationsToLocateElements) {
        Match match = this.findElement(maxIterationsToLocateElements);
        if (this.textAreaObj.isDisabled()) {
            return match.getText();
        }
        match.click();
        ClipboardUtil.clearContents();
        match.type("ac", 2);
        String contents = ClipboardUtil.getContents();
        ClipboardUtil.clearContents();
        match.click();
        return contents;
    }

    @Override
    @Deprecated
    public boolean isDisabled(int maxIterationsToLocateElements) {
        Assert.fail((String)"isDisabled() API is not supported by TextArea component.");
        return false;
    }

    @Override
    @Deprecated
    public boolean isReadonly(int maxIterationsToLocateElements) {
        Assert.fail((String)"isDisabled() API is not supported by TextArea component.");
        return false;
    }

    @Override
    @Deprecated
    public TextAreaValidatorSI validateReadonly(int maxIterationsToLocateElements) {
        Assert.fail((String)"isDisabled() API is not supported by TextArea component.");
        return this;
    }

    @Override
    @Deprecated
    public TextAreaValidatorSI validateNotReadonly(int maxIterationsToLocateElements) {
        Assert.fail((String)"isDisabled() API is not supported by TextArea component.");
        return this;
    }

    @Override
    @Deprecated
    public Actions getNewSeleniumActions() {
        Assert.fail((String)"getNewSeleniumActions() API is not supported by TextArea component.");
        return null;
    }

    @Override
    public boolean isDisabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.fail((String)"isDisabledButNotReadonly() API is not supported by TextArea component.");
        return false;
    }

    @Override
    public TextAreaValidatorSI validateDisabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateDisabledButNotReadonly() API is not supported by TextArea component.");
        return this;
    }

    @Override
    public TextAreaValidatorSI validateEnabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateEnabledButNotReadonly() API is not supported by TextArea component.");
        return this;
    }
}

