/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.validator;

import java.io.File;
import java.nio.file.Files;
import java.util.TreeMap;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.api.core.support.HttpResponse;
import org.uitnet.testing.smartfwk.api.core.support.PayloadType;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;

public class DownloadedFileValidator {
    private DownloadedFileValidator() {
    }

    public static String getDownloadLocation() {
        return TestConfigManager.getInstance().getDownloadLocation();
    }

    public static void validateBrowserFileDownloaded(String expectedStartsWithText, String expectedFileExtension, boolean deleteLatestFilteredFileAfterValidation) {
        TreeMap filteredFiles = new TreeMap();
        try {
            Files.list(new File(DownloadedFileValidator.getDownloadLocation()).toPath()).forEach(p -> {
                String fName = p.toFile().getName();
                if (fName.startsWith(expectedStartsWithText) && fName.endsWith(expectedFileExtension)) {
                    filteredFiles.put(p.toFile().lastModified(), fName);
                }
            });
            if (filteredFiles.size() == 0) {
                Assert.fail((String)("No file found at downloads location '" + DownloadedFileValidator.getDownloadLocation() + "' that starts with '" + expectedStartsWithText + "' and ends with '" + expectedFileExtension + "' text."));
            }
        }
        catch (Exception exception) {
        }
        catch (Error e) {
            throw e;
        }
        finally {
            if (deleteLatestFilteredFileAfterValidation && filteredFiles.size() > 0) {
                new File((String)filteredFiles.lastEntry().getValue()).delete();
            }
        }
    }

    public static void validateFileDownloaded(String expectedFileName, HttpResponse httpResponse, TextMatchMechanism fileNameMatchMechanism, boolean deleteAfterValidation) {
        Assert.assertNotNull((Object)httpResponse, (String)"HTTP response should not be null.");
        if (httpResponse.getPayloadType() == null || httpResponse.getPayloadType() != PayloadType.FILE) {
            Assert.fail((String)"HTTP response payload type must be of FILE type.");
        }
        DownloadedFileValidator.validateFileDownloaded(expectedFileName, httpResponse.getPayload(), httpResponse.getFilePath(), fileNameMatchMechanism, deleteAfterValidation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateFileDownloaded(String expectedFileName, String actualFileName, String actualFileAbsolutePath, TextMatchMechanism fileNameMatchMechanism, boolean deleteAfterValidation) {
        TextMatchMechanism fnMatchMech = null;
        if (fileNameMatchMechanism == null) {
            fnMatchMech = TextMatchMechanism.exactMatchWithExpectedValue;
        }
        Assert.assertNotNull((Object)actualFileName, (String)"Filename cannot be null.");
        Assert.assertNotNull((Object)actualFileName.trim().equals(""), (String)"Filename cannot be empty.");
        Assert.assertNotNull((Object)actualFileAbsolutePath, (String)("Absolute file path of expected file '" + expectedFileName + "' cannot be null."));
        File file = new File(actualFileAbsolutePath);
        try {
            switch (fnMatchMech) {
                case exactMatchWithExpectedValue: {
                    if (actualFileName.equals(expectedFileName)) break;
                    Assert.fail((String)("Actual filename '" + actualFileName + " does not match with expected filename '" + expectedFileName + "'."));
                    break;
                }
                case containsExpectedValue: {
                    if (actualFileName.contains(expectedFileName)) break;
                    Assert.fail((String)("Actual filename '" + actualFileName + " does not contain expected text '" + expectedFileName + "'."));
                    break;
                }
                case endsWithExpectedValue: {
                    if (actualFileName.endsWith(expectedFileName)) break;
                    Assert.fail((String)("Actual filename '" + actualFileName + " does not ends with expected text '" + expectedFileName + "'."));
                    break;
                }
                case startsWithExpectedValue: {
                    if (actualFileName.startsWith(expectedFileName)) break;
                    Assert.fail((String)("Actual filename '" + actualFileName + " does not starts with expected text '" + expectedFileName + "'."));
                    break;
                }
                case exactMatchWithExpectedValueWithRemovedWhiteSpace: {
                    if (actualFileName.trim().equals(expectedFileName)) break;
                    Assert.fail((String)("Actual filename '" + actualFileName + " does not match with expected filename '" + expectedFileName + "'."));
                    break;
                }
                case matchWithRegularExpression: {
                    if (actualFileName.matches(expectedFileName)) break;
                    Assert.fail((String)("Actual filename '" + actualFileName + " does not match with expected regular expression '" + expectedFileName + "'."));
                    break;
                }
            }
            if (!file.exists()) {
                Assert.fail((String)("File not found at '" + actualFileAbsolutePath + "' location."));
            }
        }
        finally {
            if (deleteAfterValidation && file.exists()) {
                file.delete();
            }
        }
    }
}

