/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.validator;

import org.testng.Assert;
import org.uitnet.testing.smartfwk.api.core.support.HttpResponse;
import org.uitnet.testing.smartfwk.api.core.support.PayloadType;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;
import org.uitnet.testing.smartfwk.validator.DownloadedFileValidator;
import org.uitnet.testing.smartfwk.validator.FileContentsValidator;

public class HttpResponseValidator {
    private HttpResponse response;

    public HttpResponseValidator(HttpResponse response) {
        this.response = response;
    }

    public HttpResponseValidator validateExpectedResponseCode(int expectedResponseCode) {
        Assert.assertEquals((int)this.response.getCode(), (int)expectedResponseCode, (String)"HTTP Response code does not match with expected value.");
        return this;
    }

    public HttpResponseValidator validateExpectedHeaderValue(String headerName, String expectedValue) {
        String actual = this.response.getHeader(headerName);
        Assert.assertEquals((String)actual, (String)expectedValue, (String)("Header '" + headerName + "' value does not match with expected value."));
        return this;
    }

    public HttpResponseValidator validateExpectedHeaderValue(String headerName, String expectedValue, TextMatchMechanism textMatchMechanism) {
        String actual = this.response.getHeader(headerName);
        if (!StringUtil.isTextMatchedWithExpectedValue(actual, expectedValue, textMatchMechanism)) {
            Assert.fail((String)("Header '" + headerName + "' actual value '" + actual + "' does not match with the expected value '" + expectedValue + "' using '" + textMatchMechanism.name() + "' text match mechanism."));
        }
        return this;
    }

    public HttpResponseValidator validateResponsePayloadType(PayloadType expectedPayloadType) {
        Assert.assertEquals((String)this.response.getPayloadType().name(), (String)expectedPayloadType.name(), (String)"HTTP Response payload type does not match.");
        return this;
    }

    public HttpResponseValidator validateResponseNotNull() {
        Assert.assertNotNull((Object)this.response.getPayload(), (String)"HTTP Response payload should not be null.");
        return this;
    }

    public HttpResponseValidator validateResponseIsNull() {
        Assert.assertNull((Object)this.response.getPayload(), (String)"HTTP Response is not null.");
        return this;
    }

    public HttpResponseValidator validateContentType(String expectedContentType) {
        this.validateExpectedHeaderValue("Content-Type", expectedContentType);
        return this;
    }

    public HttpResponseValidator validateMinContentLength(long minLength) {
        String contentLength = this.response.getHeader("Content-Length");
        if (minLength >= 0L) {
            Assert.assertNotNull((Object)contentLength, (String)"HTTP response content length should not null.");
            if (Long.parseLong(contentLength) < minLength) {
                Assert.fail((String)("HTTP response content length should be greater than " + (minLength - 1L) + "."));
            }
        }
        return this;
    }

    public HttpResponseValidator validateFileDownloaded(String expectedFileName, TextMatchMechanism fileNameMatchMechanism, boolean deleteAfterValidation) {
        this.validateResponsePayloadType(PayloadType.FILE);
        DownloadedFileValidator.validateFileDownloaded(expectedFileName, this.response, fileNameMatchMechanism, deleteAfterValidation);
        return this;
    }

    public HttpResponseValidator validateDownloadedFileContainsAllKeywordsInOrder(boolean shouldPrintFileContentsOnConsole, String ... keyWords) {
        this.validateResponsePayloadType(PayloadType.FILE);
        FileContentsValidator fcv = new FileContentsValidator(this.response.getFilePath(), shouldPrintFileContentsOnConsole);
        fcv.validateAllKeywordsPresentInOrder(keyWords);
        return this;
    }

    public HttpResponseValidator validateDownloadedFileContainsAllKeywords(boolean shouldPrintFileContentsOnConsole, String ... keyWords) {
        this.validateResponsePayloadType(PayloadType.FILE);
        FileContentsValidator fcv = new FileContentsValidator(this.response.getFilePath(), shouldPrintFileContentsOnConsole);
        fcv.validateAllKeywordsPresent(keyWords);
        return this;
    }

    public HttpResponseValidator validateDownloadedFileContainsAtLeastNKeyword(boolean shouldPrintFileContentsOnConsole, int atLeastN, boolean inOrder, String ... keyWords) {
        this.validateResponsePayloadType(PayloadType.FILE);
        FileContentsValidator fcv = new FileContentsValidator(this.response.getFilePath(), shouldPrintFileContentsOnConsole);
        fcv.validateAtLeastNKeywordPresent(atLeastN, inOrder, keyWords);
        return this;
    }

    public String getExtractedFileContents() {
        this.validateResponsePayloadType(PayloadType.FILE);
        FileContentsValidator fcv = new FileContentsValidator(this.response.getFilePath(), false);
        return fcv.extractFileContents();
    }
}

