/*
 * SmartTestAutoFramework
 * Copyright 2021 and beyond [Madhav Krishna]
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package org.uitnet.testing.smartfwk.ui.core.objects.accordion;

import org.sikuli.script.Region;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObjectValidator;

/**
 * 
 * @author Madhav Krishna
 *
 */
public abstract class SectionValidator extends UIObjectValidator {
	private Section section;

	public SectionValidator(SmartAppDriver appDriver, Section uiObject, Region region) {
		super(appDriver, uiObject, region);
	}

	@Override
	public Section getUIObject() {
		return section;
	}

	public abstract void selectSection(int maxIterationsToLocateElements);

	public abstract void isSectionSelected(int maxIterationsToLocateElements);

	public abstract void validateSectionSelected(int maxIterationsToLocateElements);
}
