/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.common;

import io.cucumber.java.en.When;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.core.validator.ExpectedInfo;
import org.uitnet.testing.smartfwk.core.validator.ParamPath;
import org.uitnet.testing.smartfwk.core.validator.ParamValue;
import org.uitnet.testing.smartfwk.core.validator.ValueMatchOperator;
import org.uitnet.testing.smartfwk.ui.core.utils.ObjectUtil;
import org.uitnet.testing.smartfwk.validator.ParameterValidator;

public class SmartConditionManagementStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartConditionManagementStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @When(value="condition={string}-Start> if [{string} {string} {string}] condition is true then execute the steps below.")
    public void set_condition(String conditionName, String conditionLeftValue, String operator, String conditionRightValue) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object avalue = this.scenarioContext.getParamValueNullAsParamName(conditionLeftValue);
        Object evalue = this.scenarioContext.getParamValueNullAsParamName(conditionRightValue);
        ValueMatchOperator oper = ValueMatchOperator.valueOf2((String)operator);
        ParamValue pv1 = ObjectUtil.convertObjectToParamValue((Object)avalue);
        ParamValue pv2 = ObjectUtil.convertObjectToParamValue((Object)evalue);
        ObjectUtil.fixValueTypesInParamValueObjects((ParamValue)pv1, (ValueMatchOperator)oper, (ParamValue)pv2);
        ParamPath pPath = new ParamPath(conditionLeftValue, pv1.getValueTypeAsStr());
        ExpectedInfo eInfo = new ExpectedInfo();
        eInfo.setEv(pv2.getV());
        eInfo.setValueType(pv2.getValueType().getType());
        try {
            ParameterValidator.validateParamValueAsExpectedInfo((boolean)false, (ParamPath)pPath, (Object)pv1.getV(), (String)operator, (ExpectedInfo)eInfo);
            this.scenarioContext.setCondition(conditionName, Boolean.valueOf(true));
        }
        catch (Throwable th) {
            this.scenarioContext.setCondition(conditionName, Boolean.valueOf(false));
        }
    }

    @When(value="condition={string}-Start> if [{string} {string} {string} and TextMatchCondition={string}] condition is true then execute the steps below.")
    public void set_condition2(String conditionName, String conditionLeftValue, String operator, String conditionRightValue, String textMatchMechanism) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object avalue = this.scenarioContext.getParamValueNullAsParamName(conditionLeftValue);
        Object evalue = this.scenarioContext.getParamValueNullAsParamName(conditionRightValue);
        ValueMatchOperator oper = ValueMatchOperator.valueOf2((String)operator);
        ParamValue pv1 = ObjectUtil.convertObjectToParamValue((Object)avalue);
        ParamValue pv2 = ObjectUtil.convertObjectToParamValue((Object)evalue);
        ObjectUtil.fixValueTypesInParamValueObjects((ParamValue)pv1, (ValueMatchOperator)oper, (ParamValue)pv2);
        ParamPath pPath = new ParamPath(conditionLeftValue, pv1.getValueTypeAsStr());
        ExpectedInfo eInfo = new ExpectedInfo();
        eInfo.setEv(pv2.getV());
        eInfo.setValueType(pv2.getValueType().getType());
        eInfo.setTextMatchMechanism(textMatchMechanism);
        try {
            ParameterValidator.validateParamValueAsExpectedInfo((boolean)false, (ParamPath)pPath, (Object)pv1.getV(), (String)operator, (ExpectedInfo)eInfo);
            this.scenarioContext.setCondition(conditionName, Boolean.valueOf(true));
        }
        catch (Throwable th) {
            this.scenarioContext.setCondition(conditionName, Boolean.valueOf(false));
        }
    }

    @When(value="condition={string}-End.")
    public void unset_condition(String conditionName) {
        if (this.scenarioContext.isConditionSet(conditionName)) {
            this.scenarioContext.unsetCondition(conditionName);
        } else if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
    }
}

