/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.common.data;

import io.cucumber.java.en.When;
import java.util.List;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.ui.core.file.reader.CSVFileReader;
import org.uitnet.testing.smartfwk.ui.core.file.reader.support.Table;

public class SmartCsvDataManagementStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartCsvDataManagementStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @When(value="read {string} CSV file into tabular form and store into {string} CSV variable.")
    public void read_csv_file_into_tabular_form_and_store_inot_variable(String relativeCSVFilePath, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Table tabularData = CSVFileReader.getData((String)relativeCSVFilePath);
        this.scenarioContext.addParamValue(variableName, (Object)tabularData);
    }

    @When(value="read {string} CSV file into tabular form and store into {string} CSV variable [DataDelimiter={string}, QuoteChar={string}, TrimData={string}].")
    public void read_sheet_data_of_excel_file_into_tabular_form_and_store_inot_variable(String relativeCSVFilePath, String variableName, char dataDelimiter, char quoteChar, String trimData) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Table tabularData = CSVFileReader.getData((String)relativeCSVFilePath, (char)dataDelimiter, (char)quoteChar, ("yes".equalsIgnoreCase(trimData) || "true".equalsIgnoreCase(trimData) ? 1 : 0) != 0);
        this.scenarioContext.addParamValue(variableName, (Object)tabularData);
    }

    @When(value="read {string} column data from {string} CSV variable and store into {string} variable.")
    public void read_column_data_from_csv_variable_and_store_into_variable(String columnName, String CSVVariableName, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Table tabularData = (Table)this.scenarioContext.getParamValue(CSVVariableName);
        List colData = tabularData.getColumnData(columnName);
        this.scenarioContext.addParamValue(variableName, (Object)colData);
    }

    @When(value="read {int} row of {string} column data from {string} CSV variable and store into {string} variable.")
    public void read_nth_row_of_column_data_from_csv_variable_and_store_into_variable(int nthRow, String columnName, String CSVVariableName, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Table tabularData = (Table)this.scenarioContext.getParamValue(CSVVariableName);
        List colData = tabularData.getColumnData(columnName);
        this.scenarioContext.addParamValue(variableName, colData.get(nthRow));
    }

    @When(value="read all column names from {string} CSV variable and store into {string} variable.")
    public void read_all_column_names_from_csv_variable_and_store_into_variable(String CSVVariableName, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Table tabularData = (Table)this.scenarioContext.getParamValue(CSVVariableName);
        List colNames = tabularData.getColumnNames();
        this.scenarioContext.addParamValue(variableName, (Object)colNames);
    }

    @When(value="read column count from {string} CSV variable and store into {string} variable.")
    public void read_column_count_from_csv_variable_and_store_into_variable(String CSVVariableName, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Table tabularData = (Table)this.scenarioContext.getParamValue(CSVVariableName);
        List colNames = tabularData.getColumnNames();
        this.scenarioContext.addParamValue(variableName, (Object)colNames.size());
    }

    @When(value="read row count from {string} CSV variable and store into {string} variable.")
    public void read_row_count_from_csv_variable_and_store_into_variable(String CSVVariableName, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Table tabularData = (Table)this.scenarioContext.getParamValue(CSVVariableName);
        this.scenarioContext.addParamValue(variableName, (Object)tabularData.getRowCount());
    }
}

