/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.common.data;

import dev.failsafe.internal.util.Assert;
import io.cucumber.datatable.DataTable;
import io.cucumber.docstring.DocString;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.File;
import java.util.List;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.api.core.reader.XmlDocumentReader;
import org.uitnet.testing.smartfwk.core.validator.ParamPath;
import org.uitnet.testing.smartfwk.core.validator.SmartDataValidator;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;
import org.uitnet.testing.smartfwk.ui.core.utils.JsonYamlUtil;
import org.w3c.dom.Document;

public class SmartXmlDataManagementStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartXmlDataManagementStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @When(value="read {string} XML file contents and store into {string} variable.")
    public void read_xml_file_contents_and_store_into_variable(String xmlDataRelativeFilePath, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        XmlDocumentReader reader = new XmlDocumentReader(new File(Locations.getProjectRootDir() + File.separator + xmlDataRelativeFilePath));
        this.scenarioContext.addParamValue(variableName, (Object)reader.getDocument());
    }

    @When(value="convert {string} XML text into XML object and store into {string} variable.")
    public void convert_xml_text_into_xml_object_and_store_into_variable(String xmlText, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        xmlText = this.scenarioContext.applyParamsValueOnText(xmlText);
        XmlDocumentReader reader = new XmlDocumentReader(xmlText);
        this.scenarioContext.addParamValue(variableName, (Object)reader.getDocument());
    }

    @When(value="convert {string} variable contents into XML object and store into {string} variable.")
    public void convert_variable_contents_into_xml_object_and_store_into_variable(String xmlInputVariableName, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String xmlInput = this.scenarioContext.getParamValueAsString(xmlInputVariableName);
        this.convert_xml_text_into_xml_object_and_store_into_variable(xmlInput, variableName);
    }

    @When(value="convert the following XML text into XML object and store into {string} variable:")
    public void convert_the_following_xml_text_into_xml_object_and_store_into_variable(String variableName, DocString xmlText) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String xmlTxt = xmlText.getContent();
        xmlTxt = this.scenarioContext.applyParamsValueOnText(xmlTxt);
        XmlDocumentReader reader = new XmlDocumentReader(xmlTxt);
        this.scenarioContext.addParamValue(variableName, (Object)reader.getDocument());
    }

    @When(value="read {string} parameter value from XML object [XMLObjRefVariable={string}] and store into {string} variable.")
    public void read_parameter_value_from_xml_object_xml_obj_ref_variable_and_store_into_variable(String xmlPath, String xmlObjRefVariable, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object xmlObjContext = this.scenarioContext.getParamValue(xmlObjRefVariable);
        Assert.notNull((Object)xmlObjContext, (String)("'" + xmlObjRefVariable + "' variable does not have XML object. Found null."));
        org.testng.Assert.assertTrue((boolean)(xmlObjContext instanceof Document), (String)("'" + xmlObjRefVariable + "' variable is not a XML object. It should be the instance of Document class."));
        Document xmlObj = (Document)xmlObjContext;
        XmlDocumentReader xmlReader = new XmlDocumentReader(xmlObj);
        ParamPath paramPath = JsonYamlUtil.parseParamPath((String)xmlPath);
        Object value = xmlReader.findAttributeOrTextValues(paramPath.getPath(), paramPath);
        this.scenarioContext.addParamValue(variableName, value);
    }

    @Then(value="verify the following parameters of XML object matches with the expected information as per the tabular info given below [XMLObjRefVariable={string}]:")
    public void verify_the_following_parameters_of_xml_object_matches_with_the_expected_information_as_per_the_tabular_info_given_below_xml_obj_ref_variable(String xmlObjRefVariable, DataTable xmlParamInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object xmlObjContext = this.scenarioContext.getParamValue(xmlObjRefVariable);
        Assert.notNull((Object)xmlObjContext, (String)("'" + xmlObjRefVariable + "' variable does not have XML object. Found null."));
        org.testng.Assert.assertTrue((boolean)(xmlObjContext instanceof Document), (String)("'" + xmlObjRefVariable + "' variable is not a XML object. It should be the instance of Document class."));
        Document xmlObj = (Document)xmlObjContext;
        List rows = xmlParamInfo.asLists();
        for (int i = 1; i < rows.size(); ++i) {
            List row = (List)rows.get(i);
            String xmlPath = (String)row.get(0);
            String oper = (String)row.get(1);
            String expectedInfo = (String)row.get(2);
            xmlPath = this.scenarioContext.applyParamsValueOnText(xmlPath);
            expectedInfo = this.scenarioContext.applyParamsValueOnText(expectedInfo);
            SmartDataValidator.validateXmlData((Document)xmlObj, (String)xmlPath, (String)oper, (String)expectedInfo);
        }
    }
}

