/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.common.local_machine;

import io.cucumber.docstring.DocString;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.local_machine.LocalMachineFileSystem;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;
import org.uitnet.testing.smartfwk.validator.DownloadedFileValidator;
import org.uitnet.testing.smartfwk.validator.FileContentsValidator;

public class SmartLocalFileManagementStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartLocalFileManagementStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @When(value="remove {string} file from the local downloads directory.")
    public void remove_file_from_the_local_downloads_directory(String fileName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        LocalMachineFileSystem.deleteFiles((String)(Locations.getProjectRootDir() + "/test-results/downloads"), (TextMatchMechanism)TextMatchMechanism.exactMatchWithExpectedValue, (String)fileName);
    }

    @Then(value="verify that the {string} file with extension {string} is downloaded [MaxTimeToWaitInSeconds={int}].")
    public void verify_that_the_file_with_extension_is_downloaded_maxtimetowaitinseconds(String fileName, String fileExtension, Integer maxTimeToWaitInSeconds) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        DownloadedFileValidator.validateBrowserFileDownloaded((String)fileName, (String)fileExtension, (boolean)false, (int)maxTimeToWaitInSeconds);
    }

    @Then(value="verify that the {string} file with extension {string} is present in downloads directory [MaxTimeToWaitInSeconds={int}].")
    public void verify_that_the_file_with_extension_is_downloaded_maxtimetowaitinseconds_1(String fileName, String fileExtension, Integer maxTimeToWaitInSeconds) {
        this.verify_that_the_file_with_extension_is_downloaded_maxtimetowaitinseconds(fileName, fileExtension, maxTimeToWaitInSeconds);
    }

    @Then(value="verify that the downloaded file {string} contains the following keywords [KeywordDelimiter={string}, InOrder={string}, ShouldPrint={string}]:")
    public void verify_that_the_downloaded_file_contains_the_following_text(String fileNameWithExtension, String keywordDelimiter, String inOrder, String shouldPrint, DocString keywords) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        FileContentsValidator fcValidator = new FileContentsValidator(Locations.getProjectRootDir() + "/test-results/downloads/" + fileNameWithExtension, "Yes".equalsIgnoreCase(shouldPrint));
        String txt = this.scenarioContext.applyParamsValueOnText(keywords.getContent());
        String[] arr = txt.split(keywordDelimiter);
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = StringUtil.trimNullAsEmpty((String)arr[i]);
        }
        if ("Yes".equalsIgnoreCase(inOrder)) {
            fcValidator.validateAllKeywordsPresentInOrder(arr);
        } else {
            fcValidator.validateAllKeywordsPresent(arr);
        }
    }
}

