/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.common.variable;

import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.core.validator.ExpectedInfo;
import org.uitnet.testing.smartfwk.core.validator.ParamPath;
import org.uitnet.testing.smartfwk.core.validator.ParamValue;
import org.uitnet.testing.smartfwk.core.validator.ValueMatchOperator;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.DataMatchUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.ObjectUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;
import org.uitnet.testing.smartfwk.validator.ParameterValidator;

public class SmartVariableManagementStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartVariableManagementStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @When(value="store null value into {string} variable.")
    public void store_null_value_into_variable(String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        this.scenarioContext.addParamValue(variableName, null);
    }

    @When(value="store empty list into {string} variable.")
    public void store_empty_list_into_variable(String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        LinkedList list = new LinkedList();
        this.scenarioContext.addParamValue(variableName, list);
    }

    @When(value="print {string} variable.")
    public void print_variable(String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        this.scenarioContext.log(variableName);
    }

    @When(value="append {string} prefix to each value present in {string} list variable.")
    public void append_prefix_to_each_value_in_list_variable(String prefix, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        List list = (List)this.scenarioContext.getParamValue(variableName);
        if (list != null) {
            LinkedList<CallSite> list2 = new LinkedList<CallSite>();
            for (String str : list) {
                list2.add((CallSite)((Object)(prefix + str)));
            }
            this.scenarioContext.addParamValue(variableName, list2);
        }
    }

    @When(value="append {string} prefix to the value of {string} variable.")
    public void append_prefix_to_the_value_of_variable(String prefix, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String str = this.scenarioContext.getParamValueAsString(variableName);
        if (str != null) {
            this.scenarioContext.addParamValue(variableName, (Object)(prefix + str));
        }
    }

    @When(value="append {string} suffix to each value present in {string} list variable.")
    public void append_suffix_to_each_value_in_list_variable(String suffix, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        List list = (List)this.scenarioContext.getParamValue(variableName);
        if (list != null) {
            LinkedList<CallSite> list2 = new LinkedList<CallSite>();
            for (String str : list) {
                list2.add((CallSite)((Object)(str + suffix)));
            }
            this.scenarioContext.addParamValue(variableName, list2);
        }
    }

    @When(value="append {string} suffix to the value of {string} variable.")
    public void append_suffix_to_the_value_of_variable(String suffix, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String str = this.scenarioContext.getParamValueAsString(variableName);
        if (str != null) {
            this.scenarioContext.addParamValue(variableName, (Object)(str + suffix));
        }
    }

    @When(value="append prefix={string} and suffix={string} to each value present in {string} list variable.")
    public void append_prefix_and_suffix_to_each_value_in_list_variable(String prefix, String suffix, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        List list = (List)this.scenarioContext.getParamValue(variableName);
        if (list != null) {
            LinkedList<CallSite> list2 = new LinkedList<CallSite>();
            for (String str : list) {
                list2.add((CallSite)((Object)(prefix + str + suffix)));
            }
            this.scenarioContext.addParamValue(variableName, list2);
        }
    }

    @When(value="append prefix={string} and suffix={string} to the value of {string} variable.")
    public void append_prefix_and_suffix_to_the_value_of_variable(String prefix, String suffix, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String str = this.scenarioContext.getParamValueAsString(variableName);
        if (str != null) {
            this.scenarioContext.addParamValue(variableName, (Object)(prefix + str + suffix));
        }
    }

    @When(value="convert {string} variable value into list using delimiter={string} and store into {string} variable.")
    public void convert_variable_value_into_list_using_delimiter_and_store_into_variable(String variableName, String delimiter, String newVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String str = this.scenarioContext.getParamValueAsString(variableName);
        if (!StringUtil.isEmptyAfterTrim((String)str)) {
            String[] arr = str.split(delimiter);
            LinkedList<String> list = new LinkedList<String>();
            for (String elem : arr) {
                list.add(elem.trim());
            }
            this.scenarioContext.addParamValue(newVariableName, list);
        }
    }

    @When(value="convert {string} list variable value into plain text using joiner={string} and store into {string} variable.")
    public void convert_list_variable_value_into_plain_text_using_joiner_and_store_into_variable(String variableName, String joiner, String newVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        List list = (List)this.scenarioContext.getParamValue(variableName);
        if (list != null) {
            Object str = "";
            for (String elem : list) {
                if ("".equals(str)) {
                    str = elem;
                    continue;
                }
                str = (String)str + joiner + elem;
            }
            this.scenarioContext.addParamValue(newVariableName, str);
        }
    }

    @When(value="convert {string} list variable value into plain text using joiner={string}, valuePrefix={string}, valueSuffix={string} and store into {string} variable.")
    public void convert_list_variable_value_into_plain_text_using_joiner_valueprefix_valuesuffix_and_store_into_variable(String variableName, String joiner, String valuePrefix, String valueSuffix, String newVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        List list = (List)this.scenarioContext.getParamValue(variableName);
        if (list != null) {
            Object str = "";
            for (String elem : list) {
                if ("".equals(str)) {
                    str = elem == null ? elem : valuePrefix + elem + valueSuffix;
                    continue;
                }
                str = elem == null ? (String)str + joiner + elem : (String)str + joiner + valuePrefix + elem + valueSuffix;
            }
            this.scenarioContext.addParamValue(newVariableName, str);
        }
    }

    @When(value="convert {string} list variable value into plain text using joiner={string}, valuePrefix={string}, valueSuffix={string}, default={string} and store into {string} variable.")
    public void convert_list_variable_value_into_plain_text_using_separator_valueprefix_valuesuffix_default_and_store_into_variable(String variableName, String joiner, String valuePrefix, String valueSuffix, String defaultValue, String newVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        LinkedList<String> list = (LinkedList<String>)this.scenarioContext.getParamValue(variableName);
        if (list != null) {
            Object str = "";
            for (String elem : list) {
                if ("".equals(str)) {
                    str = elem == null ? elem : valuePrefix + elem + valueSuffix;
                    continue;
                }
                str = elem == null ? (String)str + joiner + elem : (String)str + joiner + valuePrefix + elem + valueSuffix;
            }
            if (StringUtil.isEmptyAfterTrim((String)str)) {
                list = new LinkedList<String>();
                list.add(defaultValue);
                this.scenarioContext.addParamValue(variableName, list);
                this.scenarioContext.addParamValue(newVariableName, (Object)(valuePrefix + defaultValue + valueSuffix));
            } else {
                this.scenarioContext.addParamValue(newVariableName, str);
            }
        }
    }

    @When(value="copy {string} variable value to {string} variable.")
    public void copy_variable_value_to_variable(String variableName, String newVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object value = this.scenarioContext.getParamValue(variableName);
        if (value != null && value instanceof List) {
            List list = (List)value;
            LinkedList list2 = new LinkedList();
            for (Object elem : list) {
                list2.add(elem);
            }
            this.scenarioContext.addParamValue(newVariableName, list2);
        } else if (value != null && value instanceof Set) {
            Set list = (Set)value;
            LinkedHashSet list2 = new LinkedHashSet();
            for (Object elem : list) {
                list2.add(elem);
            }
            this.scenarioContext.addParamValue(newVariableName, list2);
        } else if (value != null && value instanceof Map) {
            Map map = (Map)value;
            LinkedHashMap map2 = new LinkedHashMap();
            for (Map.Entry elem : map.entrySet()) {
                map2.put(elem.getKey(), elem.getValue());
            }
            this.scenarioContext.addParamValue(newVariableName, map2);
        } else if (value != null && value.getClass().isArray()) {
            Object[] list = (Object[])value;
            LinkedList<Object> list2 = new LinkedList<Object>();
            for (Object elem : list) {
                list2.add(elem);
            }
            this.scenarioContext.addParamValue(newVariableName, list2);
        } else {
            this.scenarioContext.addParamValue(newVariableName, value);
        }
    }

    @Then(value="verify valueOf\\({string}) variable {string} {string}.")
    public void verify_valueof_variable1_op_expected_value(String variableName1, String operator, String expectedValue) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object avalue = this.scenarioContext.getParamValue(variableName1);
        String evalue = expectedValue;
        ValueMatchOperator oper = ValueMatchOperator.valueOf2((String)operator);
        ParamValue pv1 = ObjectUtil.convertObjectToParamValue((Object)avalue);
        ParamValue pv2 = ObjectUtil.convertObjectToParamValue((Object)evalue);
        ObjectUtil.fixValueTypesInParamValueObjects((ParamValue)pv1, (ValueMatchOperator)oper, (ParamValue)pv2);
        ParamPath pPath = new ParamPath(variableName1, pv1.getValueTypeAsStr());
        ExpectedInfo eInfo = new ExpectedInfo();
        eInfo.setEv(pv2.getV());
        eInfo.setValueType(pv2.getValueType().getType());
        ParameterValidator.validateParamValueAsExpectedInfo((boolean)false, (ParamPath)pPath, (Object)pv1.getV(), (String)operator, (ExpectedInfo)eInfo);
    }

    @Then(value="verify valueOf\\({string}) variable {string} valueOf\\({string}) variable.")
    public void verify_valueof_variable1_op_valueof_variable2(String variableName1, String operator, String variableName2) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object avalue = this.scenarioContext.getParamValue(variableName1);
        Object evalue = this.scenarioContext.getParamValue(variableName2);
        ValueMatchOperator oper = ValueMatchOperator.valueOf2((String)operator);
        ParamValue pv1 = ObjectUtil.convertObjectToParamValue((Object)avalue);
        ParamValue pv2 = ObjectUtil.convertObjectToParamValue((Object)evalue);
        ObjectUtil.fixValueTypesInParamValueObjects((ParamValue)pv1, (ValueMatchOperator)oper, (ParamValue)pv2);
        ParamPath pPath = new ParamPath(variableName1, pv1.getValueTypeAsStr());
        ExpectedInfo eInfo = new ExpectedInfo();
        eInfo.setEv(pv2.getV());
        eInfo.setValueType(pv2.getValueType().getType());
        ParameterValidator.validateParamValueAsExpectedInfo((boolean)false, (ParamPath)pPath, (Object)pv1.getV(), (String)operator, (ExpectedInfo)eInfo);
    }

    @Then(value="verify valueOf\\({string}) variable {string} valueOf\\({string}) variable to {string}.")
    public void verify_valueof_variable1_op_valueof_variable2_extrainfo(String variableName1, String operator, String variableName2, String extraInfo) {
        this.verify_valueof_variable1_op_valueof_variable2(variableName1, operator, variableName2);
    }

    @Then(value="verify valueOf\\({string}) variable {string} valueOf\\({string}) variable [TextMatchMechanism={string}].")
    public void verify_valueof_variable1_op_valueof_variable2_textmatchmechanism(String variableName1, String operator, String variableName2, String textMatchMechanism) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object avalue = this.scenarioContext.getParamValue(variableName1);
        Object evalue = this.scenarioContext.getParamValue(variableName2);
        ValueMatchOperator oper = ValueMatchOperator.valueOf2((String)operator);
        ParamValue pv1 = ObjectUtil.convertObjectToParamValue((Object)avalue);
        ParamValue pv2 = ObjectUtil.convertObjectToParamValue((Object)evalue);
        ObjectUtil.fixValueTypesInParamValueObjects((ParamValue)pv1, (ValueMatchOperator)oper, (ParamValue)pv2);
        ParamPath pPath = new ParamPath(variableName1, pv1.getValueTypeAsStr());
        ExpectedInfo eInfo = new ExpectedInfo();
        eInfo.setEv(pv2.getV());
        eInfo.setValueType(pv2.getValueType().getType());
        eInfo.setTextMatchMechanism(textMatchMechanism);
        ParameterValidator.validateParamValueAsExpectedInfo((boolean)false, (ParamPath)pPath, (Object)pv1.getV(), (String)operator, (ExpectedInfo)eInfo);
    }

    @Then(value="verify valueOf\\({string}) variable {string} valueOf\\({string}) variable [TextMatchMechanism={string}] to {string}.")
    public void verify_valueof_variable1_op_valueof_variable2_textmatchmechanism_extrainfo(String variableName1, String operator, String variableName2, String textMatchMechanism, String extraInfo) {
        this.verify_valueof_variable1_op_valueof_variable2_textmatchmechanism(variableName1, operator, variableName2, textMatchMechanism);
    }

    @Then(value="verify each element of {string} list variable matches with {string} text where TextMatchMechanism={string}.")
    public void verify_each_element_of_list_variable_matches_with_text_where_text_match_mechanism(String listVariableName, String expectedText, String textMatchMechanism) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        List list = (List)this.scenarioContext.getParamValue(listVariableName);
        expectedText = this.scenarioContext.applyParamsValueOnText(expectedText);
        TextMatchMechanism textMatchMechanismEnum = TextMatchMechanism.valueOf2((String)textMatchMechanism);
        if (list != null && !list.isEmpty()) {
            for (Object actualValue : list) {
                DataMatchUtil.validateTextValue((String)(actualValue == null ? null : String.valueOf(actualValue)), (String)expectedText, (TextMatchMechanism)textMatchMechanismEnum);
            }
        }
    }

    @Then(value="get length/size of {string} variable and store into {string} variable.")
    public void get_element_count_of_list_variable_and_store_into_variable(String variableName, String newVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object value = this.scenarioContext.getParamValue(variableName);
        if (value != null && value instanceof List) {
            List list = (List)value;
            this.scenarioContext.addParamValue(newVariableName, (Object)(list == null ? 0 : list.size()));
        } else if (value != null && value instanceof Set) {
            Set list = (Set)value;
            this.scenarioContext.addParamValue(newVariableName, (Object)(list == null ? 0 : list.size()));
        } else if (value != null && value instanceof Map) {
            Map map = (Map)value;
            this.scenarioContext.addParamValue(newVariableName, (Object)(map == null ? 0 : map.size()));
        } else if (value != null && value.getClass().isArray()) {
            Object[] list = (Object[])value;
            this.scenarioContext.addParamValue(newVariableName, (Object)(list == null ? 0 : list.length));
        } else {
            this.scenarioContext.addParamValue(newVariableName, (Object)(value == null ? 0 : ("" + value).length()));
        }
    }

    @Then(value="split valueOf\\({string}) variable using {string} separator and store index\\({int}) into {string} variable [ShouldTrim={string}].")
    public void split_valueof_variable_using_separator_and_store_index_into_variable(String variableName, String separator, int nthIndex, String newVariableName, String shouldTrim) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object value = this.scenarioContext.getParamValue(variableName);
        shouldTrim = shouldTrim != null && (shouldTrim.equalsIgnoreCase("yes") || shouldTrim.equalsIgnoreCase("true")) ? "yes" : "no";
        if (value != null && value instanceof List) {
            List list = (List)value;
            LinkedList<String> list2 = new LinkedList<String>();
            for (Object elem : list) {
                if (elem != null) {
                    String[] arr = ("" + elem).split(separator);
                    if (arr.length <= nthIndex) continue;
                    list2.add(shouldTrim.equals("yes") ? arr[nthIndex].trim() : arr[nthIndex]);
                    continue;
                }
                list2.add((String)elem);
            }
            this.scenarioContext.addParamValue(newVariableName, list2);
        } else if (value != null && value instanceof Set) {
            Set list = (Set)value;
            LinkedHashSet<String> list2 = new LinkedHashSet<String>();
            for (Object elem : list) {
                if (elem != null) {
                    String[] arr = ("" + elem).split(separator);
                    if (arr.length <= nthIndex) continue;
                    list2.add(shouldTrim.equals("yes") ? arr[nthIndex].trim() : arr[nthIndex]);
                    continue;
                }
                list2.add((String)elem);
            }
            this.scenarioContext.addParamValue(newVariableName, list2);
        } else if (value != null && value instanceof Map) {
            Map map = (Map)value;
            LinkedHashMap map2 = new LinkedHashMap();
            for (Map.Entry elem : map.entrySet()) {
                if (elem.getValue() != null) {
                    String[] arr = ("" + elem.getValue()).split(separator);
                    if (arr.length <= nthIndex) continue;
                    map2.put(elem.getKey(), shouldTrim.equals("yes") ? arr[nthIndex].trim() : arr[nthIndex]);
                    continue;
                }
                map2.put(elem.getKey(), (String)elem.getValue());
            }
            for (Map.Entry elem : map.entrySet()) {
                map2.put(elem.getKey(), (String)elem.getValue());
            }
            this.scenarioContext.addParamValue(newVariableName, map2);
        } else if (value != null && value.getClass().isArray()) {
            Object[] list = (Object[])value;
            LinkedList<Object> list2 = new LinkedList<Object>();
            for (Object elem : list) {
                if (elem != null) {
                    String[] arr = ("" + elem).split(separator);
                    if (arr.length <= nthIndex) continue;
                    list2.add(shouldTrim.equals("yes") ? arr[nthIndex].trim() : arr[nthIndex]);
                    continue;
                }
                list2.add(elem);
            }
            this.scenarioContext.addParamValue(newVariableName, list2);
        } else if (value != null) {
            String[] arr = ("" + value).split(separator);
            if (arr.length > nthIndex) {
                this.scenarioContext.addParamValue(newVariableName, (Object)(shouldTrim.equals("yes") ? arr[nthIndex].trim() : arr[nthIndex]));
            }
        } else {
            this.scenarioContext.addParamValue(newVariableName, value);
        }
    }

    @Then(value="apply existing variables value on the plain text data present in {string} variable and store into {string} variable.")
    public void apply_existing_variables_value_on_plain_text_data(String inputVariableName, String newVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String inputData = this.scenarioContext.getParamValueAsString(inputVariableName);
        inputData = this.scenarioContext.applyParamsValueOnText(inputData);
        this.scenarioContext.addParamValue(newVariableName, (Object)inputData);
    }

    @Then(value="get project root directory and store into {string} variable.")
    public void get_project_root_directory_and_store_into_variable(String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String projectRootDir = Locations.getProjectRootDir();
        this.scenarioContext.addParamValue(variableName, (Object)projectRootDir);
    }
}

