/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.ui;

import io.cucumber.java.en.When;
import java.util.Set;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;

public class SmartUiWindowAndFrameOperationsStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartUiWindowAndFrameOperationsStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @When(value="switch to {string} window.")
    public void switch_to_window(String windowHandleName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Set windowHandles = this.scenarioContext.getActiveAppDriver().getWebDriver().getWindowHandles();
        this.scenarioContext.log("AVAILABLE WINDOW HANDLE NAMES: " + windowHandles);
        this.scenarioContext.getActiveAppDriver().getWebDriver().switchTo().window(windowHandleName);
    }

    @When(value="focus {string} window.")
    public void switch_to_window_1(String windowHandleName) {
        this.switch_to_window(windowHandleName);
    }

    @When(value="switch to default content.")
    public void switch_to_default_content() {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        this.scenarioContext.getActiveAppDriver().getWebDriver().switchTo().defaultContent();
    }

    @When(value="switch to {string} frame.")
    public void switch_to_frame(String frameNameOrId) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        if ("parent".equals(frameNameOrId)) {
            this.scenarioContext.getActiveAppDriver().getWebDriver().switchTo().parentFrame();
        } else if (frameNameOrId.startsWith("INDEX:")) {
            this.scenarioContext.getActiveAppDriver().getWebDriver().switchTo().frame(Integer.valueOf(frameNameOrId.substring("INDEX:".length(), frameNameOrId.length()).trim()).intValue());
        } else {
            this.scenarioContext.getActiveAppDriver().getWebDriver().switchTo().frame(frameNameOrId);
        }
    }

    @When(value="switch to frame number {int}.")
    public void switch_to_frame_number(Integer frameNumber) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        this.scenarioContext.getActiveAppDriver().getWebDriver().switchTo().frame(frameNumber.intValue());
    }
}

