/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.api;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import io.cucumber.datatable.DataTable;
import io.cucumber.docstring.DocString;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.api.core.AbstractApiActionHandler;
import org.uitnet.testing.smartfwk.api.core.reader.JsonDocumentReader;
import org.uitnet.testing.smartfwk.api.core.reader.XmlDocumentReader;
import org.uitnet.testing.smartfwk.api.core.support.HttpMultipartFileRequest;
import org.uitnet.testing.smartfwk.api.core.support.HttpMultipartFormRequest;
import org.uitnet.testing.smartfwk.api.core.support.HttpRequest;
import org.uitnet.testing.smartfwk.api.core.support.HttpResponse;
import org.uitnet.testing.smartfwk.api.core.support.MultipartFileRecord;
import org.uitnet.testing.smartfwk.api.core.support.MultipartFormRecord;
import org.uitnet.testing.smartfwk.core.validator.SmartDataValidator;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.JsonYamlUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.XMLDocumentUtil;
import org.w3c.dom.Document;

public class SmartApiStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartApiStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @When(value="prepare HTTP request header by setting the followings parameters and store into {string} variable:")
    public void prepare_http_request_header_by_setting_the_following_parameters_and_store_into_variable(String variableName, DataTable headerParameters) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        List rows = headerParameters.asLists();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (int i = 1; i < rows.size(); ++i) {
            List row = (List)rows.get(i);
            String paramName = this.scenarioContext.applyParamsValueOnText((String)row.get(0));
            String paramValue = this.scenarioContext.applyParamsValueOnText((String)row.get(1));
            params.put(paramName, paramValue);
        }
        this.scenarioContext.addParamValue(variableName, params);
    }

    @When(value="make HTTP PUT request using the following request body on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [RequestHeaderReferenceVariable={string}] and variable info [ReqVar={string}, RespVar={string}]:")
    public void make_http_put_request_using_the_following_request_body_on_using_req_header_ref_variable(String appName, String targetServer, String targetURL, String userProfile, String requestHeaderReferenceVariable, String requestVariableName, String responseVariableName, DocString requestBody) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String reqTxt = requestBody.getContent();
        reqTxt = this.scenarioContext.applyParamsValueOnText(reqTxt);
        HttpRequest httpRequest = new HttpRequest().setPayload(reqTxt);
        Map params = (Map)this.scenarioContext.getParamValue(requestHeaderReferenceVariable);
        httpRequest.getHeaders().putAll(params);
        this.scenarioContext.addParamValue(requestVariableName, (Object)reqTxt);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpPut(targetURL, httpRequest, null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP PUT request using the following request body on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [ContentType={string}, Accept={string}] and variable info [ReqVar={string}, RespVar={string}]:")
    public void make_http_put_request_using_the_following_request_body_on(String appName, String targetServer, String targetURL, String userProfile, String contentType, String accept, String requestVariableName, String responseVariableName, DocString requestBody) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String reqTxt = requestBody.getContent();
        reqTxt = this.scenarioContext.applyParamsValueOnText(reqTxt);
        HttpRequest httpRequest = new HttpRequest().setPayload(reqTxt);
        httpRequest.setPayloadType(contentType);
        httpRequest.setResponseContentType(accept);
        this.scenarioContext.addParamValue(requestVariableName, (Object)reqTxt);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpPut(targetURL, httpRequest, null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP POST request using the following request body on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [ContentType={string}, Accept={string}] and variable info [ReqVar={string}, RespVar={string}]:")
    public void make_http_post_request_using_the_following_request_body_on_1(String appName, String targetServer, String targetURL, String userProfile, String contentType, String accept, String requestVariableName, String responseVariableName, DocString requestBody) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String reqTxt = requestBody.getContent();
        reqTxt = this.scenarioContext.applyParamsValueOnText(reqTxt);
        HttpRequest httpRequest = new HttpRequest().setPayload(reqTxt);
        httpRequest.setPayloadType(contentType);
        httpRequest.setResponseContentType(accept);
        this.scenarioContext.addParamValue(requestVariableName, (Object)reqTxt);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpPost(targetURL, httpRequest, null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP POST request using the following request body on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [RequestHeaderReferenceVariable={string}] and variable info [ReqVar={string}, RespVar={string}]:")
    public void make_http_post_request_using_the_following_request_body_on_1_using_req_header_ref_variable(String appName, String targetServer, String targetURL, String userProfile, String requestHeaderReferenceVariable, String requestVariableName, String responseVariableName, DocString requestBody) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String reqTxt = requestBody.getContent();
        reqTxt = this.scenarioContext.applyParamsValueOnText(reqTxt);
        HttpRequest httpRequest = new HttpRequest().setPayload(reqTxt);
        Map params = (Map)this.scenarioContext.getParamValue(requestHeaderReferenceVariable);
        httpRequest.getHeaders().putAll(params);
        this.scenarioContext.addParamValue(requestVariableName, (Object)reqTxt);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpPost(targetURL, httpRequest, null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP PUT request to upload the following files on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [ContentType={string}, Accept={string}] and variable info [ReqVar={string}, RespVar={string}]:")
    public void make_http_put_request_to_upload_the_following_files_on(String appName, String targetServer, String targetURL, String userProfile, String contentType, String accept, String requestVariableName, String responseVariableName, DataTable filesDetails) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpMultipartFileRequest httpRequest = new HttpMultipartFileRequest();
        httpRequest.setContentType(contentType);
        httpRequest.setResponseContentType(accept);
        List rows = filesDetails.asLists();
        for (int i = 1; i < rows.size(); ++i) {
            MultipartFileRecord multipartInfo;
            List row = (List)rows.get(i);
            String partName = (String)row.get(0);
            String fileName = (String)row.get(1);
            String fileContentType = (String)row.get(2);
            String applyVariables = (String)row.get(3);
            String filePath = Locations.getProjectRootDir() + File.separator + (String)row.get(4);
            if (applyVariables.trim().equalsIgnoreCase("yes") || applyVariables.trim().equalsIgnoreCase("true")) {
                File f = new File(filePath);
                String fileContents = null;
                try {
                    fileContents = Files.readString(f.toPath());
                }
                catch (IOException e) {
                    Assert.fail((String)("Failed to read '" + filePath + "' file."), (Throwable)e);
                }
                fileContents = this.scenarioContext.applyParamsValueOnText(fileContents);
                multipartInfo = new MultipartFileRecord(partName, fileName, fileContentType, fileContents.getBytes());
            } else {
                multipartInfo = new MultipartFileRecord(partName, fileName, fileContentType, filePath);
            }
            httpRequest.addPart(multipartInfo);
        }
        this.scenarioContext.addParamValue(requestVariableName, (Object)httpRequest);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpUploadFormFiles(targetURL, httpRequest, null, null, true);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP PUT request to upload the following files on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [RequestHeaderReferenceVariable={string}] and variable info [ReqVar={string}, RespVar={string}]:")
    public void make_http_put_request_to_upload_the_following_files_on_using_req_header_ref_variable(String appName, String targetServer, String targetURL, String userProfile, String requestHeaderReferenceVariable, String requestVariableName, String responseVariableName, DataTable filesDetails) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpMultipartFileRequest httpRequest = new HttpMultipartFileRequest();
        Map params = (Map)this.scenarioContext.getParamValue(requestHeaderReferenceVariable);
        httpRequest.getHeaders().putAll(params);
        List rows = filesDetails.asLists();
        for (int i = 1; i < rows.size(); ++i) {
            MultipartFileRecord multipartInfo;
            List row = (List)rows.get(i);
            String partName = (String)row.get(0);
            String fileName = (String)row.get(1);
            String fileContentType = (String)row.get(2);
            String applyVariables = (String)row.get(3);
            String filePath = Locations.getProjectRootDir() + File.separator + (String)row.get(4);
            if (applyVariables.trim().equalsIgnoreCase("yes") || applyVariables.trim().equalsIgnoreCase("true")) {
                File f = new File(filePath);
                String fileContents = null;
                try {
                    fileContents = Files.readString(f.toPath());
                }
                catch (IOException e) {
                    Assert.fail((String)("Failed to read '" + filePath + "' file."), (Throwable)e);
                }
                fileContents = this.scenarioContext.applyParamsValueOnText(fileContents);
                multipartInfo = new MultipartFileRecord(partName, fileName, fileContentType, fileContents.getBytes());
            } else {
                multipartInfo = new MultipartFileRecord(partName, fileName, fileContentType, filePath);
            }
            httpRequest.addPart(multipartInfo);
        }
        this.scenarioContext.addParamValue(requestVariableName, (Object)httpRequest);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpUploadFormFiles(targetURL, httpRequest, null, null, true);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP POST request to send multipart form data on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [RequestHeaderReferenceVariable={string}] and variable info [ReqVar={string}, RespVar={string}]:")
    public void make_http_post_put_request_to_send_multipart_form_data_with_custom_header1(String appName, String targetServer, String targetURL, String userProfile, String requestHeaderReferenceVariable, String requestVariableName, String responseVariableName, DataTable filesDetails) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpMultipartFormRequest httpRequest = new HttpMultipartFormRequest();
        Map params = (Map)this.scenarioContext.getParamValue(requestHeaderReferenceVariable);
        httpRequest.setContentType("multipart/form-data");
        httpRequest.getHeaders().putAll(params);
        List rows = filesDetails.asLists();
        MultipartFormRecord multipartRecord = null;
        for (int i = 1; i < rows.size(); ++i) {
            Object contents;
            List row = (List)rows.get(i);
            String partName = (String)row.get(0);
            String partType = (String)row.get(1);
            String contentType = (String)row.get(2);
            String applyVariables = (String)row.get(3);
            if ("file".equalsIgnoreCase(partType)) {
                contents = Locations.getProjectRootDir() + File.separator + (String)row.get(4);
                File f = new File((String)contents);
                String fileContents = null;
                try {
                    fileContents = Files.readString(f.toPath());
                }
                catch (IOException e) {
                    Assert.fail((String)("Failed to read '" + (String)contents + "' file."), (Throwable)e);
                }
                if (fileContents != null) {
                    if ("yes".equalsIgnoreCase(applyVariables)) {
                        fileContents = this.scenarioContext.applyParamsValueOnText(fileContents);
                    }
                    multipartRecord = new MultipartFormRecord(partName, partType, contentType, fileContents.getBytes());
                } else {
                    multipartRecord = new MultipartFormRecord(partName, partType, contentType, null);
                }
            } else if ("text".equalsIgnoreCase(partType)) {
                contents = (String)row.get(4);
                if ("yes".equalsIgnoreCase(applyVariables)) {
                    contents = this.scenarioContext.applyParamsValueOnText((String)contents);
                }
                multipartRecord = new MultipartFormRecord(partName, partType, contentType, ((String)contents).getBytes());
            } else {
                Assert.fail((String)("Part type '" + partType + "' is not supported."));
            }
            httpRequest.addPart(multipartRecord);
        }
        this.scenarioContext.addParamValue(requestVariableName, (Object)httpRequest);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpUploadMultipartFormData(targetURL, httpRequest, null, null, false);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP PUT request to send multipart form data on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [RequestHeaderReferenceVariable={string}] and variable info [ReqVar={string}, RespVar={string}]:")
    public void make_http_post_put_request_to_send_multipart_form_data_with_custom_header2(String appName, String targetServer, String targetURL, String userProfile, String requestHeaderReferenceVariable, String requestVariableName, String responseVariableName, DataTable filesDetails) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpMultipartFormRequest httpRequest = new HttpMultipartFormRequest();
        Map params = (Map)this.scenarioContext.getParamValue(requestHeaderReferenceVariable);
        httpRequest.setContentType("multipart/form-data");
        httpRequest.getHeaders().putAll(params);
        List rows = filesDetails.asLists();
        MultipartFormRecord multipartRecord = null;
        for (int i = 1; i < rows.size(); ++i) {
            Object contents;
            List row = (List)rows.get(i);
            String partName = (String)row.get(0);
            String partType = (String)row.get(1);
            String contentType = (String)row.get(2);
            String applyVariables = (String)row.get(3);
            if ("file".equalsIgnoreCase(partType)) {
                contents = Locations.getProjectRootDir() + File.separator + (String)row.get(4);
                File f = new File((String)contents);
                String fileContents = null;
                try {
                    fileContents = Files.readString(f.toPath());
                }
                catch (IOException e) {
                    Assert.fail((String)("Failed to read '" + (String)contents + "' file."), (Throwable)e);
                }
                if (fileContents != null) {
                    if ("yes".equalsIgnoreCase(applyVariables)) {
                        fileContents = this.scenarioContext.applyParamsValueOnText(fileContents);
                    }
                    multipartRecord = new MultipartFormRecord(partName, partType, contentType, fileContents.getBytes());
                } else {
                    multipartRecord = new MultipartFormRecord(partName, partType, contentType, null);
                }
            } else if ("text".equalsIgnoreCase(partType)) {
                contents = (String)row.get(4);
                if ("yes".equalsIgnoreCase(applyVariables)) {
                    contents = this.scenarioContext.applyParamsValueOnText((String)contents);
                }
                multipartRecord = new MultipartFormRecord(partName, partType, contentType, ((String)contents).getBytes());
            } else {
                Assert.fail((String)("Part type '" + partType + "' is not supported."));
            }
            httpRequest.addPart(multipartRecord);
        }
        this.scenarioContext.addParamValue(requestVariableName, (Object)httpRequest);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpUploadMultipartFormData(targetURL, httpRequest, null, null, true);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP POST request to send multipart form data on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [Accept={string}] and variable info [ReqVar={string}, RespVar={string}]:")
    public void make_http_post_put_request_to_send_multipart_form_data1(String appName, String targetServer, String targetURL, String userProfile, String accept, String requestVariableName, String responseVariableName, DataTable filesDetails) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpMultipartFormRequest httpRequest = new HttpMultipartFormRequest();
        httpRequest.setContentType("multipart/form-data");
        httpRequest.setResponseContentType(accept);
        List rows = filesDetails.asLists();
        MultipartFormRecord multipartRecord = null;
        for (int i = 1; i < rows.size(); ++i) {
            Object contents;
            List row = (List)rows.get(i);
            String partName = (String)row.get(0);
            String partType = (String)row.get(1);
            String contentType = (String)row.get(2);
            String applyVariables = (String)row.get(3);
            if ("file".equalsIgnoreCase(partType)) {
                contents = Locations.getProjectRootDir() + File.separator + (String)row.get(4);
                File f = new File((String)contents);
                String fileContents = null;
                try {
                    fileContents = Files.readString(f.toPath());
                }
                catch (IOException e) {
                    Assert.fail((String)("Failed to read '" + (String)contents + "' file."), (Throwable)e);
                }
                if (fileContents != null) {
                    if ("yes".equalsIgnoreCase(applyVariables)) {
                        fileContents = this.scenarioContext.applyParamsValueOnText(fileContents);
                    }
                    multipartRecord = new MultipartFormRecord(partName, partType, contentType, fileContents.getBytes());
                } else {
                    multipartRecord = new MultipartFormRecord(partName, partType, contentType, null);
                }
            } else if ("text".equalsIgnoreCase(partType)) {
                contents = (String)row.get(4);
                if ("yes".equalsIgnoreCase(applyVariables)) {
                    contents = this.scenarioContext.applyParamsValueOnText((String)contents);
                }
                multipartRecord = new MultipartFormRecord(partName, partType, contentType, ((String)contents).getBytes());
            } else {
                Assert.fail((String)("Part type '" + partType + "' is not supported."));
            }
            httpRequest.addPart(multipartRecord);
        }
        this.scenarioContext.addParamValue(requestVariableName, (Object)httpRequest);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpUploadMultipartFormData(targetURL, httpRequest, null, null, false);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP PUT request to send multipart form data on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [Accept={string}] and variable info [ReqVar={string}, RespVar={string}]:")
    public void make_http_post_put_request_to_send_multipart_form_data2(String appName, String targetServer, String targetURL, String userProfile, String accept, String requestVariableName, String responseVariableName, DataTable filesDetails) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpMultipartFormRequest httpRequest = new HttpMultipartFormRequest();
        httpRequest.setContentType("multipart/form-data");
        httpRequest.setResponseContentType(accept);
        List rows = filesDetails.asLists();
        MultipartFormRecord multipartRecord = null;
        for (int i = 1; i < rows.size(); ++i) {
            Object contents;
            List row = (List)rows.get(i);
            String partName = (String)row.get(0);
            String partType = (String)row.get(1);
            String contentType = (String)row.get(2);
            String applyVariables = (String)row.get(3);
            if ("file".equalsIgnoreCase(partType)) {
                contents = Locations.getProjectRootDir() + File.separator + (String)row.get(4);
                File f = new File((String)contents);
                String fileContents = null;
                try {
                    fileContents = Files.readString(f.toPath());
                }
                catch (IOException e) {
                    Assert.fail((String)("Failed to read '" + (String)contents + "' file."), (Throwable)e);
                }
                if (fileContents != null) {
                    if ("yes".equalsIgnoreCase(applyVariables)) {
                        fileContents = this.scenarioContext.applyParamsValueOnText(fileContents);
                    }
                    multipartRecord = new MultipartFormRecord(partName, partType, contentType, fileContents.getBytes());
                } else {
                    multipartRecord = new MultipartFormRecord(partName, partType, contentType, null);
                }
            } else if ("text".equalsIgnoreCase(partType)) {
                contents = (String)row.get(4);
                if ("yes".equalsIgnoreCase(applyVariables)) {
                    contents = this.scenarioContext.applyParamsValueOnText((String)contents);
                }
                multipartRecord = new MultipartFormRecord(partName, partType, contentType, ((String)contents).getBytes());
            } else {
                Assert.fail((String)("Part type '" + partType + "' is not supported."));
            }
            httpRequest.addPart(multipartRecord);
        }
        this.scenarioContext.addParamValue(requestVariableName, (Object)httpRequest);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpUploadMultipartFormData(targetURL, httpRequest, null, null, true);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP POST request to upload the following files on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [ContentType={string}, Accept={string}] and variable info [ReqVar={string}, RespVar={string}]:")
    public void make_http_post_put_request_to_upload_the_following_files_on_1(String appName, String targetServer, String targetURL, String userProfile, String contentType, String accept, String requestVariableName, String responseVariableName, DataTable filesDetails) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpMultipartFileRequest httpRequest = new HttpMultipartFileRequest();
        httpRequest.setContentType(contentType);
        httpRequest.setResponseContentType(accept);
        List rows = filesDetails.asLists();
        for (int i = 1; i < rows.size(); ++i) {
            MultipartFileRecord multipartInfo;
            List row = (List)rows.get(i);
            String partName = (String)row.get(0);
            String fileName = (String)row.get(1);
            String fileContentType = (String)row.get(2);
            String applyVariables = (String)row.get(3);
            String filePath = Locations.getProjectRootDir() + File.separator + (String)row.get(4);
            if (applyVariables.trim().equalsIgnoreCase("yes") || applyVariables.trim().equalsIgnoreCase("true")) {
                File f = new File(filePath);
                String fileContents = null;
                try {
                    fileContents = Files.readString(f.toPath());
                }
                catch (IOException e) {
                    Assert.fail((String)("Failed to read '" + filePath + "' file."), (Throwable)e);
                }
                fileContents = this.scenarioContext.applyParamsValueOnText(fileContents);
                multipartInfo = new MultipartFileRecord(partName, fileName, fileContentType, fileContents.getBytes());
            } else {
                multipartInfo = new MultipartFileRecord(partName, fileName, fileContentType, filePath);
            }
            httpRequest.addPart(multipartInfo);
        }
        this.scenarioContext.addParamValue(requestVariableName, (Object)httpRequest);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpUploadFormFiles(targetURL, httpRequest, null, null, false);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP POST request to upload the following files on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [RequestHeaderReferenceVariable={string}] and variable info [ReqVar={string}, RespVar={string}]:")
    public void make_http_post_put_request_to_upload_the_following_files_on_1_using_req_header_ref_variable(String appName, String targetServer, String targetURL, String userProfile, String requestHeaderReferenceVariable, String requestVariableName, String responseVariableName, DataTable filesDetails) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpMultipartFileRequest httpRequest = new HttpMultipartFileRequest();
        Map params = (Map)this.scenarioContext.getParamValue(requestHeaderReferenceVariable);
        httpRequest.getHeaders().putAll(params);
        List rows = filesDetails.asLists();
        for (int i = 1; i < rows.size(); ++i) {
            MultipartFileRecord multipartInfo;
            List row = (List)rows.get(i);
            String partName = (String)row.get(0);
            String fileName = (String)row.get(1);
            String fileContentType = (String)row.get(2);
            String applyVariables = (String)row.get(3);
            String filePath = Locations.getProjectRootDir() + File.separator + (String)row.get(4);
            if (applyVariables.trim().equalsIgnoreCase("yes") || applyVariables.trim().equalsIgnoreCase("true")) {
                File f = new File(filePath);
                String fileContents = null;
                try {
                    fileContents = Files.readString(f.toPath());
                }
                catch (IOException e) {
                    Assert.fail((String)("Failed to read '" + filePath + "' file."), (Throwable)e);
                }
                fileContents = this.scenarioContext.applyParamsValueOnText(fileContents);
                multipartInfo = new MultipartFileRecord(partName, fileName, fileContentType, fileContents.getBytes());
            } else {
                multipartInfo = new MultipartFileRecord(partName, fileName, fileContentType, filePath);
            }
            httpRequest.addPart(multipartInfo);
        }
        this.scenarioContext.addParamValue(requestVariableName, (Object)httpRequest);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpUploadFormFiles(targetURL, httpRequest, null, null, false);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP PUT request using the contents of the following template file on target server [AppName={string}, TargetServer={string}, TargetURL={string}] with header info [ContentType={string}, Accept={string}] and variable info [ReqVar={string}, RespVar={string}]:")
    public void make_http_post_request_using_the_contents_of_the_following_template_file_on(String appName, String targetServer, String targetURL, String userProfile, String contentType, String accept, String requestVariableName, String responseVariableName, DocString requestTemplateFile) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String templateFilePath = requestTemplateFile.getContent().trim();
        templateFilePath = this.scenarioContext.applyParamsValueOnText(templateFilePath);
        String contents = null;
        try {
            contents = Files.readString(new File(templateFilePath).toPath());
            contents = this.scenarioContext.applyParamsValueOnText(contents);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read '" + templateFilePath + "' file contents."), (Throwable)ex);
        }
        HttpRequest httpRequest = new HttpRequest().setPayload(contents);
        httpRequest.setPayloadType(contentType);
        httpRequest.setResponseContentType(accept);
        this.scenarioContext.addParamValue(requestVariableName, (Object)contents);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpPost(targetURL, httpRequest, null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP PUT request using the contents of the following template file on target server [AppName={string}, TargetServer={string}, TargetURL={string}] with header info [RequestHeaderReferenceVariable={string}] and variable info [ReqVar={string}, RespVar={string}]:")
    public void make_http_post_request_using_the_contents_of_the_following_template_file_on_using_req_header_ref_variable(String appName, String targetServer, String targetURL, String userProfile, String requestHeaderReferenceVariable, String requestVariableName, String responseVariableName, DocString requestTemplateFile) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String templateFilePath = requestTemplateFile.getContent().trim();
        templateFilePath = this.scenarioContext.applyParamsValueOnText(templateFilePath);
        String contents = null;
        try {
            contents = Files.readString(new File(templateFilePath).toPath());
            contents = this.scenarioContext.applyParamsValueOnText(contents);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read '" + templateFilePath + "' file contents."), (Throwable)ex);
        }
        HttpRequest httpRequest = new HttpRequest().setPayload(contents);
        Map params = (Map)this.scenarioContext.getParamValue(requestHeaderReferenceVariable);
        httpRequest.getHeaders().putAll(params);
        this.scenarioContext.addParamValue(requestVariableName, (Object)contents);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpPost(targetURL, httpRequest, null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP POST request using the contents of the following template file on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [ContentType={string}, Accept={string}] and variable info [ReqVar={string}, RespVar={string}]:")
    public void make_http_post_request_using_the_contents_of_the_following_template_file_on_1(String appName, String targetServer, String targetURL, String userProfile, String contentType, String accept, String requestVariableName, String responseVariableName, DocString requestTemplateFile) {
        this.make_http_post_request_using_the_contents_of_the_following_template_file_on(appName, targetServer, targetURL, userProfile, contentType, accept, requestVariableName, responseVariableName, requestTemplateFile);
    }

    @When(value="make HTTP POST request using the contents of the following template file on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [RequestHeaderReferenceVariable={string}] and variable info [ReqVar={string}, RespVar={string}]:")
    public void make_http_post_request_using_the_contents_of_the_following_template_file_on_1_using_req_header_ref_variable(String appName, String targetServer, String targetURL, String userProfile, String requestHeaderReferenceVariable, String requestVariableName, String responseVariableName, DocString requestTemplateFile) {
        this.make_http_post_request_using_the_contents_of_the_following_template_file_on_using_req_header_ref_variable(appName, targetServer, targetURL, userProfile, requestHeaderReferenceVariable, requestVariableName, responseVariableName, requestTemplateFile);
    }

    @When(value="make HTTP PUT request by setting {string} JSON object on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [Accept={string}] and variable info [ReqVar={string}, RespVar={string}].")
    public void make_http_put_request_by_setting_json_object_on(String jsonObjVariableName, String appName, String targetServer, String targetURL, String userProfile, String accept, String requestVariableName, String responseVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String contents = null;
        try {
            DocumentContext jsonDoc = (DocumentContext)this.scenarioContext.getParamValue(jsonObjVariableName);
            contents = jsonDoc.jsonString();
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read JSON document from '" + jsonObjVariableName + "' JSON object variable."), (Throwable)ex);
        }
        String contentType = "application/json";
        HttpRequest httpRequest = new HttpRequest().setPayload(contents);
        httpRequest.setPayloadType(contentType);
        httpRequest.setResponseContentType(accept);
        this.scenarioContext.addParamValue(requestVariableName, (Object)contents);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpPut(targetURL, httpRequest, null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP PUT request by setting {string} JSON object on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [RequestHeaderReferenceVariable={string}] and variable info [ReqVar={string}, RespVar={string}].")
    public void make_http_put_request_by_setting_json_object_on_using_req_header_ref_variable(String jsonObjVariableName, String appName, String targetServer, String targetURL, String userProfile, String requestHeaderReferenceVariable, String requestVariableName, String responseVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String contents = null;
        try {
            DocumentContext jsonDoc = (DocumentContext)this.scenarioContext.getParamValue(jsonObjVariableName);
            contents = jsonDoc.jsonString();
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read JSON document from '" + jsonObjVariableName + "' JSON object variable."), (Throwable)ex);
        }
        HttpRequest httpRequest = new HttpRequest().setPayload(contents);
        Map params = (Map)this.scenarioContext.getParamValue(requestHeaderReferenceVariable);
        httpRequest.getHeaders().putAll(params);
        this.scenarioContext.addParamValue(requestVariableName, (Object)contents);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpPut(targetURL, httpRequest, null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP POST request by setting {string} JSON object on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [Accept={string}] and variable info [ReqVar={string}, RespVar={string}].")
    public void make_http_post_request_by_setting_json_object_on_1(String jsonObjVariableName, String appName, String targetServer, String targetURL, String userProfile, String accept, String requestVariableName, String responseVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String contents = null;
        try {
            DocumentContext jsonDoc = (DocumentContext)this.scenarioContext.getParamValue(jsonObjVariableName);
            contents = jsonDoc.jsonString();
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read JSON document from '" + jsonObjVariableName + "' JSON object variable."), (Throwable)ex);
        }
        String contentType = "application/json";
        HttpRequest httpRequest = new HttpRequest().setPayload(contents);
        httpRequest.setPayloadType(contentType);
        httpRequest.setResponseContentType(accept);
        this.scenarioContext.addParamValue(requestVariableName, (Object)contents);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpPost(targetURL, httpRequest, null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP POST request by setting {string} JSON object on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [RequestHeaderReferenceVariable={string}] and variable info [ReqVar={string}, RespVar={string}].")
    public void make_http_post_request_by_setting_json_object_on_1_using_req_header_ref_variable(String jsonObjVariableName, String appName, String targetServer, String targetURL, String userProfile, String requestHeaderReferenceVariable, String requestVariableName, String responseVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String contents = null;
        try {
            DocumentContext jsonDoc = (DocumentContext)this.scenarioContext.getParamValue(jsonObjVariableName);
            contents = jsonDoc.jsonString();
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read JSON document from '" + jsonObjVariableName + "' JSON object variable."), (Throwable)ex);
        }
        HttpRequest httpRequest = new HttpRequest().setPayload(contents);
        Map params = (Map)this.scenarioContext.getParamValue(requestHeaderReferenceVariable);
        httpRequest.getHeaders().putAll(params);
        this.scenarioContext.addParamValue(requestVariableName, (Object)contents);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpPost(targetURL, httpRequest, null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP PUT request by setting {string} XML object on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [Accept={string}] and variable info [ReqVar={string}, RespVar={string}].")
    public void make_http_put_request_by_setting_xml_object_on(String xmlObjVariableName, String appName, String targetServer, String targetURL, String userProfile, String accept, String requestVariableName, String responseVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String contents = null;
        try {
            Document xmlDoc = (Document)this.scenarioContext.getParamValue(xmlObjVariableName);
            contents = XMLDocumentUtil.convertDocumentToString((Document)xmlDoc);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read XML document from '" + xmlObjVariableName + "' XML object variable."), (Throwable)ex);
        }
        String contentType = "application/xml";
        HttpRequest httpRequest = new HttpRequest().setPayload(contents);
        httpRequest.setPayloadType(contentType);
        httpRequest.setResponseContentType(accept);
        this.scenarioContext.addParamValue(requestVariableName, (Object)contents);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpPut(targetURL, httpRequest, null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP PUT request by setting {string} XML object on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [RequestHeaderReferenceVariable={string}] and variable info [ReqVar={string}, RespVar={string}].")
    public void make_http_put_request_by_setting_xml_object_on_using_req_header_ref_variable(String xmlObjVariableName, String appName, String targetServer, String targetURL, String userProfile, String requestHeaderReferenceVariable, String requestVariableName, String responseVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String contents = null;
        try {
            Document xmlDoc = (Document)this.scenarioContext.getParamValue(xmlObjVariableName);
            contents = XMLDocumentUtil.convertDocumentToString((Document)xmlDoc);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read XML document from '" + xmlObjVariableName + "' XML object variable."), (Throwable)ex);
        }
        HttpRequest httpRequest = new HttpRequest().setPayload(contents);
        Map params = (Map)this.scenarioContext.getParamValue(requestHeaderReferenceVariable);
        httpRequest.getHeaders().putAll(params);
        this.scenarioContext.addParamValue(requestVariableName, (Object)contents);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpPut(targetURL, httpRequest, null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP POST request by setting {string} XML object on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [Accept={string}] and variable info [ReqVar={string}, RespVar={string}].")
    public void make_http_post_request_by_setting_xml_object_on_1(String xmlObjVariableName, String appName, String targetServer, String targetURL, String userProfile, String accept, String requestVariableName, String responseVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String contents = null;
        try {
            Document xmlDoc = (Document)this.scenarioContext.getParamValue(xmlObjVariableName);
            contents = XMLDocumentUtil.convertDocumentToString((Document)xmlDoc);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read XML document from '" + xmlObjVariableName + "' XML object variable."), (Throwable)ex);
        }
        String contentType = "application/xml";
        HttpRequest httpRequest = new HttpRequest().setPayload(contents);
        httpRequest.setPayloadType(contentType);
        httpRequest.setResponseContentType(accept);
        this.scenarioContext.addParamValue(requestVariableName, (Object)contents);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpPost(targetURL, httpRequest, null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP POST request by setting {string} XML object on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [RequestHeaderReferenceVariable={string}] and variable info [ReqVar={string}, RespVar={string}].")
    public void make_http_post_request_by_setting_xml_object_on_1_using_req_header_ref_variable(String xmlObjVariableName, String appName, String targetServer, String targetURL, String userProfile, String requestHeaderReferenceVariable, String requestVariableName, String responseVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String contents = null;
        try {
            Document xmlDoc = (Document)this.scenarioContext.getParamValue(xmlObjVariableName);
            contents = XMLDocumentUtil.convertDocumentToString((Document)xmlDoc);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read XML document from '" + xmlObjVariableName + "' XML object variable."), (Throwable)ex);
        }
        HttpRequest httpRequest = new HttpRequest().setPayload(contents);
        Map params = (Map)this.scenarioContext.getParamValue(requestHeaderReferenceVariable);
        httpRequest.getHeaders().putAll(params);
        this.scenarioContext.addParamValue(requestVariableName, (Object)contents);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpPost(targetURL, httpRequest, null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP GET request on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [Accept={string}] and variable info [RespVar={string}].")
    public void make_http_get_request_on(String appName, String targetServer, String targetURL, String userProfile, String accept, String responseVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setResponseContentType(accept);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        HttpResponse httpResponse = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile).httpGet(targetURL, httpRequest.getHeaders(), null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP GET request on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [RequestHeaderReferenceVariable={string}] and variable info [RespVar={string}].")
    public void make_http_get_request_on_using_req_header_ref_variable(String appName, String targetServer, String targetURL, String userProfile, String requestHeaderReferenceVariable, String responseVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpRequest httpRequest = new HttpRequest();
        Map params = (Map)this.scenarioContext.getParamValue(requestHeaderReferenceVariable);
        httpRequest.getHeaders().putAll(params);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        HttpResponse httpResponse = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile).httpGet(targetURL, httpRequest.getHeaders(), null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP DELETE request on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [Accept={string}] and variable info [RespVar={string}].")
    public void make_http_delete_request_on(String appName, String targetServer, String targetURL, String userProfile, String accept, String responseVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setResponseContentType(accept);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpDelete(targetURL, httpRequest.getHeaders(), null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP DELETE request on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [RequestHeaderReferenceVariable={string}] and variable info [RespVar={string}].")
    public void make_http_delete_request_on_using_req_header_ref_variable(String appName, String targetServer, String targetURL, String userProfile, String requestHeaderReferenceVariable, String responseVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpRequest httpRequest = new HttpRequest();
        Map params = (Map)this.scenarioContext.getParamValue(requestHeaderReferenceVariable);
        httpRequest.getHeaders().putAll(params);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpDelete(targetURL, httpRequest.getHeaders(), null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP HEAD request on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [ContentType={string}, Accept={string}] and variable info [RespVar={string}].")
    public void make_http_head_request_on(String appName, String targetServer, String targetURL, String userProfile, String contentType, String accept, String responseVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setPayloadType(contentType);
        httpRequest.setResponseContentType(accept);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpHead(targetURL, httpRequest.getHeaders(), null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @When(value="make HTTP HEAD request on target server [AppName={string}, TargetServer={string}, TargetURL={string}] using [UserProfile={string}] with header info [RequestHeaderReferenceVariable={string}] and variable info [RespVar={string}].")
    public void make_http_head_request_on_using_req_header_ref_variable(String appName, String targetServer, String targetURL, String userProfile, String requestHeaderReferenceVariable, String responseVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpRequest httpRequest = new HttpRequest();
        Map params = (Map)this.scenarioContext.getParamValue(requestHeaderReferenceVariable);
        httpRequest.getHeaders().putAll(params);
        targetURL = this.scenarioContext.applyParamsValueOnText(targetURL);
        AbstractApiActionHandler handler = this.scenarioContext.getApiTestManager().getActionHandler(appName, targetServer, userProfile);
        HttpResponse httpResponse = handler.httpHead(targetURL, httpRequest.getHeaders(), null, null);
        this.scenarioContext.addParamValue(responseVariableName, (Object)httpResponse);
    }

    @Then(value="verify {string} HTTP response contains HTTPStatusCode={int}.")
    public void verify_http_response_contains_http_status_code(String responseVariableName, int httpStatusCode) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpResponse httpResponse = (HttpResponse)this.scenarioContext.getParamValue(responseVariableName);
        Assert.assertNotNull((Object)httpResponse, (String)"HTTP response not found.");
        httpResponse.getValidator().validateExpectedResponseCode(httpStatusCode);
    }

    @Then(value="verify {string} HTTP response contains ContentType={string}.")
    public void verify_http_response_contains_content_type(String responseVariableName, String contentType) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpResponse httpResponse = (HttpResponse)this.scenarioContext.getParamValue(responseVariableName);
        Assert.assertNotNull((Object)httpResponse, (String)"HTTP response not found.");
        httpResponse.getValidator().validateContentType(contentType);
    }

    @Then(value="verify {string} HTTP response contains following header information:")
    public void verify_http_response_variable_contains_http_status_code(String responseVariableName, DataTable expectedHeaderInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpResponse httpResponse = (HttpResponse)this.scenarioContext.getParamValue(responseVariableName);
        Assert.assertNotNull((Object)httpResponse, (String)"HTTP response not found.");
        List rows = expectedHeaderInfo.asLists();
        for (int i = 1; i < rows.size(); ++i) {
            List row = (List)rows.get(i);
            String headerName = (String)row.get(0);
            String expectedValue = (String)row.get(1);
            String textMatchMechanism = (String)row.get(2);
            if (StringUtil.isEmptyAfterTrim((String)textMatchMechanism)) {
                textMatchMechanism = TextMatchMechanism.exactMatchWithExpectedValue.name();
            }
            httpResponse.getValidator().validateExpectedHeaderValue(headerName, expectedValue, TextMatchMechanism.valueOf2((String)textMatchMechanism));
        }
    }

    @Then(value="verify body of {string} HTTP response contains following keywords in its contents:")
    public void verify_body_of_http_response_contains_following_keywords_in_its_contents(String httpResponseVariableName, DocString keywordsInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpResponse httpResponse = (HttpResponse)this.scenarioContext.getParamValue(httpResponseVariableName);
        Assert.assertNotNull((Object)httpResponse, (String)"HTTP response not found.");
        String jsonStr = keywordsInfo.getContent();
        DocumentContext jsonObj = new JsonDocumentReader(jsonStr, false).getDocumentContext();
        String inOrder = (String)JsonYamlUtil.readNoException((String)"$.inOrder", String.class, (DocumentContext)jsonObj);
        List keywords = (List)JsonYamlUtil.readNoException((String)"$.keywords", (TypeRef)new TypeRef<List<String>>(){}, (DocumentContext)jsonObj);
        if (keywords == null || keywords.size() == 0) {
            Assert.fail((String)"No expected keywords found to match in response body.");
        }
        if ("true".equalsIgnoreCase(inOrder) || "yes".equalsIgnoreCase(inOrder)) {
            httpResponse.getValidator().validateBodyContainsKeywords(keywords, true);
        } else {
            httpResponse.getValidator().validateBodyContainsKeywords(keywords, false);
        }
    }

    @Then(value="verify {string} HTTP response contains JSON data with the following expected params information:")
    public void verify_http_response_contains_json_data_with_the_following_expected_params_information(String responseVariableName, DataTable expectedParamsInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpResponse httpResponse = (HttpResponse)this.scenarioContext.getParamValue(responseVariableName);
        Assert.assertNotNull((Object)httpResponse, (String)"HTTP response not found.");
        httpResponse.getValidator().validateResponseNotEmpty();
        DocumentContext jsonObj = new JsonDocumentReader(httpResponse.getPayload(), false).getDocumentContext();
        List rows = expectedParamsInfo.asLists();
        for (int i = 1; i < rows.size(); ++i) {
            List row = (List)rows.get(i);
            String jsonPath = (String)row.get(0);
            String oper = (String)row.get(1);
            String expectedInfo = (String)row.get(2);
            jsonPath = this.scenarioContext.applyParamsValueOnText(jsonPath);
            expectedInfo = this.scenarioContext.applyParamsValueOnText(expectedInfo);
            SmartDataValidator.validateJsonOrYamlData((DocumentContext)jsonObj, (String)jsonPath, (String)oper, (String)expectedInfo);
        }
    }

    @Then(value="verify {string} HTTP response contains XML data with the following expected params information:")
    public void verify_http_response_contains_xml_data_with_the_following_expected_params_information(String responseVariableName, DataTable expectedParamsInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpResponse httpResponse = (HttpResponse)this.scenarioContext.getParamValue(responseVariableName);
        Assert.assertNotNull((Object)httpResponse, (String)"HTTP response not found.");
        httpResponse.getValidator().validateResponseNotEmpty();
        Document xmlObj = new XmlDocumentReader(httpResponse.getPayload()).getDocument();
        List rows = expectedParamsInfo.asLists();
        for (int i = 1; i < rows.size(); ++i) {
            List row = (List)rows.get(i);
            String xmlPath = (String)row.get(0);
            String operator = (String)row.get(1);
            String expectedInfo = (String)row.get(2);
            xmlPath = this.scenarioContext.applyParamsValueOnText(xmlPath);
            SmartDataValidator.validateXmlData((Document)xmlObj, (String)xmlPath, (String)operator, (String)expectedInfo);
        }
    }

    @Then(value="verify downloaded file as part of {string} HTTP response contains following expected name:")
    public void verify_downloaded_file_as_part_of_http_response_contains_following_expected_name(String httpResponseVariableName, DocString expectedFileInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpResponse httpResponse = (HttpResponse)this.scenarioContext.getParamValue(httpResponseVariableName);
        Assert.assertNotNull((Object)httpResponse, (String)"HTTP response not found.");
        String jsonStr = expectedFileInfo.getContent();
        DocumentContext jsonObj = new JsonDocumentReader(jsonStr, false).getDocumentContext();
        String textMatchMechanism = (String)JsonYamlUtil.readNoException((String)"$.textMatchMechanism", String.class, (DocumentContext)jsonObj);
        boolean deleteFile = (Boolean)JsonYamlUtil.readNoException((String)"$.deleteFile", Boolean.TYPE, (DocumentContext)jsonObj);
        String expectedFileName = (String)JsonYamlUtil.readNoException((String)"$.expectedFileName", String.class, (DocumentContext)jsonObj);
        if (StringUtil.isEmptyAfterTrim((String)expectedFileName)) {
            Assert.fail((String)"Expected filename can not be empty.");
        }
        httpResponse.getValidator().validateFileDownloaded(expectedFileName, TextMatchMechanism.valueOf2((String)textMatchMechanism), deleteFile);
    }

    @Then(value="verify downloaded file as part of {string} HTTP response contains following keywords in its contents:")
    public void verify_downloaded_file_as_part_of_http_response_contains_following_keywords_in_its_contents(String httpResponseVariableName, DocString keywordsInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpResponse httpResponse = (HttpResponse)this.scenarioContext.getParamValue(httpResponseVariableName);
        Assert.assertNotNull((Object)httpResponse, (String)"HTTP response not found.");
        String jsonStr = keywordsInfo.getContent();
        DocumentContext jsonObj = new JsonDocumentReader(jsonStr, false).getDocumentContext();
        String inOrder = (String)JsonYamlUtil.readNoException((String)"$.inOrder", String.class, (DocumentContext)jsonObj);
        List keywords = (List)JsonYamlUtil.readNoException((String)"$.keywords", (TypeRef)new TypeRef<List<String>>(){}, (DocumentContext)jsonObj);
        if (keywords == null || keywords.size() == 0) {
            Assert.fail((String)"No expected keywords found to match in file.");
        }
        if ("true".equalsIgnoreCase(inOrder) || "yes".equalsIgnoreCase(inOrder)) {
            httpResponse.getValidator().validateDownloadedFileContainsAllKeywordsInOrder(false, keywords.toArray(new String[keywords.size()]));
        } else {
            httpResponse.getValidator().validateDownloadedFileContainsAllKeywords(false, keywords.toArray(new String[keywords.size()]));
        }
    }

    @Then(value="retrieve {string} JSON path value from the payload of {string} HTTP response and store into {string} variable.")
    public void retrive_json_path_value_from_the_payload_of_http_response_and_store_into_variable(String jsonPath, String httpResponseVariableName, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        HttpResponse httpResponse = (HttpResponse)this.scenarioContext.getParamValue(httpResponseVariableName);
        Assert.assertNotNull((Object)httpResponse, (String)"HTTP response not found.");
        httpResponse.getValidator().validateResponseNotEmpty();
        DocumentContext jsonObj = new JsonDocumentReader(httpResponse.getPayload(), false).getDocumentContext();
        Object value = jsonObj.read(jsonPath, new Predicate[0]);
        this.scenarioContext.addParamValue(variableName, value);
    }
}

