/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.common;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.util.List;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.core.validator.PropertyValueType;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;

public class SmartAppRuntimeConfigurationStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartAppRuntimeConfigurationStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @Then(value="print STAS runtime configurations as JSON Object.")
    public void print_runtime_configurations_as_json() {
        DocumentContext configCtx = TestConfigManager.getInstance().getJsonContext();
        this.scenarioContext.log(configCtx.jsonString());
    }

    @When(value="read {string} property path as {string} from STAS runtime configuration and store into {string} variable.")
    public void read_property_path_from_testconfig_file_and_store_into_variable(String propertyJsonPath, String propertyValueType, String variableName) {
        DocumentContext configCtx = TestConfigManager.getInstance().getJsonContext();
        PropertyValueType valueType = PropertyValueType.valueOf2((String)propertyValueType);
        Object value = null;
        switch (valueType) {
            case STRING: {
                value = configCtx.read(propertyJsonPath, String.class, new Predicate[0]);
                break;
            }
            case STRING_LIST: {
                TypeRef<List<String>> typeRef1 = new TypeRef<List<String>>(){};
                value = configCtx.read(propertyJsonPath, (TypeRef)typeRef1);
                break;
            }
            case INTEGER: {
                value = configCtx.read(propertyJsonPath, Long.class, new Predicate[0]);
                break;
            }
            case INTEGER_LIST: {
                TypeRef<List<Long>> typeRef2 = new TypeRef<List<Long>>(){};
                value = configCtx.read(propertyJsonPath, (TypeRef)typeRef2);
                break;
            }
            case DECIMAL: {
                value = configCtx.read(propertyJsonPath, Double.class, new Predicate[0]);
                break;
            }
            case DECIMAL_LIST: {
                TypeRef<List<Double>> typeRef3 = new TypeRef<List<Double>>(){};
                value = configCtx.read(propertyJsonPath, (TypeRef)typeRef3);
                break;
            }
            case BOOLEAN: {
                value = configCtx.read(propertyJsonPath, Boolean.class, new Predicate[0]);
                break;
            }
            case BOOLEAN_LIST: {
                TypeRef<List<Boolean>> typeRef4 = new TypeRef<List<Boolean>>(){};
                value = configCtx.read(propertyJsonPath, (TypeRef)typeRef4);
            }
        }
        this.scenarioContext.addParamValue(variableName, value);
    }
}

