/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.common;

import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.common.DateTimeUnit;

public class SmartDateTimeManipulationStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartDateTimeManipulationStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @Then(value="get the local system timestamp in {string} format using [TimeZone={string}] and store into {string} variable.")
    public void get_the_local_system_timestamp_in_format_and_store_into_variable(String timestampFormat, String timeZone, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        timestampFormat = this.scenarioContext.applyParamsValueOnText(timestampFormat);
        timeZone = this.scenarioContext.applyParamsValueOnText(timeZone);
        TimeZone tzone = TimeZone.getTimeZone(timeZone);
        Date date = Calendar.getInstance(tzone).getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(timestampFormat);
        sdf.setTimeZone(tzone);
        String formattedDate = sdf.format(date);
        this.scenarioContext.addParamValue(variableName, (Object)formattedDate);
    }

    @Then(value="get current timestamp in {string} format using [TimeZone={string}] and store into {string} variable.")
    public void get_current_timestamp_in_format_and_store_into_variable(String timestampFormat, String timeZone, String variableName) {
        this.get_the_local_system_timestamp_in_format_and_store_into_variable(timestampFormat, timeZone, variableName);
    }

    @When(value="subtract {string} {string} from timestamp [TimestampAsStr={string}, Format={string}, TimeZone={string}] and store into {string} variable.")
    public void subtract_from_timestamp_and_store_into_variable(String n, String dateTimeUnit, String timestampAsStr, String timestampFormat, String timeZone, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        int n2 = Integer.valueOf(this.scenarioContext.applyParamsValueOnText(n));
        dateTimeUnit = this.scenarioContext.applyParamsValueOnText(dateTimeUnit);
        DateTimeUnit dtUnit = DateTimeUnit.valueOf2((String)dateTimeUnit);
        timestampAsStr = this.scenarioContext.applyParamsValueOnText(timestampAsStr);
        timestampFormat = this.scenarioContext.applyParamsValueOnText(timestampFormat);
        timeZone = this.scenarioContext.applyParamsValueOnText(timeZone);
        TimeZone tzone = TimeZone.getTimeZone(timeZone);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(timestampFormat);
            sdf.setTimeZone(tzone);
            Date date = sdf.parse(timestampAsStr);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            switch (dtUnit) {
                case years: {
                    cal.add(1, 0 - n2);
                    break;
                }
                case months: {
                    cal.add(2, 0 - n2);
                    break;
                }
                case weeks: {
                    cal.add(5, 0 - n2 * 7);
                    break;
                }
                case days: {
                    cal.add(5, 0 - n2);
                    break;
                }
                case hours: {
                    cal.add(10, 0 - n2);
                    break;
                }
                case minutes: {
                    cal.add(12, 0 - n2);
                    break;
                }
                case seconds: {
                    cal.add(13, 0 - n2);
                    break;
                }
                case milliseconds: {
                    cal.add(14, 0 - n2);
                    break;
                }
            }
            String fDate = sdf.format(cal.getTime());
            this.scenarioContext.addParamValue(variableName, (Object)fDate);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to parse '" + timestampAsStr + "' date using '" + timestampFormat + "' format."), (Throwable)ex);
        }
    }

    @When(value="add {string} {string} to timestamp [TimestampAsStr={string}, Format={string}, TimeZone={string}] and store into {string} variable.")
    public void add_to_timestamp_and_store_into_variable(String n, String dateTimeUnit, String timestampAsStr, String timestampFormat, String timeZone, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        int n2 = Integer.valueOf(this.scenarioContext.applyParamsValueOnText(n));
        dateTimeUnit = this.scenarioContext.applyParamsValueOnText(dateTimeUnit);
        DateTimeUnit dtUnit = DateTimeUnit.valueOf2((String)dateTimeUnit);
        timestampAsStr = this.scenarioContext.applyParamsValueOnText(timestampAsStr);
        timestampFormat = this.scenarioContext.applyParamsValueOnText(timestampFormat);
        timeZone = this.scenarioContext.applyParamsValueOnText(timeZone);
        TimeZone tzone = TimeZone.getTimeZone(timeZone);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(timestampFormat);
            sdf.setTimeZone(tzone);
            Date date = sdf.parse(timestampAsStr);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            switch (dtUnit) {
                case years: {
                    cal.add(1, n2);
                    break;
                }
                case months: {
                    cal.add(2, n2);
                    break;
                }
                case weeks: {
                    cal.add(5, n2 * 7);
                    break;
                }
                case days: {
                    cal.add(5, n2);
                    break;
                }
                case hours: {
                    cal.add(10, n2);
                    break;
                }
                case minutes: {
                    cal.add(12, n2);
                    break;
                }
                case seconds: {
                    cal.add(13, n2);
                    break;
                }
                case milliseconds: {
                    cal.add(14, n2);
                    break;
                }
            }
            String fDate = sdf.format(cal.getTime());
            this.scenarioContext.addParamValue(variableName, (Object)fDate);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to parse '" + timestampAsStr + "' date using '" + timestampFormat + "' format."), (Throwable)ex);
        }
    }

    @When(value="subtract {string} timestamp from {string} timestamp [Format:{string}, TimeZone={string}] and store difference as {string} into {string} variable.")
    public void subtract_timestamp1_from_timestamp2_and_store_difference_as_into_variable(String timestampAsStr1, String timestampAsStr2, String timestampFormat, String timeZone, String dateTimeUnit, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        timestampAsStr1 = this.scenarioContext.applyParamsValueOnText(timestampAsStr1);
        timestampAsStr2 = this.scenarioContext.applyParamsValueOnText(timestampAsStr2);
        timestampFormat = this.scenarioContext.applyParamsValueOnText(timestampFormat);
        dateTimeUnit = this.scenarioContext.applyParamsValueOnText(dateTimeUnit);
        timeZone = this.scenarioContext.applyParamsValueOnText(timeZone);
        TimeZone tzone = TimeZone.getTimeZone(timeZone);
        DateTimeUnit dtUnit = null;
        dtUnit = dateTimeUnit.startsWith("abs-") ? DateTimeUnit.valueOf2((String)dateTimeUnit.substring(4)) : DateTimeUnit.valueOf2((String)dateTimeUnit);
        SimpleDateFormat sdf = new SimpleDateFormat(timestampFormat);
        sdf.setTimeZone(tzone);
        Date date1 = null;
        try {
            date1 = sdf.parse(timestampAsStr1);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to parse '" + timestampAsStr1 + "' date using '" + timestampFormat + "' format."), (Throwable)ex);
        }
        Date date2 = null;
        try {
            date2 = sdf.parse(timestampAsStr2);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to parse '" + timestampAsStr2 + "' date using '" + timestampFormat + "' format."), (Throwable)ex);
        }
        long diffInMillies = dateTimeUnit.startsWith("abs-") ? Math.abs(date2.getTime() - date1.getTime()) : date2.getTime() - date1.getTime();
        long diff = 0L;
        switch (dtUnit) {
            case years: {
                diff = TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS) / 365L;
                break;
            }
            case months: {
                diff = TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS) / 30L;
                break;
            }
            case weeks: {
                diff = TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS) / 7L;
                break;
            }
            case days: {
                diff = TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS);
                break;
            }
            case hours: {
                diff = TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS) * 24L;
                break;
            }
            case minutes: {
                diff = TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS) * 24L * 60L;
                break;
            }
            case seconds: {
                diff = TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS) * 24L * 60L * 60L;
                break;
            }
            case milliseconds: {
                diff = diffInMillies;
                break;
            }
        }
        this.scenarioContext.addParamValue(variableName, (Object)diff);
    }
}

