/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.common.data;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import io.cucumber.datatable.DataTable;
import io.cucumber.docstring.DocString;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.File;
import java.util.List;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.api.core.reader.JsonDocumentReader;
import org.uitnet.testing.smartfwk.core.validator.ParamPath;
import org.uitnet.testing.smartfwk.core.validator.ParamValueType;
import org.uitnet.testing.smartfwk.core.validator.SmartDataValidator;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;
import org.uitnet.testing.smartfwk.ui.core.utils.JsonYamlUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;

public class SmartJsonDataManagementStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartJsonDataManagementStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @When(value="read {string} JSON file contents and store into {string} variable.")
    public void read_json_file_contents_and_store_into_variable(String jsonDataRelativeFilePath, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        JsonDocumentReader reader = new JsonDocumentReader(new File(Locations.getProjectRootDir() + File.separator + jsonDataRelativeFilePath), false);
        this.scenarioContext.addParamValue(variableName, (Object)reader.getDocumentContext());
    }

    @When(value="convert {string} JSON text into JSON object and store into {string} variable.")
    public void convert_json_text_into_json_object_and_store_into_variable(String jsonText, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        jsonText = this.scenarioContext.applyParamsValueOnText(jsonText);
        JsonDocumentReader reader = new JsonDocumentReader(jsonText, false);
        this.scenarioContext.addParamValue(variableName, (Object)reader.getDocumentContext());
    }

    @When(value="convert {string} variable contents into JSON object and store into {string} variable.")
    public void convert_variable_contents_into_json_object_and_store_into_variable(String jsonInputVariableName, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String jsonInput = this.scenarioContext.getParamValueAsString(jsonInputVariableName);
        this.convert_json_text_into_json_object_and_store_into_variable(jsonInput, variableName);
    }

    @When(value="convert the following JSON text into JSON object and store into {string} variable:")
    public void convert_the_following_json_text_into_json_object_and_store_into_variable(String variableName, DocString jsonText) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String jsonTxt = jsonText.getContent();
        jsonTxt = this.scenarioContext.applyParamsValueOnText(jsonTxt);
        JsonDocumentReader reader = new JsonDocumentReader(jsonTxt, false);
        this.scenarioContext.addParamValue(variableName, (Object)reader.getDocumentContext());
    }

    @When(value="read {string} parameter value from JSON object [JSONObjRefVariable={string}] and store into {string} variable.")
    public void read_parameter_value_from_json_object_json_obj_ref_variable_and_store_into_variable(String jsonPath, String jsonObjRefVariable, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        jsonPath = this.scenarioContext.applyParamsValueOnText(jsonPath);
        Object jsonObjContext = this.scenarioContext.getParamValue(jsonObjRefVariable);
        Assert.assertNotNull((Object)jsonObjContext, (String)("'" + jsonObjRefVariable + "' variable does not have JSON object. Found null."));
        Assert.assertTrue((boolean)(jsonObjContext instanceof DocumentContext), (String)("'" + jsonObjRefVariable + "' variable is not a JSON object. It should be the instance of DocumentContext class."));
        DocumentContext jsonObj = (DocumentContext)jsonObjContext;
        Object value = jsonObj.read(jsonPath, new Predicate[0]);
        this.scenarioContext.addParamValue(variableName, value);
    }

    @When(value="update the following parameters values into JSON object [JSONObjRefVariable={string}]:")
    public void read_parameter_value_from_json_object_json_obj_ref_variable(String jsonObjRefVariable, DataTable jsonParamInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object jsonObjContext = this.scenarioContext.getParamValue(jsonObjRefVariable);
        Assert.assertNotNull((Object)jsonObjContext, (String)("'" + jsonObjRefVariable + "' variable does not have JSON object. Found null."));
        Assert.assertTrue((boolean)(jsonObjContext instanceof DocumentContext), (String)("'" + jsonObjRefVariable + "' variable is not a JSON object. It should be the instance of DocumentContext class."));
        DocumentContext jsonObj = (DocumentContext)jsonObjContext;
        List rows = jsonParamInfo.asLists();
        for (int i = 1; i < rows.size(); ++i) {
            List row = (List)rows.get(i);
            String paramName = (String)row.get(0);
            String paramNewValue = (String)row.get(1);
            paramName = this.scenarioContext.applyParamsValueOnText(paramName);
            paramNewValue = this.scenarioContext.applyParamsValueOnText(paramNewValue);
            ParamPath pPath = JsonYamlUtil.parseParamPath((String)paramName);
            Object parsedValue = JsonYamlUtil.convertTextToTypedValue((String)pPath.getPath(), (ParamValueType)pPath.getValueType(), (String)paramNewValue);
            jsonObj.set(pPath.getPath(), parsedValue, new Predicate[0]);
        }
        this.scenarioContext.addParamValue(jsonObjRefVariable, (Object)jsonObj);
    }

    @Then(value="verify the following parameters of JSON object matches with the expected information as per the tabular info given below [JSONObjRefVariable={string}]:")
    public void verify_the_following_parameters_of_json_object_matches_with_the_expected_information_as_per_the_tabular_info_given_below_json_obj_ref_variable(String jsonObjRefVariable, DataTable jsonParamInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object jsonObjContext = this.scenarioContext.getParamValue(jsonObjRefVariable);
        Assert.assertNotNull((Object)jsonObjContext, (String)("'" + jsonObjRefVariable + "' variable does not have JSON object. Found null."));
        Assert.assertTrue((boolean)(jsonObjContext instanceof DocumentContext), (String)("'" + jsonObjRefVariable + "' variable is not a JSON object. It should be the instance of DocumentContext class."));
        DocumentContext jsonObj = (DocumentContext)jsonObjContext;
        List rows = jsonParamInfo.asLists();
        for (int i = 1; i < rows.size(); ++i) {
            List row = (List)rows.get(i);
            String jsonPath = (String)row.get(0);
            String oper = (String)row.get(1);
            String expectedInfo = (String)row.get(2);
            jsonPath = this.scenarioContext.applyParamsValueOnText(jsonPath);
            expectedInfo = this.scenarioContext.applyParamsValueOnText(expectedInfo);
            SmartDataValidator.validateJsonOrYamlData((DocumentContext)jsonObj, (String)jsonPath, (String)oper, (String)expectedInfo);
        }
    }

    @Then(value="add the following JSON info on {string} JSON path of JSON object [JSONObjRefVariable={string}]:")
    public void add_the_following_json_info_on_json_path_of_json_object(String jsonPath, String jsonObjRefVariable, DocString jsonInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String jsonInfoStr = jsonInfo.getContent();
        if (StringUtil.isEmptyAfterTrim((String)jsonInfoStr)) {
            return;
        }
        jsonInfoStr = this.scenarioContext.applyParamsValueOnText(jsonInfoStr);
        Object jsonObjContext = this.scenarioContext.getParamValue(jsonObjRefVariable);
        Assert.assertNotNull((Object)jsonObjContext, (String)("'" + jsonObjRefVariable + "' variable does not have JSON object. Found null."));
        Assert.assertTrue((boolean)(jsonObjContext instanceof DocumentContext), (String)("'" + jsonObjRefVariable + "' variable is not a JSON object. It should be the instance of DocumentContext class."));
        DocumentContext jsonObj = (DocumentContext)jsonObjContext;
        jsonPath = this.scenarioContext.applyParamsValueOnText(jsonPath);
        JsonDocumentReader jsonInfoReader = new JsonDocumentReader(jsonInfoStr, false);
        Object obj = jsonInfoReader.getDocumentContext().read("$", new Predicate[0]);
        jsonObj.add(jsonPath, obj, new Predicate[0]);
        this.scenarioContext.addParamValue(jsonObjRefVariable, (Object)jsonObj);
    }

    @Then(value="remove the following JSON paths from JSON object [JSONObjRefVariable={string}]:")
    public void remove_the_following_json_paths_from_json_object(String jsonObjRefVariable, DataTable jsonPaths) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object jsonObjContext = this.scenarioContext.getParamValue(jsonObjRefVariable);
        Assert.assertNotNull((Object)jsonObjContext, (String)("'" + jsonObjRefVariable + "' variable does not have JSON object. Found null."));
        Assert.assertTrue((boolean)(jsonObjContext instanceof DocumentContext), (String)("'" + jsonObjRefVariable + "' variable is not a JSON object. It should be the instance of DocumentContext class."));
        DocumentContext jsonObj = (DocumentContext)jsonObjContext;
        List rows = jsonPaths.asLists();
        for (int i = 1; i < rows.size(); ++i) {
            List row = (List)rows.get(i);
            String jsonPath = (String)row.get(0);
            jsonPath = this.scenarioContext.applyParamsValueOnText(jsonPath);
            jsonObj.delete(jsonPath, new Predicate[0]);
        }
        this.scenarioContext.addParamValue(jsonObjRefVariable, (Object)jsonObj);
    }

    @Then(value="update {string} key of {string} JSON path in JSON object [JSONObjRefVariable={string}] with the following value:")
    public void update_key_of_json_path_in_json_object_with_the_following_value(String key, String jsonPath, String jsonObjRefVariable, DocString newValue) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        jsonPath = this.scenarioContext.applyParamsValueOnText(jsonPath);
        key = this.scenarioContext.applyParamsValueOnText(key);
        Object jsonObjContext = this.scenarioContext.getParamValue(jsonObjRefVariable);
        Assert.assertNotNull((Object)jsonObjContext, (String)("'" + jsonObjRefVariable + "' variable does not have JSON object. Found null."));
        Assert.assertTrue((boolean)(jsonObjContext instanceof DocumentContext), (String)("'" + jsonObjRefVariable + "' variable is not a JSON object. It should be the instance of DocumentContext class."));
        DocumentContext jsonObj = (DocumentContext)jsonObjContext;
        String value = newValue.getContent();
        value = this.scenarioContext.applyParamsValueOnText(value);
        jsonObj.put(jsonPath, key, (Object)value, new Predicate[0]);
        this.scenarioContext.addParamValue(jsonObjRefVariable, (Object)jsonObj);
    }

    @Then(value="print JSON object [JSONObjRefVariable={string}].")
    public void print_json_object(String jsonObjRefVariable) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object jsonObjContext = this.scenarioContext.getParamValue(jsonObjRefVariable);
        if (jsonObjContext == null) {
            this.scenarioContext.log(null);
            return;
        }
        DocumentContext jsonObj = (DocumentContext)jsonObjContext;
        this.scenarioContext.log(jsonObj.jsonString());
    }
}

