/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.common.data;

import io.cucumber.datatable.DataTable;
import io.cucumber.docstring.DocString;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.api.core.reader.XmlDocumentReader;
import org.uitnet.testing.smartfwk.core.validator.ParamPath;
import org.uitnet.testing.smartfwk.core.validator.SmartDataValidator;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;
import org.uitnet.testing.smartfwk.ui.core.utils.JsonYamlUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class SmartXmlDataManagementStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartXmlDataManagementStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @When(value="read {string} XML file contents and store into {string} variable.")
    public void read_xml_file_contents_and_store_into_variable(String xmlDataRelativeFilePath, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        XmlDocumentReader reader = new XmlDocumentReader(new File(Locations.getProjectRootDir() + File.separator + xmlDataRelativeFilePath));
        this.scenarioContext.addParamValue(variableName, (Object)reader.getDocument());
    }

    @When(value="convert {string} XML text into XML object and store into {string} variable.")
    public void convert_xml_text_into_xml_object_and_store_into_variable(String xmlText, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        xmlText = this.scenarioContext.applyParamsValueOnText(xmlText);
        XmlDocumentReader reader = new XmlDocumentReader(xmlText);
        this.scenarioContext.addParamValue(variableName, (Object)reader.getDocument());
    }

    @When(value="convert {string} variable contents into XML object and store into {string} variable.")
    public void convert_variable_contents_into_xml_object_and_store_into_variable(String xmlInputVariableName, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String xmlInput = this.scenarioContext.getParamValueAsString(xmlInputVariableName);
        this.convert_xml_text_into_xml_object_and_store_into_variable(xmlInput, variableName);
    }

    @When(value="convert the following XML text into XML object and store into {string} variable:")
    public void convert_the_following_xml_text_into_xml_object_and_store_into_variable(String variableName, DocString xmlText) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String xmlTxt = xmlText.getContent();
        xmlTxt = this.scenarioContext.applyParamsValueOnText(xmlTxt);
        XmlDocumentReader reader = new XmlDocumentReader(xmlTxt);
        this.scenarioContext.addParamValue(variableName, (Object)reader.getDocument());
    }

    @When(value="read {string} parameter value from XML object [XMLObjRefVariable={string}] and store into {string} variable.")
    public void read_parameter_value_from_xml_object_xml_obj_ref_variable_and_store_into_variable(String xmlPath, String xmlObjRefVariable, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object xmlObjContext = this.scenarioContext.getParamValue(xmlObjRefVariable);
        Assert.assertNotNull((Object)xmlObjContext, (String)("'" + xmlObjRefVariable + "' variable does not have XML object. Found null."));
        Assert.assertTrue((boolean)(xmlObjContext instanceof Document), (String)("'" + xmlObjRefVariable + "' variable is not a XML object. It should be the instance of Document class."));
        Document xmlObj = (Document)xmlObjContext;
        XmlDocumentReader xmlReader = new XmlDocumentReader(xmlObj);
        ParamPath paramPath = JsonYamlUtil.parseParamPath((String)xmlPath);
        Object value = xmlReader.findAttributeOrTextValues(paramPath.getPath(), paramPath);
        this.scenarioContext.addParamValue(variableName, value);
    }

    @Then(value="verify the following parameters of XML object matches with the expected information as per the tabular info given below [XMLObjRefVariable={string}]:")
    public void verify_the_following_parameters_of_xml_object_matches_with_the_expected_information_as_per_the_tabular_info_given_below_xml_obj_ref_variable(String xmlObjRefVariable, DataTable xmlParamInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object xmlObjContext = this.scenarioContext.getParamValue(xmlObjRefVariable);
        Assert.assertNotNull((Object)xmlObjContext, (String)("'" + xmlObjRefVariable + "' variable does not have XML object. Found null."));
        Assert.assertTrue((boolean)(xmlObjContext instanceof Document), (String)("'" + xmlObjRefVariable + "' variable is not a XML object. It should be the instance of Document class."));
        Document xmlObj = (Document)xmlObjContext;
        List rows = xmlParamInfo.asLists();
        for (int i = 1; i < rows.size(); ++i) {
            List row = (List)rows.get(i);
            String xmlPath = (String)row.get(0);
            String oper = (String)row.get(1);
            String expectedInfo = (String)row.get(2);
            xmlPath = this.scenarioContext.applyParamsValueOnText(xmlPath);
            expectedInfo = this.scenarioContext.applyParamsValueOnText(expectedInfo);
            SmartDataValidator.validateXmlData((Document)xmlObj, (String)xmlPath, (String)oper, (String)expectedInfo);
        }
    }

    @Then(value="add the following XML info as child on {string} xpath of XML object [XMLObjRefVariable={string}]:")
    public void add_the_following_xml_info_as_child_on_xml_path_of_xml_object(String xpath, String xmlObjRefVariable, DocString xmlInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String xmlInfoStr = xmlInfo.getContent();
        if (StringUtil.isEmptyAfterTrim((String)xmlInfoStr)) {
            return;
        }
        xmlInfoStr = this.scenarioContext.applyParamsValueOnText(xmlInfoStr);
        Object xmlObjContext = this.scenarioContext.getParamValue(xmlObjRefVariable);
        Assert.assertNotNull((Object)xmlObjContext, (String)("'" + xmlObjRefVariable + "' variable does not have XML object. Found null."));
        Assert.assertTrue((boolean)(xmlObjContext instanceof Document), (String)("'" + xmlObjRefVariable + "' variable is not a XML object. It should be the instance of org.w3c.dom.Document class."));
        Document xmlObj = (Document)xmlObjContext;
        xpath = this.scenarioContext.applyParamsValueOnText(xpath);
        XmlDocumentReader xmlInfoReader = new XmlDocumentReader(xmlInfoStr);
        Document xmlInfoToAdd = xmlInfoReader.getDocument();
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList mNodes = null;
        try {
            mNodes = (NodeList)xPath.compile(xpath).evaluate(xmlObj, XPathConstants.NODE);
            if (mNodes == null || mNodes.getLength() != 1) {
                Assert.fail((String)("' " + xpath + "' path should return only one element to add additional info under this node."));
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to compile '" + xpath + "' xpath for the given XML object."), (Throwable)ex);
        }
        Node mNode = mNodes.item(0);
        NodeList aNodes = xmlInfoToAdd.getChildNodes().item(0).getChildNodes();
        for (int i = 0; i < aNodes.getLength(); ++i) {
            Node aNode = aNodes.item(i);
            if (aNode.getNodeType() != 1) continue;
            mNode.appendChild(xmlObj.adoptNode(aNode));
        }
        this.scenarioContext.addParamValue(xmlObjRefVariable, (Object)xmlObj);
    }

    @Then(value="remove the following xpaths from XML object [XMLObjRefVariable={string}]:")
    public void remove_the_xml_elements_identified_by_xpath_from_xml_object(String xmlObjRefVariable, DataTable xmlPaths) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object xmlObjContext = this.scenarioContext.getParamValue(xmlObjRefVariable);
        Assert.assertNotNull((Object)xmlObjContext, (String)("'" + xmlObjRefVariable + "' variable does not have XML object. Found null."));
        Assert.assertTrue((boolean)(xmlObjContext instanceof Document), (String)("'" + xmlObjRefVariable + "' variable is not a XML object. It should be the instance of org.w3c.dom.Document class."));
        Document xmlObj = (Document)xmlObjContext;
        List rows = xmlPaths.asLists();
        NodeList mNodes = null;
        for (int i = 1; i < rows.size(); ++i) {
            List row = (List)rows.get(i);
            String xmlPath = (String)row.get(0);
            xmlPath = this.scenarioContext.applyParamsValueOnText(xmlPath);
            XPath xPath = XPathFactory.newInstance().newXPath();
            try {
                mNodes = (NodeList)xPath.compile(xmlPath).evaluate(xmlObj, XPathConstants.NODESET);
            }
            catch (Exception ex) {
                Assert.fail((String)("Failed to compile '" + xmlPath + "' xpath for the given XML object."), (Throwable)ex);
            }
            if (mNodes == null) continue;
            for (int j = 0; j < mNodes.getLength(); ++j) {
                Element mNode = (Element)mNodes.item(j);
                if (mNode.getNodeType() != 1) continue;
                mNode.getParentNode().removeChild(mNode);
            }
        }
        this.scenarioContext.addParamValue(xmlObjRefVariable, (Object)xmlObj);
    }

    @Then(value="update the following attributes information and text part for XML elements identified by {string} xpath of XML object [XMLObjRefVariable={string}]:")
    public void update_the_following_attributes_information_and_text_part_for_xml_elements_identified_by_xpath_of_xml_object(String xpath, String xmlObjRefVariable, DocString xmlInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String xmlInfoStr = xmlInfo.getContent();
        if (StringUtil.isEmptyAfterTrim((String)xmlInfoStr)) {
            return;
        }
        xmlInfoStr = this.scenarioContext.applyParamsValueOnText(xmlInfoStr);
        Object xmlObjContext = this.scenarioContext.getParamValue(xmlObjRefVariable);
        Assert.assertNotNull((Object)xmlObjContext, (String)("'" + xmlObjRefVariable + "' variable does not have XML object. Found null."));
        Assert.assertTrue((boolean)(xmlObjContext instanceof Document), (String)("'" + xmlObjRefVariable + "' variable is not a XML object. It should be the instance of org.w3c.dom.Document class."));
        Document xmlObj = (Document)xmlObjContext;
        xpath = this.scenarioContext.applyParamsValueOnText(xpath);
        XmlDocumentReader xmlInfoReader = new XmlDocumentReader(xmlInfoStr);
        Document xmlInfoToAdd = xmlInfoReader.getDocument();
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList mNodes = null;
        try {
            mNodes = (NodeList)xPath.compile(xpath).evaluate(xmlObj, XPathConstants.NODESET);
            if (mNodes == null || mNodes.getLength() < 1) {
                return;
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to compile '" + xpath + "' xpath for the given XML object."), (Throwable)ex);
        }
        Element aNode = XmlDocumentReader.getChildElement((Node)xmlInfoToAdd, (int)0);
        NamedNodeMap attrs = aNode.getAttributes();
        for (int i = 0; i < mNodes.getLength(); ++i) {
            String textPart;
            Node node = mNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element mNode = (Element)node;
            if (attrs != null) {
                for (int j = 0; j < attrs.getLength(); ++j) {
                    Attr attr = (Attr)attrs.item(j);
                    mNode.setAttribute(attr.getName(), attr.getValue());
                }
            }
            if (StringUtil.isEmptyNoTrim((String)(textPart = StringUtil.trim((String)aNode.getTextContent())))) continue;
            if ("[[EMPTY]]".equals(textPart)) {
                mNode.setTextContent("");
                continue;
            }
            mNode.setTextContent(aNode.getTextContent());
        }
        this.scenarioContext.addParamValue(xmlObjRefVariable, (Object)xmlObj);
    }

    @Then(value="remove the following attributes information for XML elements identified by {string} xpath of XML object [XMLObjRefVariable={string}]:")
    public void remove_the_following_attributes_information_for_xml_elements_identified_by_xpath_of_xml_object(String xpath, String xmlObjRefVariable, DocString xmlInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String xmlInfoStr = xmlInfo.getContent();
        if (StringUtil.isEmptyAfterTrim((String)xmlInfoStr)) {
            return;
        }
        xmlInfoStr = this.scenarioContext.applyParamsValueOnText(xmlInfoStr);
        Object xmlObjContext = this.scenarioContext.getParamValue(xmlObjRefVariable);
        Assert.assertNotNull((Object)xmlObjContext, (String)("'" + xmlObjRefVariable + "' variable does not have XML object. Found null."));
        Assert.assertTrue((boolean)(xmlObjContext instanceof Document), (String)("'" + xmlObjRefVariable + "' variable is not a XML object. It should be the instance of org.w3c.dom.Document class."));
        Document xmlObj = (Document)xmlObjContext;
        xpath = this.scenarioContext.applyParamsValueOnText(xpath);
        XmlDocumentReader xmlInfoReader = new XmlDocumentReader(xmlInfoStr);
        Document xmlInfoToAdd = xmlInfoReader.getDocument();
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList mNodes = null;
        try {
            mNodes = (NodeList)xPath.compile(xpath).evaluate(xmlObj, XPathConstants.NODESET);
            if (mNodes == null || mNodes.getLength() < 1) {
                return;
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to compile '" + xpath + "' xpath for the given XML object."), (Throwable)ex);
        }
        Element aNode = XmlDocumentReader.getChildElement((Node)xmlInfoToAdd, (int)0);
        NamedNodeMap attrs = aNode.getAttributes();
        if (attrs == null || attrs.getLength() == 0) {
            return;
        }
        for (int i = 0; i < mNodes.getLength(); ++i) {
            Element mNode = (Element)mNodes.item(i);
            if (mNode.getNodeType() != 1) continue;
            for (int j = 0; j < attrs.getLength(); ++j) {
                Attr attr = (Attr)attrs.item(j);
                if (!mNode.hasAttribute(attr.getName())) continue;
                mNode.removeAttribute(attr.getName());
            }
        }
        this.scenarioContext.addParamValue(xmlObjRefVariable, (Object)xmlObj);
    }

    @Then(value="print XML object [XMLObjRefVariable={string}].")
    public void print_json_object(String xmlObjRefVariable) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object xmlObjContext = this.scenarioContext.getParamValue(xmlObjRefVariable);
        if (xmlObjContext == null) {
            this.scenarioContext.log(null);
            return;
        }
        Document xmlObj = (Document)xmlObjContext;
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            LSOutput output = impl.createLSOutput();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            output.setByteStream(out);
            writer.write(xmlObj, output);
            String xmlStr = new String(out.toByteArray());
            out.close();
            this.scenarioContext.log(xmlStr);
        }
        catch (Exception e) {
            Assert.fail((String)"Failed to print XML object.", (Throwable)e);
        }
    }
}

