/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.common.data;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import dev.failsafe.internal.util.Assert;
import io.cucumber.datatable.DataTable;
import io.cucumber.docstring.DocString;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.File;
import java.util.List;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.api.core.reader.YamlDocumentReader;
import org.uitnet.testing.smartfwk.core.validator.ParamPath;
import org.uitnet.testing.smartfwk.core.validator.ParamValueType;
import org.uitnet.testing.smartfwk.core.validator.SmartDataValidator;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;
import org.uitnet.testing.smartfwk.ui.core.utils.JsonYamlUtil;

public class SmartYamlDataManagementStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartYamlDataManagementStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @When(value="read {string} YAML file contents and store into {string} variable.")
    public void read_yaml_file_contents_and_store_into_variable(String yamlDataRelativeFilePath, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        YamlDocumentReader reader = new YamlDocumentReader(new File(Locations.getProjectRootDir() + File.separator + yamlDataRelativeFilePath), false);
        this.scenarioContext.addParamValue(variableName, (Object)reader.getDocumentContext());
    }

    @When(value="convert {string} YAML text into YAML object and store into {string} variable.")
    public void convert_yaml_text_into_yaml_object_and_store_into_variable(String yamlText, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        yamlText = this.scenarioContext.applyParamsValueOnText(yamlText);
        YamlDocumentReader reader = new YamlDocumentReader(yamlText, false);
        this.scenarioContext.addParamValue(variableName, (Object)reader.getDocumentContext());
    }

    @When(value="convert {string} variable contents into YAML object and store into {string} variable.")
    public void convert_variable_contents_into_yaml_object_and_store_into_variable(String yamlInputVariableName, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String yamlInput = this.scenarioContext.getParamValueAsString(yamlInputVariableName);
        this.convert_yaml_text_into_yaml_object_and_store_into_variable(yamlInput, variableName);
    }

    @When(value="convert the following YAML text into YAML object and store into {string} variable:")
    public void convert_the_following_yaml_text_into_yaml_object_and_store_into_variable(String variableName, DocString yamlText) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String yamlTxt = yamlText.getContent();
        yamlTxt = this.scenarioContext.applyParamsValueOnText(yamlTxt);
        YamlDocumentReader reader = new YamlDocumentReader(yamlTxt, false);
        this.scenarioContext.addParamValue(variableName, (Object)reader.getDocumentContext());
    }

    @When(value="read {string} parameter value from YAML object [YAMLObjRefVariable={string}] and store into {string} variable.")
    public void read_parameter_value_from_yaml_object_yaml_obj_ref_variable_and_store_into_variable(String yamlPath, String yamlObjRefVariable, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object yamlObjContext = this.scenarioContext.getParamValue(yamlObjRefVariable);
        Assert.notNull((Object)yamlObjContext, (String)("'" + yamlObjRefVariable + "' variable does not have YAML object. Found null."));
        org.testng.Assert.assertTrue((boolean)(yamlObjContext instanceof DocumentContext), (String)("'" + yamlObjRefVariable + "' variable is not a YAML object. It should be the instance of DocumentContext class."));
        DocumentContext yamlObj = (DocumentContext)yamlObjContext;
        Object value = yamlObj.read(yamlPath, new Predicate[0]);
        this.scenarioContext.addParamValue(variableName, value);
    }

    @When(value="update the following parameters values into YAML object [YAMLObjRefVariable={string}]:")
    public void read_parameter_value_from_yaml_object_yaml_obj_ref_variable(String yamlObjRefVariable, DataTable yamlParamInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object yamlObjContext = this.scenarioContext.getParamValue(yamlObjRefVariable);
        Assert.notNull((Object)yamlObjContext, (String)("'" + yamlObjRefVariable + "' variable does not have YAML object. Found null."));
        org.testng.Assert.assertTrue((boolean)(yamlObjContext instanceof DocumentContext), (String)("'" + yamlObjRefVariable + "' variable is not a YAML object. It should be the instance of DocumentContext class."));
        DocumentContext yamlObj = (DocumentContext)yamlObjContext;
        List rows = yamlParamInfo.asLists();
        for (int i = 1; i < rows.size(); ++i) {
            List row = (List)rows.get(i);
            String paramName = (String)row.get(0);
            String paramNewValue = (String)row.get(1);
            paramName = this.scenarioContext.applyParamsValueOnText(paramName);
            paramNewValue = this.scenarioContext.applyParamsValueOnText(paramNewValue);
            ParamPath pPath = JsonYamlUtil.parseParamPath((String)paramName);
            Object parsedValue = JsonYamlUtil.convertTextToTypedValue((String)pPath.getPath(), (ParamValueType)pPath.getValueType(), (String)paramNewValue);
            yamlObj.set(pPath.getPath(), parsedValue, new Predicate[0]);
        }
        this.scenarioContext.addParamValue(yamlObjRefVariable, (Object)yamlObj);
    }

    @Then(value="verify the following parameters of YAML object matches with the expected information as per the tabular info given below [YAMLObjRefVariable={string}]:")
    public void verify_the_following_parameters_of_yaml_object_matches_with_the_expected_information_as_per_the_tabular_info_given_below_yaml_obj_ref_variable(String yamlObjRefVariable, DataTable yamlParamInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Object yamlObjContext = this.scenarioContext.getParamValue(yamlObjRefVariable);
        Assert.notNull((Object)yamlObjContext, (String)("'" + yamlObjRefVariable + "' variable does not have YAML object. Found null."));
        org.testng.Assert.assertTrue((boolean)(yamlObjContext instanceof DocumentContext), (String)("'" + yamlObjRefVariable + "' variable is not a YAML object. It should be the instance of DocumentContext class."));
        DocumentContext yamlObj = (DocumentContext)yamlObjContext;
        List rows = yamlParamInfo.asLists();
        for (int i = 1; i < rows.size(); ++i) {
            List row = (List)rows.get(i);
            String yamlPath = (String)row.get(0);
            String oper = (String)row.get(1);
            String expectedInfo = (String)row.get(2);
            yamlPath = this.scenarioContext.applyParamsValueOnText(yamlPath);
            expectedInfo = this.scenarioContext.applyParamsValueOnText(expectedInfo);
            SmartDataValidator.validateJsonOrYamlData((DocumentContext)yamlObj, (String)yamlPath, (String)oper, (String)expectedInfo);
        }
    }
}

