/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.common.data.messaging;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import io.cucumber.datatable.DataTable;
import io.cucumber.docstring.DocString;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.util.List;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.SmartRegistry;
import org.uitnet.testing.smartfwk.api.core.support.MessageBucketSequenceNumberGenerator;
import org.uitnet.testing.smartfwk.core.validator.SmartDataValidator;
import org.uitnet.testing.smartfwk.core.validator.ValueMatchOperator;
import org.uitnet.testing.smartfwk.messaging.AbstractMessageHandler;
import org.uitnet.testing.smartfwk.messaging.MessageContentType;

public class SmarMessagingManagementStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmarMessagingManagementStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @When(value="send the following text message to {string} message handler:")
    public void send_the_following_text_message_to_message_handler(String messageHandlerName, DocString textMessage) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String textMessageAsStr = textMessage.getContent();
        textMessageAsStr = this.scenarioContext.applyParamsValueOnText(textMessageAsStr);
        AbstractMessageHandler messageHandler = SmartRegistry.getMessageHandlerManager().getMessageHandler(messageHandlerName);
        try {
            messageHandler.sendMessage((Object)textMessageAsStr, MessageContentType.STRING, null);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to send text message to '" + messageHandlerName + "' message handler."), (Throwable)ex);
        }
    }

    @When(value="send the following message with [MessageContentType={string}, OtherContentType={string}] to {string} message handler:")
    public void send_the_following_message_with(String messageContentType, String otherContentType, String messageHandlerName, DocString message) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String messageAsStr = message.getContent();
        messageAsStr = this.scenarioContext.applyParamsValueOnText(messageAsStr);
        MessageContentType contentType = MessageContentType.valueOf2((String)messageContentType);
        AbstractMessageHandler messageHandler = SmartRegistry.getMessageHandlerManager().getMessageHandler(messageHandlerName);
        try {
            messageHandler.sendMessage((Object)messageAsStr, contentType, otherContentType);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to send message to '" + messageHandlerName + "' message handler."), (Throwable)ex);
        }
    }

    @When(value="start message collection from {string} message handler and store into {string} bucket variable.")
    public void start_message_collection_from_message_handler(String messageHandlerName, String bucketVariableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String bucketId = this.prepareBucketId(bucketVariableName);
        this.scenarioContext.addParamValue(bucketVariableName, (Object)bucketId);
        AbstractMessageHandler messageHandler = SmartRegistry.getMessageHandlerManager().getMessageHandler(messageHandlerName);
        messageHandler.startMessageRecorder(bucketId);
    }

    @Then(value="get messages from [MessageHandler={string}, BucketVariableRef={string}] bucket as JSON object and store into {string} variable.")
    public void get_messages_from_bucket_as_json_and_store_into_variable(String messageHandlerName, String bucketVariableReference, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String bucketId = this.scenarioContext.getParamValueAsString(bucketVariableReference);
        AbstractMessageHandler messageHandler = SmartRegistry.getMessageHandlerManager().getMessageHandler(messageHandlerName);
        DocumentContext recordedMessagesContext = messageHandler.getRecordedMessagesAsJsonObject(bucketId);
        this.scenarioContext.addParamValue(variableName, (Object)recordedMessagesContext);
    }

    @Then(value="verify the size of [MessageHandler={string}, BucketVariableRef={string}] message bucket {string} {int} [MaxTimeToWaitInSeconds={int}].")
    public void verify_the_bucket(String messageHandlerName, String bucketVariableReference, String operator, int expectedSize, Integer maxTimeToWaitInSeconds) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String bucketId = this.scenarioContext.getParamValueAsString(bucketVariableReference);
        if (bucketId == null) {
            Assert.fail((String)("Message collector not started for '" + bucketVariableReference + "' bucket. To start message collection to store messages into bucket, please use 'start message collection from...' step."));
        }
        AbstractMessageHandler messageHandler = SmartRegistry.getMessageHandlerManager().getMessageHandler(messageHandlerName);
        int numIterations = maxTimeToWaitInSeconds == 0 || maxTimeToWaitInSeconds <= 2 ? 1 : maxTimeToWaitInSeconds / 2;
        ValueMatchOperator op = ValueMatchOperator.valueOf2((String)operator);
        block10: for (int i = 1; i <= numIterations; ++i) {
            try {
                DocumentContext recordedMessagesContext = messageHandler.getRecordedMessagesAsJsonObject(bucketId);
                int actualSize = (Integer)recordedMessagesContext.read("$.length()", new Predicate[0]);
                switch (op) {
                    case EQUAL_TO: {
                        if (actualSize == expectedSize) continue block10;
                        Assert.fail((String)("Actual size (" + actualSize + ") should be same as expected size (" + expectedSize + ")."));
                        break;
                    }
                    case NOT_EQUAL_TO: {
                        if (actualSize != expectedSize) continue block10;
                        Assert.fail((String)("Actual size (" + actualSize + ") should not be same as expected size (" + expectedSize + ")."));
                        break;
                    }
                    case GREATER_THAN: {
                        if (actualSize > expectedSize) continue block10;
                        Assert.fail((String)("Actual size (" + actualSize + ") should be greter than the expected size (" + expectedSize + ")."));
                        break;
                    }
                    case GREATER_THAN_EQUAL_TO: {
                        if (actualSize >= expectedSize) continue block10;
                        Assert.fail((String)("Actual size (" + actualSize + ") should be greater than or equal to the expected size (" + expectedSize + ")."));
                        break;
                    }
                    case LESS_THAN: {
                        if (actualSize < expectedSize) continue block10;
                        Assert.fail((String)("Actual size (" + actualSize + ") should be less than the expected size (" + expectedSize + ")."));
                        break;
                    }
                    case LESS_THAN_EQUAL_TO: {
                        if (actualSize <= expectedSize) continue block10;
                        Assert.fail((String)("Actual size (" + actualSize + ") should be less than or equal to the expected size (" + expectedSize + ")."));
                        break;
                    }
                    default: {
                        Assert.fail((String)("Operatoe '" + op.getOperator() + "' is not supported."));
                        break;
                    }
                }
                continue;
            }
            catch (Throwable th) {
                if (i == numIterations) {
                    Assert.fail((String)("Failed to meet all expected crietrias. Reason: " + th.getMessage()));
                    continue;
                }
                this.scenarioContext.waitForSeconds(2);
            }
        }
    }

    @Then(value="verify [MessageHandler={string}, BucketVariableRef={string}] message bucket meets the following criteria [MaxTimeToWaitInSeconds={int}]:")
    public void verify_message_bucket_meets_the_following_criteria(String messageHandlerName, String bucketVariableReference, Integer maxTimeToWaitInSeconds, DataTable expectedCriterias) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String bucketId = this.scenarioContext.getParamValueAsString(bucketVariableReference);
        if (bucketId == null) {
            Assert.fail((String)("Message collector not started for '" + bucketVariableReference + "' bucket. To start message collection to store messages into bucket, please use 'start message collection from...' step."));
        }
        AbstractMessageHandler messageHandler = SmartRegistry.getMessageHandlerManager().getMessageHandler(messageHandlerName);
        int numIterations = maxTimeToWaitInSeconds == 0 || maxTimeToWaitInSeconds <= 2 ? 1 : maxTimeToWaitInSeconds / 2;
        List rows = expectedCriterias.asLists();
        for (int i = 1; i <= numIterations; ++i) {
            try {
                DocumentContext recordedMessagesContext = messageHandler.getRecordedMessagesAsJsonObject(bucketId);
                for (int j = 1; j < rows.size(); ++j) {
                    List row = (List)rows.get(j);
                    String jsonPath = (String)row.get(0);
                    String oper = (String)row.get(1);
                    String expectedInfo = (String)row.get(2);
                    jsonPath = this.scenarioContext.applyParamsValueOnText(jsonPath);
                    expectedInfo = this.scenarioContext.applyParamsValueOnText(expectedInfo);
                    SmartDataValidator.validateJsonOrYamlData((DocumentContext)recordedMessagesContext, (String)jsonPath, (String)oper, (String)expectedInfo);
                }
                continue;
            }
            catch (Throwable th) {
                if (i == numIterations) {
                    Assert.fail((String)("Failed to meet all expected crietrias. Reason: " + th.getMessage()));
                    continue;
                }
                this.scenarioContext.waitForSeconds(2);
            }
        }
    }

    private String prepareBucketId(String bucketVariable) {
        MessageBucketSequenceNumberGenerator seqGen = MessageBucketSequenceNumberGenerator.getInstance();
        return bucketVariable + "-#-" + seqGen.next();
    }
}

