/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.common.local_machine;

import com.jayway.jsonpath.DocumentContext;
import io.cucumber.docstring.DocString;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.api.core.reader.JsonDocumentReader;
import org.uitnet.testing.smartfwk.common.command.SmartCommandExecuter;
import org.uitnet.testing.smartfwk.common.command.SyncCommandResult;
import org.uitnet.testing.smartfwk.core.stepdefs.en.common.local_machine.SmartInputCommand;
import org.uitnet.testing.smartfwk.local_machine.LocalMachineFileSystem;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;
import org.uitnet.testing.smartfwk.validator.DownloadedFileValidator;
import org.uitnet.testing.smartfwk.validator.FileContentsValidator;

public class SmartLocalFileManagementStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartLocalFileManagementStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @When(value="delete {string} file from the local downloads directory.")
    public void delete_file_from_the_local_downloads_directory(String fileName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        fileName = this.scenarioContext.applyParamsValueOnText(fileName);
        LocalMachineFileSystem.deleteFiles((String)(Locations.getProjectRootDir() + "/test-results/downloads"), (TextMatchMechanism)TextMatchMechanism.exactMatchWithExpectedValue, (String)fileName);
    }

    @When(value="delete {string} file from the following local directory:")
    public void delete_file_from_the_following_local_directory(String fileName, DocString localDirectory) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        fileName = this.scenarioContext.applyParamsValueOnText(fileName);
        String localDirectoryPath = this.scenarioContext.applyParamsValueOnText(localDirectory.getContent().trim());
        LocalMachineFileSystem.deleteFiles((String)localDirectoryPath, (TextMatchMechanism)TextMatchMechanism.exactMatchWithExpectedValue, (String)fileName);
    }

    @When(value="delete files from the local downloads directory where [FileNamePrefix:{string}, FileExtension:{string}, FileNameMatchMechanism:{string}].")
    public void delete_files_from_the_local_downloads_directory_where(String fileNamePrefix, String fileExtension, String fileNameMatchMechanism) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        fileNamePrefix = this.scenarioContext.applyParamsValueOnText(fileNamePrefix);
        LocalMachineFileSystem.deleteFiles((String)(Locations.getProjectRootDir() + "/test-results/downloads"), (TextMatchMechanism)TextMatchMechanism.valueOf2((String)fileNameMatchMechanism), (String)fileNamePrefix, (String)fileExtension);
    }

    @When(value="delete files from the following local directory where [FileNamePrefix:{string}, FileExtension:{string}, FileNameMatchMechanism:{string}]:")
    public void delete_files_from_the_following_local_directory_where(String fileNamePrefix, String fileExtension, String fileNameMatchMechanism, DocString localDirectory) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        fileNamePrefix = this.scenarioContext.applyParamsValueOnText(fileNamePrefix);
        String localDirectoryPath = this.scenarioContext.applyParamsValueOnText(localDirectory.getContent().trim());
        LocalMachineFileSystem.deleteFiles((String)localDirectoryPath, (TextMatchMechanism)TextMatchMechanism.valueOf2((String)fileNameMatchMechanism), (String)fileNamePrefix, (String)fileExtension);
    }

    @Then(value="find latest filename from local downloads directory that matches with [FileNamePrefix:{string}, FileExtension:{string}, FileNameMatchMechanism:{string}] and store into {string} variable.")
    public void find_latest_filename_from_local_downloads_directory_that_matches_with_and_store_into_variable(String fileNamePrefix, String fileExtension, String fileNameMatchMechanism, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        fileNamePrefix = this.scenarioContext.applyParamsValueOnText(fileNamePrefix);
        List files = LocalMachineFileSystem.listFiles((String)(Locations.getProjectRootDir() + "/test-results/downloads"), (TextMatchMechanism)TextMatchMechanism.valueOf2((String)fileNameMatchMechanism), (String)fileNamePrefix, (String)fileExtension);
        String latestFileName = "NOT-FOUND";
        if (files != null && files.size() > 0) {
            Collections.sort(files);
            latestFileName = (String)files.get(files.size() - 1);
            latestFileName = latestFileName.substring(latestFileName.lastIndexOf(File.separator) + 1);
        }
        this.scenarioContext.addParamValue(variableName, (Object)latestFileName);
    }

    @Then(value="find latest filename from the following local directory that matches with [FileNamePrefix:{string}, FileExtension:{string}, FileNameMatchMechanism:{string}] and store into {string} variable:")
    public void find_latest_filename_from_the_following_local_directory_that_matches_with_and_store_into_variable(String fileNamePrefix, String fileExtension, String fileNameMatchMechanism, String variableName, DocString localDirectory) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        fileNamePrefix = this.scenarioContext.applyParamsValueOnText(fileNamePrefix);
        String localDirectoryPath = this.scenarioContext.applyParamsValueOnText(localDirectory.getContent().trim());
        List files = LocalMachineFileSystem.listFiles((String)localDirectoryPath, (TextMatchMechanism)TextMatchMechanism.valueOf2((String)fileNameMatchMechanism), (String)fileNamePrefix, (String)fileExtension);
        String latestFileName = "NOT-FOUND";
        if (files != null && files.size() > 0) {
            Collections.sort(files);
            latestFileName = (String)files.get(files.size() - 1);
            latestFileName = latestFileName.substring(latestFileName.lastIndexOf(File.separator) + 1);
        }
        this.scenarioContext.addParamValue(variableName, (Object)latestFileName);
    }

    @Then(value="verify that the {string} file with extension {string} is downloaded [MaxTimeToWaitInSeconds={int}].")
    public void verify_that_the_file_with_extension_is_downloaded_maxtimetowaitinseconds(String fileName, String fileExtension, Integer maxTimeToWaitInSeconds) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        fileName = this.scenarioContext.applyParamsValueOnText(fileName);
        DownloadedFileValidator.validateBrowserFileDownloaded((String)fileName, (String)fileExtension, (boolean)false, (int)maxTimeToWaitInSeconds);
    }

    @Then(value="verify that the {string} file with extension {string} is present in downloads directory [MaxTimeToWaitInSeconds={int}].")
    public void verify_that_the_file_with_extension_is_downloaded_maxtimetowaitinseconds_1(String fileName, String fileExtension, Integer maxTimeToWaitInSeconds) {
        this.verify_that_the_file_with_extension_is_downloaded_maxtimetowaitinseconds(fileName, fileExtension, maxTimeToWaitInSeconds);
    }

    @Then(value="verify that the downloaded file {string} contains the following keywords [KeywordDelimiter={string}, InOrder={string}, ShouldPrint={string}]:")
    public void verify_that_the_downloaded_file_contains_the_following_text(String fileNameWithExtension, String keywordDelimiter, String inOrder, String shouldPrint, DocString keywords) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        fileNameWithExtension = this.scenarioContext.applyParamsValueOnText(fileNameWithExtension);
        FileContentsValidator fcValidator = new FileContentsValidator(Locations.getProjectRootDir() + "/test-results/downloads/" + fileNameWithExtension, "Yes".equalsIgnoreCase(shouldPrint));
        String txt = this.scenarioContext.applyParamsValueOnText(keywords.getContent());
        String[] arr = txt.split(keywordDelimiter);
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = StringUtil.trimNullAsEmpty((String)arr[i]);
        }
        if ("Yes".equalsIgnoreCase(inOrder)) {
            fcValidator.validateAllKeywordsPresentInOrder(arr);
        } else {
            fcValidator.validateAllKeywordsPresent(arr);
        }
    }

    @Then(value="verify the contents of {string} file that contains the following keywords [KeywordDelimiter={string}, InOrder={string}, ShouldPrint={string}]:")
    public void verify_the_contents_of_the_file_that_contains_the_following_text(String absoluteFilePath, String keywordDelimiter, String inOrder, String shouldPrint, DocString keywords) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        absoluteFilePath = this.scenarioContext.applyParamsValueOnText(absoluteFilePath);
        FileContentsValidator fcValidator = new FileContentsValidator(absoluteFilePath, "Yes".equalsIgnoreCase(shouldPrint));
        String txt = this.scenarioContext.applyParamsValueOnText(keywords.getContent());
        String[] arr = txt.split(keywordDelimiter);
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = StringUtil.trimNullAsEmpty((String)arr[i]);
        }
        if ("Yes".equalsIgnoreCase(inOrder)) {
            fcValidator.validateAllKeywordsPresentInOrder(arr);
        } else {
            fcValidator.validateAllKeywordsPresent(arr);
        }
    }

    @When(value="execute the following system command locally to {string} and store the result into {string} JSON variable:")
    public void execute_following_system_command_locally(String actionName, String variableName, DocString commandInfoAsJson) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String commandJson = commandInfoAsJson.getContent();
        commandJson = this.scenarioContext.applyParamsValueOnText(commandJson);
        JsonDocumentReader jsonReader = new JsonDocumentReader(commandJson, false);
        SmartInputCommand cmd = (SmartInputCommand)jsonReader.readValueAsObject("$", SmartInputCommand.class);
        SyncCommandResult result = SmartCommandExecuter.executeSync(cmd.getShellInfo(), (Integer)cmd.getTimeoutInSeconds(), (String)cmd.getBaseDirectory(), (String)cmd.getCommandName(), (String[])cmd.getCommandArgs());
        JsonDocumentReader jsonReader2 = new JsonDocumentReader();
        DocumentContext jsonCtx = jsonReader2.prepareDocumentContext((Object)result);
        this.scenarioContext.addParamValue(variableName, (Object)jsonCtx);
    }
}

