/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.common.remote_machine;

import io.cucumber.docstring.DocString;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.remote_machine.AbstractRemoteMachineActionHandler;
import org.uitnet.testing.smartfwk.remote_machine.RemoteMachineManager;
import org.uitnet.testing.smartfwk.remote_machine.SmartRemoteMachineManager;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;

public class SmartRemoteFileManagementStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartRemoteFileManagementStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @When(value="remove expected file\\(s) [RemoteDirectory={string}, ExpectedFileName={string}, FileNameMatchMechanism={string}] from remote machine [AppName={string}, RemoteMachineName:{string}].")
    public void remove_expected_files_from_remote_machine(String remoteDirectory, String expectedFileName, String fileNameMatchMechanism, String appName, String remoteMachineName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        remoteDirectory = this.scenarioContext.applyParamsValueOnText(remoteDirectory);
        expectedFileName = this.scenarioContext.applyParamsValueOnText(expectedFileName);
        RemoteMachineManager remoteMachineMgr = SmartRemoteMachineManager.getInstance();
        AbstractRemoteMachineActionHandler handler = remoteMachineMgr.getActionHandler(appName, remoteMachineName);
        handler.deleteFiles(remoteDirectory, TextMatchMechanism.valueOf2((String)fileNameMatchMechanism), expectedFileName);
    }

    @When(value="download expected remote file\\(s) [RemoteDirectory={string}, ExpectedFileName={string}, FileNameMatchMechanism={string}] from remote machine [AppName={string}, RemoteMachineName:{string}].")
    public void download_expected_files_from_remote_machine(String remoteDirectory, String expectedFileName, String fileNameMatchMechanism, String appName, String remoteMachineName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        remoteDirectory = this.scenarioContext.applyParamsValueOnText(remoteDirectory);
        expectedFileName = this.scenarioContext.applyParamsValueOnText(expectedFileName);
        RemoteMachineManager remoteMachineMgr = SmartRemoteMachineManager.getInstance();
        AbstractRemoteMachineActionHandler handler = remoteMachineMgr.getActionHandler(appName, remoteMachineName);
        handler.downloadFiles(remoteDirectory, TextMatchMechanism.valueOf2((String)fileNameMatchMechanism), expectedFileName, Locations.getProjectRootDir() + "/test-results/downloads/");
    }

    @When(value="upload local file\\(s) [LocalDirectory={string}, ExpectedFileName={string}, FileNameMatchMechanism={string}] on remote machine [AppName={string}, RemoteMachineName:{string}, RemoteDirectory={string}].")
    public void upload_expected_files_on_remote_machine(String localDirectory, String expectedFileName, String fileNameMatchMechanism, String appName, String remoteMachineName, String remoteDirectory) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        localDirectory = this.scenarioContext.applyParamsValueOnText(localDirectory);
        expectedFileName = this.scenarioContext.applyParamsValueOnText(expectedFileName);
        remoteDirectory = this.scenarioContext.applyParamsValueOnText(remoteDirectory);
        RemoteMachineManager remoteMachineMgr = SmartRemoteMachineManager.getInstance();
        AbstractRemoteMachineActionHandler handler = remoteMachineMgr.getActionHandler(appName, remoteMachineName);
        handler.uploadFiles(Locations.getProjectRootDir() + localDirectory, TextMatchMechanism.valueOf2((String)fileNameMatchMechanism), expectedFileName, remoteDirectory);
    }

    @Then(value="verify that the expected files [RemoteDirectory={string}, ExpectedFileName={string}, FileNameMatchMechanism={string}] are uploaded on remote machine [AppName={string}, RemoteMachineName:{string}, MaxTimeToWaitInSeconds={int}].")
    public void verify_that_the_expected_files_are_present_on_remote_machine(String remoteDirectory, String expectedFileName, String fileNameMatchMechanism, String appName, String remoteMachineName, Integer maxTimeToWaitInSeconds) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        expectedFileName = this.scenarioContext.applyParamsValueOnText(expectedFileName);
        remoteDirectory = this.scenarioContext.applyParamsValueOnText(remoteDirectory);
        RemoteMachineManager remoteMachineMgr = SmartRemoteMachineManager.getInstance();
        AbstractRemoteMachineActionHandler handler = remoteMachineMgr.getActionHandler(appName, remoteMachineName);
        handler.validateFileExists(remoteDirectory, TextMatchMechanism.valueOf2((String)fileNameMatchMechanism), expectedFileName, maxTimeToWaitInSeconds.intValue());
    }

    @Then(value="verify that the expected files [RemoteDirectory={string}, ExpectedFileName={string}, FileNameMatchMechanism={string}] are present on remote machine [AppName={string}, RemoteMachineName:{string}, MaxTimeToWaitInSeconds={int}].")
    public void verify_that_the_expected_files_are_present_on_remote_machine_1(String remoteDirectory, String expectedFileName, String fileNameMatchMechanism, String appName, String remoteMachineName, Integer maxTimeToWaitInSeconds) {
        this.verify_that_the_expected_files_are_present_on_remote_machine(remoteDirectory, expectedFileName, fileNameMatchMechanism, appName, remoteMachineName, maxTimeToWaitInSeconds);
    }

    @Then(value="verify that the expected directories [RemoteDirectory={string}, ExpectedFolderName={string}, FolderNameMatchMechanism={string}] are present on remote machine [AppName={string}, RemoteMachineName:{string}, MaxTimeToWaitInSeconds={int}].")
    public void verify_that_the_expected_directory_are_present_on_remote_machine(String remoteDirectory, String expectedFolderName, String folderNameMatchMechanism, String appName, String remoteMachineName, Integer maxTimeToWaitInSeconds) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        expectedFolderName = this.scenarioContext.applyParamsValueOnText(expectedFolderName);
        remoteDirectory = this.scenarioContext.applyParamsValueOnText(remoteDirectory);
        RemoteMachineManager remoteMachineMgr = SmartRemoteMachineManager.getInstance();
        AbstractRemoteMachineActionHandler handler = remoteMachineMgr.getActionHandler(appName, remoteMachineName);
        handler.validateFolderExists(remoteDirectory, TextMatchMechanism.valueOf2((String)folderNameMatchMechanism), expectedFolderName, maxTimeToWaitInSeconds.intValue());
    }

    @Then(value="execute the following command on remote machine [AppName={string}, RemoteMachineName:{string}, MaxTimeToWaitInSeconds={int}] and store result into {string} variable:")
    public void execute_the_fillowing_command_on_remote_machine(String appName, String remoteMachineName, Integer maxTimeToWaitInSeconds, String variableName, DocString command) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String commandAsStr = command.getContent();
        commandAsStr = this.scenarioContext.applyParamsValueOnText(commandAsStr);
        RemoteMachineManager remoteMachineMgr = SmartRemoteMachineManager.getInstance();
        AbstractRemoteMachineActionHandler handler = remoteMachineMgr.getActionHandler(appName, remoteMachineName);
        String result = handler.executeCommand(commandAsStr);
        this.scenarioContext.addParamValue(variableName, (Object)result);
    }
}

