/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.ui;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.en.Then;
import java.lang.invoke.CallSite;
import java.util.LinkedList;
import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.api.core.support.PageObjectInfo;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.utils.ColorContrastUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.FontUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.PageObjectUtil;

public class Smart508CompliancyStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public Smart508CompliancyStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @Then(value="verify the tab key navigation order for the following page elements is same as given below [pageOrSecionName={string}, focusSwitchIntervalInMillis: {int}]:")
    public void verify_the_tab_key_navigation_order_for_elements(String pageOrSectionName, int focusSwitchIntervalInMillis, DataTable dataTable) {
        WebElement nextElem;
        WebElement elem;
        PageObjectInfo peInfoNext;
        String peNext;
        PageObjectInfo peInfo;
        String pe;
        int i;
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        List rows = dataTable.asLists();
        Assert.assertTrue((rows.size() > 2 ? 1 : 0) != 0, (String)"Please specify atleast 2 page elements in the data table to verify tab key navigation.");
        SmartAppDriver appDriver = this.scenarioContext.getActiveAppDriver();
        List row = null;
        List rowNext = null;
        for (i = 1; i < rows.size() - 1; ++i) {
            row = (List)rows.get(i);
            pe = (String)row.get(0);
            peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
            rowNext = (List)rows.get(i + 1);
            peNext = (String)rowNext.get(0);
            peInfoNext = PageObjectUtil.getPageObjectInfo((String)peNext, (SmartCucumberScenarioContext)this.scenarioContext);
            if (i == 1) {
                PageObjectUtil.invokeValidatorMethod((String)"sendCommandKeys", (String[])new String[]{Integer.TYPE.getTypeName(), CharSequence[].class.getTypeName()}, (Object[])new Object[]{peInfoNext.getMaxIterationsToLocateElements(), new CharSequence[]{Keys.LEFT_SHIFT, Keys.TAB}}, (PageObjectInfo)peInfoNext, (SmartCucumberScenarioContext)this.scenarioContext);
                this.scenarioContext.waitForMilliSeconds(focusSwitchIntervalInMillis);
            }
            PageObjectUtil.invokeValidatorMethod((String)"sendCommandKeys", (String[])new String[]{Integer.TYPE.getTypeName(), CharSequence[].class.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements(), new CharSequence[]{Keys.TAB}}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
            this.scenarioContext.waitForMilliSeconds(focusSwitchIntervalInMillis);
            elem = appDriver.getWebDriver().switchTo().activeElement();
            if (elem == null) {
                Assert.fail((String)("Tab key pressed at page element present in row " + (i + 1) + ". Next focused/active element is not found."));
                continue;
            }
            nextElem = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfoNext.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfoNext, (SmartCucumberScenarioContext)this.scenarioContext);
            Assert.assertEquals((String)("tagName=" + elem.getTagName()), (String)("tagName=" + nextElem.getTagName()), (String)("Page element at row " + (i + 1) + " is not the next focused element after tab key pressed on row " + i + " element."));
            Assert.assertEquals((String)("id=" + elem.getAttribute("id")), (String)("id=" + nextElem.getAttribute("id")), (String)("Page element at row " + (i + 1) + " is not the next focused element after tab key pressed on row " + i + " element."));
            Assert.assertEquals((String)("name=" + elem.getAttribute("name")), (String)("name=" + nextElem.getAttribute("name")), (String)("Page element at row " + (i + 1) + " is not the next focused element after tab key pressed on row " + i + " element."));
            Assert.assertEquals((String)("css=" + elem.getAttribute("css")), (String)("css=" + nextElem.getAttribute("css")), (String)("Page element at row " + (i + 1) + " is not the next focused element after tab key pressed on row " + i + " element."));
            Assert.assertEquals((String)("style=" + elem.getAttribute("style")), (String)("style=" + nextElem.getAttribute("style")), (String)("Page element at row " + (i + 1) + " is not the next focused element after tab key pressed on row " + i + " element."));
            Assert.assertEquals((String)("text=" + elem.getText()), (String)("text=" + nextElem.getText()), (String)("Page element at row " + (i + 1) + " is not the next focused element after tab key pressed on row " + i + " element."));
        }
        for (i = rows.size() - 1; i > 1; --i) {
            row = (List)rows.get(i);
            pe = (String)row.get(0);
            peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
            rowNext = (List)rows.get(i - 1);
            peNext = (String)rowNext.get(0);
            peInfoNext = PageObjectUtil.getPageObjectInfo((String)peNext, (SmartCucumberScenarioContext)this.scenarioContext);
            PageObjectUtil.invokeValidatorMethod((String)"sendCommandKeys", (String[])new String[]{Integer.TYPE.getTypeName(), CharSequence[].class.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements(), new CharSequence[]{Keys.LEFT_SHIFT, Keys.TAB}}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
            this.scenarioContext.waitForMilliSeconds(focusSwitchIntervalInMillis);
            elem = appDriver.getWebDriver().switchTo().activeElement();
            if (elem == null) {
                Assert.fail((String)("Shift+Tab key pressed at page element present in row " + i + ". Previous focused/active element is not found."));
                continue;
            }
            nextElem = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfoNext.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfoNext, (SmartCucumberScenarioContext)this.scenarioContext);
            Assert.assertEquals((String)elem.getTagName(), (String)nextElem.getTagName(), (String)("Page element at row " + (i - 1) + " is not the previous focused element after shift+tab key is pressed on row " + i + " element."));
            Assert.assertEquals((String)elem.getAttribute("id"), (String)nextElem.getAttribute("id"), (String)("Page element at row " + (i - 1) + " is not the previous focused element after shift+tab key is pressed on row " + i + " element."));
            Assert.assertEquals((String)elem.getAttribute("name"), (String)nextElem.getAttribute("name"), (String)("Page element at row " + (i - 1) + " is not the previous focused element after shift+tab key is pressed on row " + i + " element."));
            Assert.assertEquals((String)elem.getAttribute("css"), (String)nextElem.getAttribute("css"), (String)("Page element at row " + (i - 1) + " is not the previous focused element after shift+tab key is pressed on row " + i + " element."));
            Assert.assertEquals((String)elem.getAttribute("style"), (String)nextElem.getAttribute("style"), (String)("Page element at row " + (i - 1) + " is not the previous focused element after shift+tab key is pressed on row " + i + " element."));
            Assert.assertEquals((String)elem.getText(), (String)nextElem.getText(), (String)("Page element at row " + (i - 1) + " is not the previous focused element after shift+tab key is pressed on row " + i + " element."));
        }
    }

    @Then(value="verify color contrast ratio [expected minContrastRatio={double} for minFontWeight={int} and minFontSize={double} rem] for the following page elements present on {string}:")
    public void verify_color_contrast_ratio_for_page_elements(double minContrastRatio, int minFontWeight, double minFontSize, String pageOrSectionName, DataTable dataTable) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        List rows = dataTable.asLists();
        List row = null;
        WebElement webElem = null;
        LinkedList<CallSite> invalidRows = new LinkedList<CallSite>();
        for (int i = 1; i < rows.size(); ++i) {
            row = (List)rows.get(i);
            String pe = (String)row.get(0);
            PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
            webElem = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
            String fgColor = webElem.getCssValue("color");
            String bgColor = webElem.getCssValue("background-color");
            int fontWeight = Integer.parseInt(webElem.getCssValue("font-weight"));
            double fontSizeInREM = FontUtil.computeFontSizeInREM((String)webElem.getCssValue("font-size"));
            double actualContrastRatio = ColorContrastUtil.calcContrastRatio((String)fgColor, (String)bgColor);
            if (fontWeight >= minFontWeight && fontSizeInREM >= minFontSize) {
                if (actualContrastRatio >= minContrastRatio) continue;
                invalidRows.add((CallSite)((Object)("{row: " + (i + 1) + ", ratio: " + actualContrastRatio + ", fontWeight: " + fontWeight + ", fontSize: " + fontSizeInREM + "}")));
                continue;
            }
            invalidRows.add((CallSite)((Object)("{row: " + (i + 1) + ", ratio: " + actualContrastRatio + ", fontWeight: " + fontWeight + ", fontSize: " + fontSizeInREM + "}")));
        }
        if (invalidRows.size() > 0) {
            Assert.fail((String)("Color contrast ratio (ForegroundColor/BackgroundColor) for the page elements presents on the following rows is invalid: \n" + invalidRows + "\n   Expected minimum color contrast ratio is " + minContrastRatio + "."));
        }
    }
}

