/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.ui;

import io.cucumber.docstring.DocString;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.ui.core.AbstractAppConnector;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;
import org.uitnet.testing.smartfwk.ui.core.config.WebBrowserType;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;

public class SmartUiBasicAppOperationsStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartUiBasicAppOperationsStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @Given(value="set the following app driver properties for [AppName={string}, WebBrowser={string}]:")
    public void set_the_following_driver_properties_for_app_webbrowser(String appName, String browserType, DocString jsonDocument) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        this.scenarioContext.overrideDriverProps(appName, browserType, jsonDocument.getContent());
    }

    @Given(value="set the following app driver properties for [AppName={string}]:")
    public void set_the_following_driver_properties_for_app_webbrowser2(String appName, DocString jsonDocument) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        this.scenarioContext.overrideDriverProps(appName, WebBrowserType.notApplicable.getType(), jsonDocument.getContent());
    }

    @When(value="open {string} application.")
    public void connect_or_switch_to_application(String appName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        this.scenarioContext.connectOrSwitch(appName);
    }

    @Given(value="{string} application is already opened.")
    public void connect_or_switch_to_application_2(String appName) {
        this.connect_or_switch_to_application(appName);
    }

    @Given(value="application {string} is already opened.")
    public void connect_or_switch_to_application_3(String appName) {
        this.connect_or_switch_to_application(appName);
    }

    @When(value="switch to {string} application.")
    public void connect_or_switch_to_application_4(String appName) {
        this.connect_or_switch_to_application(appName);
    }

    @When(value="connect to {string} application.")
    public void connect_or_switch_to_application_5(String appName) {
        this.connect_or_switch_to_application(appName);
    }

    @Given(value="already connected to {string} application.")
    public void connect_or_switch_to_application_6(String appName) {
        this.connect_or_switch_to_application(appName);
    }

    @Then(value="connection to application is successful.")
    public void app_connected_or_switched_success() {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
    }

    @Then(value="application switching is successful.")
    public void app_connected_or_switched_success_1() {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
    }

    @Then(value="application is switched successfully.")
    public void app_connected_or_switched_success_2() {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
    }

    @Given(value="user is logged in using {string} user profile.")
    public void user_login_using_user_profile(String userProfileName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        this.scenarioContext.setActiveUserProfileOnActiveApp(userProfileName);
    }

    @Given(value="user is already logged in using {string} user profile.")
    public void user_login_using_user_profile_1(String userProfileName) {
        this.user_login_using_user_profile(userProfileName);
    }

    @When(value="user login using {string} user profile.")
    public void user_login_using_user_profile_2(String userProfileName) {
        this.user_login_using_user_profile(userProfileName);
    }

    @When(value="login using {string} user profile.")
    public void user_login_using_user_profile_3(String userProfileName) {
        this.user_login_using_user_profile(userProfileName);
    }

    @When(value="logout active user.")
    public void logout_active_user() {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        this.scenarioContext.getActiveAppConnector().logoutAndNoQuit();
    }

    @When(value="logout active user from {string} application.")
    public void logout_active_user_from_app(String appName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        AbstractAppConnector appConnector = this.scenarioContext.getAppConnector(appName);
        if (appConnector != null) {
            appConnector.logoutAndNoQuit();
        }
    }

    @When(value="user switch to {string} user profile.")
    public void user_login_using_user_profile_4(String userProfileName) {
        this.user_login_using_user_profile(userProfileName);
    }

    @When(value="switch to {string} user profile.")
    public void user_login_using_user_profile_5(String userProfileName) {
        this.user_login_using_user_profile(userProfileName);
    }

    @Given(value="user is already connected using {string} user profile on {string} application.")
    public void user_login_using_user_profile_on_application_1(String userProfileName, String appName) {
        this.user_login_using_user_profile_on_application(userProfileName, appName);
    }

    @Given(value="user is already logged in using {string} user profile on {string} application.")
    public void user_login_using_user_profile_on_application(String userProfileName, String appName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        this.connect_or_switch_to_application(appName);
        this.user_login_using_user_profile(userProfileName);
    }

    @When(value="switch to {string} application using {string} user profile.")
    public void switch_to_application_using_user_profile(String appName, String userProfileName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        this.connect_or_switch_to_application(appName);
        this.user_login_using_user_profile(userProfileName);
    }

    @When(value="connect to {string} application using {string} user profile.")
    public void switch_to_application_using_user_profile_1(String appName, String userProfileName) {
        this.switch_to_application_using_user_profile(appName, userProfileName);
    }

    @Given(value="URL {string} is already opened.")
    public void open_url(String url) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        if (url.startsWith("file:///")) {
            String newUrl = "file:///" + Locations.getProjectRootDir().replace("\\", "/") + "/" + url.split("file:///")[1].trim();
            this.scenarioContext.getActiveAppDriver().openURL(newUrl);
        } else {
            this.scenarioContext.getActiveAppDriver().openURL(url);
        }
    }

    @Given(value="{string} URL is already opened.")
    public void open_url_1(String url) {
        this.open_url(url);
    }

    @When(value="open {string} URL.")
    public void open_url_2(String url) {
        this.open_url(url);
    }

    @Then(value="the {string} URL is displayed.")
    public void url_is_displayed(String url) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
    }

    @Then(value="{string} URL is displayed.")
    public void url_is_displayed_1(String url) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
    }

    @Then(value="the {string} URL is opened.")
    public void url_is_displayed_2(String url) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
    }

    @Then(value="{string} URL is opened.")
    public void url_is_displayed_3(String url) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
    }

    @Then(value="verify {string} page is displayed.")
    public void verify_the_page_is_displayed(String pageName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
    }

    @Then(value="the {string} page is displayed.")
    public void the_page_is_displayed(String pageName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
    }

    @Then(value="{string} page is displayed.")
    public void the_page_is_displayed_1(String pageName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
    }

    @Then(value="{string} application is switched successfully.")
    public void application_is_switched_successfully(String appName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        if (!StringUtil.isTextMatchedWithExpectedValue((String)this.scenarioContext.getActiveAppName(), (String)appName, (TextMatchMechanism)TextMatchMechanism.exactMatchWithExpectedValue)) {
            Assert.fail((String)(appName + " is not activated."));
        }
    }

    @Then(value="connected to {string} application successfully.")
    public void application_is_switched_successfully_1(String appName) {
        this.application_is_switched_successfully(appName);
    }

    @Then(value="{string} application is opened successfully.")
    public void application_is_switched_successfully_2(String appName) {
        this.application_is_switched_successfully(appName);
    }

    @Then(value="{string} user profile is switched successfully.")
    public void user_profile_is_switched_successfully(String userProfile) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        if (!StringUtil.isTextMatchedWithExpectedValue((String)this.scenarioContext.getActiveUserProfileNameOfActiveApp(), (String)userProfile, (TextMatchMechanism)TextMatchMechanism.exactMatchWithExpectedValue)) {
            Assert.fail((String)(userProfile + " is not activated."));
        }
    }

    @Then(value="{string} user profile is activated successfully.")
    public void user_profile_is_switched_successfully_1(String userProfile) {
        this.user_profile_is_switched_successfully(userProfile);
    }

    @Then(value="{string} user profile is switched successfully on {string} application.")
    public void user_profile_is_switched_successfully(String userProfile, String appName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        if (!StringUtil.isTextMatchedWithExpectedValue((String)this.scenarioContext.getActiveAppName(), (String)appName, (TextMatchMechanism)TextMatchMechanism.exactMatchWithExpectedValue)) {
            Assert.fail((String)(appName + " is not activated."));
        }
        if (!StringUtil.isTextMatchedWithExpectedValue((String)this.scenarioContext.getActiveUserProfileName(appName), (String)userProfile, (TextMatchMechanism)TextMatchMechanism.exactMatchWithExpectedValue)) {
            Assert.fail((String)(userProfile + " is not activated."));
        }
    }

    @Then(value="{string} user profile is activated successfully on {string} application.")
    public void user_profile_is_switched_successfully_1(String userProfile, String appName) {
        this.user_profile_is_switched_successfully(userProfile);
    }

    @Then(value="take screenshot.")
    public void take_screenshot() {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        if (this.scenarioContext.isUiScenario()) {
            this.scenarioContext.captureScreenshot("scenario-RUNNUNG");
        }
    }

    @Then(value="take screenshot and store filename in {string} variable.")
    public void take_screenshot_and_store_filename_in_variable(String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        if (this.scenarioContext.isUiScenario()) {
            String fileName = this.scenarioContext.captureScreenshot("scenario-RUNNUNG");
            this.scenarioContext.addParamValue(variableName, (Object)fileName);
        }
    }

    @Then(value="{string} will be {string}.")
    public void action_will_be_performed(String action, String performed) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
    }

    @When(value="wait for {int} seconds.")
    public void wait_for_seconds(int waitNumSeconds) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        this.scenarioContext.waitForSeconds(waitNumSeconds);
    }
}

