/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.ui;

import io.cucumber.datatable.DataTable;
import io.cucumber.docstring.DocString;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.api.core.reader.JsonDocumentReader;
import org.uitnet.testing.smartfwk.api.core.support.PageObjectInfo;
import org.uitnet.testing.smartfwk.common.MethodSignature;
import org.uitnet.testing.smartfwk.core.validator.ExpectedInfo;
import org.uitnet.testing.smartfwk.core.validator.InputValue;
import org.uitnet.testing.smartfwk.core.validator.ParamPath;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.AreaCoordinates;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.JsonYamlUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.PageObjectUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.WebElementUtil;
import org.uitnet.testing.smartfwk.validator.FieldValidator;
import org.uitnet.testing.smartfwk.validator.ParameterValidator;

public class SmartUiFormElementOperationsStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartUiFormElementOperationsStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @Then(value="verify the web page title is {string} with [TextMatchMechanism={string}, MaxTimeToWaitInSeconds={int}].")
    public void verify_the_web_page_title_is_with(String titleName, String textMatchMechanism, Integer maxTimeTowaitInSeconds) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String text = this.scenarioContext.getActiveAppDriver().getWebDriver().getTitle();
        TextMatchMechanism matchMechanism = TextMatchMechanism.valueOf2((String)textMatchMechanism);
        FieldValidator.validateFieldValueAsExpectedValue((String)"Web page title", (Object)text, (Object)titleName, (TextMatchMechanism)matchMechanism);
    }

    @Then(value="verify the web page current URL is {string} with [TextMatchMechanism={string}, MaxTimeToWaitInSeconds={int}].")
    public void verify_the_web_page_current_URL_is_with(String titleName, String textMatchMechanism, Integer maxTimeTowaitInSeconds) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String text = this.scenarioContext.getActiveAppDriver().getWebDriver().getCurrentUrl();
        TextMatchMechanism matchMechanism = TextMatchMechanism.valueOf2((String)textMatchMechanism);
        FieldValidator.validateFieldValueAsExpectedValue((String)"Web page current URL", (Object)text, (Object)titleName, (TextMatchMechanism)matchMechanism);
    }

    @Then(value="verify the focused element has the following information [ElementName={string}, AttributeName={string}, AttributeValue={string}] with [TextMatchMechanism={string}, MaxTimeToWaitInSeconds={int}].")
    public void verify_the_focused_element_has_the_following_information(String elementName, String attributeName, String attributeValue, String textMatchMechanism, int maxTimeToWaitInSeconds) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        int maxIterationsToLocateElements = maxTimeToWaitInSeconds <= 4 ? 2 : maxTimeToWaitInSeconds / 2;
        String actualElemName = "";
        String actualTextValue = "";
        try {
            SmartAppDriver appDriver = this.scenarioContext.getActiveAppDriver();
            for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
                block7: {
                    try {
                        WebElement elem = appDriver.getWebDriver().switchTo().activeElement();
                        if (elem == null) {
                            Assert.fail((String)"Focused/active element is not found.");
                        }
                        actualElemName = elem.getTagName();
                        FieldValidator.validateFieldValueAsExpectedValue((String)"Focused/active element name", (Object)actualElemName, (Object)elementName, (TextMatchMechanism)TextMatchMechanism.exactMatchWithExpectedValue);
                        actualTextValue = elem.getAttribute(attributeName);
                        TextMatchMechanism matchMechanism = TextMatchMechanism.valueOf2((String)textMatchMechanism);
                        FieldValidator.validateFieldValueAsExpectedValue((String)"Focused/active element attribute value", (Object)actualTextValue, (Object)attributeValue, (TextMatchMechanism)matchMechanism);
                    }
                    catch (Throwable th) {
                        if (i != maxIterationsToLocateElements) break block7;
                        throw th;
                    }
                }
                appDriver.waitForSeconds(2);
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to verify focused element (Name: " + actualElemName + ") attribute value[" + attributeName + "=" + attributeValue + "]. Actual value: " + actualTextValue + "."), (Throwable)th);
        }
    }

    @Then(value="verify the focused element has the following information [ElementName={string}, TextValue={string}] with [TextMatchMechanism={string}, MaxTimeToWaitInSeconds={int}].")
    public void verify_the_focused_element_has_the_following_information(String elementName, String textValue, String textMatchMechanism, int maxTimeToWaitInSeconds) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        int maxIterationsToLocateElements = maxTimeToWaitInSeconds <= 4 ? 2 : maxTimeToWaitInSeconds / 2;
        String actualElemName = "";
        String actualTextValue = "";
        try {
            SmartAppDriver appDriver = this.scenarioContext.getActiveAppDriver();
            for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
                block7: {
                    try {
                        WebElement elem = appDriver.getWebDriver().switchTo().activeElement();
                        if (elem == null) {
                            Assert.fail((String)"Focused/active element is not found.");
                        }
                        actualElemName = elem.getTagName();
                        FieldValidator.validateFieldValueAsExpectedValue((String)"Focused/active element name", (Object)actualElemName, (Object)elementName, (TextMatchMechanism)TextMatchMechanism.exactMatchWithExpectedValue);
                        actualTextValue = elem.getText();
                        TextMatchMechanism matchMechanism = TextMatchMechanism.valueOf2((String)textMatchMechanism);
                        FieldValidator.validateFieldValueAsExpectedValue((String)"Focused/active element text value", (Object)actualTextValue, (Object)textValue, (TextMatchMechanism)matchMechanism);
                    }
                    catch (Throwable th) {
                        if (i != maxIterationsToLocateElements) break block7;
                        throw th;
                    }
                }
                appDriver.waitForSeconds(2);
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to verify focused element (Name: " + actualElemName + ") text value=" + textValue + ". Actual value: " + actualTextValue + "."), (Throwable)th);
        }
    }

    @Then(value="verify that the following page elements are visible on {string}:")
    public void verify_that_the_following_page_elements_are_visible_1(String pageOrScreenName, DataTable dataTable) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        List rows = dataTable.asLists();
        List row = null;
        for (int i = 1; i < rows.size(); ++i) {
            row = (List)rows.get(i);
            String pe = (String)row.get(0);
            PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
            PageObjectUtil.invokeValidatorMethod((String)"validateVisible", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        }
    }

    @Then(value="verify {string} page element is visible on {string}.")
    public void verify_that_the_page_element_is_visible(String pe, String pageOrScreenName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        PageObjectUtil.invokeValidatorMethod((String)"validateVisible", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
    }

    @Then(value="verify that {string} page element is visible on {string}.")
    public void verify_that_the_page_element_is_visible_3(String pe, String pageOrScreenName) {
        this.verify_that_the_page_element_is_visible(pe, pageOrScreenName);
    }

    @Then(value="verify that the following page elements are hidden on {string}:")
    public void verify_that_the_following_page_elements_are_hidden(String pageOrScreenName, DataTable dataTable) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        List rows = dataTable.asLists();
        List row = null;
        for (int i = 1; i < rows.size(); ++i) {
            row = (List)rows.get(i);
            String pe = (String)row.get(0);
            PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
            PageObjectUtil.invokeValidatorMethod((String)"validateHidden", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        }
    }

    @Then(value="verify that the following page elements are not visible on {string}:")
    public void verify_that_the_following_page_elements_are_hidden_3(String pageOrScreenName, DataTable dataTable) {
        this.verify_that_the_following_page_elements_are_hidden(pageOrScreenName, dataTable);
    }

    @Then(value="get visibility of {string} page element and store into {string} variable.")
    public void get_visibility_of_page_element_and_store_into_variable(String pe, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        Boolean visible = false;
        try {
            visible = (Boolean)PageObjectUtil.invokeValidatorMethod((String)"isVisible", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        }
        catch (Throwable th) {
            this.scenarioContext.log("Visibility is 'no' because: " + th.getMessage());
        }
        this.scenarioContext.addParamValue(variableName, (Object)(visible != false ? "yes" : "no"));
    }

    @Then(value="get presence of {string} page element and store into {string} variable.")
    public void get_presence_of_page_element_and_store_into_variable(String pe, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        Boolean visible = false;
        try {
            visible = (Boolean)PageObjectUtil.invokeValidatorMethod((String)"isPresent", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        }
        catch (Throwable th) {
            this.scenarioContext.log("Presence is 'no' because: " + th.getMessage());
        }
        this.scenarioContext.addParamValue(variableName, (Object)(visible != false ? "yes" : "no"));
    }

    @Then(value="verify {string} page element is hidden on {string}.")
    public void verify_page_element_is_hidden(String pe, String pageOrScreenName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        PageObjectUtil.invokeValidatorMethod((String)"validateHidden", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
    }

    @Then(value="verify that {string} page element is hidden on {string}.")
    public void verify_that_the_page_element_is_hidden(String pe, String pageOrScreenName) {
        this.verify_page_element_is_hidden(pe, pageOrScreenName);
    }

    @Then(value="verify {string} page element is not visible on {string}.")
    public void verify_page_element_is_not_visible(String pe, String pageOrScreenName) {
        this.verify_page_element_is_hidden(pe, pageOrScreenName);
    }

    @Then(value="verify that {string} page element is not visible on {string}.")
    public void verify_that_the_page_element_is_not_visible(String pe, String pageOrScreenName) {
        this.verify_that_the_page_element_is_hidden(pe, pageOrScreenName);
    }

    @Then(value="verify that the following page elements are disabled on {string}:")
    public void verify_that_the_following_page_elements_are_disabled(String pageOrScreenName, DataTable dataTable) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        List rows = dataTable.asLists();
        List row = null;
        for (int i = 1; i < rows.size(); ++i) {
            row = (List)rows.get(i);
            String pe = (String)row.get(0);
            PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
            PageObjectUtil.invokeValidatorMethod((String)"validateDisabled", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        }
    }

    @Then(value="verify that {string} page element is disabled on {string}.")
    public void verify_that_the_page_element_is_disabled_1(String pe, String pageOrScreenName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        PageObjectUtil.invokeValidatorMethod((String)"validateDisabled", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
    }

    @Then(value="verify that the following page elements are enabled on {string}:")
    public void verify_that_the_following_page_elements_are_enabled_1(String pageOrScreenName, DataTable dataTable) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        List rows = dataTable.asLists();
        List row = null;
        for (int i = 1; i < rows.size(); ++i) {
            row = (List)rows.get(i);
            String pe = (String)row.get(0);
            PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
            PageObjectUtil.invokeValidatorMethod((String)"validateEnabled", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        }
    }

    @Then(value="verify that {string} page element is enabled on {string}.")
    public void verify_that_the_page_element_is_enabled(String pe, String pageOrScreenName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        PageObjectUtil.invokeValidatorMethod((String)"validateEnabled", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
    }

    @When(value="type {string} text in {string} page element at {string} location.")
    public void type_text_in_page_element(String inputValue, String pe, String location) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        inputValue = this.scenarioContext.applyParamsValueOnText(inputValue);
        InputValue inputValueObj = JsonYamlUtil.parseInputValue((String)inputValue);
        PageObjectUtil.invokeValidatorMethod((String)"typeText", (String[])new String[]{String.class.getTypeName(), NewTextLocation.class.getTypeName(), Integer.TYPE.getTypeName(), Boolean.TYPE.getTypeName(), Integer.TYPE.getTypeName()}, (Object[])new Object[]{inputValueObj.getValue(), NewTextLocation.valueOf2((String)location), inputValueObj.getTypeSpeedMspc(), inputValueObj.getTypeAfterClick(), peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
    }

    @When(value="type {string} text in {string} page element.")
    public void type_text_in_page_element_1(String inputValue, String pe) {
        this.type_text_in_page_element(inputValue, pe, "replace");
    }

    @When(value="type the following text in {string} page element:")
    public void type_the_following_text_in_page_element_1(String pe, DocString textToType) {
        this.type_text_in_page_element_1(textToType.getContent(), pe);
    }

    @Then(value="verify that the text part of {string} page element matches {string} text where TextMatchMechanism={string}.")
    public void verify_that_the_text_part_of_page_element_matches_text_where_textmatchmechanism_1(String pe, String expectedText, String textMatchMechanism) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        expectedText = this.scenarioContext.applyParamsValueOnText(expectedText);
        for (int i = 0; i <= peInfo.getMaxIterationsToLocateElements(); ++i) {
            try {
                WebElement elements = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{0}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
                FieldValidator.validateFieldValueAsExpectedValue((String)(peInfo.getPageObject().getName() + "->text"), (Object)elements.getText(), (Object)expectedText, (TextMatchMechanism)TextMatchMechanism.valueOf2((String)textMatchMechanism));
                break;
            }
            catch (Throwable th) {
                if (i == peInfo.getMaxIterationsToLocateElements()) {
                    throw th;
                }
                this.scenarioContext.waitForSeconds(2);
                continue;
            }
        }
    }

    @Then(value="verify that {string} attribute value of {string} page element matches {string} text where TextMatchMechanism={string}.")
    public void verify_that_attribute_value_of_page_element_matches_text_where_textmatchmechanism(String attributeName, String pe, String expectedText, String textMatchMechanism) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        expectedText = this.scenarioContext.applyParamsValueOnText(expectedText);
        for (int i = 0; i <= peInfo.getMaxIterationsToLocateElements(); ++i) {
            try {
                WebElement elements = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{0}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
                FieldValidator.validateFieldValueAsExpectedValue((String)(peInfo.getPageObject().getName() + "->" + attributeName), (Object)elements.getAttribute(attributeName), (Object)expectedText, (TextMatchMechanism)TextMatchMechanism.valueOf2((String)textMatchMechanism));
                break;
            }
            catch (Throwable th) {
                if (i == peInfo.getMaxIterationsToLocateElements()) {
                    throw th;
                }
                this.scenarioContext.waitForSeconds(2);
                continue;
            }
        }
    }

    @Then(value="verify that the value of {string} page element matches {string} text where TextMatchMechanism={string}.")
    public void verify_value_of_page_element_matches_text_where_textmatchmechanism(String pe, String expectedText, String textMatchMechanism) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        expectedText = this.scenarioContext.applyParamsValueOnText(expectedText);
        PageObjectUtil.invokeValidatorMethod((String)"validateValue", (String[])new String[]{String.class.getTypeName(), TextMatchMechanism.class.getTypeName(), Integer.TYPE.getTypeName()}, (Object[])new Object[]{expectedText, textMatchMechanism, 1}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
    }

    @Then(value="get input text value of {string} page element and store into {string} variable.")
    public void get_input_text_value_of_page_element_and_store_into_variable(String pe, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        WebElement element = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        String textValue = WebElementUtil.getInputTextValue((SmartAppDriver)this.scenarioContext.getActiveAppDriver(), (WebElement)element);
        this.scenarioContext.addParamValue(variableName, (Object)textValue);
    }

    @Then(value="get input text value of each element of {string} page element and store into {string} variable.")
    public void get_input_text_value_of_each_element_of_page_element_and_store_into_variable(String pe, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i <= peInfo.getMaxIterationsToLocateElements(); ++i) {
            block6: {
                try {
                    List elements = (List)PageObjectUtil.invokeValidatorMethod((String)"findElements", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{0}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
                    list.clear();
                    if (elements != null) {
                        for (WebElement elem : elements) {
                            String textValue = WebElementUtil.getInputTextValue((SmartAppDriver)this.scenarioContext.getActiveAppDriver(), (WebElement)elem);
                            list.add(textValue);
                        }
                        break;
                    }
                }
                catch (Throwable th) {
                    if (i != peInfo.getMaxIterationsToLocateElements()) break block6;
                    throw th;
                }
            }
            this.scenarioContext.waitForSeconds(2);
        }
        this.scenarioContext.addParamValue(variableName, list);
    }

    @Then(value="get text part of each element of {string} page element and store into {string} variable.")
    public void verify_text_part_of_each_element_of_page_element_and_store_into_variable(String pe, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i <= peInfo.getMaxIterationsToLocateElements(); ++i) {
            try {
                List elements = (List)PageObjectUtil.invokeValidatorMethod((String)"findElements", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{0}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
                list.clear();
                if (elements != null) {
                    for (WebElement elem : elements) {
                        String textValue = elem.getText();
                        list.add(textValue);
                    }
                    break;
                }
            }
            catch (Throwable th) {
                if (i == peInfo.getMaxIterationsToLocateElements()) break;
            }
            this.scenarioContext.waitForSeconds(2);
        }
        this.scenarioContext.addParamValue(variableName, list);
    }

    @Then(value="get text part of {string} page element and store into {string} variable.")
    public void verify_text_part_of_page_element_and_store_into_variable(String pe, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        String textValue = "";
        for (int i = 0; i <= peInfo.getMaxIterationsToLocateElements(); ++i) {
            block5: {
                try {
                    WebElement element = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{0}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
                    if (element != null) {
                        textValue = element.getText();
                        break;
                    }
                }
                catch (Throwable th) {
                    if (i != peInfo.getMaxIterationsToLocateElements()) break block5;
                    throw th;
                }
            }
            this.scenarioContext.waitForSeconds(2);
        }
        this.scenarioContext.addParamValue(variableName, (Object)textValue);
    }

    @Then(value="get {string} attribute value of each element of {string} page element and store into {string} variable.")
    public void get_attribute_value_of_each_element_of_page_element_and_store_into_variable(String attributeName, String pe, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i <= peInfo.getMaxIterationsToLocateElements(); ++i) {
            block6: {
                try {
                    List elements = (List)PageObjectUtil.invokeValidatorMethod((String)"findElements", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{0}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
                    list.clear();
                    if (elements != null) {
                        for (WebElement elem : elements) {
                            String textValue = elem.getAttribute(attributeName);
                            list.add(textValue);
                        }
                        break;
                    }
                }
                catch (Throwable th) {
                    if (i != peInfo.getMaxIterationsToLocateElements()) break block6;
                    throw th;
                }
            }
            this.scenarioContext.waitForSeconds(2);
        }
        this.scenarioContext.addParamValue(variableName, list);
    }

    @Then(value="get {string} attribute value of {string} page element and store into {string} variable.")
    public void get_attribute_value_of_page_element_and_store_into_variable(String attributeName, String pe, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        String textValue = "";
        for (int i = 0; i <= peInfo.getMaxIterationsToLocateElements(); ++i) {
            block5: {
                try {
                    WebElement element = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{0}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
                    if (element != null) {
                        textValue = element.getAttribute(attributeName);
                        break;
                    }
                }
                catch (Throwable th) {
                    if (i != peInfo.getMaxIterationsToLocateElements()) break block5;
                    throw th;
                }
            }
            this.scenarioContext.waitForSeconds(2);
        }
        this.scenarioContext.addParamValue(variableName, (Object)textValue);
    }

    @Then(value="verify text part of each element of {string} page element matches {string} text where TextMatchMechanism={string}.")
    public void verify_text_part_of_each_element_of_page_element_matches_text_where_textmatchmechanism(String pe, String expectedText, String textMatchMechanism) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        expectedText = this.scenarioContext.applyParamsValueOnText(expectedText);
        for (int i = 0; i <= peInfo.getMaxIterationsToLocateElements(); ++i) {
            block6: {
                try {
                    List elements = (List)PageObjectUtil.invokeValidatorMethod((String)"findElements", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{0}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
                    if (elements != null) {
                        for (WebElement elem : elements) {
                            String textValue = elem.getText();
                            FieldValidator.validateFieldValueAsExpectedValue((String)(peInfo.getPageObject().getName() + "->Text"), (Object)textValue, (Object)expectedText, (TextMatchMechanism)TextMatchMechanism.valueOf2((String)textMatchMechanism));
                        }
                        break;
                    }
                }
                catch (Throwable th) {
                    if (i != peInfo.getMaxIterationsToLocateElements()) break block6;
                    throw th;
                }
            }
            this.scenarioContext.waitForSeconds(2);
        }
    }

    @Then(value="verify text part of {string} page element matches {string} text where TextMatchMechanism={string}.")
    public void verify_text_part_of_page_element_matches_text_where_textmatchmechanism(String pe, String expectedText, String textMatchMechanism) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        expectedText = this.scenarioContext.applyParamsValueOnText(expectedText);
        for (int i = 0; i <= peInfo.getMaxIterationsToLocateElements(); ++i) {
            block5: {
                try {
                    WebElement element = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{0}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
                    if (element != null) {
                        String textValue = element.getText();
                        FieldValidator.validateFieldValueAsExpectedValue((String)(peInfo.getPageObject().getName() + "->Text"), (Object)textValue, (Object)expectedText, (TextMatchMechanism)TextMatchMechanism.valueOf2((String)textMatchMechanism));
                        break;
                    }
                }
                catch (Throwable th) {
                    if (i != peInfo.getMaxIterationsToLocateElements()) break block5;
                    throw th;
                }
            }
            this.scenarioContext.waitForSeconds(2);
        }
    }

    @Then(value="verify text part of {string} page element {string} {string}.")
    public void verify_text_part_of_page_element(String pe, String operator, String expectedInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        for (int i = 0; i <= peInfo.getMaxIterationsToLocateElements(); ++i) {
            try {
                WebElement element = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{0}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
                if (element == null) continue;
                String textValue = element.getText();
                ExpectedInfo eInfo = JsonYamlUtil.parseExpectedInfo((String)expectedInfo);
                ParamPath pPath = new ParamPath(peInfo.getPageObject().getName() + "-Text", "string");
                ParameterValidator.validateParamValueAsExpectedInfo((boolean)true, (ParamPath)pPath, (Object)textValue, (String)operator, (ExpectedInfo)eInfo);
                break;
            }
            catch (Throwable th) {
                if (i == peInfo.getMaxIterationsToLocateElements()) {
                    throw th;
                }
                this.scenarioContext.waitForSeconds(2);
            }
        }
    }

    @Then(value="verify text part of each element of {string} page element {string} {string}.")
    public void verify_text_part_of_each_element_of_page_element(String pe, String operator, String expectedInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        for (int i = 0; i <= peInfo.getMaxIterationsToLocateElements(); ++i) {
            try {
                List elements = (List)PageObjectUtil.invokeValidatorMethod((String)"findElements", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{0}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
                if (elements == null) continue;
                LinkedList<String> elems = new LinkedList<String>();
                for (WebElement elem : elements) {
                    String textValue = elem.getText();
                    elems.add(textValue);
                }
                ExpectedInfo eInfo = JsonYamlUtil.parseExpectedInfo((String)expectedInfo);
                ParamPath pPath = new ParamPath(peInfo.getPageObject().getName() + "-Text", "string-list");
                ParameterValidator.validateParamValueAsExpectedInfo((boolean)true, (ParamPath)pPath, elems, (String)operator, (ExpectedInfo)eInfo);
                break;
            }
            catch (Throwable th) {
                if (i == peInfo.getMaxIterationsToLocateElements()) {
                    throw th;
                }
                this.scenarioContext.waitForSeconds(2);
            }
        }
    }

    @Then(value="verify {string} attribute value of each element of {string} page element matches {string} text where TextMatchMechanism={string}.")
    public void verify_attribute_value_of_each_element_of_page_element_matches_text_where_textmatchmechanism(String attributeName, String pe, String expectedText, String textMatchMechanism) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        expectedText = this.scenarioContext.applyParamsValueOnText(expectedText);
        for (int i = 0; i <= peInfo.getMaxIterationsToLocateElements(); ++i) {
            block6: {
                try {
                    List elements = (List)PageObjectUtil.invokeValidatorMethod((String)"findElements", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{0}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
                    if (elements != null) {
                        for (WebElement elem : elements) {
                            String textValue = elem.getAttribute(attributeName);
                            FieldValidator.validateFieldValueAsExpectedValue((String)(peInfo.getPageObject().getName() + "->" + attributeName), (Object)textValue, (Object)expectedText, (TextMatchMechanism)TextMatchMechanism.valueOf2((String)textMatchMechanism));
                        }
                        break;
                    }
                }
                catch (Throwable th) {
                    if (i != peInfo.getMaxIterationsToLocateElements()) break block6;
                    throw th;
                }
            }
            this.scenarioContext.waitForSeconds(2);
        }
    }

    @Then(value="verify {string} attribute value of {string} page element matches {string} text where TextMatchMechanism={string}.")
    public void verify_attribute_value_of_page_element_matches_text_where_textmatchmechanism(String attributeName, String pe, String expectedText, String textMatchMechanism) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        expectedText = this.scenarioContext.applyParamsValueOnText(expectedText);
        for (int i = 0; i <= peInfo.getMaxIterationsToLocateElements(); ++i) {
            block5: {
                try {
                    WebElement element = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{0}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
                    if (element != null) {
                        String textValue = element.getAttribute(attributeName);
                        FieldValidator.validateFieldValueAsExpectedValue((String)(peInfo.getPageObject().getName() + "->" + attributeName), (Object)textValue, (Object)expectedText, (TextMatchMechanism)TextMatchMechanism.valueOf2((String)textMatchMechanism));
                        break;
                    }
                }
                catch (Throwable th) {
                    if (i != peInfo.getMaxIterationsToLocateElements()) break block5;
                    throw th;
                }
            }
            this.scenarioContext.waitForSeconds(2);
        }
    }

    @When(value="call {string} validator method of {string} page element to {string}.")
    public void call_validator_method_of_page_object_to_1(String methodAsJson, String pe, String operation) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        JsonDocumentReader jsonReader = new JsonDocumentReader(methodAsJson, false);
        MethodSignature method = (MethodSignature)jsonReader.readValueAsObject("$", MethodSignature.class);
        PageObjectUtil.invokeValidatorMethod((String)method.getName(), (String[])method.getArgsType(), (Object[])method.getArgsValue(), (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
    }

    @When(value="call {string} validator method of {string} page element to {string} and store output to {string} variable.")
    public void call_validator_method_of_page_element_to_and_store_output_to_variable(String methodAsJson, String pe, String operation, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        JsonDocumentReader jsonReader = new JsonDocumentReader(methodAsJson, false);
        MethodSignature method = (MethodSignature)jsonReader.readValueAsObject("$", MethodSignature.class);
        Object output = PageObjectUtil.invokeValidatorMethod((String)method.getName(), (String[])method.getArgsType(), (Object[])method.getArgsValue(), (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        this.scenarioContext.addParamValue(variableName, output);
    }

    @Then(value="verify the selected values of the following page elements on {string}:")
    public void validate_the_selected_values_of_the_following_page_elements(String pageOrScreenName, DataTable dataTable) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        List rows = dataTable.asLists();
        for (int i = 1; i < rows.size(); ++i) {
            List row = (List)rows.get(i);
            String pe = (String)row.get(0);
            String operator = (String)row.get(1);
            String expectedInfo = (String)row.get(2);
            expectedInfo = this.scenarioContext.applyParamsValueOnText(expectedInfo);
            PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
            ExpectedInfo eInfo = JsonYamlUtil.parseExpectedInfo((String)expectedInfo);
            PageObjectUtil.validateFormFieldData((PageObjectInfo)peInfo, (String)operator, (ExpectedInfo)eInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        }
    }

    @When(value="fill the following form fields values present on {string}:")
    public void fill_the_following_form_fields_value_present_on_page(String pageOrScreenName, DataTable dataTable) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        List rows = dataTable.asLists();
        for (int i = 1; i < rows.size(); ++i) {
            List row = (List)rows.get(i);
            String pe = (String)row.get(0);
            String inputValueStr = (String)row.get(1);
            inputValueStr = this.scenarioContext.applyParamsValueOnText(inputValueStr);
            PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
            InputValue inputValue = JsonYamlUtil.parseInputValue((String)inputValueStr);
            PageObjectUtil.fillUiInputFieldInfo((PageObjectInfo)peInfo, (InputValue)inputValue, (SmartCucumberScenarioContext)this.scenarioContext);
        }
    }

    @When(value="enter the following form fields information present on {string}:")
    public void fill_the_following_form_fields_value_present_on_page_1(String pageOrScreenName, DataTable dataTable) {
        this.fill_the_following_form_fields_value_present_on_page(pageOrScreenName, dataTable);
    }

    @Then(value="get dropdown options of {string} page element and store into {string} variable.")
    public void get_dropdown_options_of_page_element_and_store_into_variable(String pe, String variableName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        List list = new LinkedList();
        for (int i = 0; i <= peInfo.getMaxIterationsToLocateElements(); ++i) {
            try {
                list = (List)PageObjectUtil.invokeValidatorMethod((String)"getAvailableItems", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{0}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
                break;
            }
            catch (Throwable th) {
                if (i == peInfo.getMaxIterationsToLocateElements()) {
                    throw th;
                }
                this.scenarioContext.waitForSeconds(2);
                continue;
            }
        }
        this.scenarioContext.addParamValue(variableName, list);
    }

    @Then(value="verify dropdown options of {string} page element {string} {string}.")
    public void verify_dropdown_options_of_page_element(String pe, String operator, String expectedInfo) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        List list = new LinkedList();
        for (int i = 0; i <= peInfo.getMaxIterationsToLocateElements(); ++i) {
            try {
                list = (List)PageObjectUtil.invokeValidatorMethod((String)"getAvailableItems", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{0}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
                break;
            }
            catch (Throwable th) {
                if (i == peInfo.getMaxIterationsToLocateElements()) {
                    throw th;
                }
                this.scenarioContext.waitForSeconds(2);
                continue;
            }
        }
        expectedInfo = this.scenarioContext.applyParamsValueOnText(expectedInfo);
        ExpectedInfo eInfo = JsonYamlUtil.parseExpectedInfo((String)expectedInfo);
        ParamPath pPath = new ParamPath(peInfo.getPageObject().getName() + "-options", "string-list");
        ParameterValidator.validateParamValueAsExpectedInfo((boolean)true, (ParamPath)pPath, list, (String)operator, (ExpectedInfo)eInfo);
    }

    @Then(value="verify the location of {string} page element is within [x1={int}, y1={int}, x2={int}, y2={int}] rectangular area.")
    public void verify_page_element_is_within_rectangular_area(String pe, int x1, int y1, int x2, int y2) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
        Dimension origWindowSize = this.scenarioContext.getActiveAppDriver().getWebDriver().manage().window().getSize();
        String screenSize = origWindowSize.getWidth() + " x " + origWindowSize.getHeight();
        for (int i = 0; i <= peInfo.getMaxIterationsToLocateElements(); ++i) {
            try {
                WebElement element = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{0}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
                Rectangle rect = element.getRect();
                if (rect.x >= x1 && rect.y >= y1 && rect.x + rect.getWidth() <= x2 && rect.y + rect.getHeight() <= y2) break;
                Assert.fail((String)("Screen Size [" + screenSize + "'] :> Element is not within the specified coordinates {x1: " + x1 + ", y1: " + y1 + ", x2: " + x2 + ", y2: " + y2 + "}. Actual Coordinates: {x1: " + rect.x + ", y1:" + rect.y + ", x2:" + (rect.x + rect.width) + ", y2:" + (rect.y + rect.height) + "}."));
                break;
            }
            catch (Throwable th) {
                if (i == peInfo.getMaxIterationsToLocateElements()) {
                    throw th;
                }
                this.scenarioContext.waitForSeconds(2);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Then(value="verify the location of the following page elements on the screen:")
    public void verify_the_location_of_the_page_elements_on_the_screen(DataTable dataTable) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        List rows = dataTable.asLists();
        Dimension origWindowSize = this.scenarioContext.getActiveAppDriver().getWebDriver().manage().window().getSize();
        try {
            String lastScreenSize = "";
            LinkedHashMap<String, CallSite> peErrorMap = new LinkedHashMap<String, CallSite>();
            for (int i = 1; i < rows.size(); ++i) {
                List row = (List)rows.get(i);
                String screenSize = (String)row.get(0);
                String pe = (String)row.get(1);
                String coordinatesAsStr = (String)row.get(2);
                if (!lastScreenSize.equals(screenSize)) {
                    lastScreenSize = screenSize.toLowerCase();
                    String[] ssWH = screenSize.split("x");
                    this.scenarioContext.getActiveAppDriver().getWebDriver().manage().window().setSize(new Dimension(Integer.valueOf(ssWH[0].trim()).intValue(), Integer.valueOf(ssWH[1].trim()).intValue()));
                }
                try {
                    PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pe, (SmartCucumberScenarioContext)this.scenarioContext);
                    JsonDocumentReader r = new JsonDocumentReader(coordinatesAsStr, false);
                    AreaCoordinates coordinates = (AreaCoordinates)r.readValueAsObject("$", AreaCoordinates.class);
                    PageObjectUtil.invokeValidatorMethod((String)"validateElementPresentWithinArea", (String[])new String[]{AreaCoordinates.class.getTypeName(), Integer.TYPE.getTypeName()}, (Object[])new Object[]{coordinates, peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
                    continue;
                }
                catch (Throwable th) {
                    peErrorMap.put(pe, (CallSite)((Object)("Screen Size [" + screenSize + "'] :> " + th.getMessage())));
                }
            }
            if (peErrorMap.size() > 0) {
                Object failedMessage = "ERRORS: \n  ";
                for (Map.Entry entry : peErrorMap.entrySet()) {
                    failedMessage = (String)failedMessage + (String)entry.getKey() + " :> " + (String)entry.getValue() + "\n\n  ";
                }
                Assert.fail((String)failedMessage);
            }
        }
        finally {
            this.scenarioContext.getActiveAppDriver().getWebDriver().manage().window().setSize(new Dimension(origWindowSize.width, origWindowSize.height));
        }
    }
}

