/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.ui;

import io.cucumber.docstring.DocString;
import io.cucumber.java.en.When;
import java.util.List;
import org.openqa.selenium.WebElement;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.api.core.reader.JsonDocumentReader;
import org.uitnet.testing.smartfwk.api.core.support.PageObjectInfo;
import org.uitnet.testing.smartfwk.api.core.support.ScrollbarType;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.utils.PageObjectUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.PageScrollUtil;

public class SmartUiMouseOperationsStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartUiMouseOperationsStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @When(value="click on {string} page element to {string}.")
    public void click_on_page_element(String pageElement, String actionName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pageElement);
        PageObjectUtil.invokeValidatorMethod((String)"click", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
    }

    @When(value="click {string} page element to {string}.")
    public void click_on_page_element_2(String pageElement, String actionName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        this.click_on_page_element(pageElement, actionName);
    }

    @When(value="force click on {string} page element to {string}.")
    public void force_click_on_page_element(String pageElement, String actionName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pageElement);
        PageObjectUtil.invokeValidatorMethod((String)"forceClick", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
    }

    @When(value="force click {string} page element to {string}.")
    public void force_click_on_page_element_2(String pageElement, String actionName) {
        this.force_click_on_page_element(pageElement, actionName);
    }

    @When(value="click on the following page elements to {string}:")
    public void click_on_the_following_page_elements(String actionName, DocString pageElements) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        String pageElementsAsStr = pageElements.getContent();
        JsonDocumentReader jsonReader = new JsonDocumentReader(pageElementsAsStr, true);
        List peList = jsonReader.readValuesAsList("$");
        for (String pe : peList) {
            this.click_on_page_element(pe, actionName);
        }
    }

    @When(value="double click on {string} page element to {string}.")
    public void double_click_on_page_element(String pageElement, String actionName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pageElement);
        PageObjectUtil.invokeValidatorMethod((String)"doubleClick", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
    }

    @When(value="double click {string} page element to {string}.")
    public void double_click_on_page_element_2(String pageElement, String actionName) {
        this.double_click_on_page_element(pageElement, actionName);
    }

    @When(value="right click on {string} page element to {string}.")
    public void right_click_on_page_element(String pageElement, String actionName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pageElement);
        PageObjectUtil.invokeValidatorMethod((String)"rightClick", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
    }

    @When(value="right click {string} page element to {string}.")
    public void right_click_on_page_element_2(String pageElement, String actionName) {
        this.right_click_on_page_element(pageElement, actionName);
    }

    @When(value="click and hold on {string} page element to {string}.")
    public void click_and_hold_on_page_element(String pageElement, String actionName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pageElement);
        PageObjectUtil.invokeValidatorMethod((String)"clickAndHold", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
    }

    @When(value="click and hold {string} page element to {string}.")
    public void click_and_hold_on_page_element_2(String pageElement, String actionName) {
        this.click_and_hold_on_page_element(pageElement, actionName);
    }

    @When(value="release hold click from {string} page element to {string}.")
    public void release_hold_click_from_page_element(String pageElement, String actionName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pageElement);
        PageObjectUtil.invokeValidatorMethod((String)"release", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
    }

    @When(value="drag {string} page element and drop on {string} page element.")
    public void drag_and_drop_page_element(String dragElemPageObject, String dropElemPageObject) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        this.click_and_hold_on_page_element(dragElemPageObject, "");
        PageObjectInfo sourcePoInfo = PageObjectUtil.getPageObjectInfo((String)dragElemPageObject);
        PageObjectInfo targetPoInfo = PageObjectUtil.getPageObjectInfo((String)dropElemPageObject);
        WebElement sourceElem = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{sourcePoInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)sourcePoInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        WebElement targetElem = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{targetPoInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)targetPoInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        PageScrollUtil.mouseDragAndDrop((SmartAppDriver)this.scenarioContext.getActiveAppDriver(), (WebElement)sourceElem, (WebElement)targetElem);
    }

    @When(value="mouse hoverover on {string} page element to {string}.")
    public void mouse_hoverover_on_page_element(String pageElement, String actionName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pageElement);
        PageObjectUtil.invokeValidatorMethod((String)"mouseHoverOver", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        this.scenarioContext.waitForSeconds(1);
    }

    @When(value="mouse hoverover {string} page element to {string}.")
    public void mouse_hoverover_on_page_element_2(String pageElement, String actionName) {
        this.mouse_hoverover_on_page_element(pageElement, actionName);
    }

    @When(value="set horizontal scrollbar thumb pesition {int} pixels away from left [ScrollbarPageElement={string}].")
    public void set_horizontal_scrollbar_thumb_position_pixel_away_from_left(int distanceInPixels, String scrollbarPageObject) {
        PageObjectInfo sourcePoInfo = PageObjectUtil.getPageObjectInfo((String)scrollbarPageObject);
        WebElement elem = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{sourcePoInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)sourcePoInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        PageScrollUtil.setScrollbarThumbgripLocation((SmartAppDriver)this.scenarioContext.getActiveAppDriver(), (WebElement)elem, (ScrollbarType)ScrollbarType.HORIZONTAL, (int)distanceInPixels);
    }

    @When(value="set horizontal scrollbar thumb position {double} percent away from left [ScrollbarPageElement={string}].")
    public void set_horizontal_scrollbar_thumb_position_percent_away_from_left(double distanceInPercentage, String scrollbarPageObject) {
        PageObjectInfo sourcePoInfo = PageObjectUtil.getPageObjectInfo((String)scrollbarPageObject);
        WebElement elem = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{sourcePoInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)sourcePoInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        PageScrollUtil.setScrollbarThumbgripLocation((SmartAppDriver)this.scenarioContext.getActiveAppDriver(), (WebElement)elem, (ScrollbarType)ScrollbarType.HORIZONTAL, (double)distanceInPercentage);
    }

    @When(value="set vertical scrollbar thumb position {int} pixels away from top [ScrollbarPageElement={string}].")
    public void set_vertical_scrollbar_thumb_position_pixel_away_from_top(int distanceInPixels, String scrollbarPageObject) {
        PageObjectInfo sourcePoInfo = PageObjectUtil.getPageObjectInfo((String)scrollbarPageObject);
        WebElement elem = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{sourcePoInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)sourcePoInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        PageScrollUtil.setScrollbarThumbgripLocation((SmartAppDriver)this.scenarioContext.getActiveAppDriver(), (WebElement)elem, (ScrollbarType)ScrollbarType.VERTICAL, (int)distanceInPixels);
    }

    @When(value="set vertical scrollbar thumb position {double} percent away from top [ScrollbarPageElement={string}].")
    public void set_vertical_scrollbar_thumb_position_percent_away_from_top(double distanceInPercentage, String scrollbarPageObject) {
        PageObjectInfo sourcePoInfo = PageObjectUtil.getPageObjectInfo((String)scrollbarPageObject);
        WebElement elem = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{sourcePoInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)sourcePoInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        PageScrollUtil.setScrollbarThumbgripLocation((SmartAppDriver)this.scenarioContext.getActiveAppDriver(), (WebElement)elem, (ScrollbarType)ScrollbarType.VERTICAL, (double)distanceInPercentage);
    }
}

