/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.ui;

import io.cucumber.java.en.When;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.api.core.support.PageObjectInfo;
import org.uitnet.testing.smartfwk.ui.core.utils.PageObjectUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.TouchActionsUtil;

public class SmartUiTouchScreenOperationsStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartUiTouchScreenOperationsStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @When(value="tap on {string} page element for {int} milliseconds to {string}.")
    public void tap_on_page_element_for_milliseconds_to(String pageElement, int holdDurationInMs, String actionName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pageElement);
        WebElement webElem = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        this.scenarioContext.waitForSeconds(1);
        TouchActionsUtil.tapOnElement((WebDriver)this.scenarioContext.getActiveAppDriver().getWebDriver(), (WebElement)webElem, (int)holdDurationInMs);
    }

    @When(value="double tap on {string} page element using {int} milliseconds as pause duration to {string}.")
    public void double_tap_on_page_element_using_milliseconds_as_pause_duration_to(String pageElement, int pauseDurationInMs, String actionName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pageElement);
        WebElement webElem = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        this.scenarioContext.waitForSeconds(1);
        TouchActionsUtil.doubleTapOnElement((WebDriver)this.scenarioContext.getActiveAppDriver().getWebDriver(), (WebElement)webElem, (int)pauseDurationInMs);
    }

    @When(value="tap {int} times on {string} page element using {int} milliseconds as pause duration to {string}.")
    public void tap_n_times_on_page_element_using_milliseconds_as_pause_duration_to(int nTimes, String pageElement, int pauseDurationInMs, String actionName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pageElement);
        WebElement webElem = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        this.scenarioContext.waitForSeconds(1);
        TouchActionsUtil.nTapsOnElement((WebDriver)this.scenarioContext.getActiveAppDriver().getWebDriver(), (WebElement)webElem, (int)nTimes, (int)pauseDurationInMs);
    }

    @When(value="swipe up {int} pixels in {int} milliseconds from {string} page element location.")
    public void swipe_up_pixels_in_milliseconds_from_page_object_location(int pixels, int durationInMs, String pageElement) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pageElement);
        WebElement webElem = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        this.scenarioContext.waitForSeconds(1);
        TouchActionsUtil.swipeUpFromElement((WebDriver)this.scenarioContext.getActiveAppDriver().getWebDriver(), (WebElement)webElem, (int)pixels, (int)durationInMs);
    }

    @When(value="swipe down {int} pixels in {int} milliseconds from {string} page element location.")
    public void swipe_down_pixels_in_milliseconds_from_page_object_location(int pixels, int durationInMs, String pageElement) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pageElement);
        WebElement webElem = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        this.scenarioContext.waitForSeconds(1);
        TouchActionsUtil.swipeDownFromElement((WebDriver)this.scenarioContext.getActiveAppDriver().getWebDriver(), (WebElement)webElem, (int)pixels, (int)durationInMs);
    }

    @When(value="swipe left {int} pixels in {int} milliseconds from {string} page element location.")
    public void swipe_left_pixels_in_milliseconds_from_page_object_location(int pixels, int durationInMs, String pageElement) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pageElement);
        WebElement webElem = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        this.scenarioContext.waitForSeconds(1);
        TouchActionsUtil.swipeLeftFromElement((WebDriver)this.scenarioContext.getActiveAppDriver().getWebDriver(), (WebElement)webElem, (int)pixels, (int)durationInMs);
    }

    @When(value="swipe right {int} pixels in {int} milliseconds from {string} page element location.")
    public void swipe_right_pixels_in_milliseconds_from_page_object_location(int pixels, int durationInMs, String pageElement) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        PageObjectInfo peInfo = PageObjectUtil.getPageObjectInfo((String)pageElement);
        WebElement webElem = (WebElement)PageObjectUtil.invokeValidatorMethod((String)"findElement", (String[])new String[]{Integer.TYPE.getTypeName()}, (Object[])new Object[]{peInfo.getMaxIterationsToLocateElements()}, (PageObjectInfo)peInfo, (SmartCucumberScenarioContext)this.scenarioContext);
        this.scenarioContext.waitForSeconds(1);
        TouchActionsUtil.swipeRightFromElement((WebDriver)this.scenarioContext.getActiveAppDriver().getWebDriver(), (WebElement)webElem, (int)pixels, (int)durationInMs);
    }
}

