/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.core.stepdefs.en.ui;

import io.cucumber.docstring.DocString;
import io.cucumber.java.en.When;
import java.util.Set;
import org.openqa.selenium.WebDriver;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.core.validator.ExpectedInfo;
import org.uitnet.testing.smartfwk.core.validator.ParamPath;
import org.uitnet.testing.smartfwk.ui.core.utils.JsonYamlUtil;
import org.uitnet.testing.smartfwk.validator.ParameterValidator;

public class SmartUiWindowAndFrameOperationsStepDefs {
    private SmartCucumberScenarioContext scenarioContext;

    public SmartUiWindowAndFrameOperationsStepDefs(SmartCucumberScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    @When(value="switch to {string} window.")
    public void switch_to_window(String windowHandleName) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        Set windowHandles = this.scenarioContext.getActiveAppDriver().getWebDriver().getWindowHandles();
        this.scenarioContext.log("AVAILABLE WINDOW HANDLE NAMES: " + windowHandles);
        this.scenarioContext.getActiveAppDriver().getWebDriver().switchTo().window(windowHandleName);
    }

    @When(value="focus {string} window.")
    public void switch_to_window_1(String windowHandleName) {
        this.switch_to_window(windowHandleName);
    }

    @When(value="switch to default content.")
    public void switch_to_default_content() {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        this.scenarioContext.getActiveAppDriver().getWebDriver().switchTo().defaultContent();
    }

    @When(value="switch to {string} frame.")
    public void switch_to_frame(String frameNameOrId) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        if ("parent".equals(frameNameOrId)) {
            this.scenarioContext.getActiveAppDriver().getWebDriver().switchTo().parentFrame();
        } else if (frameNameOrId.startsWith("INDEX:")) {
            this.scenarioContext.getActiveAppDriver().getWebDriver().switchTo().frame(Integer.valueOf(frameNameOrId.substring("INDEX:".length(), frameNameOrId.length()).trim()).intValue());
        } else {
            this.scenarioContext.getActiveAppDriver().getWebDriver().switchTo().frame(frameNameOrId);
        }
    }

    @When(value="switch to frame number {int}.")
    public void switch_to_frame_number(Integer frameNumber) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        this.scenarioContext.getActiveAppDriver().getWebDriver().switchTo().frame(frameNumber.intValue());
    }

    @When(value="click on {string} button to close the alert dialog [MaxTimeToWaitInSeconds={int}].")
    public void click_on_cancel_button_to_close_the_alert(String buttonName, int maxTimeToWaitInSeconds) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        WebDriver webDriver = this.scenarioContext.getActiveAppDriver().getWebDriver();
        int maxIters = maxTimeToWaitInSeconds / 2 < 1 ? 0 : maxTimeToWaitInSeconds / 2;
        for (int i = 0; i <= maxIters; ++i) {
            try {
                if ("OK".equalsIgnoreCase(buttonName) || "Reload".equalsIgnoreCase(buttonName) || "Leave page".equalsIgnoreCase(buttonName)) {
                    webDriver.switchTo().alert().accept();
                    break;
                }
                if ("Cancel".equalsIgnoreCase(buttonName) || "Stay on page".equalsIgnoreCase(buttonName)) {
                    webDriver.switchTo().alert().dismiss();
                    break;
                }
                Assert.fail((String)("'" + buttonName + "' button is not supported."));
                break;
            }
            catch (Throwable th) {
                if (i == maxIters) {
                    throw th;
                }
                this.scenarioContext.waitForSeconds(2);
                continue;
            }
        }
    }

    @When(value="verify the alert dialog message {string} {string} [MaxTimeToWaitInSeconds={int}].")
    public void verify_the_alert_dialog_message_where(String operator, String expectedInfo, int maxTimeToWaitInSeconds) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        WebDriver webDriver = this.scenarioContext.getActiveAppDriver().getWebDriver();
        int maxIters = maxTimeToWaitInSeconds / 2 < 1 ? 0 : maxTimeToWaitInSeconds / 2;
        for (int i = 0; i <= maxIters; ++i) {
            try {
                String textValue = webDriver.switchTo().alert().getText();
                ExpectedInfo eInfo = JsonYamlUtil.parseExpectedInfo((String)expectedInfo);
                ParamPath pPath = new ParamPath("Alert-Text", "string");
                ParameterValidator.validateParamValueAsExpectedInfo((boolean)true, (ParamPath)pPath, (Object)textValue, (String)operator, (ExpectedInfo)eInfo);
                break;
            }
            catch (Throwable th) {
                if (i == maxIters) {
                    throw th;
                }
                this.scenarioContext.waitForSeconds(2);
                continue;
            }
        }
    }

    @When(value="enter the following text on alert dialog and click on {string} button [MaxTimeToWaitInSeconds={int}]:")
    public void verify_the_alert_dialog_message_where(String buttonName, int maxTimeToWaitInSeconds, DocString text) {
        if (!this.scenarioContext.isLastConditionSetToTrue()) {
            this.scenarioContext.log("This step is not executed due to false value of condition=\"" + this.scenarioContext.getLastConditionName() + "\".");
            return;
        }
        WebDriver webDriver = this.scenarioContext.getActiveAppDriver().getWebDriver();
        String text2 = text.getContent();
        text2 = this.scenarioContext.applyParamsValueOnText(text2);
        int maxIters = maxTimeToWaitInSeconds / 2 < 1 ? 0 : maxTimeToWaitInSeconds / 2;
        for (int i = 0; i <= maxIters; ++i) {
            try {
                webDriver.switchTo().alert().sendKeys(text2);
                if ("OK".equalsIgnoreCase(buttonName)) {
                    webDriver.switchTo().alert().accept();
                    break;
                }
                if ("Cancel".equalsIgnoreCase(buttonName)) {
                    webDriver.switchTo().alert().dismiss();
                    break;
                }
                Assert.fail((String)("'" + buttonName + "' button is not supported."));
                break;
            }
            catch (Throwable th) {
                if (i == maxIters) {
                    throw th;
                }
                this.scenarioContext.waitForSeconds(2);
                continue;
            }
        }
    }
}

