/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.criterion.BinaryCriterion;
import org.ujorm.criterion.Criterion;
import org.ujorm.criterion.Operator;
import org.ujorm.criterion.ValueCriterion;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.TableWrapper;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriterionDecoder {
    private final OrmHandler handler;
    private final SqlDialect dialect;
    private final Criterion criterion;
    private final List<Key> orderBy;
    private final StringBuilder sql;
    private final List<ValueCriterion> values;
    private final Set<MetaTable> tables;

    public CriterionDecoder(Criterion criterion, MetaTable metaTable) {
        this(criterion, metaTable.getDatabase(), null);
    }

    public CriterionDecoder(Criterion criterion, MetaDatabase metaDatabase, List<Key> list) {
        this.criterion = criterion;
        this.dialect = metaDatabase.getDialect();
        this.orderBy = list;
        this.handler = metaDatabase.getOrmHandler();
        this.sql = new StringBuilder(64);
        this.values = new ArrayList<ValueCriterion>();
        this.tables = new HashSet<MetaTable>();
        if (criterion != null) {
            this.unpack(criterion);
            this.writeRelations();
        }
    }

    protected final void unpack(Criterion criterion) {
        if (criterion.isBinary()) {
            this.unpackBinary((BinaryCriterion)criterion);
        } else {
            try {
                ValueCriterion valueCriterion = this.dialect.printCriterion((ValueCriterion)criterion, this.sql);
                if (valueCriterion != null) {
                    this.values.add(valueCriterion);
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }

    private void unpackBinary(BinaryCriterion binaryCriterion) {
        boolean bl = false;
        switch (binaryCriterion.getOperator()) {
            case OR: {
                bl = true;
            }
            case AND: {
                if (bl) {
                    this.sql.append(" (");
                }
                this.unpack(binaryCriterion.getLeftNode());
                this.sql.append(" ");
                this.sql.append(binaryCriterion.getOperator().name());
                this.sql.append(" ");
                this.unpack(binaryCriterion.getRightNode());
                if (!bl) break;
                this.sql.append(") ");
                break;
            }
            default: {
                String string = "Operator is not supported in the SQL statement: " + binaryCriterion.getOperator();
                throw new UnsupportedOperationException(string);
            }
        }
    }

    public int getColumnCount() {
        return this.values.size();
    }

    public MetaColumn getColumn(int n) {
        Key key = this.values.get(n).getLeftNode();
        MetaColumn metaColumn = (MetaColumn)this.handler.findColumnModel(key);
        return metaColumn;
    }

    public Operator getOperator(int n) {
        Operator operator = this.values.get(n).getOperator();
        return operator;
    }

    public Object getValue(int n) {
        Object object = this.values.get(n).getRightNode();
        return object;
    }

    public Object getValueExtended(int n) {
        ValueCriterion valueCriterion = this.values.get(n);
        Object object = valueCriterion.getRightNode();
        if (object == null) {
            return object;
        }
        if (valueCriterion.isInsensitive()) {
            object = object.toString().toUpperCase();
        }
        switch (valueCriterion.getOperator()) {
            case CONTAINS: 
            case CONTAINS_CASE_INSENSITIVE: {
                return "%" + object + "%";
            }
            case STARTS: 
            case STARTS_CASE_INSENSITIVE: {
                return object + "%";
            }
            case ENDS: 
            case ENDS_CASE_INSENSITIVE: {
                return "%" + object;
            }
        }
        return object;
    }

    public Criterion getCriterion() {
        return this.criterion;
    }

    public String getWhere() {
        return this.sql.toString();
    }

    public boolean isEmpty() {
        return this.sql.length() == 0;
    }

    public Key getBaseProperty() {
        Key key = null;
        for (ValueCriterion valueCriterion : this.values) {
            if (valueCriterion.getLeftNode() == null) continue;
            key = valueCriterion.getLeftNode();
            break;
        }
        while (key != null && !key.isDirect()) {
            key = ((CompositeKey)key).getFirstKey();
        }
        return key;
    }

    protected final void writeRelations() {
        boolean bl;
        Key[] keyArray = this.getPropertyRelations();
        boolean bl2 = bl = this.sql.length() > 0 && keyArray.length > 0;
        if (bl) {
            this.sql.append(" AND (");
        }
        boolean bl3 = false;
        for (Key key : keyArray) {
            try {
                MetaColumn metaColumn = (MetaColumn)this.handler.findColumnModel(key);
                List<MetaColumn> list = metaColumn.getForeignColumns();
                TableWrapper tableWrapper = list.get(0).getTable();
                this.tables.add((MetaTable)MetaColumn.TABLE.of((Ujo)metaColumn));
                this.tables.add((MetaTable)tableWrapper);
                for (int i = metaColumn.getForeignColumns().size() - 1; i >= 0; --i) {
                    if (bl3) {
                        this.sql.append(" AND ");
                    } else {
                        bl3 = true;
                    }
                    metaColumn.printForeignColumnFullName(i, this.sql);
                    this.sql.append(" = ");
                    this.dialect.printColumnAlias(list.get(i), this.sql);
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
        if (bl) {
            this.sql.append(")");
        }
    }

    protected Key[] getPropertyRelations() {
        HashSet hashSet = new HashSet();
        ArrayList arrayList = new ArrayList();
        for (ValueCriterion valueCriterion : this.values) {
            Key key = valueCriterion.getLeftNode();
            Object object = valueCriterion.getRightNode();
            if (!key.isDirect()) {
                ((CompositeKey)key).exportKeys(arrayList);
                arrayList.remove(arrayList.size() - 1);
            }
            if (!(object instanceof CompositeKey)) continue;
            ((CompositeKey)object).exportKeys(arrayList);
            arrayList.remove(arrayList.size() - 1);
        }
        if (this.orderBy != null) {
            for (Key key : this.orderBy) {
                if (key.isDirect()) continue;
                ((CompositeKey)key).exportKeys(arrayList);
                arrayList.remove(arrayList.size() - 1);
            }
        }
        hashSet.addAll(arrayList);
        return hashSet.toArray(new Key[hashSet.size()]);
    }

    public MetaTable[] getTables(MetaTable metaTable) {
        this.tables.add(metaTable);
        return this.tables.toArray(new MetaTable[this.tables.size()]);
    }

    public MetaTable[] getTablesSorted(final MetaTable metaTable) {
        MetaTable[] metaTableArray = this.getTables(metaTable);
        if (metaTableArray.length > 1 && metaTableArray[0] != metaTable) {
            Arrays.sort(metaTableArray, new Comparator<MetaTable>(){

                @Override
                public int compare(MetaTable metaTable3, MetaTable metaTable2) {
                    return metaTable3 == metaTable ? -1 : (metaTable2 == metaTable ? 1 : 0);
                }
            });
        }
        return metaTableArray;
    }

    public OrmHandler getHandler() {
        return this.handler;
    }

    public String toString() {
        return this.criterion != null ? this.criterion.toString() : null;
    }
}

