/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.dialect;

import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ujorm.Ujo;
import org.ujorm.orm.CriterionDecoder;
import org.ujorm.orm.DbType;
import org.ujorm.orm.ITypeService;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.UjoSequencer;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSSqlDialect
extends SqlDialect {
    private final Integer MSSQL_MAX_ALLOWED_SIZE = 8000;

    @Override
    public String getJdbcUrl() {
        return "jdbc:sqlserver://localhost:1433";
    }

    @Override
    public String getJdbcDriver() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    public Appendable printUpdate(MetaTable metaTable, List<MetaColumn> list, CriterionDecoder criterionDecoder, Appendable appendable) throws IOException {
        appendable.append("UPDATE ");
        appendable.append(metaTable.getAlias());
        appendable.append("\n\tSET ");
        for (int i = 0; i < list.size(); ++i) {
            MetaColumn metaColumn = list.get(i);
            if (metaColumn.isPrimaryKey()) {
                throw new IllegalStateException("Primary key can not be changed: " + metaColumn);
            }
            appendable.append(i == 0 ? "" : ", ");
            appendable.append((CharSequence)MetaColumn.NAME.of((Ujo)metaColumn));
            appendable.append("=?");
        }
        appendable.append("\n\tFROM ");
        this.printTableAliasDefinition(metaTable, appendable);
        appendable.append("\n\tWHERE ");
        appendable.append(criterionDecoder.getWhere());
        return appendable;
    }

    @Override
    public Appendable printDelete(MetaTable metaTable, CriterionDecoder criterionDecoder, Appendable appendable) throws IOException {
        appendable.append("DELETE ");
        appendable.append(metaTable.getAlias());
        appendable.append("\n\tFROM ");
        LinkedHashMap<String, MetaTable> linkedHashMap = new LinkedHashMap<String, MetaTable>();
        this.getTablesFromCriterion(criterionDecoder, metaTable, linkedHashMap);
        this.printTablesWithAlias(linkedHashMap.values(), appendable);
        appendable.append(" WHERE ");
        appendable.append(criterionDecoder.getWhere());
        return appendable;
    }

    public Appendable printColumnUnderAlias(MetaColumn metaColumn, Appendable appendable) throws IOException {
        MetaTable metaTable = (MetaTable)MetaColumn.TABLE.of((Ujo)metaColumn);
        appendable.append(metaTable.getAlias());
        appendable.append('_');
        appendable.append((CharSequence)MetaColumn.NAME.of((Ujo)metaColumn));
        return appendable;
    }

    public Appendable printColumnOrderAlias(MetaColumn metaColumn, Appendable appendable) throws IOException {
        MetaTable metaTable = (MetaTable)MetaColumn.TABLE.of((Ujo)metaColumn);
        appendable.append("o_");
        appendable.append(metaTable.getAlias());
        appendable.append('_');
        appendable.append((CharSequence)MetaColumn.NAME.of((Ujo)metaColumn));
        return appendable;
    }

    protected void printTableColumnsWithUnderAliases(List<MetaColumn> list, Appendable appendable) throws IOException {
        String string = "";
        for (MetaColumn metaColumn : list) {
            if (metaColumn.isForeignKey()) {
                for (int i = 0; i < metaColumn.getForeignColumns().size(); ++i) {
                    appendable.append(string);
                    appendable.append(((MetaTable)MetaColumn.TABLE.of((Ujo)metaColumn)).getAlias());
                    appendable.append('.');
                    appendable.append(metaColumn.getForeignColumnName(i));
                    appendable.append(" AS ");
                    this.printColumnUnderAlias(metaColumn, appendable);
                    string = ", ";
                }
                continue;
            }
            if (!metaColumn.isColumn()) continue;
            appendable.append(string);
            this.printColumnAlias(metaColumn, appendable);
            appendable.append(" AS ");
            this.printColumnUnderAlias(metaColumn, appendable);
            string = ", ";
        }
    }

    protected void printTableColumnsUnderAliases(List<MetaColumn> list, Appendable appendable) throws IOException {
        String string = "";
        for (MetaColumn metaColumn : list) {
            if (metaColumn.isForeignKey()) {
                for (int i = 0; i < metaColumn.getForeignColumns().size(); ++i) {
                    appendable.append(string);
                    this.printColumnUnderAlias(metaColumn, appendable);
                    string = ", ";
                }
                continue;
            }
            if (!metaColumn.isColumn()) continue;
            appendable.append(string);
            this.printColumnUnderAlias(metaColumn, appendable);
            string = ", ";
        }
    }

    protected void createInnerSelectPart(Query query, Appendable appendable) throws IOException {
        appendable.append("SELECT ");
        if (query.isDistinct()) {
            appendable.append("DISTINCT ");
        }
        this.printTableColumnsWithUnderAliases(query.getColumns(), appendable);
        appendable.append(", ");
        this.printOrderColumns(query, appendable, false, true, false);
    }

    protected void createRowOrderPart(Query query, Appendable appendable, boolean bl) throws IOException {
        appendable.append(", ROW_NUMBER() OVER (");
        if (query.getOrderBy().isEmpty()) {
            MetaColumn metaColumn = query.getColumn(0);
            appendable.append(" ORDER BY ");
            if (bl) {
                this.printColumnOrderAlias(metaColumn, appendable);
            } else {
                this.printColumnAlias(metaColumn, appendable);
            }
        } else {
            this.printSelectOrder(query, appendable, bl);
        }
        appendable.append(") AS RowNum ");
    }

    protected void printOrderColumns(Query query, Appendable appendable, boolean bl, boolean bl2, boolean bl3) throws IOException {
        List list = query.getOrderBy();
        for (int i = 0; i < list.size(); ++i) {
            MetaColumn metaColumn = query.readOrderColumn(i);
            boolean bl4 = list.get(i).isAscending();
            if (i > 0) {
                appendable.append(", ");
            }
            if (bl) {
                this.printColumnOrderAlias(metaColumn, appendable);
            } else {
                this.printColumnAlias(metaColumn, appendable);
                if (bl2) {
                    appendable.append(" AS ");
                    this.printColumnOrderAlias(metaColumn, appendable);
                }
            }
            if (bl4 || !bl3) continue;
            appendable.append(" DESC");
        }
    }

    public void printSelectOrder(Query query, Appendable appendable, boolean bl) throws IOException {
        appendable.append(" ORDER BY ");
        this.printOrderColumns(query, appendable, bl, false, true);
    }

    protected void createWherePart(Query query, Appendable appendable) throws IOException {
        Object object;
        LinkedHashMap<String, MetaTable> linkedHashMap = new LinkedHashMap<String, MetaTable>();
        List list = query.getOrderBy();
        for (int i = 0; i < list.size(); ++i) {
            object = query.readOrderColumn(i);
            String string = ((MetaTable)((MetaColumn)object).getTable()).getAlias();
            linkedHashMap.put(string, (MetaTable)((MetaColumn)object).getTable());
        }
        if (query.getCriterion() != null) {
            CriterionDecoder criterionDecoder = query.getDecoder();
            this.getTablesFromCriterion(criterionDecoder, query.getTableModel(), linkedHashMap);
            this.printTablesWithAlias(linkedHashMap.values(), appendable);
            object = criterionDecoder.getWhere();
            if (!((String)object).isEmpty()) {
                appendable.append(" WHERE ");
                appendable.append(criterionDecoder.getWhere());
            }
        } else {
            this.printTablesWithAlias(linkedHashMap.values(), appendable);
        }
    }

    private void getTablesFromCriterion(CriterionDecoder criterionDecoder, MetaTable metaTable, Map<String, MetaTable> map) {
        MetaTable[] metaTableArray = criterionDecoder.getTables(metaTable);
        for (int i = 0; i < metaTableArray.length; ++i) {
            MetaTable metaTable2 = metaTableArray[i];
            String string = metaTable2.getAlias();
            map.put(string, metaTable2);
        }
    }

    protected void printTablesWithAlias(Collection<MetaTable> collection, Appendable appendable) throws IOException {
        boolean bl = true;
        for (MetaTable metaTable : collection) {
            if (!bl) {
                appendable.append(", ");
            }
            this.printTableAliasDefinition(metaTable, appendable);
            bl = false;
        }
    }

    protected void createOuterPart(String string, Query query, Appendable appendable) throws IOException {
        appendable.append("SELECT ");
        List<MetaColumn> list = query.getColumns();
        boolean bl = true;
        for (MetaColumn metaColumn : list) {
            if (!bl) {
                appendable.append(", ");
            }
            this.printColumnUnderAlias(metaColumn, appendable);
            bl = false;
        }
        appendable.append("\n\tFROM (");
        appendable.append(string);
        appendable.append("\n) AS MyInnerTable ");
        if (query.isLimit()) {
            appendable.append("WHERE MyInnerTable.RowNum ");
            int n = query.isOffset() ? query.getOffset() + 1 : 1;
            appendable.append("BETWEEN " + n + " AND ");
            int n2 = n + query.getLimit() - 1;
            appendable.append(String.valueOf(n2));
        } else if (query.isOffset()) {
            appendable.append("WHERE MyInnerTable.RowNum ");
            appendable.append("> ");
            appendable.append(String.valueOf(query.getOffset()));
        }
        if (query.getOrderBy() != null && !query.getOrderBy().isEmpty()) {
            this.printSelectOrder(query, appendable, true);
        }
    }

    @Override
    protected Appendable printSelectTable(Query query, boolean bl, Appendable appendable) throws IOException {
        if (bl || !query.isLimit() && !query.isOffset()) {
            appendable = super.printSelectTable(query, bl, appendable);
        } else {
            if (query.getOrderBy() == null || query.getOrderBy().isEmpty()) {
                query.orderBy(query.getColumn(0).getProperty());
            }
            StringBuilder stringBuilder = new StringBuilder(256);
            this.createInnerSelectPart(query, stringBuilder);
            if (!query.isDistinct()) {
                this.createRowOrderPart(query, stringBuilder, false);
            }
            stringBuilder.append("\n\t\tFROM ");
            this.createWherePart(query, stringBuilder);
            if (query.isDistinct()) {
                stringBuilder = this.createMiddlePart(query, stringBuilder.toString());
            }
            this.createOuterPart(stringBuilder.toString(), query, appendable);
        }
        return appendable;
    }

    @Override
    protected String getColumnType(MetaColumn metaColumn) {
        switch ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))) {
            case BLOB: {
                return "VARBINARY";
            }
            case TIMESTAMP: {
                return "DATETIME";
            }
            case BOOLEAN: {
                return "TINYINT";
            }
        }
        return super.getColumnType(metaColumn);
    }

    @Override
    public Appendable printComment(MetaTable metaTable, Appendable appendable) throws IOException {
        appendable.append("ALTER TABLE ");
        this.printFullTableName(metaTable, appendable);
        appendable.append(" COMMENT = '");
        this.escape((CharSequence)MetaTable.COMMENT.of((Ujo)metaTable), appendable);
        appendable.append("'");
        return appendable;
    }

    @Override
    public Appendable printComment(MetaColumn metaColumn, Appendable appendable) throws IOException {
        appendable.append("ALTER TABLE ");
        this.printFullTableName((MetaTable)metaColumn.getTable(), appendable);
        appendable.append(" MODIFY COLUMN ");
        if (metaColumn.isPrimaryKey()) {
            String string = " PRIMARY KEY";
            String string2 = this.printColumnDeclaration(metaColumn, null, new StringBuilder()).toString();
            appendable.append(string2.replaceAll(string, " "));
        } else if (metaColumn.isForeignKey()) {
            this.printFKColumnsDeclaration(metaColumn, appendable);
        } else {
            this.printColumnDeclaration(metaColumn, null, appendable);
        }
        appendable.append(" COMMENT '");
        this.escape((CharSequence)MetaColumn.COMMENT.of((Ujo)metaColumn), appendable);
        appendable.append("'");
        return appendable;
    }

    @Override
    public Appendable printCreateSchema(String string, Appendable appendable) throws IOException {
        appendable.append("IF NOT EXISTS (SELECT * FROM sys.databases WHERE name = '");
        appendable.append(string);
        appendable.append("') ");
        appendable.append("BEGIN CREATE DATABASE ");
        appendable.append(string);
        appendable.append(" END ");
        return appendable;
    }

    @Override
    public Appendable printFullTableName(MetaTable metaTable, boolean bl, Appendable appendable) throws IOException {
        String string = (String)MetaTable.SCHEMA.of((Ujo)metaTable);
        String string2 = (String)MetaTable.NAME.of((Ujo)metaTable);
        if (this.isFilled(string)) {
            appendable.append(bl && metaTable.isDefaultSchema() ? "~" : string);
            appendable.append('.');
        }
        appendable.append("dbo.");
        appendable.append(string2);
        return appendable;
    }

    @Override
    public Appendable printSequenceTable(MetaDatabase metaDatabase, Appendable appendable) throws IOException {
        String string = (String)MetaDatabase.SCHEMA.of((Ujo)metaDatabase);
        Integer n = (Integer)MetaParams.SEQUENCE_CACHE.of((Ujo)metaDatabase.getParams());
        appendable.append("CREATE TABLE ");
        if (this.isFilled(string)) {
            appendable.append(string);
            appendable.append('.');
        }
        appendable.append("dbo.");
        MetaColumn metaColumn = new MetaColumn((ITypeService)metaDatabase.getParams().getConverter(null));
        MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.BIGINT);
        appendable.append(this.getSeqTableModel().getTableName() + "\n\t( " + this.getQuotedName(this.getSeqTableModel().getId()) + " VARCHAR(96) NOT NULL PRIMARY KEY" + "\n\t, " + this.getQuotedName(this.getSeqTableModel().getSequence()) + " " + this.getColumnType(metaColumn) + " DEFAULT " + n + " NOT NULL" + "\n\t, " + this.getQuotedName(this.getSeqTableModel().getCache()) + " INT DEFAULT " + n + " NOT NULL" + "\n\t, " + this.getQuotedName(this.getSeqTableModel().getMaxValue()) + " " + this.getColumnType(metaColumn) + " DEFAULT 0 NOT NULL" + "\n\t)");
        return appendable;
    }

    @Override
    protected Appendable printSequenceTableName(UjoSequencer ujoSequencer, Appendable appendable) throws IOException {
        String string = ujoSequencer.getDatabaseSchema();
        if (this.isFilled(string)) {
            appendable.append(string);
            appendable.append('.');
        }
        appendable.append("dbo.");
        appendable.append(this.getSeqTableModel().getTableName());
        return appendable;
    }

    @Override
    public Appendable printAlterTableAddColumn(MetaColumn metaColumn, Appendable appendable) throws IOException {
        appendable.append("ALTER TABLE ");
        this.printFullTableName((MetaTable)metaColumn.getTable(), appendable);
        appendable.append(" ADD ");
        if (metaColumn.isForeignKey()) {
            this.printFKColumnsDeclaration(metaColumn, appendable);
        } else {
            this.printColumnDeclaration(metaColumn, null, appendable);
        }
        if (metaColumn.hasDefaultValue()) {
            this.printDefaultValue(metaColumn, appendable);
        }
        return appendable;
    }

    @Override
    public Appendable printDefaultValue(MetaColumn metaColumn, Appendable appendable) throws IOException {
        Object object = metaColumn.getJdbcFriendlyDefaultValue();
        boolean bl = object != null;
        String string = "";
        if (object instanceof String) {
            bl = ((String)object).length() > 0;
            string = "'";
        } else if (object instanceof Date) {
            bl = true;
            string = "'";
        }
        if (bl) {
            appendable.append(" DEFAULT ");
            appendable.append(string);
            if (object instanceof Boolean) {
                appendable.append((Boolean)object != false ? (char)'1' : '0');
            } else {
                appendable.append(object.toString());
            }
            appendable.append(string);
        }
        return appendable;
    }

    @Override
    public Appendable printInsert(List<? extends OrmUjo> list, int n, int n2, Appendable appendable) throws IOException {
        return this.printInsertBySelect(list, n, n2, "", appendable);
    }

    @Override
    public Appendable printColumnDeclaration(MetaColumn metaColumn, String string, Appendable appendable) throws IOException {
        if (!MetaColumn.MAX_LENGTH.isDefault((Ujo)metaColumn) && metaColumn.getType().equals(Blob.class) && (Integer)MetaColumn.MAX_LENGTH.getValue((Ujo)metaColumn) > this.MSSQL_MAX_ALLOWED_SIZE) {
            String string2 = string != null ? string : (String)MetaColumn.NAME.of((Ujo)metaColumn);
            appendable.append(string2);
            appendable.append(' ');
            appendable.append(this.getColumnType(metaColumn));
            appendable.append("( MAX");
            if (!MetaColumn.PRECISION.isDefault((Ujo)metaColumn)) {
                appendable.append("," + MetaColumn.PRECISION.of((Ujo)metaColumn));
            }
            appendable.append(")");
            if (((Boolean)MetaColumn.MANDATORY.of((Ujo)metaColumn)).booleanValue() && string == null) {
                appendable.append(" NOT NULL");
            }
            if (((Boolean)MetaColumn.PRIMARY_KEY.of((Ujo)metaColumn)).booleanValue() && string == null) {
                appendable.append(" PRIMARY KEY");
            }
            return appendable;
        }
        return super.printColumnDeclaration(metaColumn, string, appendable);
    }

    private StringBuilder createMiddlePart(Query query, String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        this.printTableColumnsUnderAliases(query.getColumns(), stringBuilder);
        stringBuilder.append(", ");
        this.printOrderColumns(query, stringBuilder, true, false, false);
        this.createRowOrderPart(query, stringBuilder, true);
        stringBuilder.append(" FROM (");
        stringBuilder.append(string);
        stringBuilder.append(") AS DistinctTable");
        return stringBuilder;
    }

    @Override
    public void releaseSavepoint(Connection connection, Savepoint savepoint, boolean bl) throws SQLException {
    }

    @Override
    public Appendable printQuotedName(CharSequence charSequence, Appendable appendable) throws IOException {
        appendable.append('[');
        appendable.append(charSequence);
        appendable.append(']');
        return appendable;
    }
}

