/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.dialect;

import java.io.IOException;
import org.ujorm.Ujo;
import org.ujorm.orm.CriterionDecoder;
import org.ujorm.orm.DbType;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.orm.metaModel.MoreParams;

public class MySqlDialect
extends SqlDialect {
    public String getJdbcUrl() {
        return "jdbc:mysql://127.0.0.1:3306/db1";
    }

    public String getJdbcDriver() {
        return "com.mysql.jdbc.Driver";
    }

    public Appendable printDelete(MetaTable metaTable, CriterionDecoder criterionDecoder, Appendable appendable) throws IOException {
        MetaTable[] metaTableArray = criterionDecoder.getTablesSorted(metaTable);
        if (metaTableArray.length > 1) {
            appendable.append("DELETE FROM ");
            for (int i = 0; i < metaTableArray.length; ++i) {
                if (i > 0) {
                    appendable.append(", ");
                }
                this.printTableAliasDefinition(metaTableArray[i], appendable);
            }
            appendable.append(" WHERE ");
            appendable.append(criterionDecoder.getWhere());
        } else {
            String string = this.printFullTableName(metaTable, new StringBuilder(64)).toString();
            String string2 = criterionDecoder.getWhere().replace(metaTable.getAlias() + '.', string + '.');
            appendable.append("DELETE FROM ");
            appendable.append(string);
            appendable.append(" WHERE ");
            appendable.append(string2);
        }
        return appendable;
    }

    public Appendable printSequenceTable(MetaDatabase metaDatabase, Appendable appendable) throws IOException {
        return super.printSequenceTable(metaDatabase, appendable).append(' ').append(this.getEngine(null));
    }

    public Appendable printTable(MetaTable metaTable, Appendable appendable) throws IOException {
        return super.printTable(metaTable, appendable).append(' ').append(this.getEngine(metaTable));
    }

    protected String getEngine(MetaTable metaTable) {
        String string = (String)MetaParams.MORE_PARAMS.add(MoreParams.DIALECT_MYSQL_ENGINE_TYPE).of((Ujo)this.ormHandler.getParameters());
        return string;
    }

    protected String getColumnType(MetaColumn metaColumn) {
        switch ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))) {
            case TIMESTAMP: {
                return "DATETIME";
            }
            case CLOB: {
                return "LONGTEXT";
            }
            case BLOB: {
                return "LONGBLOB";
            }
        }
        return super.getColumnType(metaColumn);
    }

    public Appendable printComment(MetaTable metaTable, Appendable appendable) throws IOException {
        appendable.append("ALTER TABLE ");
        this.printFullTableName(metaTable, appendable);
        appendable.append(" COMMENT = '");
        this.escape((CharSequence)MetaTable.COMMENT.of((Ujo)metaTable), appendable);
        appendable.append("'");
        return appendable;
    }

    public Appendable printComment(MetaColumn metaColumn, Appendable appendable) throws IOException {
        appendable.append("ALTER TABLE ");
        this.printFullTableName((MetaTable)metaColumn.getTable(), appendable);
        appendable.append(" MODIFY COLUMN ");
        if (metaColumn.isPrimaryKey()) {
            String string = " PRIMARY KEY";
            String string2 = this.printColumnDeclaration(metaColumn, null, new StringBuilder()).toString();
            appendable.append(string2.replaceAll(string, " "));
        } else if (metaColumn.isForeignKey()) {
            this.printFKColumnsDeclaration(metaColumn, appendable);
        } else {
            this.printColumnDeclaration(metaColumn, null, appendable);
        }
        appendable.append(" COMMENT '");
        this.escape((CharSequence)MetaColumn.COMMENT.of((Ujo)metaColumn), appendable);
        appendable.append("'");
        return appendable;
    }

    public Appendable printQuotedName(CharSequence charSequence, Appendable appendable) throws IOException {
        appendable.append('`');
        appendable.append(charSequence);
        appendable.append('`');
        return appendable;
    }
}

