/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.dialect;

import java.io.IOException;
import java.util.List;
import org.ujorm.Ujo;
import org.ujorm.orm.DbType;
import org.ujorm.orm.Query;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaIndex;

public class PostgreSqlDialect
extends SqlDialect {
    public String getJdbcUrl() {
        return "";
    }

    public String getJdbcDriver() {
        return "org.postgresql.Driver";
    }

    public Appendable printCreateSchema(String string, Appendable appendable) throws IOException {
        appendable.append("CREATE SCHEMA ");
        appendable.append(string);
        return appendable;
    }

    protected String getColumnType(MetaColumn metaColumn) {
        switch ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))) {
            case CLOB: {
                if (metaColumn.isTypeOf(String.class)) {
                    return "TEXT";
                }
            }
            case BLOB: 
            case BINARY: {
                return "BYTEA";
            }
        }
        return super.getColumnType(metaColumn);
    }

    public Appendable printIndex(MetaIndex metaIndex, Appendable appendable) throws IOException {
        super.printIndex(metaIndex, appendable);
        if (((Boolean)MetaIndex.UNIQUE.of((Ujo)metaIndex)).booleanValue()) {
            this.printIndexCondition(metaIndex, appendable);
        }
        return appendable;
    }

    public Appendable printIndexCondition(MetaIndex metaIndex, Appendable appendable) throws IOException {
        String string = " WHERE ";
        for (MetaColumn metaColumn : (List)MetaIndex.COLUMNS.of((Ujo)metaIndex)) {
            if (metaColumn.hasDefaultValue()) continue;
            appendable.append(string);
            appendable.append((CharSequence)MetaColumn.NAME.of((Ujo)metaColumn));
            appendable.append(" IS NOT NULL");
            string = " AND ";
        }
        return appendable;
    }

    public void printOffset(Query query, Appendable appendable) throws IOException {
        if (query.isOffset()) {
            appendable.append(" OFFSET " + query.getOffset());
        }
    }
}

