/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.KeyFactory;
import org.ujorm.core.UjoManager;
import org.ujorm.implementation.orm.RelationToOne;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.DbType;
import org.ujorm.orm.ForeignKey;
import org.ujorm.orm.ITypeService;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.TypeService;
import org.ujorm.orm.annot.Column;
import org.ujorm.orm.annot.Comment;
import org.ujorm.orm.ao.UjoStatement;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaPKey;
import org.ujorm.orm.metaModel.MetaRelation2Many;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaColumn
extends MetaRelation2Many
implements ColumnWrapper {
    private static final Class<MetaColumn> CLASS = MetaColumn.class;
    private static final KeyFactory<MetaColumn> fa = KeyFactory.CamelBuilder.get(CLASS);
    public static final Key<MetaColumn, Boolean> PRIMARY_KEY = fa.newKey("primaryKey", (Object)false);
    public static final Key<MetaColumn, DbType> DB_TYPE = fa.newKey("dbType", (Object)DbType.Automatic);
    public static final Key<MetaColumn, Boolean> MANDATORY = fa.newKey("mandatory", (Object)false);
    public static final Key<MetaColumn, Integer> MAX_LENGTH = fa.newKey("maxLength", (Object)-1);
    public static final Key<MetaColumn, Integer> PRECISION = fa.newKey("precision", (Object)-1);
    public static final Key<MetaColumn, String> DEFAULT_VALUE = fa.newKey("default", (Object)"");
    public static final Key<MetaColumn, String> INDEX = fa.newKey("index", (Object)"");
    public static final Key<MetaColumn, String> UNIQUE_INDEX = fa.newKey("uniqueIndex", (Object)"");
    public static final Key<MetaColumn, String> CONSTRAINT_NAME = fa.newKey("constraintName", (Object)"");
    public static final Key<MetaColumn, Class<? extends ITypeService>> CONVERTER = fa.newClassKey("converter", ITypeService.class);
    public static final Key<MetaColumn, String> COMMENT = fa.newKey("comment", (Object)"");
    private List<MetaColumn> relatedModel;
    private String[] foreignNames = null;
    private static final String[] EMPTY_NAMES;
    private char typeCode;
    private boolean foreignKey;
    private final ITypeService converter;

    public MetaColumn() {
        this(null);
    }

    public MetaColumn(ITypeService iTypeService) {
        this.converter = iTypeService;
    }

    public MetaColumn(MetaTable metaTable, Key key, MetaColumn metaColumn) {
        super(metaTable, key, metaColumn);
        Comment comment;
        Column column;
        this.foreignKey = this.isTypeOf(OrmUjo.class);
        Field field = UjoManager.getInstance().getPropertyField(metaTable.getType(), key);
        Column column2 = column = field != null ? field.getAnnotation(Column.class) : null;
        if (metaColumn != null) {
            this.changeDefault(this, PRIMARY_KEY, PRIMARY_KEY.of((Ujo)metaColumn));
            this.changeDefault(this, MANDATORY, MANDATORY.of((Ujo)metaColumn));
            this.changeDefault(this, MAX_LENGTH, MAX_LENGTH.of((Ujo)metaColumn));
            this.changeDefault(this, PRECISION, PRECISION.of((Ujo)metaColumn));
            this.changeDefault(this, DB_TYPE, DB_TYPE.of((Ujo)metaColumn));
            this.changeDefault(this, INDEX, INDEX.of((Ujo)metaColumn));
            this.changeDefault(this, UNIQUE_INDEX, UNIQUE_INDEX.of((Ujo)metaColumn));
            this.changeDefault(this, COMMENT, COMMENT.of((Ujo)metaColumn));
            this.changeDefault(this, CONVERTER, CONVERTER.of((Ujo)metaColumn));
        }
        if (column != null) {
            this.changeDefault(this, PRIMARY_KEY, column.pk());
            this.changeDefault(this, MANDATORY, column.mandatory());
            this.changeDefault(this, MAX_LENGTH, column.length());
            this.changeDefault(this, PRECISION, column.precision());
            this.changeDefault(this, DB_TYPE, column.type());
            this.changeDefault(this, INDEX, column.index());
            this.changeDefault(this, UNIQUE_INDEX, column.uniqueIndex());
            this.changeDefault(this, CONSTRAINT_NAME, column.constraintName());
            this.changeDefault(this, CONVERTER, column.converter());
        }
        if (field != null && (comment = field.getAnnotation(Comment.class)) != null) {
            this.changeDefault(this, COMMENT, comment.value());
        }
        comment = CONVERTER.isDefault((Ujo)this) ? null : (Class)CONVERTER.of((Ujo)this);
        this.converter = this.getHandler().getParameters().getConverter(comment);
        if (DB_TYPE.isDefault((Ujo)this)) {
            ((MetaDatabase)MetaTable.DATABASE.of((Ujo)metaTable)).changeDbType(this);
        }
        if (MAX_LENGTH.isDefault((Ujo)this)) {
            ((MetaDatabase)MetaTable.DATABASE.of((Ujo)metaTable)).changeDbLength(this);
        }
    }

    @Override
    public boolean isColumn() {
        return true;
    }

    @Override
    public boolean isForeignKey() {
        return this.foreignKey;
    }

    public boolean isPrimaryKey() {
        boolean bl = (Boolean)PRIMARY_KEY.of((Ujo)this);
        return bl;
    }

    public boolean isCommented() {
        return !COMMENT.isDefault((Ujo)this);
    }

    public String getComment() {
        return (String)COMMENT.of((Ujo)this);
    }

    public int getMaxLength() {
        return (Integer)MAX_LENGTH.of((Ujo)this);
    }

    public int getPrecision() {
        return (Integer)PRECISION.of((Ujo)this);
    }

    public boolean isMandatory() {
        return (Boolean)MANDATORY.of((Ujo)this);
    }

    public MetaTable getForeignTable() {
        return this.getForeignColumns().get(0).getTable();
    }

    public List<MetaColumn> getForeignColumns() {
        if (this.relatedModel == null) {
            this.assignForeignColumns();
        }
        return this.relatedModel;
    }

    private void assignForeignColumns() {
        List list;
        if (TABLE_PROPERTY.of((Ujo)this) instanceof RelationToOne) {
            RelationToOne relationToOne = (RelationToOne)((Object)TABLE_PROPERTY.of((Ujo)this));
            MetaColumn metaColumn = (MetaColumn)this.getHandler().findColumnModel(relationToOne.getRelatedKey());
            list = new ArrayList(1);
            list.add(metaColumn);
        } else {
            MetaTable metaTable = this.getHandler().findTableModel(this.getType());
            if (metaTable != null) {
                MetaPKey metaPKey = (MetaPKey)((Object)MetaTable.PK.of((Ujo)metaTable));
                list = MetaPKey.COLUMNS.getList((Ujo)metaPKey);
            } else {
                list = Collections.emptyList();
            }
        }
        this.relatedModel = list;
    }

    private String[] getForeignColumnNames() {
        if (this.foreignNames == null) {
            if (this.isForeignKey()) {
                List<MetaColumn> list = this.getForeignColumns();
                StringTokenizer stringTokenizer = new StringTokenizer(list.size() == 1 ? (String)NAME.of((Ujo)this) : "", ", ");
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                for (MetaColumn metaColumn : list) {
                    String string = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "fk_" + (String)NAME.of((Ujo)this) + "_" + (String)NAME.of((Ujo)metaColumn);
                    arrayList.add(string);
                }
                this.foreignNames = arrayList.toArray(new String[arrayList.size()]);
            } else {
                this.foreignNames = EMPTY_NAMES;
            }
        }
        return this.foreignNames;
    }

    public String getForeignColumnName(int n) {
        String string = this.getForeignColumnNames()[n];
        return string;
    }

    public Object getValue(OrmUjo ormUjo) {
        Key key = this.getProperty();
        Object object = key.of((Ujo)ormUjo);
        return object;
    }

    public void setValue(Ujo ujo, Object object) {
        Key key = this.getProperty();
        if (this.isForeignKey() && object != null && !(object instanceof OrmUjo)) {
            object = new ForeignKey(object);
        }
        key.setValue(ujo, object);
    }

    public Class getType() {
        return ((Key)TABLE_PROPERTY.of((Ujo)this)).getType();
    }

    @Override
    public String toString() {
        return this.getFullName();
    }

    public String getFullName() {
        try {
            StringBuilder stringBuilder = new StringBuilder(32);
            MetaTable metaTable = (MetaTable)TABLE.of((Ujo)this);
            metaTable.getDatabase().getDialect().printFullTableName(metaTable, stringBuilder);
            stringBuilder.append('.');
            stringBuilder.append((String)NAME.of((Ujo)this));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public String getAliasName() {
        try {
            String string = ((MetaTable)TABLE.of((Ujo)this)).getDatabase().getDialect().printColumnAlias(this, new StringBuilder(32)).toString();
            return string;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public void printForeignColumnFullName(int n, Appendable appendable) throws IOException {
        MetaTable metaTable = (MetaTable)TABLE.of((Ujo)this);
        appendable.append(metaTable.getAlias());
        appendable.append('.');
        appendable.append(this.getForeignColumnNames()[n]);
    }

    public char getTypeCode() {
        return this.typeCode;
    }

    public boolean hasDefaultValue() {
        Object object = this.getProperty().getDefault();
        boolean bl = object instanceof String ? ((String)object).length() > 0 : object != null;
        return bl;
    }

    public Object getJdbcFriendlyDefaultValue() {
        Object object = new UjoStatement().getDefaultValue(this);
        return object;
    }

    public Class getDialectClass() {
        Class<? extends SqlDialect> clazz = ((MetaTable)TABLE.of((Ujo)this)).getDatabase().get(MetaDatabase.DIALECT);
        return clazz;
    }

    public String getDialectName() {
        return this.getDialectClass().getSimpleName();
    }

    public void initTypeCode() {
        List<MetaColumn> list;
        this.checkReadOnly(true);
        this.typeCode = TypeService.getTypeCode(this);
        if (this.isForeignKey() && (list = this.getForeignColumns()).size() > 0) {
            DB_TYPE.setValue((Ujo)this, DB_TYPE.of((Ujo)list.get(0)));
        }
    }

    public boolean isVoid() {
        return this.isTypeOf(Void.class);
    }

    public String getConstraintName() {
        return (String)CONSTRAINT_NAME.of((Ujo)this);
    }

    public ITypeService getConverter() {
        return this.converter;
    }

    public Class getDbTypeClass() {
        if (!this.readOnly()) {
            if (this.isForeignKey()) {
                return this.getType();
            }
            this.initTypeCode();
        }
        return this.converter.getDbTypeClass(this);
    }

    @Override
    public MetaColumn getModel() {
        return this;
    }

    static {
        fa.lock();
        EMPTY_NAMES = new String[0];
    }
}

