/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.ujorm.Key;
import org.ujorm.ListKey;
import org.ujorm.Ujo;
import org.ujorm.UjoAction;
import org.ujorm.core.KeyFactory;
import org.ujorm.core.annot.Transient;
import org.ujorm.core.annot.XmlAttribute;
import org.ujorm.extensions.StringWrapper;
import org.ujorm.implementation.orm.RelationToMany;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.AbstractMetaModel;
import org.ujorm.orm.BytesWrapper;
import org.ujorm.orm.DbProcedure;
import org.ujorm.orm.DbType;
import org.ujorm.orm.JdbcStatement;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.UjoSequencer;
import org.ujorm.orm.annot.Db;
import org.ujorm.orm.ao.CheckReport;
import org.ujorm.orm.ao.CommentPolicy;
import org.ujorm.orm.ao.Orm2ddlPolicy;
import org.ujorm.orm.ao.UjoStatement;
import org.ujorm.orm.dialect.MySqlDialect;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaIndex;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaProcedure;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaDatabase
extends AbstractMetaModel
implements Comparable<MetaDatabase> {
    private static final Class<MetaDatabase> CLASS = MetaDatabase.class;
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(MetaDatabase.class);
    private static final boolean ADD_DB_MODEL = true;
    private static final KeyFactory<MetaDatabase> fa = KeyFactory.CamelBuilder.get(CLASS);
    @XmlAttribute
    public static final Key<MetaDatabase, String> ID = fa.newKey("id", (Object)"");
    public static final Key<MetaDatabase, String> SCHEMA = fa.newKey("schema", (Object)"");
    public static final Key<MetaDatabase, Boolean> READ_ONLY = fa.newKey("readOnly", (Object)false);
    public static final Key<MetaDatabase, Class<? extends SqlDialect>> DIALECT = fa.newKey("dialect");
    public static final Key<MetaDatabase, String> JDBC_URL = fa.newKey("jdbcUrl", (Object)"");
    public static final Key<MetaDatabase, String> JDBC_DRIVER = fa.newKey("jdbcDriver", (Object)"");
    public static final Key<MetaDatabase, String> USER = fa.newKey("user", (Object)"");
    public static final Key<MetaDatabase, String> PASSWORD = fa.newKey("password", (Object)"");
    public static final ListKey<MetaDatabase, String> JNDI = fa.newListKey("jndi");
    public static final Key<MetaDatabase, Class<? extends UjoSequencer>> SEQUENCER = fa.newClassKey("sequencer", UjoSequencer.class);
    public static final Key<MetaDatabase, Orm2ddlPolicy> ORM2DLL_POLICY = fa.newKey("orm2ddlPolicy", (Object)Orm2ddlPolicy.INHERITED);
    public static final ListKey<MetaDatabase, MetaTable> TABLES = fa.newListKey("table");
    public static final ListKey<MetaDatabase, MetaProcedure> PROCEDURES = fa.newListKey("procedure");
    @Transient
    public static final Key<MetaDatabase, Integer> ORDER = fa.newKey("order", (Object)0);
    @Transient
    public static final Key<MetaDatabase, OrmUjo> ROOT = fa.newKey("root");
    private OrmHandler ormHandler;
    private SqlDialect dialect;

    public MetaDatabase() {
    }

    public MetaDatabase(OrmHandler ormHandler, OrmUjo ormUjo, MetaDatabase metaDatabase, Integer n) {
        Object object;
        Object object22;
        Db db;
        this.ormHandler = ormHandler;
        ROOT.setValue((Ujo)this, (Object)ormUjo);
        ORDER.setValue((Ujo)this, (Object)n);
        if (metaDatabase != null) {
            this.changeDefault(this, SCHEMA, SCHEMA.of((Ujo)metaDatabase));
            this.changeDefault(this, READ_ONLY, READ_ONLY.of((Ujo)metaDatabase));
            this.changeDefault(this, ORM2DLL_POLICY, ORM2DLL_POLICY.of((Ujo)metaDatabase));
            this.changeDefault(this, DIALECT, DIALECT.of((Ujo)metaDatabase));
            this.changeDefault(this, JDBC_URL, JDBC_URL.of((Ujo)metaDatabase));
            this.changeDefault(this, JDBC_DRIVER, JDBC_DRIVER.of((Ujo)metaDatabase));
            this.changeDefault(this, USER, USER.of((Ujo)metaDatabase));
            this.changeDefault(this, PASSWORD, PASSWORD.of((Ujo)metaDatabase));
            this.changeDefault(this, JNDI, JNDI.of((Ujo)metaDatabase));
            this.changeDefault(this, SEQUENCER, SEQUENCER.of((Ujo)metaDatabase));
        }
        if ((db = ormUjo.getClass().getAnnotation(Db.class)) != null) {
            this.changeDefault(this, SCHEMA, db.schema());
            this.changeDefault(this, READ_ONLY, db.readOnly());
            this.changeDefault(this, ORM2DLL_POLICY, db.Orm2ddlPolicy());
            this.changeDefault(this, DIALECT, db.dialect());
            this.changeDefault(this, JDBC_URL, db.jdbcUrl());
            this.changeDefault(this, JDBC_DRIVER, db.jdbcDriver());
            this.changeDefault(this, USER, db.user());
            this.changeDefault(this, PASSWORD, db.password());
            this.changeDefault(this, JNDI, Arrays.asList(db.jndi()));
            this.changeDefault(this, SEQUENCER, db.sequencer());
        }
        this.changeDefault(this, ID, ormUjo.getClass().getSimpleName());
        this.changeDefault(this, JDBC_URL, this.getDialect().getJdbcUrl());
        this.changeDefault(this, JDBC_DRIVER, this.getDialect().getJdbcDriver());
        this.changeDefault(this, ORM2DLL_POLICY, MetaParams.ORM2DLL_POLICY.of((Ujo)this.getParams()));
        this.changeDefault(this, ORM2DLL_POLICY, MetaParams.ORM2DLL_POLICY.getDefault());
        for (Object object22 : ormUjo.readKeys()) {
            AbstractMetaModel abstractMetaModel;
            MetaTable metaTable;
            if (object22 instanceof RelationToMany) {
                object = (RelationToMany)((Object)object22);
                metaTable = metaDatabase != null ? metaDatabase.findTable(object.getName()) : null;
                abstractMetaModel = new MetaTable(this, (RelationToMany)((Object)object), metaTable);
                TABLES.addItem((Ujo)this, (Object)abstractMetaModel);
                ormHandler.addTableModel((MetaTable)abstractMetaModel);
                continue;
            }
            if (!object22.isTypeOf(DbProcedure.class)) continue;
            object = object22;
            metaTable = metaDatabase != null ? metaDatabase.findProcedure(object.getName()) : null;
            abstractMetaModel = new MetaProcedure(this, (Key)object, (MetaProcedure)((Object)metaTable));
            PROCEDURES.addItem((Ujo)this, (Object)abstractMetaModel);
            ormHandler.addProcedureModel((MetaProcedure)abstractMetaModel);
        }
        String string = (String)SCHEMA.of((Ujo)this);
        object22 = new RelationToMany((String)(this.isFilled(string) ? string : RelationToMany.class.getSimpleName()), ormUjo.getClass());
        object = new MetaTable(this, (RelationToMany)((Object)object22), null);
        ((MetaTable)object).setNotPersistent();
        TABLES.addItem((Ujo)this, object);
        ormHandler.addTableModel((MetaTable)object);
    }

    public SqlDialect getDialect() {
        if (this.dialect == null) {
            try {
                this.dialect = (SqlDialect)((Class)DIALECT.of((Ujo)this)).newInstance();
                this.dialect.setHandler(this.ormHandler);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Can't create an instance of " + this.dialect, exception);
            }
        }
        return this.dialect;
    }

    public void changeDbType(MetaColumn metaColumn) {
        Class clazz = metaColumn.getDbTypeClass();
        if (Void.class == clazz) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.NULL);
        } else if (String.class == clazz || StringWrapper.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.VARCHAR);
        } else if (Integer.class == clazz || Color.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.INT);
        } else if (Short.class == clazz) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.SMALLINT);
        } else if (Long.class == clazz || BigInteger.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.BIGINT);
        } else if (Double.class == clazz || BigDecimal.class == clazz) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.DECIMAL);
        } else if (Date.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.DATE);
        } else if (java.util.Date.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.TIMESTAMP);
        } else if (Byte.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.CHAR);
        } else if (Character.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.CHAR);
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.BOOLEAN);
        } else if (Enum.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.SMALLINT);
        } else if (Blob.class.isAssignableFrom(clazz) || BytesWrapper.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.BLOB);
        } else if (Clob.class.isAssignableFrom(clazz)) {
            MetaColumn.DB_TYPE.setValue((Ujo)metaColumn, (Object)DbType.CLOB);
        } else if (OrmUjo.class.isAssignableFrom(clazz)) {
            // empty if block
        }
    }

    public void changeDbLength(MetaColumn metaColumn) {
        switch ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)metaColumn))) {
            case DECIMAL: {
                this.changeDefault(metaColumn, MetaColumn.MAX_LENGTH, 8);
                this.changeDefault(metaColumn, MetaColumn.PRECISION, 2);
                break;
            }
            case VARCHAR: 
            case VARCHAR_IGNORECASE: {
                if (!MetaColumn.MAX_LENGTH.isDefault((Ujo)metaColumn)) break;
                boolean bl = metaColumn.getType().isEnum();
                MetaColumn.MAX_LENGTH.setValue((Ujo)metaColumn, (Object)(bl ? this.maxEnumLenght4Db(metaColumn) : 128));
                break;
            }
        }
    }

    private int maxEnumLenght4Db(MetaColumn metaColumn) throws IllegalArgumentException {
        try {
            int n = 1;
            UjoStatement ujoStatement = new UjoStatement();
            for (Object t : metaColumn.getType().getEnumConstants()) {
                metaColumn.getConverter().setValue(metaColumn, ujoStatement, t, 1);
                Object object = ujoStatement.getValue();
                if (!(object instanceof String)) continue;
                n = Math.max(n, ((String)object).length());
            }
            return n;
        }
        catch (SQLException sQLException) {
            throw new IllegalArgumentException(sQLException);
        }
    }

    private void createTableComments(List<MetaTable> list, Statement statement, StringBuilder stringBuilder) {
        try {
            for (MetaTable metaTable : list) {
                switch ((Orm2ddlPolicy)((Object)MetaTable.ORM2DLL_POLICY.of((Ujo)metaTable))) {
                    case CREATE_DDL: 
                    case CREATE_OR_UPDATE_DDL: {
                        if (!metaTable.isTable()) break;
                        if (metaTable.isCommented()) {
                            stringBuilder.setLength(0);
                            Appendable appendable = this.getDialect().printComment(metaTable, (Appendable)stringBuilder);
                            if (appendable.toString().length() > 0) {
                                this.executeUpdate(appendable, statement, metaTable);
                            }
                        }
                        for (MetaColumn metaColumn : (List)MetaTable.COLUMNS.of((Ujo)metaTable)) {
                            if (!metaColumn.isCommented()) continue;
                            stringBuilder.setLength(0);
                            Appendable appendable = this.getDialect().printComment(metaColumn, (Appendable)stringBuilder);
                            if (appendable.toString().length() <= 0) continue;
                            this.executeUpdate(appendable, statement, metaTable);
                        }
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Error on table comment: {0}", new Object[]{stringBuilder});
        }
    }

    private String dbIdentifier(String string, DatabaseMetaData databaseMetaData) throws SQLException {
        if (databaseMetaData.storesUpperCaseIdentifiers()) {
            return string.toUpperCase();
        }
        if (databaseMetaData.storesLowerCaseIdentifiers()) {
            return string.toLowerCase();
        }
        return string;
    }

    private int getTableTotalCount() {
        int n = 0;
        for (MetaTable metaTable : TABLES.getList((Ujo)this)) {
            if (!metaTable.isTable()) continue;
            ++n;
        }
        return n;
    }

    private boolean isModelChanged(Connection connection, List<MetaTable> list, List<MetaColumn> list2, List<MetaIndex> list3) throws SQLException {
        list.clear();
        list2.clear();
        list3.clear();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        boolean bl = this.getDialect() instanceof MySqlDialect;
        String string = null;
        for (MetaTable metaTable : (List)TABLES.of((Ujo)this)) {
            boolean bl2;
            boolean bl3;
            if (!metaTable.isTable()) continue;
            HashSet<String> hashSet = new HashSet<String>(32);
            String string2 = this.dbIdentifier((String)MetaTable.SCHEMA.of((Ujo)metaTable), databaseMetaData);
            ResultSet resultSet = databaseMetaData.getColumns(bl ? string2 : null, bl ? null : string2, this.dbIdentifier((String)MetaTable.NAME.of((Ujo)metaTable), databaseMetaData), string);
            while (resultSet.next()) {
                hashSet.add(resultSet.getString("COLUMN_NAME").toUpperCase());
            }
            resultSet.close();
            boolean bl4 = bl3 = hashSet.size() > 0;
            if (bl3) {
                for (MetaColumn metaColumn : (List)MetaTable.COLUMNS.of((Ujo)metaTable)) {
                    bl2 = hashSet.contains(((String)MetaColumn.NAME.of((Ujo)metaColumn)).toUpperCase());
                    if (bl2) continue;
                    LOGGER.log(Level.INFO, "New DB column: " + metaColumn.getFullName());
                    list2.add(metaColumn);
                }
            } else {
                LOGGER.log(Level.INFO, "New DB table: " + (String)MetaTable.NAME.of((Ujo)metaTable));
                list.add(metaTable);
            }
            hashSet.clear();
            if (bl3) {
                resultSet = databaseMetaData.getIndexInfo(bl ? string2 : null, bl ? null : string2, this.dbIdentifier((String)MetaTable.NAME.of((Ujo)metaTable), databaseMetaData), false, false);
                while (resultSet.next()) {
                    String string3 = resultSet.getString("INDEX_NAME");
                    if (string3 == null) continue;
                    hashSet.add(string3.toUpperCase());
                }
                resultSet.close();
            }
            for (MetaIndex metaIndex : metaTable.getIndexCollection()) {
                bl2 = hashSet.contains(((String)MetaIndex.NAME.of((Ujo)metaIndex)).toUpperCase());
                if (bl2) continue;
                LOGGER.log(Level.INFO, "New DB index: " + (Object)((Object)metaIndex));
                list3.add(metaIndex);
            }
        }
        boolean bl5 = !list.isEmpty() || !list2.isEmpty() || !list3.isEmpty();
        return bl5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void create(Session session) {
        Connection connection = session.getConnection(this, true);
        Statement statement = null;
        StringBuilder stringBuilder = new StringBuilder(256);
        Appendable appendable = stringBuilder;
        ArrayList<MetaTable> arrayList = new ArrayList<MetaTable>();
        ArrayList<MetaColumn> arrayList2 = new ArrayList<MetaColumn>();
        ArrayList<MetaColumn> arrayList3 = new ArrayList<MetaColumn>();
        ArrayList<MetaIndex> arrayList4 = new ArrayList<MetaIndex>();
        boolean bl = false;
        int n = this.getTableTotalCount();
        boolean bl2 = false;
        try {
            void var15_41;
            statement = connection.createStatement();
            if (this.isSequenceTableRequired()) {
                void var15_24;
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                Object list2 = null;
                String string = "";
                try {
                    appendable = this.getDialect().printSequenceCurrentValue(this.findFirstSequencer(), stringBuilder);
                    preparedStatement = connection.prepareStatement(appendable.toString());
                    preparedStatement.setString(1, "-");
                    resultSet = preparedStatement.executeQuery();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                }
                if (var15_24 != null) {
                    switch ((Orm2ddlPolicy)((Object)ORM2DLL_POLICY.of((Ujo)this))) {
                        case VALIDATE: 
                        case WARNING: {
                            throw new IllegalStateException(string, (Throwable)var15_24);
                        }
                        case CREATE_DDL: 
                        case CREATE_OR_UPDATE_DDL: 
                        case INHERITED: {
                            bl = true;
                        }
                    }
                }
                if (LOGGER.isLoggable(Level.INFO)) {
                    String string3 = "Table ''{0}'' {1} available on the database ''{2}''.";
                    string3 = MessageFormat.format(string3, this.getDialect().getSeqTableModel().getTableName(), var15_24 != null ? "is not" : "is", this.getId());
                    LOGGER.log(Level.INFO, string3);
                }
                try {
                    if (var15_24 != null) {
                        connection.rollback();
                    }
                }
                finally {
                    MetaDatabase.close(null, preparedStatement, resultSet, false);
                }
            }
            boolean bl3 = false;
            switch ((Orm2ddlPolicy)((Object)ORM2DLL_POLICY.of((Ujo)this))) {
                case CREATE_DDL: {
                    bl3 = true;
                }
                case CREATE_OR_UPDATE_DDL: 
                case VALIDATE: 
                case WARNING: 
                case INHERITED: {
                    boolean bl4 = this.isModelChanged(connection, arrayList, arrayList2, arrayList4);
                    if (!bl4 || !bl3 || arrayList.size() >= n) break;
                    return;
                }
                default: {
                    return;
                }
            }
            switch ((CheckReport)((Object)MetaParams.CHECK_KEYWORDS.of((Ujo)this.getParams()))) {
                case WARNING: 
                case EXCEPTION: {
                    Set<String> set = this.getDialect().getKeywordSet(connection);
                    for (MetaTable metaTable : arrayList) {
                        if (!metaTable.isTable()) continue;
                        this.checkKeyWord((String)MetaTable.NAME.of((Ujo)metaTable), metaTable, set);
                        for (MetaColumn metaColumn : (List)MetaTable.COLUMNS.of((Ujo)metaTable)) {
                            this.checkKeyWord((String)MetaColumn.NAME.of((Ujo)metaColumn), metaTable, set);
                        }
                    }
                    for (MetaColumn metaColumn : arrayList2) {
                        this.checkKeyWord((String)MetaColumn.NAME.of((Ujo)metaColumn), (MetaTable)metaColumn.getTable(), set);
                    }
                    for (MetaIndex metaIndex : arrayList4) {
                        this.checkKeyWord((String)MetaIndex.NAME.of((Ujo)metaIndex), (MetaTable)MetaIndex.TABLE.of((Ujo)metaIndex), set);
                    }
                    break;
                }
            }
            if (n == arrayList.size()) {
                for (String string : this.getSchemas(arrayList)) {
                    stringBuilder.setLength(0);
                    appendable = this.getDialect().printCreateSchema(string, stringBuilder);
                    if (!this.isFilled(appendable)) continue;
                    try {
                        statement.executeUpdate(appendable.toString());
                    }
                    catch (SQLException sQLException) {
                        LOGGER.log(Level.INFO, "{0}: {1}; {2}", new Object[]{sQLException.getClass().getName(), appendable.toString(), sQLException.getMessage()});
                        connection.rollback();
                    }
                }
            }
            int n2 = 0;
            for (MetaTable metaTable : arrayList) {
                if (!metaTable.isTable()) continue;
                ++n2;
                stringBuilder.setLength(0);
                appendable = this.getDialect().printTable(metaTable, stringBuilder);
                this.executeUpdate(appendable, statement, metaTable);
                arrayList3.addAll(metaTable.getForeignColumns());
                bl2 = true;
            }
            for (MetaColumn metaColumn : arrayList2) {
                stringBuilder.setLength(0);
                appendable = this.getDialect().printAlterTableAddColumn(metaColumn, stringBuilder);
                this.executeUpdate(appendable, statement, (MetaTable)metaColumn.getTable());
                bl2 = true;
                if (!metaColumn.isForeignKey()) continue;
                arrayList3.add(metaColumn);
            }
            for (MetaIndex metaIndex : arrayList4) {
                stringBuilder.setLength(0);
                appendable = this.getDialect().printIndex(metaIndex, stringBuilder);
                this.executeUpdate(appendable, statement, (MetaTable)MetaIndex.TABLE.of((Ujo)metaIndex));
                bl2 = true;
            }
            for (MetaColumn metaColumn : arrayList3) {
                if (!metaColumn.isForeignKey()) continue;
                stringBuilder.setLength(0);
                MetaTable metaTable = (MetaTable)MetaColumn.TABLE.of((Ujo)metaColumn);
                appendable = this.getDialect().printForeignKey(metaColumn, metaTable, stringBuilder);
                this.executeUpdate(appendable, statement, (MetaTable)metaColumn.getTable());
                bl2 = true;
            }
            if (bl) {
                stringBuilder.setLength(0);
                appendable = this.getDialect().printSequenceTable(this, stringBuilder);
                MetaTable metaTable = new MetaTable();
                MetaTable.ORM2DLL_POLICY.setValue((Ujo)metaTable, MetaParams.ORM2DLL_POLICY.getDefault());
                this.executeUpdate(appendable, statement, metaTable);
            }
            switch ((CommentPolicy)((Object)MetaParams.COMMENT_POLICY.of((Ujo)this.ormHandler.getParameters()))) {
                case FOR_NEW_OBJECT: {
                    ArrayList<MetaTable> arrayList5 = arrayList;
                    break;
                }
                case ALWAYS: {
                    List list = TABLES.getList((Ujo)this);
                    break;
                }
                case ON_ANY_CHANGE: {
                    List list = bl2 ? TABLES.getList((Ujo)this) : Collections.emptyList();
                    break;
                }
                case NEVER: {
                    List list = Collections.emptyList();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported parameter");
                }
            }
            if (!var15_41.isEmpty()) {
                appendable = stringBuilder;
                this.createTableComments((List<MetaTable>)var15_41, statement, stringBuilder);
            }
            connection.commit();
        }
        catch (Throwable throwable) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.WARNING, "Can't rollback DB" + this.getId(), (Throwable)sQLException);
            }
            throw new IllegalArgumentException("ILLEGAL SQL: " + appendable, throwable);
        }
    }

    private void executeUpdate(Appendable appendable, Statement statement, MetaTable metaTable) throws IllegalStateException, SQLException {
        boolean bl = false;
        switch (metaTable.getOrm2ddlPolicy()) {
            case INHERITED: {
                throw new IllegalStateException("An internal error due the DDL policy: " + (Object)((Object)metaTable.getOrm2ddlPolicy()));
            }
            case DO_NOTHING: {
                return;
            }
            case VALIDATE: {
                bl = true;
            }
            case WARNING: {
                String string = "A database validation (caused by the parameter " + MetaTable.ORM2DLL_POLICY + ") have found an inconsistency. " + "There is required a database change: " + appendable;
                if (bl) {
                    throw new IllegalStateException(string);
                }
                LOGGER.log(Level.WARNING, string);
            }
        }
        statement.executeUpdate(appendable.toString());
        LOGGER.log(Level.INFO, appendable.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Connection connection, JdbcStatement jdbcStatement, ResultSet resultSet, boolean bl) throws IllegalStateException {
        try {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            finally {
                try {
                    if (jdbcStatement != null) {
                        jdbcStatement.close();
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            String string = "Can't close a SQL object";
            if (bl) {
                throw new IllegalStateException(string, throwable);
            }
            LOGGER.log(Level.SEVERE, string, throwable);
        }
    }

    protected void checkKeyWord(String string, MetaTable metaTable, Set<String> set) throws Exception {
        if (set.contains(string.toUpperCase())) {
            String string2 = "The database table or column called '" + string + "' is a SQL keyword. See the class: " + metaTable.getType().getName() + ".\nNOTE: the keyword checking can be disabled by the Ujorm parameter: " + MetaParams.CHECK_KEYWORDS;
            switch ((CheckReport)((Object)MetaParams.CHECK_KEYWORDS.of((Ujo)this.getParams()))) {
                case EXCEPTION: {
                    throw new IllegalArgumentException(string2);
                }
                case WARNING: {
                    LOGGER.log(Level.WARNING, string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Connection connection, Statement statement, ResultSet resultSet, boolean bl) throws IllegalStateException {
        try {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            String string = "Can't close a SQL object";
            if (bl) {
                throw new IllegalStateException(string, throwable);
            }
            LOGGER.log(Level.SEVERE, string, throwable);
        }
    }

    public OrmHandler getOrmHandler() {
        return this.ormHandler;
    }

    public MetaParams getParams() {
        return this.ormHandler.getParameters();
    }

    public String getId() {
        return (String)ID.of((Ujo)this);
    }

    public Connection createConnection() throws Exception {
        Connection connection = this.dialect.createConnection(this);
        if (connection.getAutoCommit()) {
            connection.setAutoCommit(false);
        }
        return connection;
    }

    public Connection createInternalConnection() throws Exception {
        Connection connection;
        List list = (List)JNDI.of((Ujo)this);
        if (!list.isEmpty()) {
            LOGGER.log(Level.FINE, "JNDI: {0}", new Object[]{list});
            InitialContext initialContext = this.dialect.createJndiInitialContext(this);
            int n = list.size() - 1;
            for (int i = 0; i < n; ++i) {
                if ((initialContext = (InitialContext)initialContext.lookup((String)list.get(i))) != null) continue;
                throw new IllegalStateException("JNDI problem: InitialContext was not found for the: " + (String)list.get(i));
            }
            DataSource dataSource = (DataSource)initialContext.lookup((String)list.get(n));
            if (dataSource == null) {
                throw new IllegalStateException("JNDI problem: database connection was not found for the: " + list);
            }
            connection = dataSource.getConnection();
        } else {
            Class.forName((String)JDBC_DRIVER.of((Ujo)this));
            connection = DriverManager.getConnection((String)JDBC_URL.of((Ujo)this), (String)USER.of((Ujo)this), (String)PASSWORD.of((Ujo)this));
        }
        return connection;
    }

    public boolean equals(Object object) {
        if (object instanceof MetaDatabase) {
            MetaDatabase metaDatabase = (MetaDatabase)object;
            Integer n = (Integer)ORDER.of((Ujo)this);
            Integer n2 = (Integer)ORDER.of((Ujo)metaDatabase);
            return n.equals(n2);
        }
        return false;
    }

    public int hashCode() {
        Integer n = (Integer)ORDER.of((Ujo)this);
        return n.hashCode();
    }

    public Session getDefaultSession() {
        return this.ormHandler.getSession();
    }

    private Set<String> getSchemas(List<MetaTable> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (MetaTable metaTable : list) {
            String string;
            if (!metaTable.isTable() || !this.isFilled(string = (String)MetaTable.SCHEMA.of((Ujo)metaTable))) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    MetaTable findTable(String string) {
        if (this.isFilled(string)) {
            for (MetaTable metaTable : TABLES.getList((Ujo)this)) {
                if (!MetaTable.ID.equals((Ujo)metaTable, (Object)string)) continue;
                return metaTable;
            }
        }
        return null;
    }

    MetaProcedure findProcedure(String string) {
        if (this.isFilled(string)) {
            for (MetaProcedure metaProcedure : PROCEDURES.getList((Ujo)this)) {
                if (!MetaProcedure.ID.equals((Ujo)metaProcedure, (Object)string)) continue;
                return metaProcedure;
            }
        }
        return null;
    }

    private UjoSequencer findFirstSequencer() {
        for (MetaTable metaTable : (List)TABLES.of((Ujo)this)) {
            if (!metaTable.isTable()) continue;
            return metaTable.getSequencer();
        }
        return null;
    }

    public boolean isSequenceTableRequired() {
        for (MetaTable metaTable : (List)TABLES.of((Ujo)this)) {
            if (!metaTable.isTable() || !metaTable.getSequencer().isSequenceTableRequired()) continue;
            return true;
        }
        return false;
    }

    protected UjoSequencer createSequencer(MetaTable metaTable) {
        UjoSequencer ujoSequencer;
        Class clazz = (Class)SEQUENCER.of((Ujo)this);
        if (clazz == UjoSequencer.class) {
            ujoSequencer = new UjoSequencer(metaTable);
        } else {
            try {
                Constructor constructor = clazz.getConstructor(MetaTable.class);
                ujoSequencer = (UjoSequencer)constructor.newInstance(metaTable);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Can't create sequencer for " + clazz, exception);
            }
        }
        return ujoSequencer;
    }

    public List<MetaIndex> getIndexList() {
        ArrayList<MetaIndex> arrayList = new ArrayList<MetaIndex>(32);
        for (MetaTable metaTable : (List)TABLES.of((Ujo)this)) {
            arrayList.addAll(metaTable.getIndexCollection());
        }
        return arrayList;
    }

    public String toString() {
        String string = (String)ID.of((Ujo)this) + '[' + TABLES.getItemCount((Ujo)this) + ']';
        return string;
    }

    @Override
    public int compareTo(MetaDatabase metaDatabase) {
        Integer n = (Integer)ORDER.of((Ujo)this);
        Integer n2 = (Integer)ORDER.of((Ujo)metaDatabase);
        return n.compareTo(n2);
    }

    @Override
    public boolean readAuthorization(UjoAction ujoAction, Key key, Object object) {
        switch (ujoAction.getType()) {
            case 2: {
                return key != PASSWORD;
            }
        }
        return super.readAuthorization(ujoAction, key, object);
    }

    static {
        fa.lock();
    }
}

