/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.ujorm.Key;
import org.ujorm.ListKey;
import org.ujorm.Ujo;
import org.ujorm.core.KeyFactory;
import org.ujorm.orm.AbstractMetaModel;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaTable;

public final class MetaPKey
extends AbstractMetaModel {
    private static final Class<MetaPKey> CLASS = MetaPKey.class;
    private static final KeyFactory<MetaPKey> fa = KeyFactory.CamelBuilder.get(CLASS);
    public static final Key<MetaPKey, MetaTable> TABLE = fa.newKey("table");
    public static final ListKey<MetaPKey, MetaColumn> COLUMNS = fa.newListKey("columns");

    public MetaPKey(MetaTable metaTable) {
        TABLE.setValue((Ujo)this, (Object)metaTable);
        COLUMNS.setValue((Ujo)this, new ArrayList(0));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10);
        for (MetaColumn metaColumn : COLUMNS.getList((Ujo)this)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(metaColumn.toString());
        }
        return stringBuilder.toString();
    }

    public boolean assignPrimaryKey(OrmUjo ormUjo, Session session) throws IllegalArgumentException {
        int n = COLUMNS.getItemCount((Ujo)this);
        if (n == 1) {
            MetaColumn metaColumn = (MetaColumn)COLUMNS.getItem((Ujo)this, 0);
            Key key = metaColumn.getProperty();
            if (key.of((Ujo)ormUjo) != null) {
                return false;
            }
            long l = ((MetaTable)TABLE.of((Ujo)this)).getSequencer().nextValue(session);
            switch (metaColumn.getTypeCode()) {
                case '\u0006': {
                    ormUjo.writeValue(key, l);
                    return true;
                }
                case '\u0005': {
                    ormUjo.writeValue(key, (int)l);
                    return true;
                }
                case '\u0004': {
                    ormUjo.writeValue(key, (short)l);
                    return true;
                }
                case '\u0002': {
                    ormUjo.writeValue(key, (byte)l);
                    return true;
                }
                case '\n': {
                    ormUjo.writeValue(key, BigInteger.valueOf(l));
                    return true;
                }
                case '\u000b': {
                    ormUjo.writeValue(key, String.valueOf(l));
                    return true;
                }
            }
            return false;
        }
        for (int i = 0; i < n; ++i) {
            MetaColumn metaColumn = (MetaColumn)COLUMNS.getItem((Ujo)this, i);
            Key key = metaColumn.getProperty();
            if (key.of((Ujo)ormUjo) != null) continue;
            String string = "Table " + ormUjo + " must have defined only one primary key type of Long, Integer, Short, Byte, BigInteger or String for an auto-increment support";
            throw new IllegalArgumentException(string);
        }
        return false;
    }

    public MetaColumn getFirstColumn() {
        return this.getColumn(0);
    }

    public MetaColumn getColumn(int n) {
        return (MetaColumn)((List)COLUMNS.of((Ujo)this)).get(n);
    }

    public int getCount() {
        return COLUMNS.getItemCount((Ujo)this);
    }

    static {
        fa.lock();
    }
}

