/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.utility;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.UjoProperty;
import org.ujorm.core.UjoIterator;
import org.ujorm.criterion.Criterion;
import org.ujorm.orm.ExtendedOrmUjo;
import org.ujorm.orm.ForeignKey;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.Session;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaPKey;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaRelation2Many;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrmTools {
    public static final SerialBlob createBlob(byte[] byArray) {
        try {
            return byArray != null ? new SerialBlob(byArray) : null;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static SerialBlob createBlob(InputStream inputStream) {
        try {
            int n;
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
            while ((n = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            SerialBlob serialBlob = new SerialBlob(byteArrayOutputStream.toByteArray());
            return serialBlob;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Reding error", exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Reding error", iOException);
            }
        }
    }

    public static byte[] getBlobBytes(Blob blob) throws IllegalStateException, IndexOutOfBoundsException {
        try {
            if (blob == null) {
                return null;
            }
            if (blob.length() <= Integer.MAX_VALUE) {
                return blob.getBytes(1L, (int)blob.length());
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Reding error", exception);
        }
        throw new IndexOutOfBoundsException("Length of the result is great than Integer.MAX_VALUE");
    }

    public static InputStream getBlobStream(Blob blob) throws IllegalStateException {
        try {
            return blob.getBinaryStream();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Reding error", exception);
        }
    }

    public static final SerialClob createClob(char[] cArray) {
        try {
            return cArray != null ? new SerialClob(cArray) : null;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static SerialClob createClob(String string) {
        return string != null ? OrmTools.createClob(string.toCharArray()) : null;
    }

    public static SerialClob createClob(Reader reader) {
        try {
            int n;
            char[] cArray = new char[1024];
            CharArrayWriter charArrayWriter = new CharArrayWriter(cArray.length);
            while ((n = reader.read(cArray)) >= 0) {
                charArrayWriter.write(cArray, 0, n);
            }
            SerialClob serialClob = new SerialClob(charArrayWriter.toCharArray());
            return serialClob;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Reader error", exception);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Reader error", iOException);
            }
        }
    }

    public static String getClobString(Clob clob) throws IllegalStateException, IndexOutOfBoundsException {
        try {
            if (clob == null) {
                return null;
            }
            if (clob.length() <= Integer.MAX_VALUE) {
                return clob.getSubString(1L, (int)clob.length());
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Reding error", exception);
        }
        throw new IndexOutOfBoundsException("Length of the result is great than Integer.MAX_VALUE");
    }

    public static char[] getClob(Clob clob) throws IllegalStateException, IndexOutOfBoundsException {
        return clob != null ? OrmTools.getClobString(clob).toCharArray() : null;
    }

    public static void loadLazyValues(OrmUjo ormUjo) {
        OrmTools.loadLazyValues(ormUjo, 1);
    }

    public static void loadLazyValues(OrmUjo ormUjo, int n) {
        if (--n < 0) {
            return;
        }
        for (UjoProperty ujoProperty : ormUjo.readKeys()) {
            Object object;
            if (!ujoProperty.isTypeOf(OrmUjo.class) || (object = ujoProperty.of((Ujo)ormUjo)) == null || n <= 0) continue;
            OrmTools.loadLazyValues((OrmUjo)object, n);
        }
    }

    public static <UJO extends OrmUjo> List<UJO> loadLazyValues(Iterable<UJO> iterable, int n) {
        List<OrmUjo> list = iterable instanceof List ? null : new ArrayList(64);
        for (OrmUjo ormUjo : iterable) {
            OrmTools.loadLazyValues(ormUjo, n);
            if (list == null) continue;
            list.add(ormUjo);
        }
        if (list == null) {
            list = (List)iterable;
        }
        return list;
    }

    public boolean reload(OrmUjo ormUjo, Session session) {
        return session.reload(ormUjo);
    }

    public static <UJO extends ExtendedOrmUjo> List<UJO> loadLazyValuesAsBatch(Iterable<UJO> iterable, Key<UJO, ? extends OrmUjo> key) {
        Object object;
        Object object222;
        ArrayList<ExtendedOrmUjo> arrayList = new ArrayList<ExtendedOrmUjo>(iterable instanceof List ? ((List)iterable).size() : 128);
        HashMap<Object, OrmUjo> hashMap = new HashMap<Object, OrmUjo>(64);
        while (!key.isDirect()) {
            key = ((CompositeKey)key).getFirstKey();
        }
        for (Object object222 : iterable) {
            arrayList.add((ExtendedOrmUjo)object222);
            object = object222.readFK(key);
            if (object == null) continue;
            hashMap.put(((ForeignKey)object).getValue(), null);
        }
        if (arrayList.isEmpty()) {
            return arrayList;
        }
        Session session = ((ExtendedOrmUjo)arrayList.get(0)).readSession();
        object222 = (MetaColumn)session.getHandler().findColumnModel(key, true);
        object = ((MetaColumn)object222).getForeignColumns().get(0);
        Query<OrmUjo> query = session.createQuery(((MetaTable)((MetaColumn)object).getTable()).getType());
        int n = session.getParameters().get(MetaParams.MAX_ITEM_COUNT_4_IN);
        int n2 = hashMap.size();
        ArrayList arrayList2 = new ArrayList(Math.min(n, n2));
        Iterator iterator = hashMap.keySet().iterator();
        for (int i = 1; i <= n2; ++i) {
            arrayList2.add(iterator.next());
            if (i % n != 0 && i != n2) continue;
            query.setCriterion((Criterion<OrmUjo>)Criterion.whereIn((Key)((MetaRelation2Many)((Object)object)).getProperty(), arrayList2));
            for (OrmUjo ormUjo : query) {
                hashMap.put(((MetaColumn)object).getValue(ormUjo), ormUjo);
            }
            arrayList2.clear();
        }
        for (ExtendedOrmUjo extendedOrmUjo : arrayList) {
            ForeignKey foreignKey = extendedOrmUjo.readFK(key);
            if (foreignKey == null) continue;
            extendedOrmUjo.writeSession(null);
            extendedOrmUjo.writeValue(key, hashMap.get(foreignKey.getValue()));
            extendedOrmUjo.writeSession(session);
        }
        return arrayList;
    }

    public static <UJO extends ExtendedOrmUjo> List<UJO> loadLazyValuesAsBatch(Query<UJO> query) {
        List list = ((UjoIterator)query.iterator()).toList();
        List list2 = MetaTable.COLUMNS.getList((Ujo)query.getTableModel());
        for (MetaColumn metaColumn : list2) {
            if (!metaColumn.isForeignKey()) continue;
            OrmTools.loadLazyValuesAsBatch(list, metaColumn.getProperty());
        }
        return list;
    }

    public static Criterion createCriterion(MetaTable metaTable, Criterion criterion, List<Object> list) {
        Criterion criterion2 = criterion;
        if (OrmTools.isFilled(list)) {
            MetaPKey metaPKey = (MetaPKey)((Object)MetaTable.PK.of((Ujo)metaTable));
            if (metaPKey.getCount() != 1) {
                throw new IllegalStateException("There supported only objects with a one primary keys");
            }
            Criterion criterion3 = metaPKey.getFirstColumn().getProperty().whereIn(list);
            criterion2 = criterion2 != null ? criterion2.or(criterion3) : criterion3;
        }
        return criterion2 != null ? criterion2 : metaTable.getFirstPK().getProperty().forNone();
    }

    public static boolean isFilled(CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0;
    }

    public static boolean isFilled(Collection collection) {
        return collection != null && !collection.isEmpty();
    }
}

