/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.UjoManager;
import org.ujorm.core.UjoManagerXML;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.DbProcedure;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;
import org.ujorm.orm.ao.Orm2ddlPolicy;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaProcedure;
import org.ujorm.orm.metaModel.MetaRelation2Many;
import org.ujorm.orm.metaModel.MetaRoot;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmHandler {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(OrmHandler.class);
    private static OrmHandler handler = new OrmHandler();
    private MetaRoot databases = new MetaRoot();
    private MetaRoot configuration;
    private Session session;
    private final HashMap<Key, MetaRelation2Many> propertyMap = new HashMap();
    private final HashMap<Class, MetaTable> entityMap = new HashMap();
    private final HashMap<Class, MetaProcedure> procedureMap = new HashMap();

    public OrmHandler() {
    }

    public <UJO extends OrmUjo> OrmHandler(Class<UJO> clazz) {
        this();
        this.loadDatabase(clazz);
    }

    public <UJO extends OrmUjo> OrmHandler(Class<UJO> ... classArray) {
        this();
        this.loadDatabase(classArray);
    }

    public static OrmHandler getInstance() {
        return handler;
    }

    public Session getDefaultSession() {
        if (this.session == null) {
            this.session = this.createSession();
        }
        return this.session;
    }

    public Session getSession() {
        return this.getDefaultSession();
    }

    public Session createSession() {
        return new Session(this);
    }

    public boolean config(String string) throws IllegalArgumentException {
        try {
            if (string.startsWith("~")) {
                String string2 = System.getProperty("user.home") + string.substring(1);
                return this.config(new File(string2).toURI().toURL(), true);
            }
            return this.config(new URL(string), true);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Configuration file is not valid " + string, malformedURLException);
        }
    }

    public void config(MetaParams metaParams) throws IllegalArgumentException {
        MetaRoot.PARAMETERS.setValue((Ujo)this.databases, (Object)metaParams);
    }

    public void config(MetaRoot metaRoot) throws IllegalArgumentException {
        this.configuration = metaRoot;
        MetaParams metaParams = (MetaParams)((Object)MetaRoot.PARAMETERS.of((Ujo)this.configuration));
        if (metaParams != null) {
            this.config(metaParams);
        }
    }

    public boolean config(URL uRL, boolean bl) throws IllegalArgumentException {
        try {
            MetaRoot metaRoot = (MetaRoot)UjoManagerXML.getInstance().parseXML((InputStream)new BufferedInputStream(uRL.openStream()), MetaRoot.class, (Object)this);
            this.config(metaRoot);
            return true;
        }
        catch (Exception exception) {
            if (bl) {
                throw new IllegalArgumentException("Configuration file is not valid ", exception);
            }
            return false;
        }
    }

    public boolean isPersistent(Key key) {
        boolean bl = key.isTypeOf(List.class) || UjoManager.getInstance().isTransientProperty(key);
        return !bl;
    }

    private <UJO extends OrmUjo> MetaDatabase loadDatabaseInternal(Class<UJO> clazz) {
        String string = clazz.getSimpleName();
        MetaDatabase metaDatabase = this.configuration != null ? this.configuration.removeDb(string) : null;
        UJO UJO = this.getInstance(clazz);
        MetaDatabase metaDatabase2 = new MetaDatabase(this, (OrmUjo)UJO, metaDatabase, this.databases.getDatabaseCount());
        this.databases.add(metaDatabase2);
        return metaDatabase2;
    }

    public final <UJO extends OrmUjo> void loadDatabase(Class<UJO> clazz) {
        this.loadDatabase(new Class[]{clazz});
    }

    public synchronized <UJO extends OrmUjo> void loadDatabase(Class<UJO> ... classArray) {
        File file;
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("The meta-model is locked and can\u00b4t be changed.");
        }
        for (Class<UJO> iOException : classArray) {
            this.loadDatabaseInternal(iOException);
        }
        MetaParams metaParams = this.getParameters();
        Object object = this.propertyMap.values().iterator();
        while (object.hasNext()) {
            MetaRelation2Many string = object.next();
            if (!string.isColumn()) continue;
            ((MetaColumn)string).initTypeCode();
        }
        this.databases.setReadOnly(true);
        Object object2 = object = (Boolean)MetaParams.LOG_METAMODEL_INFO.of((Ujo)metaParams) != false ? Level.INFO : Level.FINE;
        if (LOGGER.isLoggable((Level)object)) {
            String file2 = "DATABASE META-MODEL:\n" + this.getConfig();
            LOGGER.log((Level)object, file2);
        }
        if ((file = (File)MetaParams.SAVE_CONFIG_TO_FILE.of((Ujo)this.getParameters())) != null) {
            try {
                this.databases.print(file);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Can't create configuration " + file, iOException);
            }
        }
        for (MetaDatabase metaDatabase : this.getDatabases()) {
            switch ((Orm2ddlPolicy)((Object)MetaDatabase.ORM2DLL_POLICY.of((Ujo)metaDatabase))) {
                case CREATE_DDL: 
                case CREATE_OR_UPDATE_DDL: 
                case VALIDATE: {
                    metaDatabase.create(this.getDefaultSession());
                }
            }
        }
    }

    private <UJO extends OrmUjo> UJO getInstance(Class<UJO> clazz) {
        try {
            return (UJO)((OrmUjo)clazz.newInstance());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Can't create instance of " + clazz, exception);
        }
    }

    public boolean isReadOnly() {
        List<MetaDatabase> list = this.getDatabases();
        boolean bl = list == null || list.isEmpty() ? false : list.get(0).readOnly();
        return bl;
    }

    public void addProcedureModel(MetaProcedure metaProcedure) {
        this.procedureMap.put(((Key)MetaProcedure.DB_PROPERTY.of((Ujo)metaProcedure)).getType(), metaProcedure);
    }

    public void addTableModel(MetaTable metaTable) {
        this.entityMap.put(metaTable.getType(), metaTable);
    }

    public void addColumnModel(MetaRelation2Many metaRelation2Many) {
        Key key = metaRelation2Many.getKey();
        MetaRelation2Many metaRelation2Many2 = this.findColumnModel(key);
        if (metaRelation2Many2 == null) {
            this.propertyMap.put(key, metaRelation2Many);
        } else {
            Class<OrmUjo> clazz = metaRelation2Many2.getTableClass();
            Class<OrmUjo> clazz2 = metaRelation2Many.getTableClass();
            if (clazz2.isAssignableFrom(clazz)) {
                this.propertyMap.put(key, metaRelation2Many);
            }
        }
    }

    public <T extends Annotation> T findAnnotation(Key key, Class<T> clazz) {
        if (!key.isDirect()) {
            key = ((CompositeKey)key).getFirstKey();
        }
        try {
            for (Field field : this.findColumnModel(key, true).getTableClass().getFields()) {
                if (field.getModifiers() != 25 || field.get(null) != key) continue;
                return field.getAnnotation(clazz);
            }
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Illegal state for: " + key, throwable);
        }
        return null;
    }

    public final MetaRelation2Many findColumnModel(Key key) {
        return this.findColumnModel(key, false);
    }

    public MetaRelation2Many findColumnModel(Key key, boolean bl) throws IllegalArgumentException {
        if (key != null && !key.isDirect()) {
            key = ((CompositeKey)key).getLastKey();
        }
        MetaRelation2Many metaRelation2Many = this.propertyMap.get(key);
        if (bl && metaRelation2Many == null) {
            String string = key != null ? key.toStringFull() : String.valueOf(key);
            throw new IllegalArgumentException("The key " + string + " have got no meta-model.");
        }
        return metaRelation2Many;
    }

    public MetaTable findTableModel(Class<? extends OrmUjo> clazz) throws IllegalStateException {
        MetaTable metaTable = this.entityMap.get(clazz);
        if (metaTable == null) {
            String string = "An entity mapping bug: the " + clazz + " is not mapped to the Database.";
            throw new IllegalStateException(string);
        }
        return metaTable;
    }

    public MetaProcedure findProcedureModel(Class<? extends DbProcedure> clazz) throws IllegalStateException {
        MetaProcedure metaProcedure = this.procedureMap.get(clazz);
        if (metaProcedure == null) {
            String string = "An procedure mapping bug: the " + clazz + " is not mapped to the Database.";
            throw new IllegalStateException(string);
        }
        return metaProcedure;
    }

    public MetaParams getParameters() {
        return (MetaParams)((Object)MetaRoot.PARAMETERS.of((Ujo)this.databases));
    }

    public boolean isDatabaseLoaded() {
        int n = MetaRoot.DATABASES.getItemCount((Ujo)this.databases);
        return n > 0;
    }

    public List<MetaDatabase> getDatabases() {
        return (List)MetaRoot.DATABASES.of((Ujo)this.databases);
    }

    public List<Key> findPropertiesByType(Class clazz) {
        ArrayList<Key> arrayList = new ArrayList<Key>();
        for (Key key : this.propertyMap.keySet()) {
            if (!key.isTypeOf(clazz)) continue;
            arrayList.add(key);
        }
        return arrayList;
    }

    public String getConfig() {
        return this.databases.toString();
    }
}

