/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.ujorm.Ujo;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.Session;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaTable;

public class UjoSequencer {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(UjoSequencer.class);
    protected final MetaTable table;
    protected long sequence = 0L;
    protected long seqLimit = 0L;
    protected long maxValue = 0L;

    public UjoSequencer(MetaTable metaTable) {
        this.table = metaTable;
    }

    public synchronized long nextValue(Session session) {
        if (this.sequence < this.seqLimit) {
            return ++this.sequence;
        }
        MetaDatabase metaDatabase = (MetaDatabase)MetaTable.DATABASE.of((Ujo)this.table);
        Connection connection = null;
        ResultSet resultSet = null;
        String string = null;
        PreparedStatement preparedStatement = null;
        StringBuilder stringBuilder = new StringBuilder(64);
        try {
            connection = session.getSeqConnection(metaDatabase);
            String string2 = metaDatabase.getDialect().printFullTableName(this.getTable(), true, stringBuilder).toString();
            stringBuilder.setLength(0);
            stringBuilder.setLength(0);
            string = metaDatabase.getDialect().printSequenceNextValue(this, stringBuilder).toString();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, string + "; [" + string2 + ']');
            }
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, string2);
            int n = preparedStatement.executeUpdate();
            if (n == 0) {
                stringBuilder.setLength(0);
                Integer n2 = (Integer)MetaParams.SEQUENCE_CACHE.of((Ujo)this.getDatabase().getParams());
                string = metaDatabase.getDialect().printSequenceInit(this, n2.intValue(), n2, stringBuilder).toString();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, string + "; [" + string2 + ']');
                }
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setString(1, string2);
                preparedStatement.executeUpdate();
            }
            stringBuilder.setLength(0);
            string = metaDatabase.getDialect().printSequenceCurrentValue(this, stringBuilder).toString();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, string + "; [" + string2 + ']');
            }
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, string2);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            this.seqLimit = resultSet.getLong(1);
            int n3 = resultSet.getInt(2);
            this.maxValue = resultSet.getLong(3);
            this.sequence = this.seqLimit - (long)n3 + 1L;
            if (this.maxValue != 0L) {
                if (this.seqLimit > this.maxValue) {
                    this.seqLimit = this.maxValue;
                    if (this.sequence > this.maxValue) {
                        String string3 = "The sequence '" + string2 + "' needs to raise the maximum value: " + this.maxValue;
                        throw new IllegalStateException(string3);
                    }
                    preparedStatement.close();
                    string = metaDatabase.getDialect().printSequenceNextValue(this, stringBuilder).toString();
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, string + "; [" + string2 + ']');
                    }
                    preparedStatement = connection.prepareStatement(string);
                    preparedStatement.setString(1, string2);
                    preparedStatement.execute();
                }
                if (this.maxValue > Long.MAX_VALUE - (long)n3) {
                    String string4 = "The sequence attribute '" + string2 + ".maxValue' is too hight," + " the recommended maximal value is: " + (Long.MAX_VALUE - (long)n3) + " (Long.MAX_VALUE-step)";
                    LOGGER.log(Level.WARNING, string4);
                }
            }
            connection.commit();
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.log(Level.WARNING, "Rollback fails");
                    }
                }
                IllegalStateException illegalStateException = throwable instanceof IllegalStateException ? (IllegalStateException)throwable : new IllegalStateException("ILLEGAL SQL: " + string, throwable);
                throw illegalStateException;
            }
            catch (Throwable throwable2) {
                MetaDatabase.close(null, preparedStatement, resultSet, true);
                throw throwable2;
            }
        }
        MetaDatabase.close(null, preparedStatement, resultSet, true);
        return this.sequence;
    }

    public String getDatabaseSchema() {
        return (String)MetaDatabase.SCHEMA.of((Ujo)this.getDatabase());
    }

    public int getIncrement() {
        int n = (Integer)MetaParams.SEQUENCE_CACHE.of((Ujo)this.table.getDatabase().getParams());
        return n;
    }

    public int getInitDbCache() {
        return 1;
    }

    public MetaDatabase getDatabase() {
        return (MetaDatabase)MetaTable.DATABASE.of((Ujo)this.table);
    }

    public MetaTable getTable() {
        return this.table;
    }

    public boolean isSequenceTableRequired() {
        return true;
    }
}

