/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.UjoIterator;
import org.ujorm.core.UjoManager;
import org.ujorm.criterion.BinaryCriterion;
import org.ujorm.criterion.Criterion;
import org.ujorm.criterion.ValueCriterion;
import org.ujorm.implementation.orm.RelationToMany;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.CriterionDecoder;
import org.ujorm.orm.DbProcedure;
import org.ujorm.orm.ExtendedOrmUjo;
import org.ujorm.orm.ForeignKey;
import org.ujorm.orm.JdbcStatement;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.Transaction;
import org.ujorm.orm.ao.CacheKey;
import org.ujorm.orm.ao.CachePolicy;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaPKey;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaProcedure;
import org.ujorm.orm.metaModel.MetaRelation2Many;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session {
    private static final String SQL_VALUES = "-- SQL VALUES: ";
    public static final String SQL_ILLEGAL = "ILLEGAL SQL: ";
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(Session.class);
    private final OrmHandler handler;
    private final MetaParams params;
    private final HashMap<MetaDatabase, Connection>[] connections = new HashMap[]{new HashMap(2), new HashMap(2)};
    private Map<CacheKey, OrmUjo> cache;
    private boolean rollbackOnly = false;
    private boolean lazyLoadingEnabled;
    private boolean closed = false;
    private Transaction transaction;

    Session(OrmHandler ormHandler) {
        this.handler = ormHandler;
        this.params = ormHandler.getParameters();
        this.lazyLoadingEnabled = (Boolean)MetaParams.LAZY_LOADING_ENABLED.of((Ujo)this.params);
        this.clearCache((CachePolicy)((Object)MetaParams.CACHE_POLICY.of((Ujo)this.params)));
    }

    public Transaction beginTransaction() throws IllegalStateException {
        this.transaction = new Transaction(this, this.transaction);
        return this.transaction;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public final OrmHandler getHandler() {
        return this.handler;
    }

    public void commitTransaction() {
        if (this.transaction != null) {
            this.transaction.commit();
        } else {
            LOGGER.log(Level.WARNING, "Transaction is not running");
            this.commit();
        }
    }

    public void commit() {
        this.commit(true);
    }

    public void rollbackTransaction() {
        if (this.transaction != null) {
            this.transaction.rollback();
        } else {
            LOGGER.log(Level.WARNING, "Transaction is not running");
            this.rollback();
        }
    }

    public final void rollback() {
        this.commit(false);
    }

    public final void commit(boolean bl) throws IllegalStateException {
        this.commit(bl, null);
    }

    void commit(boolean bl, Transaction transaction) throws IllegalStateException {
        if (bl && this.rollbackOnly) {
            this.commit(false);
            throw new IllegalStateException("The Ujorm session has got the 'rollbackOnly' state.");
        }
        Savepoint[] savepointArray = transaction != null ? transaction.getSavepoints() : null;
        Object object = null;
        try {
            Object[] objectArray = this.connections[0].keySet().toArray(new MetaDatabase[this.connections[0].size()]);
            if (objectArray.length > 1) {
                Arrays.sort(objectArray);
            }
            Level level = Level.FINE;
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2;
                object = objectArray[i];
                Connection connection = this.connections[0].get(object);
                if (bl) {
                    object2 = null;
                    if (savepointArray != null) {
                        Savepoint savepoint = savepointArray[i];
                        if (savepoint != null) {
                            ((MetaDatabase)object).getDialect().releaseSavepoint(connection, savepoint, false);
                        }
                        if (transaction.isRoot()) {
                            object2 = "Transaction commit of the ";
                        }
                    } else {
                        object2 = "Commit of the ";
                    }
                    if (object2 == null) continue;
                    connection.commit();
                    if (!LOGGER.isLoggable(level)) continue;
                    LOGGER.log(level, (String)object2 + ((MetaDatabase)object).getId());
                    continue;
                }
                if (savepointArray != null) {
                    object2 = savepointArray[i];
                    if (object2 != null) {
                        connection.rollback((Savepoint)object2);
                        ((MetaDatabase)object).getDialect().releaseSavepoint(connection, (Savepoint)object2, true);
                    }
                } else {
                    connection.rollback();
                }
                if (!LOGGER.isLoggable(level)) continue;
                LOGGER.log(level, "Rolback of the " + ((MetaDatabase)object).getId());
            }
            this.transaction = transaction != null ? transaction.getParent() : null;
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.SEVERE, "Can't make commit of DB " + object, throwable);
            throw new IllegalStateException("Can't make commit of DB " + object, throwable);
        }
        this.rollbackOnly = false;
    }

    Savepoint[] setSavepoint() {
        Savepoint[] savepointArray;
        if (this.rollbackOnly) {
            throw new IllegalStateException("The Ujorm session has got the 'rollbackOnly' state.");
        }
        Object object = null;
        try {
            Object[] objectArray = this.connections[0].keySet().toArray(new MetaDatabase[this.connections[0].size()]);
            savepointArray = new Savepoint[objectArray.length];
            if (objectArray.length > 1) {
                Arrays.sort(objectArray);
            }
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                Connection connection = this.connections[0].get(object);
                savepointArray[i] = connection.setSavepoint();
            }
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.SEVERE, "Can't save a savepoint to DB " + object, throwable);
            throw new IllegalStateException("Can't save a savepoint to DB " + object, throwable);
        }
        this.rollbackOnly = false;
        return savepointArray;
    }

    public <UJO extends OrmUjo> Query<UJO> createQuery(Class<UJO> clazz) {
        Criterion criterion = Criterion.where((boolean)true);
        return this.createQuery(criterion, clazz);
    }

    @Deprecated
    public final <UJO extends OrmUjo> Query<UJO> createQuery(Class<UJO> clazz, Criterion<UJO> criterion) {
        return this.createQuery(criterion, clazz);
    }

    public final <UJO extends OrmUjo> Query<UJO> createQuery(Criterion<UJO> criterion, Class<UJO> clazz) {
        MetaTable metaTable = this.handler.findTableModel(clazz);
        return new Query<UJO>(metaTable, criterion, this);
    }

    public final <UJO extends OrmUjo> Query<UJO> createQuery(Criterion<UJO> criterion) {
        MetaRelation2Many metaRelation2Many = this.getBasicColumn(criterion);
        MetaTable metaTable = (MetaTable)MetaRelation2Many.TABLE.of((Ujo)metaRelation2Many);
        return new Query<UJO>(metaTable, criterion, this);
    }

    public MetaRelation2Many getBasicColumn(Criterion criterion) {
        while (criterion.isBinary()) {
            criterion = ((BinaryCriterion)criterion).getLeftNode();
        }
        ValueCriterion valueCriterion = (ValueCriterion)criterion;
        if (valueCriterion.getLeftNode() == null) {
            return null;
        }
        Key key = valueCriterion.getLeftNode();
        while (!key.isDirect()) {
            key = ((CompositeKey)key).getFirstKey();
        }
        MetaRelation2Many metaRelation2Many = this.handler.findColumnModel(key, true);
        return metaRelation2Many;
    }

    public final <DB extends OrmUjo> DB getFirstDatabase() {
        return this.getDatabase(null);
    }

    public <DB extends OrmUjo> DB getDatabase(Class<DB> clazz) {
        try {
            OrmUjo ormUjo = clazz != null ? (OrmUjo)clazz.newInstance() : (OrmUjo)MetaDatabase.ROOT.of((Ujo)this.handler.getDatabases().get(0));
            ormUjo.writeSession(this);
            return (DB)ormUjo;
        }
        catch (Exception exception) {
            throw new RuntimeException("Can't create database from: " + clazz);
        }
    }

    public void saveOrUpdate(OrmUjo ormUjo) throws IllegalStateException {
        this.checkNotNull(ormUjo, "saveOrUpdate");
        if (ormUjo.readSession() == null) {
            this.save(ormUjo);
        } else {
            this.update(ormUjo);
        }
    }

    private MetaTable modifyParent(OrmUjo ormUjo) {
        OrmUjo ormUjo2;
        MetaTable metaTable = this.handler.findTableModel(ormUjo.getClass());
        if (((Boolean)MetaParams.INHERITANCE_MODE.of((Ujo)this.params)).booleanValue() && (ormUjo2 = metaTable.getParent(ormUjo)) != null) {
            this.saveOrUpdate(ormUjo2);
        }
        return metaTable;
    }

    public void save(List<? extends OrmUjo> list) throws IllegalStateException {
        int n = this.params.get(MetaParams.INSERT_MULTIROW_ITEM_LIMIT);
        this.save(list, n);
    }

    /*
     * WARNING - void declaration
     */
    public void save(List<? extends OrmUjo> list, int n) throws IllegalStateException {
        Object object;
        if (list == null || list.isEmpty()) {
            LOGGER.log(Level.INFO, "The multi insert list is empty");
            return;
        }
        MetaTable metaTable = this.handler.findTableModel(list.get(0).getClass());
        MetaDatabase metaDatabase = (MetaDatabase)MetaTable.DATABASE.of((Ujo)metaTable);
        int n2 = list.size();
        metaTable.assertChangeAllowed();
        if (!metaDatabase.getDialect().isMultiRowInsertSupported()) {
            for (OrmUjo ormUjo : list) {
                this.save(ormUjo);
            }
            return;
        }
        boolean bl = (Boolean)MetaParams.INHERITANCE_MODE.of((Ujo)this.params);
        for (OrmUjo n4 : list) {
            if (bl && (object = metaTable.getParent(n4)) != null) {
                this.saveOrUpdate((OrmUjo)object);
            }
            metaTable.assignPrimaryKey(n4, this);
            n4.writeSession(this);
        }
        n = this.between(n, 1, n2);
        boolean n3 = false;
        int n4 = n;
        object = null;
        String string = "";
        StringBuilder stringBuilder = new StringBuilder(256);
        try {
            int n5;
            void var7_11;
            while (var7_11 < n5) {
                stringBuilder.setLength(0);
                string = metaDatabase.getDialect().printInsert(list, (int)var7_11, n5, stringBuilder).toString();
                LOGGER.log(Level.INFO, string);
                object = this.getStatement(metaDatabase, string, true);
                ((JdbcStatement)object).assignValues(list, (int)var7_11, n5);
                LOGGER.log(Level.FINE, SQL_VALUES + ((JdbcStatement)object).getAssignedValues());
                ((JdbcStatement)object).executeUpdate();
                MetaDatabase.close(null, (JdbcStatement)object, null, true);
                object = null;
                var7_11 = n5;
                n5 = this.between((int)(var7_11 + n), (int)var7_11, n2);
            }
        }
        catch (Throwable throwable) {
            this.rollbackOnly = true;
            throw new IllegalStateException(SQL_ILLEGAL + string, throwable);
        }
        finally {
            MetaDatabase.close(null, (JdbcStatement)object, null, true);
        }
    }

    private int between(int n, int n2, int n3) {
        if (n < n2) {
            n = n2;
        } else if (n > n3) {
            n = n3;
        }
        return n;
    }

    public void save(OrmUjo ormUjo) throws IllegalStateException {
        this.checkNotNull(ormUjo, "save");
        JdbcStatement jdbcStatement = null;
        String string = "";
        try {
            MetaTable metaTable = this.modifyParent(ormUjo);
            metaTable.assertChangeAllowed();
            metaTable.assignPrimaryKey(ormUjo, this);
            ormUjo.writeSession(this);
            MetaDatabase metaDatabase = (MetaDatabase)MetaTable.DATABASE.of((Ujo)metaTable);
            string = metaDatabase.getDialect().printInsert(ormUjo, this.out(128)).toString();
            LOGGER.log(Level.INFO, string);
            jdbcStatement = this.getStatement(metaDatabase, string, true);
            jdbcStatement.assignValues(ormUjo);
            LOGGER.log(Level.INFO, SQL_VALUES + jdbcStatement.getAssignedValues());
            jdbcStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            try {
                this.rollbackOnly = true;
                throw new IllegalStateException(SQL_ILLEGAL + string, throwable);
            }
            catch (Throwable throwable2) {
                MetaDatabase.close(null, jdbcStatement, null, true);
                throw throwable2;
            }
        }
        MetaDatabase.close(null, jdbcStatement, null, true);
    }

    public int update(OrmUjo ormUjo) throws IllegalStateException {
        return this.update(ormUjo, this.createPkCriterion(ormUjo), true);
    }

    public int update(OrmUjo ormUjo, Criterion criterion) {
        return this.update(ormUjo, criterion, false);
    }

    private int update(OrmUjo ormUjo, Criterion criterion, boolean bl) {
        List<MetaColumn> list;
        MetaDatabase metaDatabase;
        MetaTable metaTable;
        String string;
        JdbcStatement jdbcStatement;
        int n;
        block6: {
            this.checkNotNull(ormUjo, "update");
            n = 0;
            jdbcStatement = null;
            string = null;
            metaTable = bl ? this.modifyParent(ormUjo) : this.handler.findTableModel(ormUjo.getClass());
            metaTable.assertChangeAllowed();
            metaDatabase = (MetaDatabase)MetaTable.DATABASE.of((Ujo)metaTable);
            list = this.getOrmColumns(ormUjo.readChangedProperties(true));
            if (!list.isEmpty()) break block6;
            LOGGER.log(Level.WARNING, "No changes to update in the object: " + ormUjo);
            int n2 = n;
            MetaDatabase.close(null, jdbcStatement, null, true);
            return n2;
        }
        try {
            CriterionDecoder criterionDecoder = new CriterionDecoder(criterion, metaTable);
            string = metaDatabase.getDialect().printUpdate(list, criterionDecoder, this.out(64)).toString();
            jdbcStatement = this.getStatement(metaDatabase, string, true);
            jdbcStatement.assignValues(ormUjo, list);
            jdbcStatement.assignValues(criterionDecoder);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, string + " " + SQL_VALUES + jdbcStatement.getAssignedValues());
            }
            n = jdbcStatement.executeUpdate();
            ormUjo.writeSession(this);
        }
        catch (Throwable throwable) {
            try {
                this.rollbackOnly = true;
                MetaDatabase.close(null, jdbcStatement, null, false);
                throw new IllegalStateException(SQL_ILLEGAL + string, throwable);
            }
            catch (Throwable throwable2) {
                MetaDatabase.close(null, jdbcStatement, null, true);
                throw throwable2;
            }
        }
        MetaDatabase.close(null, jdbcStatement, null, true);
        return n;
    }

    public <UJO extends OrmUjo> int delete(Criterion<UJO> criterion) {
        MetaRelation2Many metaRelation2Many = this.getBasicColumn(criterion);
        MetaTable metaTable = (MetaTable)MetaRelation2Many.TABLE.of((Ujo)metaRelation2Many);
        return this.delete(metaTable, criterion);
    }

    public int delete(OrmUjo ormUjo) {
        OrmUjo ormUjo2;
        this.checkNotNull(ormUjo, "delete");
        MetaTable metaTable = this.handler.findTableModel(ormUjo.getClass());
        metaTable.assertChangeAllowed();
        MetaColumn metaColumn = metaTable.getFirstPK();
        Criterion criterion = Criterion.where((Key)metaColumn.getKey(), (Object)metaColumn.getValue(ormUjo));
        int n = this.delete(metaTable, criterion);
        this.removeCache(ormUjo, (MetaPKey)((Object)MetaTable.PK.of((Ujo)metaTable)));
        if (((Boolean)MetaParams.INHERITANCE_MODE.of((Ujo)this.params)).booleanValue() && (ormUjo2 = metaTable.getParent(ormUjo)) != null) {
            this.delete(ormUjo2);
        }
        return n;
    }

    public <UJO extends OrmUjo> int delete(Class<UJO> clazz, Criterion<UJO> criterion) {
        MetaTable metaTable = this.handler.findTableModel(clazz);
        return this.delete(metaTable, criterion);
    }

    protected <UJO extends OrmUjo> int delete(MetaTable metaTable, Criterion<UJO> criterion) {
        metaTable.assertChangeAllowed();
        int n = 0;
        JdbcStatement jdbcStatement = null;
        String string = "";
        try {
            MetaDatabase metaDatabase = (MetaDatabase)MetaTable.DATABASE.of((Ujo)metaTable);
            CriterionDecoder criterionDecoder = new CriterionDecoder(criterion, metaTable);
            string = metaDatabase.getDialect().printDelete(criterionDecoder, this.out(64)).toString();
            jdbcStatement = this.getStatement(metaDatabase, string, true);
            jdbcStatement.assignValues(criterionDecoder);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, string + SQL_VALUES + jdbcStatement.getAssignedValues());
            }
            n = jdbcStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            try {
                this.rollbackOnly = true;
                MetaDatabase.close(null, jdbcStatement, null, false);
                throw new IllegalStateException(SQL_ILLEGAL + string, throwable);
            }
            catch (Throwable throwable2) {
                MetaDatabase.close(null, jdbcStatement, null, true);
                throw throwable2;
            }
        }
        MetaDatabase.close(null, jdbcStatement, null, true);
        return n;
    }

    protected void call(DbProcedure dbProcedure) {
        JdbcStatement jdbcStatement = null;
        String string = "";
        MetaDatabase metaDatabase = dbProcedure.metaProcedure.getDatabase();
        MetaProcedure metaProcedure = dbProcedure.metaProcedure();
        try {
            string = metaDatabase.getDialect().printCall(metaProcedure, this.out(64)).toString();
            jdbcStatement = this.getStatementCallable(metaDatabase, string, true);
            jdbcStatement.assignValues(dbProcedure);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, string + " " + SQL_VALUES + jdbcStatement.getAssignedValues());
            }
            jdbcStatement.execute();
            jdbcStatement.loadValues(dbProcedure);
        }
        catch (Throwable throwable) {
            try {
                this.rollbackOnly = true;
                MetaDatabase.close(null, jdbcStatement, null, false);
                throw new IllegalStateException(SQL_ILLEGAL + string, throwable);
            }
            catch (Throwable throwable2) {
                MetaDatabase.close(null, jdbcStatement, null, true);
                throw throwable2;
            }
        }
        MetaDatabase.close(null, jdbcStatement, null, true);
    }

    protected List<MetaColumn> getOrmColumns(Key ... keyArray) {
        ArrayList<MetaColumn> arrayList = new ArrayList<MetaColumn>(keyArray.length);
        for (Key key : keyArray) {
            MetaRelation2Many metaRelation2Many = this.handler.findColumnModel(key);
            if (!(metaRelation2Many instanceof MetaColumn)) continue;
            arrayList.add((MetaColumn)metaRelation2Many);
        }
        return arrayList;
    }

    protected Criterion createPkCriterion(OrmUjo ormUjo) {
        Criterion criterion = null;
        MetaTable metaTable = this.handler.findTableModel(ormUjo.getClass());
        MetaPKey metaPKey = (MetaPKey)((Object)MetaTable.PK.of((Ujo)metaTable));
        List list = (List)MetaPKey.COLUMNS.of((Ujo)metaPKey);
        for (MetaColumn metaColumn : list) {
            Criterion criterion2 = Criterion.where((Key)metaColumn.getKey(), (Object)metaColumn.getValue(ormUjo));
            criterion = criterion != null ? criterion.and(criterion2) : criterion2;
        }
        return criterion != null ? criterion : Criterion.where((boolean)false);
    }

    public <UJO extends OrmUjo> long getRowCount(Query<UJO> query) {
        long l = -1L;
        JdbcStatement jdbcStatement = null;
        ResultSet resultSet = null;
        MetaTable metaTable = query.getTableModel();
        MetaDatabase metaDatabase = (MetaDatabase)MetaTable.DATABASE.of((Ujo)metaTable);
        String string = "";
        try {
            string = metaDatabase.getDialect().printSelect(metaTable, query, true, this.out(128)).toString();
            LOGGER.log(Level.INFO, string);
            jdbcStatement = this.getStatement(metaDatabase, string, false);
            jdbcStatement.assignValues(query);
            LOGGER.log(Level.INFO, SQL_VALUES + jdbcStatement.getAssignedValues());
            resultSet = jdbcStatement.executeQuery();
            l = resultSet.next() ? resultSet.getLong(1) : 0L;
        }
        catch (Exception exception) {
            try {
                this.rollbackOnly = true;
                throw new RuntimeException(SQL_ILLEGAL + string, exception);
            }
            catch (Throwable throwable) {
                MetaDatabase.close(null, jdbcStatement, resultSet, false);
                throw throwable;
            }
        }
        MetaDatabase.close(null, jdbcStatement, resultSet, false);
        return l;
    }

    public JdbcStatement getStatement(Query query) {
        JdbcStatement jdbcStatement = null;
        String string = "";
        try {
            MetaTable metaTable = query.getTableModel();
            MetaDatabase metaDatabase = (MetaDatabase)MetaTable.DATABASE.of((Ujo)metaTable);
            string = metaDatabase.getDialect().printSelect(metaTable, query, false, this.out(360)).toString();
            query.setStatementInfo(string);
            jdbcStatement = this.getStatement(metaDatabase, string, false);
            if (query.getLimit() >= 0) {
                jdbcStatement.getPreparedStatement().setMaxRows(query.getLimit());
            }
            if (query.getFetchSize() >= 0) {
                jdbcStatement.getPreparedStatement().setFetchSize(query.getFetchSize());
            }
            jdbcStatement.assignValues(query);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, string + " " + SQL_VALUES + jdbcStatement.getAssignedValues());
            }
            return jdbcStatement;
        }
        catch (Throwable throwable) {
            this.rollbackOnly = true;
            throw new IllegalStateException(SQL_ILLEGAL + string, throwable);
        }
    }

    private MetaColumn findOrmColumn(MetaTable metaTable, Class clazz) {
        for (MetaColumn metaColumn : (List)MetaTable.COLUMNS.of((Ujo)metaTable)) {
            if (!metaColumn.isForeignKey() || metaColumn.getType() != clazz) continue;
            return metaColumn;
        }
        return null;
    }

    public <UJO extends OrmUjo> UjoIterator<UJO> iterateInternal(RelationToMany relationToMany, OrmUjo ormUjo) {
        MetaTable metaTable;
        Class clazz = relationToMany.getItemType();
        MetaTable metaTable2 = this.handler.findTableModel(clazz);
        MetaColumn metaColumn = this.findOrmColumn(metaTable2, ormUjo.getClass());
        if (metaColumn == null && (metaTable = this.handler.findTableModel(ormUjo.getClass())).isPersistent()) {
            String string = "Can't find a foreign key of " + metaTable2 + " to a " + ormUjo.getClass().getSimpleName();
            throw new IllegalStateException(string);
        }
        metaTable = metaColumn != null ? Criterion.where((Key)metaColumn.getKey(), (Object)ormUjo) : Criterion.constant((Key)metaTable2.getFirstPK().getKey(), (boolean)true);
        Query<OrmUjo> query = this.createQuery((Criterion<UJO>)metaTable, (Class<UJO>)metaTable2.getType());
        UjoIterator<OrmUjo> ujoIterator = UjoIterator.getInstance(query);
        return ujoIterator;
    }

    private Connection getConnection_(MetaDatabase metaDatabase, int n) throws IllegalStateException {
        Connection connection = this.connections[n].get(metaDatabase);
        if (connection == null) {
            this.assertOpenSession();
            try {
                connection = metaDatabase.createConnection();
            }
            catch (Exception exception) {
                throw new IllegalStateException("Can't create an connection for " + metaDatabase, exception);
            }
            this.connections[n].put(metaDatabase, connection);
        }
        return connection;
    }

    public final Connection getFirstConnection() throws IllegalStateException {
        return this.getFirstConnection(true);
    }

    public final Connection getFirstConnection(boolean bl) throws IllegalStateException {
        return this.getConnection(0, bl);
    }

    public final Connection getConnection(int n, boolean bl) throws IllegalStateException {
        MetaDatabase metaDatabase = this.handler.getDatabases().get(n);
        return this.getConnection(metaDatabase, bl);
    }

    public final Connection getConnection(MetaDatabase metaDatabase, boolean bl) throws IllegalStateException {
        Connection connection = this.getConnection_(metaDatabase, 0);
        if (this.transaction != null && bl) {
            this.transaction.assignSavepoint(metaDatabase, connection);
        }
        return connection;
    }

    final Connection getSeqConnection(MetaDatabase metaDatabase) throws IllegalStateException {
        return this.getConnection_(metaDatabase, 1);
    }

    public JdbcStatement getStatement(MetaDatabase metaDatabase, CharSequence charSequence, boolean bl) throws SQLException {
        JdbcStatement jdbcStatement = new JdbcStatement(this.getConnection(metaDatabase, bl), charSequence, this.handler);
        return jdbcStatement;
    }

    public JdbcStatement getStatementCallable(MetaDatabase metaDatabase, String string, boolean bl) throws SQLException {
        JdbcStatement jdbcStatement = new JdbcStatement(this.getConnection(metaDatabase, bl).prepareCall(string), this.handler);
        return jdbcStatement;
    }

    public <UJO extends OrmUjo> UJO load(Class<UJO> clazz, Object object) throws NoSuchElementException {
        MetaTable metaTable = this.handler.findTableModel(clazz);
        MetaColumn metaColumn = metaTable.getFirstPK();
        UjoManager.getInstance();
        UjoManager.assertAssign((Key)((Key)MetaColumn.TABLE_KEY.of((Ujo)metaColumn)), (Object)object);
        Criterion criterion = Criterion.where((Key)metaColumn.getKey(), (Object)object);
        Query<UJO> query = this.createQuery(criterion);
        UJO UJO = query.uniqueResult();
        return UJO;
    }

    public <UJO extends OrmUjo> UJO loadInternal(Key key, Object object, boolean bl) throws NoSuchElementException {
        Object object2;
        this.assertOpenSession();
        MetaColumn metaColumn = (MetaColumn)this.handler.findColumnModel(key, true);
        List<MetaColumn> list = metaColumn.getForeignColumns();
        if (list.size() != 1) {
            throw new UnsupportedOperationException("There is supported only a one-column foreign key: " + metaColumn);
        }
        MetaTable metaTable = null;
        if (this.cache != null && (object2 = this.findCache((Class)(metaTable = (MetaTable)MetaColumn.TABLE.of((Ujo)list.get(0))).getType(), object)) != null) {
            return (UJO)object2;
        }
        object2 = Criterion.where((Key)list.get(0).getKey(), (Object)object);
        UJO UJO = this.createQuery((Criterion<UJO>)object2).uniqueResult();
        if (bl && UJO == null) {
            throw new RuntimeException("Deleted object for key " + object);
        }
        if (this.cache != null) {
            this.addCache((OrmUjo)UJO, (MetaPKey)((Object)MetaTable.PK.of((Ujo)metaTable)));
        }
        return UJO;
    }

    public void close() throws IllegalStateException {
        this.closed = true;
        this.cache = null;
        Throwable throwable = null;
        MetaDatabase metaDatabase = null;
        String string = "Can't close connection for DB ";
        for (HashMap<MetaDatabase, Connection> hashMap : this.connections) {
            for (MetaDatabase metaDatabase2 : hashMap.keySet()) {
                try {
                    Connection connection = hashMap.get(metaDatabase2);
                    if (connection == null) continue;
                    connection.rollback();
                    connection.close();
                }
                catch (Throwable throwable2) {
                    LOGGER.log(Level.SEVERE, string + metaDatabase2, throwable2);
                    if (throwable != null) continue;
                    throwable = throwable2;
                    metaDatabase = metaDatabase2;
                }
            }
            hashMap.clear();
        }
        if (throwable != null) {
            throw new IllegalStateException(string + metaDatabase, throwable);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void assertOpenSession() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed (" + this.hashCode() + ")");
        }
    }

    private StringBuilder out(int n) {
        return new StringBuilder(n);
    }

    private void addCache(OrmUjo ormUjo, MetaPKey metaPKey) {
        CacheKey cacheKey = CacheKey.newInstance(ormUjo, metaPKey);
        this.cache.put(cacheKey, ormUjo);
    }

    private boolean removeCache(OrmUjo ormUjo, MetaPKey metaPKey) {
        CacheKey cacheKey = CacheKey.newInstance(ormUjo, metaPKey);
        OrmUjo ormUjo2 = this.cache.remove(cacheKey);
        return ormUjo2 != null;
    }

    public OrmUjo findCache(Class clazz, Object object) {
        this.assertOpenSession();
        CacheKey cacheKey = CacheKey.newInstance(clazz, object);
        return this.cache.get(cacheKey);
    }

    public OrmUjo findCache(Class clazz, Object ... objectArray) {
        this.assertOpenSession();
        CacheKey cacheKey = CacheKey.newInstance(clazz, objectArray);
        return this.cache.get(cacheKey);
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public final void clearCache(CachePolicy cachePolicy) {
        this.assertOpenSession();
        switch (cachePolicy) {
            case PROTECTED_CACHE: {
                this.cache = new WeakHashMap<CacheKey, OrmUjo>();
                break;
            }
            case SOLID_CACHE: {
                this.cache = new HashMap<CacheKey, OrmUjo>();
                break;
            }
            case NO_CACHE: {
                this.cache = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported cache policy: " + (Object)((Object)cachePolicy));
            }
        }
    }

    public final MetaParams getParameters() {
        return this.params;
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly || this.transaction != null && this.transaction.getStatus() == 4;
    }

    public void markForRolback() {
        this.rollbackOnly = true;
    }

    public ForeignKey readFK(OrmUjo ormUjo, Key<?, ? extends OrmUjo> key) throws IllegalStateException {
        MetaColumn metaColumn = (MetaColumn)this.handler.findColumnModel(key);
        if (metaColumn != null && metaColumn.isForeignKey()) {
            Object object = metaColumn.getForeignColumns().get(0).getKey().of((Ujo)ormUjo);
            return new ForeignKey(object);
        }
        String string = ormUjo.getClass().getSimpleName() + "." + key;
        throw new IllegalStateException("The property '" + string + "' is not a foreign key");
    }

    public boolean reload(OrmUjo ormUjo) {
        if (ormUjo == null) {
            return false;
        }
        MetaTable metaTable = this.handler.findTableModel(ormUjo.getClass());
        MetaPKey metaPKey = (MetaPKey)((Object)MetaTable.PK.of((Ujo)metaTable));
        boolean bl = ormUjo instanceof ExtendedOrmUjo;
        Criterion criterion = null;
        for (Object object : (List)MetaPKey.COLUMNS.of((Ujo)metaPKey)) {
            Object object2 = Criterion.where((Key)((MetaRelation2Many)((Object)object)).getKey(), (Object)((MetaColumn)object).getValue(ormUjo));
            criterion = criterion != null ? criterion.and((Criterion)object2) : object2;
        }
        Iterator<Object> iterator = this.createQuery(criterion).uniqueResult();
        if (iterator == null) {
            return false;
        }
        ormUjo.writeSession(null);
        for (Object object2 : (List)MetaTable.COLUMNS.of((Ujo)metaTable)) {
            if (bl && ((MetaColumn)object2).isForeignKey()) {
                Key key = ((MetaRelation2Many)((Object)object2)).getKey();
                ormUjo.writeValue(key, ((ExtendedOrmUjo)((Object)iterator)).readFK(key));
                continue;
            }
            if (!((MetaColumn)object2).isColumn()) continue;
            ((MetaRelation2Many)((Object)object2)).getKey().copy(iterator, (Ujo)ormUjo);
        }
        ormUjo.writeSession(this);
        ormUjo.readChangedProperties(true);
        return true;
    }

    public final SqlDialect getDialect(Class<? extends OrmUjo> clazz) {
        return this.handler.findTableModel(clazz).getDatabase().getDialect();
    }

    public boolean hasDialect(Class<? extends OrmUjo> clazz, Class<? extends SqlDialect> ... classArray) {
        SqlDialect sqlDialect = this.handler.findTableModel(clazz).getDatabase().getDialect();
        for (Class<? extends SqlDialect> clazz2 : classArray) {
            if (!clazz2.isInstance(sqlDialect)) continue;
            return true;
        }
        return false;
    }

    public static Session newClosedSession(OrmHandler ormHandler) {
        Session session = new Session(ormHandler);
        session.close();
        return session;
    }

    public boolean isLazyLoadingEnabled() {
        return this.lazyLoadingEnabled;
    }

    public void setLazyLoadingEnabled(boolean bl) {
        this.lazyLoadingEnabled = bl;
    }

    protected void checkNotNull(OrmUjo ormUjo, String string) throws IllegalArgumentException {
        if (ormUjo == null) {
            throw new IllegalArgumentException("A null object can't be used for the action: " + string);
        }
    }
}

