/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.ujorm.Key;
import org.ujorm.ListKey;
import org.ujorm.Ujo;
import org.ujorm.core.KeyFactory;
import org.ujorm.core.UjoManager;
import org.ujorm.core.UjoManagerXML;
import org.ujorm.extensions.UjoTextable;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.AbstractMetaModel;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.utility.OrmTools;

public final class MetaRoot
extends AbstractMetaModel {
    private static final Class<MetaRoot> CLASS = MetaRoot.class;
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(MetaRoot.class);
    private static final KeyFactory<MetaRoot> fa = KeyFactory.CamelBuilder.get(CLASS);
    public static final ListKey<MetaRoot, MetaDatabase> DATABASES = fa.newListKey("database");
    public static final Key<MetaRoot, MetaParams> PARAMETERS = fa.newKey("parameters");

    public MetaRoot() {
        PARAMETERS.setValue((Ujo)this, (Object)new MetaParams());
    }

    public MetaDatabase getDatabase() {
        MetaDatabase metaDatabase = DATABASES.getItemCount((Ujo)this) > 0 ? (MetaDatabase)DATABASES.getItem((Ujo)this, 0) : null;
        return metaDatabase;
    }

    public MetaDatabase getDatabase(String string) {
        for (MetaDatabase metaDatabase : DATABASES.getList((Ujo)this)) {
            if (string != null && !MetaDatabase.SCHEMA.equals((Ujo)metaDatabase, (Object)string)) continue;
            return metaDatabase;
        }
        return null;
    }

    public int getDatabaseCount() {
        return DATABASES.getItemCount((Ujo)this);
    }

    public final void add(MetaDatabase metaDatabase) {
        DATABASES.addItem((Ujo)this, (Object)metaDatabase);
    }

    public String toString() {
        CharArrayWriter charArrayWriter = new CharArrayWriter(128);
        try {
            this.print(charArrayWriter);
            charArrayWriter.append("\n---\n");
        }
        catch (IOException iOException) {
            LOGGER.log(UjoLogger.ERROR, "Can't export model into XML", (Throwable)iOException);
        }
        return charArrayWriter.toString();
    }

    private String getXmlHeader() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm", Locale.ENGLISH);
        String string = new StringBuilder(128).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n<!-- The Ujorm configuration file release ").append(UjoManager.version()).append(" was created ").append(simpleDateFormat.format(new Date())).append(" -->").toString();
        return string;
    }

    public void print(Writer writer) throws IOException {
        UjoManagerXML.getInstance().saveXML(writer, (UjoTextable)this, this.getXmlHeader(), ((Object)((Object)this)).getClass());
    }

    public void print(File file) throws IOException {
        UjoManagerXML.getInstance().saveXML(file, (UjoTextable)this, this.getXmlHeader(), ((Object)((Object)this)).getClass());
    }

    public MetaDatabase removeDb(String string) {
        if (super.readOnly()) {
            throw new UnsupportedOperationException("The internal state is 'read only'");
        }
        if (OrmTools.isFilled(string)) {
            for (MetaDatabase metaDatabase : DATABASES.getList((Ujo)this)) {
                MetaDatabase.ID.of((Ujo)metaDatabase);
                if (!MetaDatabase.ID.equals((Ujo)metaDatabase, (Object)string)) continue;
                DATABASES.getList((Ujo)this).remove(metaDatabase);
                return metaDatabase;
            }
        }
        return null;
    }

    static {
        fa.lock();
    }
}

