/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.ujorm.Ujo;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.Session;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaTable;

public class UjoSequencer {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(UjoSequencer.class);
    public static final int SEQ_LIMIT = 1;
    public static final int SEQ_STEP = 2;
    public static final int SEQ_MAX_VALUE = 3;
    protected final MetaTable table;
    protected long sequence = 0L;
    protected long seqLimit = 0L;
    protected long maxValue = 0L;

    public UjoSequencer(MetaTable metaTable) {
        this.table = metaTable;
    }

    public synchronized long nextValue(Session session) {
        if (this.sequence < this.seqLimit) {
            return ++this.sequence;
        }
        MetaDatabase metaDatabase = (MetaDatabase)MetaTable.DATABASE.of((Ujo)this.table);
        Connection connection = null;
        ResultSet resultSet = null;
        String string = null;
        PreparedStatement preparedStatement = null;
        StringBuilder stringBuilder = new StringBuilder(64);
        try {
            connection = session.getSeqConnection(metaDatabase);
            String string2 = metaDatabase.getDialect().printFullTableName(this.getTable(), true, stringBuilder).toString();
            stringBuilder.setLength(0);
            string = metaDatabase.getDialect().printSequenceNextValue(this, stringBuilder).toString();
            if (LOGGER.isLoggable(UjoLogger.INFO)) {
                LOGGER.log(UjoLogger.INFO, string + "; [" + string2 + ']');
            }
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, string2);
            int n = preparedStatement.executeUpdate();
            if (n == 0) {
                stringBuilder.setLength(0);
                string = metaDatabase.getDialect().printSequenceInit(this, stringBuilder).toString();
                if (LOGGER.isLoggable(UjoLogger.INFO)) {
                    LOGGER.log(UjoLogger.INFO, string + "; [" + string2 + ']');
                }
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setString(1, string2);
                preparedStatement.executeUpdate();
            }
            long[] lArray = this.getCurrentDBSequence(connection, stringBuilder);
            this.seqLimit = lArray[1];
            int n2 = (int)lArray[2];
            this.maxValue = lArray[3];
            this.sequence = this.seqLimit - (long)n2 + 1L;
            if (this.maxValue != 0L) {
                if (this.seqLimit > this.maxValue) {
                    this.seqLimit = this.maxValue;
                    if (this.sequence > this.maxValue) {
                        String string3 = "The sequence '" + string2 + "' needs to raise the maximum value: " + this.maxValue;
                        throw new IllegalStateException(string3);
                    }
                    preparedStatement.close();
                    stringBuilder.setLength(0);
                    string = metaDatabase.getDialect().printSequenceNextValue(this, stringBuilder).toString();
                    if (LOGGER.isLoggable(UjoLogger.INFO)) {
                        LOGGER.log(UjoLogger.INFO, string + "; [" + string2 + ']');
                    }
                    preparedStatement = connection.prepareStatement(string);
                    preparedStatement.setString(1, string2);
                    preparedStatement.execute();
                }
                if (this.maxValue > Long.MAX_VALUE - (long)n2) {
                    String string4 = "The sequence attribute '" + string2 + ".maxValue' is too hight," + " the recommended maximal value is: " + (Long.MAX_VALUE - (long)n2) + " (Long.MAX_VALUE-step)";
                    LOGGER.log(UjoLogger.WARN, string4);
                }
            }
            connection.commit();
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.log(UjoLogger.WARN, "Rollback fails");
                    }
                }
                IllegalStateException illegalStateException = throwable instanceof IllegalStateException ? (IllegalStateException)throwable : new IllegalStateException("ILLEGAL SQL: " + string, throwable);
                throw illegalStateException;
            }
            catch (Throwable throwable2) {
                MetaDatabase.close(null, preparedStatement, resultSet, true);
                throw throwable2;
            }
        }
        MetaDatabase.close(null, preparedStatement, resultSet, true);
        return this.sequence;
    }

    public String getDatabaseSchema() {
        return (String)MetaDatabase.SCHEMA.of((Ujo)this.getDatabase());
    }

    public int getIncrement() {
        int n = (Integer)MetaParams.SEQUENCE_CACHE.of((Ujo)this.table.getDatabase().getParams());
        return n;
    }

    public int getInitDbCache() {
        return 1;
    }

    public MetaDatabase getDatabase() {
        return (MetaDatabase)MetaTable.DATABASE.of((Ujo)this.table);
    }

    public MetaTable getTable() {
        return this.table;
    }

    public boolean isSequenceTableRequired() {
        return true;
    }

    public synchronized void reset() {
        this.sequence = 0L;
        this.seqLimit = 0L;
        this.maxValue = 0L;
    }

    public long[] getCurrentDBSequence(Connection connection, StringBuilder stringBuilder) throws Exception {
        if (stringBuilder != null) {
            stringBuilder.setLength(0);
        } else {
            stringBuilder = new StringBuilder(64);
        }
        MetaDatabase metaDatabase = (MetaDatabase)MetaTable.DATABASE.of((Ujo)this.table);
        String string = metaDatabase.getDialect().printFullTableName(this.getTable(), true, stringBuilder).toString();
        stringBuilder.setLength(0);
        metaDatabase.getDialect().printSequenceCurrentValue(this, stringBuilder);
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            long[] lArray = new long[4];
            lArray[1] = resultSet.getLong(1);
            lArray[2] = resultSet.getLong(2);
            lArray[3] = resultSet.getLong(3);
            return lArray;
        }
        return null;
    }
}

