/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.impl;

import org.ujorm.Key;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.TableWrapper;
import org.ujorm.orm.metaModel.MetaColumn;

public class ColumnWrapperImpl
implements ColumnWrapper {
    private MetaColumn column;
    private TableWrapper table;
    private Key key;

    public ColumnWrapperImpl(MetaColumn metaColumn, TableWrapper tableWrapper) {
        this(metaColumn, tableWrapper, metaColumn.getKey());
    }

    public ColumnWrapperImpl(MetaColumn metaColumn, Key key) {
        this(metaColumn, null, key);
    }

    public ColumnWrapperImpl(MetaColumn metaColumn, TableWrapper tableWrapper, Key key) {
        assert (metaColumn != null) : "The MetaColumn must not be null";
        this.column = metaColumn;
        this.table = tableWrapper != null ? tableWrapper : metaColumn.getTable();
        this.key = key != null ? key : metaColumn.getKey();
    }

    public MetaColumn getModel() {
        return this.column;
    }

    public TableWrapper getTable() {
        return this.table;
    }

    public Key getKey() {
        return this.key;
    }

    public boolean isCompositeKey() {
        return this.key.isComposite();
    }

    public boolean equals(Object object) {
        if (object instanceof ColumnWrapper) {
            Key key = ((ColumnWrapper)object).getKey();
            return this.getKey().getName().equals(key.getName()) && this.getKey().getDomainType() == key.getDomainType();
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().getName().hashCode();
    }

    public String toString() {
        return this.key.toStringFull();
    }
}

