/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ujorm.Key;
import org.ujorm.ListKey;
import org.ujorm.Ujo;
import org.ujorm.core.KeyFactory;
import org.ujorm.core.UjoManager;
import org.ujorm.core.annot.Transient;
import org.ujorm.core.annot.XmlAttribute;
import org.ujorm.implementation.orm.RelationToMany;
import org.ujorm.orm.AbstractMetaModel;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;
import org.ujorm.orm.SqlNameProvider;
import org.ujorm.orm.TableWrapper;
import org.ujorm.orm.UjoSequencer;
import org.ujorm.orm.annot.Comment;
import org.ujorm.orm.annot.Table;
import org.ujorm.orm.annot.View;
import org.ujorm.orm.ao.Orm2ddlPolicy;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaIndex;
import org.ujorm.orm.metaModel.MetaPKey;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaRelation2Many;
import org.ujorm.orm.metaModel.MetaSelect;
import org.ujorm.orm.metaModel.MoreParams;
import org.ujorm.orm.utility.OrmTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaTable
extends AbstractMetaModel
implements TableWrapper {
    private static final Class<MetaTable> CLASS = MetaTable.class;
    private static final KeyFactory<MetaTable> fa = KeyFactory.CamelBuilder.get(CLASS);
    @XmlAttribute
    public static final Key<MetaTable, String> ID = fa.newKey("id", (Object)"");
    public static final Key<MetaTable, String> NAME = fa.newKey("name", (Object)"");
    public static final Key<MetaTable, String> ALIAS = fa.newKey("alias", (Object)"");
    public static final Key<MetaTable, String> SCHEMA = fa.newKey("schema", (Object)"");
    public static final Key<MetaTable, Boolean> READ_ONLY = fa.newKey("readOnly", (Object)false);
    public static final Key<MetaTable, Orm2ddlPolicy> ORM2DLL_POLICY = fa.newKey("orm2ddlPolicy", (Object)Orm2ddlPolicy.INHERITED);
    public static final Key<MetaTable, String> SEQUENCE = fa.newKey("sequence", (Object)"");
    @XmlAttribute
    public static final Key<MetaTable, Boolean> VIEW = fa.newKey("view", (Object)false);
    public static final Key<MetaTable, String> SELECT = fa.newKey("select", (Object)"");
    public static final Key<MetaTable, String> COMMENT = fa.newKey("comment", (Object)"");
    public static final ListKey<MetaTable, MetaColumn> COLUMNS = fa.newListKey("column");
    public static final ListKey<MetaTable, MetaRelation2Many> RELATIONS = fa.newListKey("relation2m");
    @Transient
    public static final Key<MetaTable, MetaSelect> SELECT_MODEL = fa.newKey("selectModel");
    @Transient
    public static final Key<MetaTable, MetaPKey> PK = fa.newKey("pk");
    @Transient
    public static final Key<MetaTable, RelationToMany> DB_PROPERTY = fa.newKey("dbProperty");
    @Transient
    public static final Key<MetaTable, MetaDatabase> DATABASE = fa.newKey("database");
    private final UjoSequencer sequencer;
    private Boolean sequenceSchemaSymbol;

    public MetaTable() {
        this.sequencer = null;
    }

    public MetaTable(MetaDatabase metaDatabase, RelationToMany relationToMany, MetaTable metaTable) {
        Object object;
        Object object2;
        this.sequencer = metaDatabase.createSequencer(this);
        ID.setValue((Ujo)this, (Object)relationToMany.getName());
        DATABASE.setValue((Ujo)this, (Object)metaDatabase);
        DB_PROPERTY.setValue((Ujo)this, (Object)relationToMany);
        Field field = UjoManager.getInstance().getPropertyField((Ujo)MetaDatabase.ROOT.of((Ujo)metaDatabase), (Key)relationToMany);
        View view = field != null ? field.getAnnotation(View.class) : null;
        View view2 = relationToMany.getItemType().getAnnotation(View.class);
        VIEW.setValue((Ujo)this, (Object)(view != null || view2 != null ? 1 : 0));
        if (metaTable != null) {
            this.changeDefault(this, NAME, NAME.of((Ujo)metaTable));
            this.changeDefault(this, ALIAS, ALIAS.of((Ujo)metaTable));
            this.changeDefault(this, SCHEMA, SCHEMA.of((Ujo)metaTable));
            this.changeDefault(this, READ_ONLY, READ_ONLY.of((Ujo)metaTable));
            this.changeDefault(this, ORM2DLL_POLICY, ORM2DLL_POLICY.of((Ujo)metaTable));
            this.changeDefault(this, SEQUENCE, SEQUENCE.of((Ujo)metaTable));
            this.changeDefault(this, SELECT, SELECT.of((Ujo)metaTable));
            this.changeDefault(this, VIEW, VIEW.of((Ujo)metaTable));
            this.changeDefault(this, COMMENT, COMMENT.of((Ujo)metaTable));
        }
        if (((Boolean)VIEW.of((Ujo)this)).booleanValue()) {
            if (view != null) {
                this.changeDefault(this, NAME, view.name());
            }
            if (view != null) {
                this.changeDefault(this, NAME, view.value());
            }
            if (view != null) {
                this.changeDefault(this, ALIAS, view.alias());
            }
            if (view != null) {
                this.changeDefault(this, SCHEMA, view.schema());
            }
            if (view != null) {
                this.changeDefault(this, SELECT, view.select());
            }
            if (view2 != null) {
                this.changeDefault(this, NAME, view2.name());
            }
            if (view2 != null) {
                this.changeDefault(this, NAME, view2.value());
            }
            if (view2 != null) {
                this.changeDefault(this, ALIAS, view2.alias());
            }
            if (view2 != null) {
                this.changeDefault(this, SCHEMA, view2.schema());
            }
            if (view2 != null) {
                this.changeDefault(this, SELECT, view2.select());
            }
        } else {
            object2 = field != null ? field.getAnnotation(Table.class) : null;
            object = relationToMany.getItemType().getAnnotation(Table.class);
            if (object2 != null) {
                this.changeDefault(this, NAME, object2.name());
            }
            if (object2 != null) {
                this.changeDefault(this, NAME, object2.value());
            }
            if (object2 != null) {
                this.changeDefault(this, ALIAS, object2.alias());
            }
            if (object2 != null) {
                this.changeDefault(this, SCHEMA, object2.schema());
            }
            if (object2 != null) {
                this.changeDefault(this, READ_ONLY, object2.readOnly());
            }
            if (object2 != null) {
                this.changeDefault(this, ORM2DLL_POLICY, object2.orm2ddlPolicy());
            }
            if (object2 != null) {
                this.changeDefault(this, SEQUENCE, object2.sequence());
            }
            if (object != null) {
                this.changeDefault(this, NAME, object.name());
            }
            if (object != null) {
                this.changeDefault(this, NAME, object.value());
            }
            if (object != null) {
                this.changeDefault(this, ALIAS, object.alias());
            }
            if (object != null) {
                this.changeDefault(this, SCHEMA, object.schema());
            }
            if (object != null) {
                this.changeDefault(this, READ_ONLY, object.readOnly());
            }
            if (object != null) {
                this.changeDefault(this, ORM2DLL_POLICY, object.orm2ddlPolicy());
            }
            if (object != null) {
                this.changeDefault(this, SEQUENCE, object.sequence());
            }
        }
        this.changeDefault(this, SCHEMA, MetaDatabase.SCHEMA.of((Ujo)metaDatabase));
        this.changeDefault(this, READ_ONLY, MetaDatabase.READ_ONLY.of((Ujo)metaDatabase));
        this.changeDefault(this, ORM2DLL_POLICY, MetaDatabase.ORM2DLL_POLICY.of((Ujo)metaDatabase));
        this.changeDefault(this, NAME, relationToMany.getName());
        object2 = (String)MetaParams.TABLE_ALIAS_PREFIX.of((Ujo)metaDatabase.getParams());
        object = (String)MetaParams.TABLE_ALIAS_SUFFIX.of((Ujo)metaDatabase.getParams());
        this.changeDefault(this, ALIAS, (String)object2 + (String)NAME.of((Ujo)this) + (String)object);
        Comment comment = field != null ? field.getAnnotation(Comment.class) : null;
        Comment comment2 = relationToMany.getItemType().getAnnotation(Comment.class);
        if (comment != null) {
            this.changeDefault(this, COMMENT, comment.value());
        }
        if (comment2 != null) {
            this.changeDefault(this, COMMENT, comment2.value());
        }
        if (((Boolean)VIEW.of((Ujo)this)).booleanValue() && !SELECT.isDefault((Ujo)this)) {
            SELECT_MODEL.setValue((Ujo)this, (Object)new MetaSelect(this));
        }
        MetaPKey metaPKey = new MetaPKey(this);
        PK.setValue((Ujo)this, (Object)metaPKey);
        OrmHandler ormHandler = metaDatabase.getOrmHandler();
        UjoManager ujoManager = UjoManager.getInstance();
        for (Key key : ujoManager.readKeys(relationToMany.getItemType())) {
            MetaRelation2Many metaRelation2Many;
            MetaRelation2Many metaRelation2Many2;
            if (ujoManager.isTransientProperty(key)) continue;
            if (key instanceof RelationToMany) {
                metaRelation2Many2 = metaTable != null ? metaTable.findRelation(key.getName()) : null;
                metaRelation2Many = new MetaRelation2Many(this, key, metaRelation2Many2);
                RELATIONS.addItem((Ujo)this, (Object)metaRelation2Many);
                ormHandler.addColumnModel(metaRelation2Many);
                continue;
            }
            metaRelation2Many2 = metaTable != null ? metaTable.findColumn(key.getName()) : null;
            metaRelation2Many = new MetaColumn(this, key, (MetaColumn)metaRelation2Many2);
            COLUMNS.addItem((Ujo)this, (Object)metaRelation2Many);
            ormHandler.addColumnModel(metaRelation2Many);
            if (!((Boolean)MetaColumn.PRIMARY_KEY.of((Ujo)metaRelation2Many)).booleanValue()) continue;
            MetaPKey.COLUMNS.addItem((Ujo)metaPKey, (Object)metaRelation2Many);
        }
    }

    public void assignPrimaryKey(OrmUjo ormUjo, Session session) {
        Class<OrmUjo> clazz = this.getType();
        if (clazz.isInstance(ormUjo)) {
            try {
                MetaPKey metaPKey = (MetaPKey)((Object)PK.of((Ujo)this));
                metaPKey.assignPrimaryKey(ormUjo, session);
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("DB SEQUENCE is not supported for " + clazz, throwable);
            }
        } else {
            throw new IllegalArgumentException("Argument is not type of " + clazz);
        }
    }

    public OrmUjo createBO() throws InstantiationException, IllegalAccessException {
        OrmUjo ormUjo = this.getType().newInstance();
        return ormUjo;
    }

    public final Class<OrmUjo> getType() {
        return ((RelationToMany)((Object)DB_PROPERTY.of((Ujo)this))).getItemType();
    }

    public MetaColumn getFirstPK() {
        return ((MetaPKey)((Object)PK.of((Ujo)this))).getFirstColumn();
    }

    public boolean isPersistent() {
        return DATABASE.of((Ujo)this) != null;
    }

    public boolean isDefaultSchema() {
        if (this.sequenceSchemaSymbol == null) {
            this.sequenceSchemaSymbol = this.getDatabase().getParams().get(MetaParams.SEQUENCE_SCHEMA_SYMBOL);
        }
        if (this.sequenceSchemaSymbol.booleanValue()) {
            String string = (String)SCHEMA.of((Ujo)this);
            String string2 = (String)MetaDatabase.SCHEMA.of((Ujo)this.getDatabase());
            return string.equals(string2);
        }
        return false;
    }

    @Override
    public boolean isView() {
        return (Boolean)VIEW.of((Ujo)this);
    }

    public boolean isTable() {
        return this.isPersistent() && !this.isView();
    }

    public boolean isCommented() {
        return !COMMENT.isDefault((Ujo)this);
    }

    public String getComment() {
        return (String)COMMENT.of((Ujo)this);
    }

    public boolean isSelectModel() {
        return SELECT_MODEL.of((Ujo)this) != null;
    }

    public void setNotPersistent() {
        DATABASE.setValue((Ujo)this, null);
    }

    @Override
    public String getAlias() {
        return (String)ALIAS.of((Ujo)this);
    }

    public final MetaDatabase getDatabase() {
        return (MetaDatabase)DATABASE.of((Ujo)this);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    MetaColumn findColumn(String string) {
        if (OrmTools.isFilled(string)) {
            for (MetaColumn metaColumn : (List)COLUMNS.of((Ujo)this)) {
                if (!MetaColumn.ID.equals((Ujo)metaColumn, (Object)string)) continue;
                return metaColumn;
            }
        }
        return null;
    }

    MetaRelation2Many findRelation(String string) {
        if (OrmTools.isFilled(string)) {
            for (MetaRelation2Many metaRelation2Many : (List)RELATIONS.of((Ujo)this)) {
                if (!MetaRelation2Many.ID.equals((Ujo)metaRelation2Many, (Object)string)) continue;
                return metaRelation2Many;
            }
        }
        return null;
    }

    public List<MetaColumn> getForeignColumns() {
        ArrayList<MetaColumn> arrayList = new ArrayList<MetaColumn>();
        for (MetaColumn metaColumn : COLUMNS.getList((Ujo)this)) {
            if (!metaColumn.isForeignKey()) continue;
            arrayList.add(metaColumn);
        }
        return arrayList;
    }

    public UjoSequencer getSequencer() {
        return this.sequencer;
    }

    public MetaIndex createIndexForColumn(String string, MetaColumn metaColumn) {
        MetaIndex metaIndex = new MetaIndex(string, this);
        boolean bl = ((String)MetaColumn.UNIQUE_INDEX.of((Ujo)metaColumn)).length() > 0;
        MetaIndex.UNIQUE.setValue((Ujo)metaIndex, (Object)bl);
        return metaIndex;
    }

    public String createIndexNameForColumn(MetaColumn metaColumn, boolean bl) {
        String string = bl ? (String)MetaColumn.UNIQUE_INDEX.of((Ujo)metaColumn) : (String)MetaColumn.INDEX.of((Ujo)metaColumn);
        if (string.length() == 0 && metaColumn.isForeignKey()) {
            string = "AUTO";
        }
        assert (string.length() > 0);
        if ("AUTO".equalsIgnoreCase(string)) {
            SqlNameProvider sqlNameProvider = this.getDatabase().getDialect().getNameProvider();
            string = bl ? sqlNameProvider.getUniqueConstraintName(metaColumn) : sqlNameProvider.getIndexName(metaColumn);
        }
        return string;
    }

    public Collection<MetaIndex> getIndexCollection() {
        boolean bl = (Boolean)MetaParams.MORE_PARAMS.add(MoreParams.EXTENTED_INDEX_NAME_STRATEGY).of((Ujo)((MetaDatabase)DATABASE.of((Ujo)this)).getOrmHandler().getParameters());
        return bl ? this.getIndexCollectionExtended() : this.getIndexCollectionOriginal();
    }

    private Collection<MetaIndex> getIndexCollectionExtended() {
        HashMap<String, MetaIndex> hashMap = new HashMap<String, MetaIndex>();
        for (MetaColumn metaColumn : COLUMNS.getList((Ujo)this)) {
            boolean bl;
            String string = (String)MetaColumn.UNIQUE_INDEX.of((Ujo)metaColumn);
            String string2 = (String)MetaColumn.INDEX.of((Ujo)metaColumn);
            boolean bl2 = string2.length() > 0;
            boolean bl3 = bl = string.length() > 0;
            if (bl2 || metaColumn.isForeignKey()) {
                this.addIndex(metaColumn, hashMap, false);
            }
            if (!bl) continue;
            this.addIndex(metaColumn, hashMap, true);
        }
        return hashMap.values();
    }

    private Collection<MetaIndex> getIndexCollectionOriginal() {
        HashMap<String, MetaIndex> hashMap = new HashMap<String, MetaIndex>();
        block0: for (MetaColumn metaColumn : COLUMNS.getList((Ujo)this)) {
            String[] stringArray = new String[]{(String)MetaColumn.INDEX.of((Ujo)metaColumn), (String)MetaColumn.UNIQUE_INDEX.of((Ujo)metaColumn)};
            for (int i = 0; i < 2; ++i) {
                if (stringArray[i].length() <= 0) continue;
                String string = stringArray[i].toUpperCase();
                MetaIndex metaIndex = (MetaIndex)((Object)hashMap.get(string));
                if (metaIndex == null) {
                    metaIndex = new MetaIndex(stringArray[i], this);
                    hashMap.put(string, metaIndex);
                }
                if (i == 0) {
                    MetaIndex.UNIQUE.setValue((Ujo)metaIndex, (Object)false);
                } else if (string.equalsIgnoreCase(stringArray[0])) continue block0;
                MetaIndex.COLUMNS.addItem((Ujo)metaIndex, (Object)metaColumn);
            }
        }
        return hashMap.values();
    }

    private void addIndex(MetaColumn metaColumn, Map<String, MetaIndex> map, boolean bl) {
        String string = this.createIndexNameForColumn(metaColumn, bl);
        MetaIndex metaIndex = map.get(string);
        if (metaIndex == null) {
            metaIndex = this.createIndexForColumn(string, metaColumn);
            map.put(string, metaIndex);
        }
        MetaIndex.COLUMNS.addItem((Ujo)metaIndex, (Object)metaColumn);
    }

    public OrmUjo getParent(OrmUjo ormUjo) {
        MetaColumn metaColumn = this.getFirstPK();
        if (metaColumn.isForeignKey()) {
            return (OrmUjo)metaColumn.getValue(ormUjo);
        }
        return null;
    }

    public boolean isReadOnly() {
        return (Boolean)READ_ONLY.of((Ujo)this);
    }

    public void assertChangeAllowed() {
        if (this.isReadOnly()) {
            String string = "The table '" + (String)NAME.of((Ujo)this) + "' have got the READ-ONLY mode. Check the Ujorm meta-model configuration.";
            throw new IllegalStateException(string);
        }
    }

    public Orm2ddlPolicy getOrm2ddlPolicy() {
        return (Orm2ddlPolicy)((Object)ORM2DLL_POLICY.of((Ujo)this));
    }

    @Override
    public MetaTable getModel() {
        return this;
    }

    @Override
    public List<? extends ColumnWrapper> getColumns() {
        return COLUMNS.getList((Ujo)this);
    }

    public void clearReadOnly() {
        super.clearReadOnly(this.getDatabase().getOrmHandler());
    }

    static {
        fa.lock();
    }
}

