/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.IOException;
import java.sql.ResultSet;
import org.ujorm.Ujo;
import org.ujorm.core.UjoManager;
import org.ujorm.implementation.orm.OrmProperty;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.Session;
import org.ujorm.orm.UjoSequencer;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaTable;

public class NativeDbSequencer
extends UjoSequencer {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(OrmProperty.class);

    public NativeDbSequencer(MetaTable metaTable) {
        super(metaTable);
    }

    public synchronized long nextValue(Session session) {
        String string = (String)MetaTable.SEQUENCE.of((Ujo)this.table);
        if (UjoManager.isFilled((CharSequence)string)) {
            try {
                ResultSet resultSet = session.getFirstConnection().createStatement().executeQuery(this.createNextSequence(string));
                if (resultSet.next()) {
                    return resultSet.getLong(1);
                }
                throw new IllegalStateException("No value for sequence: " + string);
            }
            catch (Exception exception) {
                String string2 = "Sequence error for name: " + string;
                LOGGER.log(UjoLogger.ERROR, string2, (Throwable)exception);
                throw new IllegalStateException(string2, exception);
            }
        }
        return super.nextValue(session);
    }

    public String createNextSequence(String string) throws IOException {
        return ((MetaDatabase)MetaTable.DATABASE.of((Ujo)this.table)).getDialect().printNextSequence(string, this.table, new StringBuilder(128)).toString();
    }
}

